/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.LaboResultsAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.PreviousLabResults;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.controls.browser.BrowserComposite;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.util1.ConcurrentHashSet;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LaboResultsBrowserComposite
extends BrowserComposite {
    private static final Logger logger = Logger.getLogger(LaboResultsBrowserComposite.class.getName());
    private IPatient patient;
    protected Clipboard clipboard;
    protected String textCopied = null;

    public LaboResultsBrowserComposite(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
    }

    public LaboResultsBrowserComposite(Composite parent, int browserControlStyle) {
        super(parent, browserControlStyle);
    }

    protected void init() {
        super.init();
        new PreviousLabRsultsFunction(this.getInnerBrowser());
        new CopyToClipboard(this.getInnerBrowser());
        this.clipboard = new Clipboard(this.getDisplay());
    }

    protected String getResourceName() {
        return super.getResourceName();
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
    }

    public void setHtml(HtmlResource htmlResource) {
        this.textCopied = "";
        super.setHtml(htmlResource);
    }

    public void setHtml(Exception e) {
        this.textCopied = "";
        super.setHtml(e);
    }

    public void setHtml(String html) {
        this.textCopied = "";
        super.setHtml(html);
    }

    protected class CopyToClipboard
    extends BrowserFunction {
        CopyToClipboard(Browser browser) {
            super(browser, "copyToClipboard");
        }

        public Object function(Object[] arguments) {
            try {
                String text = (String)arguments[0];
                if (StringUtils.isNotEmpty((String)text) && LaboResultsBrowserComposite.this.textCopied != null && LaboResultsBrowserComposite.this.textCopied.indexOf(text) == -1) {
                    LaboResultsBrowserComposite.this.textCopied = StringUtils.isEmpty((String)LaboResultsBrowserComposite.this.textCopied) ? text : String.valueOf(LaboResultsBrowserComposite.this.textCopied) + "\n" + text;
                    LaboResultsBrowserComposite.this.clipboard.setContents(new Object[]{LaboResultsBrowserComposite.this.textCopied}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur copy to clipboard", e);
            }
            return null;
        }
    }

    protected class PreviousLabRsultsFunction
    extends BrowserFunction {
        Browser browser;
        final Set<String> runningCalls;

        PreviousLabRsultsFunction(Browser browser) {
            super(browser, "jsToJavaLoadLab");
            this.runningCalls = new ConcurrentHashSet();
            this.browser = browser;
        }

        public Object function(Object[] arguments) {
            block3: {
                final String idField = (String)arguments[0];
                int lastTiret = idField.lastIndexOf("-");
                final String labCode = idField.substring(0, lastTiret);
                final Integer idPatient = LaboResultsBrowserComposite.this.getPatient() == null ? null : LaboResultsBrowserComposite.this.getPatient().getId();
                final String key = idPatient + labCode;
                if (this.runningCalls.contains(key)) {
                    return null;
                }
                System.out.println(key);
                Callback callback = new Callback((IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(final ReturnObject response) {
                        System.out.println("LaboResultsBrowserComposite.PreviousLabRsultsFunction.function(...).new Callback() {...}.responseReceived()");
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                block12: {
                                    try {
                                        try {
                                            List list = (List)response.getObj();
                                            if (list == null) break block12;
                                            System.out.println(list);
                                            String ret = "";
                                            JoinList lstArray = new JoinList(",");
                                            int ii = 0;
                                            for (PreviousLabResults p : list) {
                                                if (ii < 9) {
                                                    ret = String.valueOf(ret) + p + "|";
                                                } else if (ii == 9) {
                                                    ret = String.valueOf(ret) + "...|...|";
                                                }
                                                ++ii;
                                                try {
                                                    if ("Pt X".equalsIgnoreCase(p.getDate()) || "...".equals(p.getDate())) continue;
                                                    long time = DateUtil.ctod((String)p.getDate()).getTimeInMillis();
                                                    float val = Float.parseFloat(p.getVal());
                                                    lstArray.add((CharSequence)("[" + time + "," + val + "]"));
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            if (ret.length() > 0) {
                                                StringBuilder dataArray = new StringBuilder("[").append(lstArray.toString()).append("]");
                                                ret = ret.substring(0, ret.length() - 1);
                                                String text = "pushDataTo(\"" + idField + "\", \"" + ret + "\", " + dataArray.toString() + ");";
                                                (this).PreviousLabRsultsFunction.this.browser.execute(text);
                                                break block12;
                                            }
                                            String text = "pushDataToOld(\"" + idField + "\", \" \");";
                                            (this).PreviousLabRsultsFunction.this.browser.execute(text);
                                        }
                                        catch (Exception e) {
                                            logger.log(Level.SEVERE, "failed to getPatientLastSpecificResultsAsync for patient " + idPatient + " with labCode " + labCode, e);
                                            (this).PreviousLabRsultsFunction.this.runningCalls.remove(key);
                                        }
                                    }
                                    finally {
                                        (this).PreviousLabRsultsFunction.this.runningCalls.remove(key);
                                    }
                                }
                            }
                        });
                    }

                    public void exception(Exception e) {
                        PreviousLabRsultsFunction.this.runningCalls.remove(key);
                        super.exception(e);
                    }
                };
                try {
                    this.runningCalls.add(key);
                    LaboResultsAccessorClient.getInstance().getPatientLastSpecificResultsAsync(Application.get().getGlobalInstances().getSession(), callback, idPatient, labCode);
                }
                catch (Exception e) {
                    this.runningCalls.remove(key);
                    logger.log(Level.SEVERE, "failed to getPatientLastSpecificResultsAsync for patient " + idPatient + " with labCode " + labCode, e);
                    if (callback == null || callback.killed()) break block3;
                    callback.kill();
                }
            }
            return null;
        }
    }
}

