/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.RunnableR;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.library.log.LogUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public final class PerspectiveManager {
    private static final Logger logger = Logger.getLogger(PerspectiveManager.class.getName());
    private static final String configFilename = ".loginPerspective.xml";
    private static final String lastCurrentPerspectiveSection = "lastCurrentPerspective";
    private static PerspectiveManager instance;
    private static boolean initialized;
    private Perspective currentPerspective;
    private IPerspectiveDescriptor currentPerspectiveDescriptor;

    private static PerspectiveManager getInstance() {
        if (!initialized) {
            throw new IllegalStateException("PerspectiveManager is not initialized");
        }
        if (instance == null) {
            instance = new PerspectiveManager();
        }
        return instance;
    }

    public static void initialize() {
        initialized = true;
        PerspectiveManager.getInstance();
    }

    private PerspectiveManager() {
        try {
            this.currentPerspective = PerspectiveManager.getInitialPerspective();
            this.currentPerspectiveDescriptor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
        }
        catch (Exception exception) {
            this.currentPerspective = null;
            this.currentPerspectiveDescriptor = null;
        }
        IWorkbenchWindow w = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        w.addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                logger.log(Level.FINE, LogUtil.format((String)".perspectiveActivated", (String[])new String[]{"page", "perspective"}, (Object[])new Object[]{page.getLabel(), perspective.getId()}));
                PerspectiveManager.this.currentPerspective = Perspective.from(perspective.getId());
                PerspectiveManager.this.currentPerspectiveDescriptor = perspective;
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                Log.log((Logger)logger, (String)".perspectiveChanged", (String[])new String[]{"page", "perspective", "changeId"}, (Object[])new Object[]{page, perspective, changeId});
            }
        });
    }

    public static boolean openLoginPerspective(boolean force) {
        return PerspectiveManager.open(Perspective.LOG_IN_PERSPECTIVE, true, force);
    }

    public static boolean openInSwtThread(final Perspective perspective, final boolean fallbackToLogin, final boolean force) throws Exception {
        return (Boolean)UI.runInSwtThread((RunnableR)new RunnableR<Boolean>(){

            public Boolean run() {
                return PerspectiveManager.open(perspective, fallbackToLogin, force);
            }
        });
    }

    public static boolean open(Perspective perspective, boolean fallbackToLogin, boolean force) {
        if (perspective == null) {
            throw new IllegalArgumentException("perspective to open cant be null");
        }
        PerspectiveManager i = PerspectiveManager.getInstance();
        if (i.shouldOpen(perspective)) {
            if (i.closeCurrent(force)) {
                return i.open(perspective);
            }
        } else if (fallbackToLogin && i.currentPerspective != Perspective.LOG_IN_PERSPECTIVE && i.closeCurrent(force)) {
            return i.open(Perspective.LOG_IN_PERSPECTIVE);
        }
        return false;
    }

    private boolean shouldOpen(Perspective perspective) {
        boolean should = true;
        should = should || perspective == Perspective.LOG_IN_PERSPECTIVE;
        should = should && perspective != this.currentPerspective;
        return should;
    }

    private boolean closeCurrent(boolean force) {
        boolean closed = true;
        if (this.currentPerspectiveDescriptor != null) {
            boolean allClosed;
            IWorkbenchPage page;
            IWorkbench win = PlatformUI.getWorkbench();
            IWorkbenchPage iWorkbenchPage = page = win.getActiveWorkbenchWindow() == null ? null : win.getActiveWorkbenchWindow().getActivePage();
            if (page != null && (allClosed = (closed = page.closeAllEditors(!force)))) {
                try {
                    page.closePerspective(this.currentPerspectiveDescriptor, true, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return closed;
    }

    public static boolean closeAll(boolean force) {
        boolean closed = true;
        PerspectiveManager.getInstance().currentPerspective = null;
        PerspectiveManager.getInstance().currentPerspectiveDescriptor = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = activeWorkbenchWindow.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                boolean allClosed = page.closeAllEditors(!force);
                boolean bl = closed = closed && allClosed;
                if (allClosed) {
                    page.close();
                }
                ++n2;
            }
        }
        return closed;
    }

    private boolean open(Perspective perspective) {
        IWorkbench win = PlatformUI.getWorkbench();
        try {
            win.showPerspective(perspective.id, win.getActiveWorkbenchWindow());
            this.currentPerspective = perspective;
            this.currentPerspectiveDescriptor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
            return true;
        }
        catch (WorkbenchException e) {
            logger.log(Level.SEVERE, "Failed to open perspective " + String.valueOf((Object)perspective), e);
            return false;
        }
    }

    public static void storeCurrentPerspectiveToFile() {
        if (PerspectiveManager.getInstance().currentPerspective != null) {
            MyDialogSettings ds = new MyDialogSettings(configFilename, lastCurrentPerspectiveSection);
            String key = PerspectiveManager.getKey();
            if (key != null) {
                ds.put(key, PerspectiveManager.getInstance().currentPerspective.id);
                ds.save();
            } else {
                logger.log(Level.INFO, "Failed to store current persepective as session or user is null");
            }
        }
    }

    public static boolean openLastPerspectiveFromFile() {
        return PerspectiveManager.open(PerspectiveManager.retrieveLastPerspectiveFromFile(), true, false);
    }

    public static Perspective retrieveLastPerspectiveFromFile() {
        PerspectiveManager.getInstance();
        final String key = PerspectiveManager.getKey();
        if (key != null) {
            MyDialogSettings ds = new MyDialogSettings(configFilename, lastCurrentPerspectiveSection){

                public void setDefaultValues() {
                    this.put(key, Perspective.OFYS_PERSPECTIVE.id);
                }
            };
            try {
                return Perspective.from(ds.get(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ds.removeSection(lastCurrentPerspectiveSection);
                ds.save();
            }
        } else {
            logger.log(Level.INFO, "Failed to retrieve last persepective as session or user is null");
        }
        return Perspective.LOG_IN_PERSPECTIVE;
    }

    private static String getKey() {
        String key = null;
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && session.getUser() != null) {
            key = "PER" + String.valueOf(session.getUser().hashCode());
        }
        return key;
    }

    public static Perspective getCurrentPerspective() {
        return PerspectiveManager.getInstance().currentPerspective;
    }

    public static String getCurrentPerspectiveName() {
        return IntroPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0].getPerspective().getLabel();
    }

    public static Perspective getInitialPerspective() {
        return Perspective.LOG_IN_PERSPECTIVE;
    }

    public static enum Perspective {
        LOG_IN_PERSPECTIVE("ca.infodata.ofys.ui.intro.login.LoginPerspective"),
        APPOINTMENT_PERSPECTIVE("ca.infodata.ofys.ui.appointment.AppointmentPerspective"),
        ENCOUNTER_PERSPECTIVE("ca.infodata.ofys.ui.menu.EncounterPerspective"),
        OFYS_PERSPECTIVE("ca.infodata.ofys.ui.menu.DossierPerspective"),
        SCAN_PERSPECTIVE("ca.infodata.ofys.ui.menu.ScanPerspective"),
        PREFERENCES_PERSPECTIVE("ca.infodata.ofys.ui.preferences.AdminPerspective"),
        NEW_UI_PERSPECTIVE("ca.infodata.ofys.ui.menu.NewUiPerspective");

        public final String id;

        private Perspective(String id) {
            this.id = id;
        }

        public static Perspective from(String id) {
            Perspective[] perspectiveArray = Perspective.values();
            int n = perspectiveArray.length;
            int n2 = 0;
            while (n2 < n) {
                Perspective p = perspectiveArray[n2];
                if (p.id.equals(id)) {
                    return p;
                }
                ++n2;
            }
            throw new IllegalArgumentException("no Perspective correspond to id " + id);
        }
    }
}

