/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.help;

import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.Util;
import ca.infodata.util1.date.LocaleProvider;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class HelpDialog {
    private Browser browser;
    private Shell shell;

    public HelpDialog(Shell parent, int style, final String helpUrl) {
        this.shell = new Shell(parent, 0x870 | style);
        this.shell.setText("Aide");
        FormToolkit toolkit = UI.createToolKit((Widget)this.shell);
        toolkit.adapt((Composite)this.shell);
        ResourceBundle bundle = ResourceBundle.getBundle("plugin", LocaleProvider.isEnglish() ? Locale.ENGLISH : Locale.FRENCH);
        String text = bundle.getString("HelpDialog.OUVRIR_DANS_UN_NAVIGATEUR_EXTERNE");
        Hyperlink link = toolkit.createHyperlink((Composite)this.shell, text, 0);
        link.setFont(ResourceGetter.getFont((int)1, (int)0));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    Util.openUrl((String)helpUrl);
                    HelpDialog.this.shell.close();
                }
                catch (ExecutionException executionException) {}
            }
        });
        this.browser = new Browser((Composite)this.shell, 0);
        this.browser.setUrl(helpUrl);
        toolkit.adapt((Composite)this.browser);
        FormLayout layout = new FormLayout();
        FormData data = new FormData();
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        link.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment((Control)link);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.browser.setLayoutData((Object)data);
        this.shell.setLayout((Layout)layout);
        Listener keyDownListener = new Listener(){

            public void handleEvent(Event e) {
                if (!HelpDialog.this.shell.isDisposed() && HelpDialog.this.shell.getDisplay().getActiveShell() == HelpDialog.this.shell && UI.ESC((Event)e)) {
                    HelpDialog.this.shell.close();
                }
            }
        };
        this.shell.getDisplay().addFilter(1, keyDownListener);
        this.shell.pack();
        UI.packAsParentDialog((Shell)this.shell);
        UI.centerComposite((Composite)this.shell, (Composite)parent);
        this.shell.open();
    }

    public void setUrl(String url) {
        this.browser.setUrl(url);
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }
}

