/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.browsersetting;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class BrowserSetter {
    private Map<String, Object> defaultSetting;
    private Map<String, String> maxSetting;
    public static Map<String, String> DEFAULT_MAXIMIZED_SETTING = new HashMap<String, String>();
    private static String PAGE_SETUP_KEYS;

    static {
        DEFAULT_MAXIMIZED_SETTING.put("Print_Background", "yes");
        DEFAULT_MAXIMIZED_SETTING.put("Shrink_To_Fit", "yes");
        DEFAULT_MAXIMIZED_SETTING.put("footer", "");
        DEFAULT_MAXIMIZED_SETTING.put("header", "");
        DEFAULT_MAXIMIZED_SETTING.put("margin_bottom", "0.25000");
        DEFAULT_MAXIMIZED_SETTING.put("margin_left", "0.25000");
        DEFAULT_MAXIMIZED_SETTING.put("margin_right", "0.25000");
        DEFAULT_MAXIMIZED_SETTING.put("margin_top", "0.25000");
        PAGE_SETUP_KEYS = "Software\\Microsoft\\Internet Explorer\\PageSetup";
    }

    private BrowserSetter(Map<String, String> maxSetting) {
        TreeMap def;
        this.defaultSetting = def = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PAGE_SETUP_KEYS);
        this.maxSetting = maxSetting;
    }

    public boolean setBrowserToBestPrint() {
        return this.setPrintSetting(this.maxSetting);
    }

    public boolean resetBrowserSetting() {
        return this.setPrintSetting(this.defaultSetting);
    }

    private boolean setPrintSetting(Map<String, ?> map) {
        try {
            for (Map.Entry<String, ?> e : map.entrySet()) {
                Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PAGE_SETUP_KEYS, (String)e.getKey(), (String)e.getValue().toString());
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static BrowserSetter getBrowserSetting() throws Exception {
        return BrowserSetter.getBrowserSetting(DEFAULT_MAXIMIZED_SETTING);
    }

    public static BrowserSetter getBrowserSetting(Map<String, String> setting) throws Exception {
        BrowserSetter bs = null;
        if (!BrowserSetter.isWindows()) {
            throw new Exception("Can only set browser settings for windows");
        }
        bs = new BrowserSetter(setting);
        return bs;
    }
}

