/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.NAM;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.IControlWrapper;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.windows.AbstractSingleInputWindows;
import ca.infodata.ofys.ui.person.patient.NamText;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FindCandidateActionDialog
extends AbstractSingleInputWindows {
    private MyMaskedText txtFirstname;
    private MyMaskedText txtLastname;
    private MyCalendarText txtBirthDate;
    private MyCombo<XPerson.Gender> cmbGender;
    private NamText txtHealthInsuranceNumber;
    private ControlDecoration txtHealthInsuranceNumberDec;
    private FindCandidateActionDialogData data;

    public FindCandidateActionDialog(Shell shell, FindCandidateActionDialogData data) {
        super(shell, "Le patient n'a pas \u00e9t\u00e9 trouv\u00e9 au dsq", "Veuillez corriger les informations de ce patient. \n\nNotez que la recherche priorise le nam : \n\n\t - Un nam invalide peut donc faire \u00e9chouer la recherche.\n\n\t - Ou encore si on connait le nam, il n'est alors pas n\u00e9cessaire \n\t   de renseigner les autres champs");
        this.data = data;
        this.getBuilder().setDefaultButton(0);
        this.getBuilder().setDefaultReturnCode(1);
    }

    protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
        parent = new Composite(parent, 0);
        MyLabel separator = new MyLabel(parent, 258);
        new MyLabel(parent, Messages.getString((String)"NUMERO_ASS_MALADIE", (String[])new String[0]), 0);
        this.txtHealthInsuranceNumber = new NamText(parent, 2048);
        this.txtHealthInsuranceNumber.setText(this.data.nam);
        new MyLabel(parent, Messages.getString((String)"PRENOM", (String[])new String[0]), 16384);
        this.txtFirstname = new MyMaskedText(parent, 2052);
        this.txtFirstname.setTextLimit(MyMasks.STANDARD_TEXT_LIMIT);
        this.txtFirstname.setText(this.data.firstName);
        new MyLabel(parent, Messages.getString((String)"NOM", (String[])new String[0]), 16384);
        this.txtLastname = new MyMaskedText(parent, 2052);
        this.txtLastname.setTextLimit(MyMasks.STANDARD_TEXT_LIMIT);
        this.txtLastname.setText(this.data.lastName);
        new MyLabel(parent, Messages.getString((String)"DATE_DE_NAISSANCE", (String[])new String[0]), 0);
        this.txtBirthDate = new MyCalendarText(parent, 0);
        this.txtBirthDate.setDate((IPartialDate)this.data.birthDate);
        new MyLabel(parent, Messages.getString((String)"SEXE", (String[])new String[0]), 0);
        this.cmbGender = new MyCombo(parent, 8);
        this.cmbGender.add((Object)XPerson.Gender.MASCULIN);
        this.cmbGender.add((Object)XPerson.Gender.FEMININ);
        this.cmbGender.select((Object)XPerson.Gender.from((String)this.data.gender));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 5;
        parent.setLayout((Layout)gridLayout);
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalIndent = 20;
            data.minimumWidth = 150;
            c.setLayoutData((Object)data);
            ++n2;
        }
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.horizontalSpan = 2;
        data2.minimumWidth = 100;
        separator.setLayoutData((Object)data2);
        return new IControlWrapper((Control)parent);
    }

    protected boolean btnPressed(int btnId) {
        if (btnId == 0) {
            if (this.txtHealthInsuranceNumberDec != null) {
                this.txtHealthInsuranceNumberDec.dispose();
            }
            if (StringUtils.isNotBlank((String)this.txtHealthInsuranceNumber.getText())) {
                try {
                    new NAM(this.txtHealthInsuranceNumber.getText().trim());
                }
                catch (Exception exception) {
                    MessageUtil.errorMsg((Shell)this.getShell(), (String)"Le Num\u00e9ro Ass. Maladie est invalide");
                    return false;
                }
            } else {
                if (this.txtBirthDate.getDate() == null) {
                    MessageUtil.errorMsg((Shell)this.getShell(), (String)"La Date de naissance est obligatoire");
                    return false;
                }
                if (this.cmbGender.getSelection() == null) {
                    MessageUtil.errorMsg((Shell)this.getShell(), (String)"Le Sexe est obligatoire");
                    return false;
                }
            }
            this.data.nam = this.txtHealthInsuranceNumber.getText();
            this.data.birthDate = this.txtBirthDate.getDate();
            this.data.gender = this.cmbGender.getSelection() == null ? null : ((XPerson.Gender)this.cmbGender.getSelection()).id;
            this.data.firstName = this.txtFirstname.getText().trim();
            this.data.lastName = this.txtLastname.getText().trim();
        }
        return true;
    }

    public static class FindCandidateActionDialogData {
        public String nam;
        public String firstName;
        public String lastName;
        public LocalDate birthDate;
        public String gender;
    }
}

