/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.crypto.util.Pack;
import org.bouncycastle.util.Arrays;

public class GOST3411Digest
implements ExtendedDigest {
    private static final int DIGEST_LENGTH = 32;
    private byte[] H = new byte[32];
    private byte[] L = new byte[32];
    private byte[] M = new byte[32];
    private byte[] Sum = new byte[32];
    private byte[][] C = new byte[4][32];
    private byte[] xBuf = new byte[32];
    private int xBufOff;
    private long byteCount;
    private BlockCipher cipher = new GOST28147Engine();
    private byte[] sBox;
    private byte[] K = new byte[32];
    byte[] a = new byte[8];
    short[] wS = new short[16];
    short[] w_S = new short[16];
    byte[] S = new byte[32];
    byte[] U = new byte[32];
    byte[] V = new byte[32];
    byte[] W = new byte[32];
    private static final byte[] C2;

    static {
        byte[] byArray = new byte[32];
        byArray[1] = -1;
        byArray[3] = -1;
        byArray[5] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[10] = -1;
        byArray[12] = -1;
        byArray[14] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[20] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[31] = -1;
        C2 = byArray;
    }

    public GOST3411Digest() {
        this.sBox = GOST28147Engine.getSBox("D-A");
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
    }

    public GOST3411Digest(byte[] sBoxParam) {
        this.sBox = Arrays.clone(sBoxParam);
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
    }

    public GOST3411Digest(GOST3411Digest t) {
        this.sBox = t.sBox;
        this.cipher.init(true, new ParametersWithSBox(null, this.sBox));
        this.reset();
        System.arraycopy(t.H, 0, this.H, 0, t.H.length);
        System.arraycopy(t.L, 0, this.L, 0, t.L.length);
        System.arraycopy(t.M, 0, this.M, 0, t.M.length);
        System.arraycopy(t.Sum, 0, this.Sum, 0, t.Sum.length);
        System.arraycopy(t.C[1], 0, this.C[1], 0, t.C[1].length);
        System.arraycopy(t.C[2], 0, this.C[2], 0, t.C[2].length);
        System.arraycopy(t.C[3], 0, this.C[3], 0, t.C[3].length);
        System.arraycopy(t.xBuf, 0, this.xBuf, 0, t.xBuf.length);
        this.xBufOff = t.xBufOff;
        this.byteCount = t.byteCount;
    }

    @Override
    public String getAlgorithmName() {
        return "GOST3411";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.sumByteArray(this.xBuf);
            this.processBlock(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        while (this.xBufOff != 0 && len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
        while (len > this.xBuf.length) {
            System.arraycopy(in, inOff, this.xBuf, 0, this.xBuf.length);
            this.sumByteArray(this.xBuf);
            this.processBlock(this.xBuf, 0);
            inOff += this.xBuf.length;
            len -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    private byte[] P(byte[] in) {
        int k = 0;
        while (k < 8) {
            this.K[4 * k] = in[k];
            this.K[1 + 4 * k] = in[8 + k];
            this.K[2 + 4 * k] = in[16 + k];
            this.K[3 + 4 * k] = in[24 + k];
            ++k;
        }
        return this.K;
    }

    private byte[] A(byte[] in) {
        int j = 0;
        while (j < 8) {
            this.a[j] = (byte)(in[j] ^ in[j + 8]);
            ++j;
        }
        System.arraycopy(in, 8, in, 0, 24);
        System.arraycopy(this.a, 0, in, 24, 8);
        return in;
    }

    private void E(byte[] key, byte[] s, int sOff, byte[] in, int inOff) {
        this.cipher.init(true, new KeyParameter(key));
        this.cipher.processBlock(in, inOff, s, sOff);
    }

    private void fw(byte[] in) {
        this.cpyBytesToShort(in, this.wS);
        this.w_S[15] = (short)(this.wS[0] ^ this.wS[1] ^ this.wS[2] ^ this.wS[3] ^ this.wS[12] ^ this.wS[15]);
        System.arraycopy(this.wS, 1, this.w_S, 0, 15);
        this.cpyShortToBytes(this.w_S, in);
    }

    protected void processBlock(byte[] in, int inOff) {
        System.arraycopy(in, inOff, this.M, 0, 32);
        System.arraycopy(this.H, 0, this.U, 0, 32);
        System.arraycopy(this.M, 0, this.V, 0, 32);
        int j = 0;
        while (j < 32) {
            this.W[j] = (byte)(this.U[j] ^ this.V[j]);
            ++j;
        }
        this.E(this.P(this.W), this.S, 0, this.H, 0);
        int i = 1;
        while (i < 4) {
            byte[] tmpA = this.A(this.U);
            int j2 = 0;
            while (j2 < 32) {
                this.U[j2] = (byte)(tmpA[j2] ^ this.C[i][j2]);
                ++j2;
            }
            this.V = this.A(this.A(this.V));
            j2 = 0;
            while (j2 < 32) {
                this.W[j2] = (byte)(this.U[j2] ^ this.V[j2]);
                ++j2;
            }
            this.E(this.P(this.W), this.S, i * 8, this.H, i * 8);
            ++i;
        }
        int n = 0;
        while (n < 12) {
            this.fw(this.S);
            ++n;
        }
        n = 0;
        while (n < 32) {
            this.S[n] = (byte)(this.S[n] ^ this.M[n]);
            ++n;
        }
        this.fw(this.S);
        n = 0;
        while (n < 32) {
            this.S[n] = (byte)(this.H[n] ^ this.S[n]);
            ++n;
        }
        n = 0;
        while (n < 61) {
            this.fw(this.S);
            ++n;
        }
        System.arraycopy(this.S, 0, this.H, 0, this.H.length);
    }

    private void finish() {
        Pack.longToLittleEndian(this.byteCount * 8L, this.L, 0);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processBlock(this.L, 0);
        this.processBlock(this.Sum, 0);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        System.arraycopy(this.H, 0, out, outOff, this.H.length);
        this.reset();
        return 32;
    }

    @Override
    public void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        int i = 0;
        while (i < this.H.length) {
            this.H[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.L.length) {
            this.L[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.M.length) {
            this.M[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.C[1].length) {
            this.C[1][i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.C[3].length) {
            this.C[3][i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.Sum.length) {
            this.Sum[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.xBuf.length) {
            this.xBuf[i] = 0;
            ++i;
        }
        System.arraycopy(C2, 0, this.C[2], 0, C2.length);
    }

    private void sumByteArray(byte[] in) {
        int carry = 0;
        int i = 0;
        while (i != this.Sum.length) {
            int sum = (this.Sum[i] & 0xFF) + (in[i] & 0xFF) + carry;
            this.Sum[i] = (byte)sum;
            carry = sum >>> 8;
            ++i;
        }
    }

    private void cpyBytesToShort(byte[] S, short[] wS) {
        int i = 0;
        while (i < S.length / 2) {
            wS[i] = (short)(S[i * 2 + 1] << 8 & 0xFF00 | S[i * 2] & 0xFF);
            ++i;
        }
    }

    private void cpyShortToBytes(short[] wS, byte[] S) {
        int i = 0;
        while (i < S.length / 2) {
            S[i * 2 + 1] = (byte)(wS[i] >> 8);
            S[i * 2] = (byte)wS[i];
            ++i;
        }
    }

    @Override
    public int getByteLength() {
        return 32;
    }
}

