/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERT61String
extends ASN1Object
implements DERString {
    String string;

    public static DERT61String getInstance(Object obj) {
        if (obj == null || obj instanceof DERT61String) {
            return (DERT61String)obj;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERT61String getInstance(ASN1TaggedObject obj, boolean explicit) {
        DERObject o = obj.getObject();
        if (explicit) {
            return DERT61String.getInstance(o);
        }
        return new DERT61String(ASN1OctetString.getInstance(o).getOctets());
    }

    public DERT61String(byte[] string) {
        char[] cs = new char[string.length];
        int i = 0;
        while (i != cs.length) {
            cs[i] = (char)(string[i] & 0xFF);
            ++i;
        }
        this.string = new String(cs);
    }

    public DERT61String(String string) {
        this.string = string;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(20, this.getOctets());
    }

    public byte[] getOctets() {
        char[] cs = this.string.toCharArray();
        byte[] bs = new byte[cs.length];
        int i = 0;
        while (i != cs.length) {
            bs[i] = (byte)cs[i];
            ++i;
        }
        return bs;
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERT61String)) {
            return false;
        }
        return this.getString().equals(((DERT61String)o).getString());
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }
}

