/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import org.apache.lucene.search.spell.StringDistance;

public class NGramDistance
implements StringDistance {
    private int n;

    public NGramDistance(int size) {
        this.n = size;
    }

    public NGramDistance() {
        this(2);
    }

    @Override
    public float getDistance(String source, String target) {
        int sl = source.length();
        int tl = target.length();
        if (sl == 0 || tl == 0) {
            if (sl == tl) {
                return 1.0f;
            }
            return 0.0f;
        }
        int cost = 0;
        if (sl < this.n || tl < this.n) {
            int i = 0;
            int ni = Math.min(sl, tl);
            while (i < ni) {
                if (source.charAt(i) == target.charAt(i)) {
                    ++cost;
                }
                ++i;
            }
            return (float)cost / (float)Math.max(sl, tl);
        }
        char[] sa = new char[sl + this.n - 1];
        int i = 0;
        while (i < sa.length) {
            sa[i] = i < this.n - 1 ? (char)'\u0000' : source.charAt(i - this.n + 1);
            ++i;
        }
        float[] p = new float[sl + 1];
        float[] d = new float[sl + 1];
        char[] t_j = new char[this.n];
        i = 0;
        while (i <= sl) {
            p[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= tl) {
            if (j < this.n) {
                int ti = 0;
                while (ti < this.n - j) {
                    t_j[ti] = '\u0000';
                    ++ti;
                }
                ti = this.n - j;
                while (ti < this.n) {
                    t_j[ti] = target.charAt(ti - (this.n - j));
                    ++ti;
                }
            } else {
                t_j = target.substring(j - this.n, j).toCharArray();
            }
            d[0] = j;
            i = 1;
            while (i <= sl) {
                cost = 0;
                int tn = this.n;
                int ni = 0;
                while (ni < this.n) {
                    if (sa[i - 1 + ni] != t_j[ni]) {
                        ++cost;
                    } else if (sa[i - 1 + ni] == '\u0000') {
                        --tn;
                    }
                    ++ni;
                }
                float ec = (float)cost / (float)tn;
                d[i] = Math.min(Math.min(d[i - 1] + 1.0f, p[i] + 1.0f), p[i - 1] + ec);
                ++i;
            }
            float[] _d = p;
            p = d;
            d = _d;
            ++j;
        }
        return 1.0f - p[sl] / (float)Math.max(tl, sl);
    }

    public int hashCode() {
        return 1427 * this.n * this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NGramDistance o = (NGramDistance)obj;
        return o.n == this.n;
    }

    public String toString() {
        return "ngram(" + this.n + ")";
    }
}

