/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BaseCompositeReader;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ParallelAtomicReader;

public class ParallelCompositeReader
extends BaseCompositeReader<IndexReader> {
    private final boolean closeSubReaders;
    private final Set<IndexReader> completeReaderSet = Collections.newSetFromMap(new IdentityHashMap());

    public ParallelCompositeReader(CompositeReader ... readers) throws IOException {
        this(true, readers);
    }

    public ParallelCompositeReader(boolean closeSubReaders, CompositeReader ... readers) throws IOException {
        this(closeSubReaders, readers, readers);
    }

    public ParallelCompositeReader(boolean closeSubReaders, CompositeReader[] readers, CompositeReader[] storedFieldReaders) throws IOException {
        super(ParallelCompositeReader.prepareSubReaders(readers, storedFieldReaders));
        this.closeSubReaders = closeSubReaders;
        Collections.addAll(this.completeReaderSet, readers);
        Collections.addAll(this.completeReaderSet, storedFieldReaders);
        if (!closeSubReaders) {
            for (IndexReader reader : this.completeReaderSet) {
                reader.incRef();
            }
        }
        this.completeReaderSet.addAll(this.getSequentialSubReaders());
    }

    private static IndexReader[] prepareSubReaders(CompositeReader[] readers, CompositeReader[] storedFieldsReaders) throws IOException {
        if (readers.length == 0) {
            if (storedFieldsReaders.length > 0) {
                throw new IllegalArgumentException("There must be at least one main reader if storedFieldsReaders are used.");
            }
            return new IndexReader[0];
        }
        List<? extends IndexReader> firstSubReaders = readers[0].getSequentialSubReaders();
        int maxDoc = readers[0].maxDoc();
        int noSubs = firstSubReaders.size();
        int[] childMaxDoc = new int[noSubs];
        boolean[] childAtomic = new boolean[noSubs];
        int i = 0;
        while (i < noSubs) {
            IndexReader r = firstSubReaders.get(i);
            childMaxDoc[i] = r.maxDoc();
            childAtomic[i] = r instanceof AtomicReader;
            ++i;
        }
        ParallelCompositeReader.validate(readers, maxDoc, childMaxDoc, childAtomic);
        ParallelCompositeReader.validate(storedFieldsReaders, maxDoc, childMaxDoc, childAtomic);
        IndexReader[] subReaders = new IndexReader[noSubs];
        int i2 = 0;
        while (i2 < subReaders.length) {
            int j;
            IndexReader[] storedSubs;
            if (firstSubReaders.get(i2) instanceof AtomicReader) {
                AtomicReader[] atomicSubs = new AtomicReader[readers.length];
                int j2 = 0;
                while (j2 < readers.length) {
                    atomicSubs[j2] = (AtomicReader)readers[j2].getSequentialSubReaders().get(i2);
                    ++j2;
                }
                storedSubs = new AtomicReader[storedFieldsReaders.length];
                j = 0;
                while (j < storedFieldsReaders.length) {
                    storedSubs[j] = (AtomicReader)storedFieldsReaders[j].getSequentialSubReaders().get(i2);
                    ++j;
                }
                subReaders[i2] = new ParallelAtomicReader(true, atomicSubs, (AtomicReader[])storedSubs){

                    @Override
                    protected void doClose() {
                    }
                };
            } else {
                assert (firstSubReaders.get(i2) instanceof CompositeReader);
                CompositeReader[] compositeSubs = new CompositeReader[readers.length];
                int j3 = 0;
                while (j3 < readers.length) {
                    compositeSubs[j3] = (CompositeReader)readers[j3].getSequentialSubReaders().get(i2);
                    ++j3;
                }
                storedSubs = new CompositeReader[storedFieldsReaders.length];
                j = 0;
                while (j < storedFieldsReaders.length) {
                    storedSubs[j] = (CompositeReader)storedFieldsReaders[j].getSequentialSubReaders().get(i2);
                    ++j;
                }
                subReaders[i2] = new ParallelCompositeReader(true, compositeSubs, (CompositeReader[])storedSubs){

                    @Override
                    protected void doClose() {
                    }
                };
            }
            ++i2;
        }
        return subReaders;
    }

    private static void validate(CompositeReader[] readers, int maxDoc, int[] childMaxDoc, boolean[] childAtomic) {
        int i = 0;
        while (i < readers.length) {
            CompositeReader reader = readers[i];
            List<? extends IndexReader> subs = reader.getSequentialSubReaders();
            if (reader.maxDoc() != maxDoc) {
                throw new IllegalArgumentException("All readers must have same maxDoc: " + maxDoc + "!=" + reader.maxDoc());
            }
            int noSubs = subs.size();
            if (noSubs != childMaxDoc.length) {
                throw new IllegalArgumentException("All readers must have same number of subReaders");
            }
            int subIDX = 0;
            while (subIDX < noSubs) {
                IndexReader r = subs.get(subIDX);
                if (r.maxDoc() != childMaxDoc[subIDX]) {
                    throw new IllegalArgumentException("All readers must have same corresponding subReader maxDoc");
                }
                if (childAtomic[subIDX] ? !(r instanceof AtomicReader) : !(r instanceof CompositeReader)) {
                    throw new IllegalArgumentException("All readers must have same corresponding subReader types (atomic or composite)");
                }
                ++subIDX;
            }
            ++i;
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        IOException ioe = null;
        for (IndexReader reader : this.completeReaderSet) {
            try {
                if (this.closeSubReaders) {
                    reader.close();
                    continue;
                }
                reader.decRef();
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

