/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.windows;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextInputDialog {
    private static final String ANNULER = Messages.getString((String)"ANNULER", (String[])new String[0]);
    private static final String OK = Messages.getString((String)"OK", (String[])new String[0]);
    private boolean ok;
    private String text;
    private String title;
    private boolean waitForWindowToClose = true;
    private Shell dialog;
    private Shell parent;

    public void open() {
        this.createDialog();
        this.dialog.pack();
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.dialog.open();
        if (this.waitForWindowToClose) {
            UI.waitForWindowToClose((Shell)this.dialog);
        }
    }

    private void createDialog() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.dispose();
        }
        this.ok = false;
        this.dialog = new Shell(this.parent, 2144);
        this.dialog.setText(StringUtils.defaultString((String)this.getTitle()));
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)white, (Widget)this.dialog);
        this.dialog.setBackground(white);
        FormToolkit toolkit = UI.createToolKit((Widget)this.dialog);
        final TemplateAssistText assistText = new TemplateAssistText((Composite)this.dialog, 64, toolkit);
        assistText.setText(this.getText());
        assistText.setType(XCompletionProposalType.OTHER);
        ControlDecorator.decorateWithEditProposal(assistText, 16512);
        assistText.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (UI.CTRL((KeyEvent)e) && e.keyCode == 13) {
                    e.doit = false;
                    TextInputDialog.this.text = assistText.getText();
                    TextInputDialog.this.ok = true;
                    TextInputDialog.this.close();
                }
            }
        });
        String ok = String.valueOf(OK) + " ";
        ok = LibPlugin.ON_MAC ? String.valueOf(ok) + "(Cmd+Retour)" : String.valueOf(ok) + "(Ctrl+Retour)";
        MyButton btnOk = new MyButton((Composite)this.dialog, ok, 8, toolkit);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextInputDialog.this.text = assistText.getText();
                TextInputDialog.this.ok = true;
                TextInputDialog.this.close();
            }
        });
        MyButton btnCancel = new MyButton((Composite)this.dialog, ANNULER, 8, toolkit);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextInputDialog.this.ok = false;
                TextInputDialog.this.close();
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.spacing = 5;
        this.dialog.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 500;
        data.height = 50;
        assistText.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(assistText.getControl(), 5);
        data.right = new FormAttachment(100, -5);
        data.width = 150;
        btnCancel.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(assistText.getControl(), 5);
        data.right = new FormAttachment(btnCancel.getControl(), -5);
        data.width = 150;
        btnOk.setLayoutData(data);
    }

    public void close() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public final boolean isOk() {
        return this.ok;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isWaitForWindowToClose() {
        return this.waitForWindowToClose;
    }

    public void setWaitForWindowToClose(boolean waitForWindowToClose) {
        this.waitForWindowToClose = waitForWindowToClose;
    }

    public Shell getParent() {
        return this.parent;
    }

    public void setParent(Shell parent) {
        this.parent = parent;
    }
}

