/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.completion;

import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.assistant.AssistantProposer;
import ca.infodata.ofys.ui.controls.assistant.AssistantProposition;
import ca.infodata.ofys.ui.controls.assistant.gabarit.TemplateAssistantProposer;
import ca.infodata.ofys.ui.controls.assistant.gabarit.TemplateAssistantProposition;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.textAssistant.AssistText;
import ca.infodata.ofys.ui.controls.textAssistant.CompletionAssistant;
import ca.infodata.util1.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TemplateAssistText
extends AssistText {
    private XCompletionProposalType type;

    public TemplateAssistText(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
    }

    public TemplateAssistText(Composite parent, int style) {
        super(parent, style);
    }

    public void setType(XCompletionProposalType type) {
        this.type = type;
        try {
            CompletionAssistant<XTemplate> contentAssistant = new CompletionAssistant<XTemplate>((AssistantProposer)new TemplateAssistantProposer(TemplateAccessorClient.getInstance(), this.type)){

                @Override
                public String getTextValue() {
                    String s = TemplateAssistText.this.getTextForSearch();
                    return s;
                }

                @Override
                public void itemSelected(AssistantProposition<XTemplate> obj) {
                    if (obj != null && obj instanceof TemplateAssistantProposition) {
                        TemplateAssistantProposition tp = (TemplateAssistantProposition)obj;
                        TemplateAssistText.this.setTextAtOffset(tp.getText());
                    }
                }
            };
            contentAssistant.install(this.viewer.getControl());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setTextAtOffset(String text) {
        StyledText styleText = this.getStyledText();
        int[] select = styleText.getSelectionRanges();
        String baseText = this.getText();
        String newText = baseText.substring(0, select[0]);
        newText = String.valueOf(newText) + text;
        newText = String.valueOf(newText) + baseText.substring(select[0] + select[1]);
        this.setText(newText);
        styleText.setCaretOffset(select[0] + text.length());
    }

    private String getTextForSearch() {
        StyledText st = this.getStyledText();
        if (StringUtils.isNotBlank((String)st.getSelectionText())) {
            return st.getSelectionText();
        }
        int offset = st.getCaretOffset();
        --offset;
        StringBuilder sb = new StringBuilder(30);
        String strBase = st.getText();
        while (offset >= 0 && offset < strBase.length()) {
            String c = String.valueOf(strBase.charAt(offset));
            if ((c = c.replaceAll("[^\\w\u00c0-\u00ff0-9_-]", "\t")).contains("\t")) break;
            sb.append(c);
            --offset;
        }
        st.setSelectionRange(offset + 1, st.getCaretOffset() - (offset + 1));
        return sb.reverse().toString();
    }

    public XCompletionProposalType getType() {
        return this.type;
    }

    public void setVariablesReplacer(Object replacer) {
    }

    public void setVisible(boolean b) {
        this.getStyledText().setVisible(b);
    }
}

