/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2.properties;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PageFormat2;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PageFormat2Property;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrinterProperty;
import ca.infodata.ofys.ui.controls.report2.PrintController;
import ca.infodata.ofys.ui.controls.report2.properties.PaperSizesFactory;
import ca.infodata.ofys.ui.pdf.PrintPdfX;
import ca.infodata.ofys.util.MiscUtil;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;

public class SingleReportPropertiesController {
    private static final Logger logger = Logger.getLogger(SingleReportPropertiesController.class.getName());
    private IReport report;
    private PrintController printController;
    private Set<IReportProperty<?>> modifiedProperties;
    private PrintService printService;
    private PaperSizesFactory paperSizes;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);

    public SingleReportPropertiesController(IReport report, PrintController controller) {
        this.report = report;
        this.printController = controller;
        this.modifiedProperties = new HashSet();
    }

    public Future<Throwable> tryQueryPrinter(final String printer) throws Exception {
        Future<Throwable> future = this.executorService.submit(new Callable<Throwable>(){

            @Override
            public Throwable call() throws Exception {
                PrintService printService;
                try {
                    printService = PrintPdfX.getPrintService((String)printer);
                }
                catch (Throwable e) {
                    return e;
                }
                try {
                    new PaperSizesFactory(printService);
                    return null;
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Failed to get printer paper format. continue anyway by some paper format may be missing", e);
                    return null;
                }
            }
        });
        return future;
    }

    public IReport getReport() {
        return this.report;
    }

    private PrintService getPrintService() throws PrinterException {
        if (this.printService == null) {
            this.printService = PrintPdfX.getPrintService((String)this.getReportOrDefaultPrinter());
        }
        return this.printService;
    }

    private PaperSizesFactory getPaperSizesFactory() throws PrinterException {
        if (this.paperSizes == null) {
            this.paperSizes = new PaperSizesFactory(this.getPrintService());
        }
        return this.paperSizes;
    }

    public String getReportPrinter() {
        if (this.report != null) {
            return (String)this.report.getProperties().getValue("printer", null);
        }
        return null;
    }

    public String getReportOrDefaultPrinter() {
        String printer = this.getReportPrinter();
        if (printer == null) {
            printer = this.getDefaultPrinter();
        }
        return printer;
    }

    public String getDefaultPrinter() {
        return this.printController.getDefaultPrinter();
    }

    public void setReportPageFormat(PageFormat pageFormat) throws PrinterException {
        PageFormat2 pageFormat2 = this.getPaperSizesFactory().toPageFormat2(pageFormat);
        this.setReportPageFormat(pageFormat2);
    }

    public PageFormat2 getDefaultPageFormat2() {
        try {
            PageFormat pageFormat = PrintPdfX.defaultPageFormat((PrintService)this.getPrintService());
            return this.getPaperSizesFactory().toPageFormat2(pageFormat);
        }
        catch (PrinterException printerException) {
            return null;
        }
    }

    public void setReportPageFormat(PageFormat2 value) {
        if (this.report != null) {
            this.set((IReportProperty)new PageFormat2Property(value), (Object)value);
            String printer = this.getReportOrDefaultPrinter();
            this.set((IReportProperty)new PrinterProperty(printer), (Object)printer);
        }
    }

    public PageFormat2 getReportPageFormat2(boolean returnDefaultIfNull) {
        if (this.report != null) {
            PageFormat2 pageFormat2 = (PageFormat2)this.report.getProperties().getValue("pageFormat", null);
            if (pageFormat2 == null && returnDefaultIfNull) {
                pageFormat2 = this.getDefaultPageFormat2();
            }
            return pageFormat2;
        }
        return null;
    }

    public PageFormat getReportPageFormat() {
        PageFormat2 pf2 = this.getReportPageFormat2(true);
        if (pf2 != null) {
            return pf2.toPageFormat();
        }
        return null;
    }

    public String[] getPrinterList() {
        return this.printController.getPrinterList();
    }

    public void setPrinter(String printer2) {
        if (this.report != null) {
            String printer1 = this.getReportOrDefaultPrinter();
            this.set((IReportProperty)new PrinterProperty(printer2), (Object)printer2);
            if (!printer1.equals(printer2)) {
                this.printService = null;
                this.paperSizes = null;
                this.setReportPageFormat(this.getDefaultPageFormat2());
            }
        }
    }

    public void savePreferences() {
        if (this.report != null) {
            this.printController.savePreferences(this.report, this.modifiedProperties);
            this.modifiedProperties.clear();
        }
    }

    public <T> void set(IReportProperty<T> property, T value) {
        IReportProperty property2 = this.report.getProperties().get(property.name());
        if (property2 == null || !MiscUtil.areObjectsEquals(value, (Object)property2.value())) {
            this.report.getProperties().put(property);
            this.modifiedProperties.add(property);
            property.setValue(value);
        }
    }

    public Object getValue(String name, Object defaultValue) {
        return this.report.getProperties().getValue(name, defaultValue);
    }
}

