/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.plugins.searchview;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.data.middle.dataobjects.pdf.TablePdf;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.ICombo;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.ISearchView;
import ca.infodata.ofys.ui.controls.MyEmptySelection;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MySelection;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyList;
import ca.infodata.ofys.ui.controls.form.MySearchText;
import ca.infodata.ofys.ui.controls.form.MyTable;
import ca.infodata.ofys.ui.controls.form.MyTable2;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.ISearchSelectionContextMenuContribution;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoicePopup;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchControlAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.controls.template.proposal.ControlContentAdapter;
import ca.infodata.ofys.ui.controls.template.proposal.TemplateContentProposalAdapter;
import ca.infodata.ofys.ui.controls.template.proposal.TemplateContentProposalItem;
import ca.infodata.ofys.ui.controls.textAssistant.AssistText;
import ca.infodata.ofys.ui.controls.windows.AbstractSingleInputWindows;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.IRelativeDate;
import com.lowagie.text.Paragraph;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.mb.listeners.GenListenerManager;

public abstract class BaseSearchComposite
implements ISearchView,
ISelectionProvider,
IRefreshFont {
    private static final Logger logger = Logger.getLogger(BaseSearchComposite.class.getName());
    private String elementId;
    private FontAwareComposite comTopSearch;
    protected FontAwareComposite comSearch;
    protected FontAwareComposite comViewSelect;
    protected FontAwareTable tblSearch;
    protected List<SearchColumn> tableColumns;
    protected KeyListener enterCtrlEnterListener;
    protected static final String ENTER_CTRL_ENTER_TOOLTIP_LOC_WEB = Messages.getString((String)"RETOUR_RECHERCHE_LOCALE_WEB", (String[])new String[0]);
    protected static final String ENTER_CTRL_ENTER_TOOLTIP = Messages.getString((String)"RETOUR_RECHERCHE", (String[])new String[0]);
    protected static final String ADD_NEW_TEMPLATE = Messages.getString((String)"ADD_NEW_TEMPLATE", (String[])new String[0]);
    private static final String EFFACER_CRIT_RECHERCHE = Messages.getString((String)"EFFACER_CRIT_RECHERCHE", (String[])new String[0]);
    protected MyLabel lblMessage;
    private MyButton btnSearch;
    private MyButton btnNew;
    private MyButton btnCustom;
    private IReferenceControl customReferenceControl;
    private Object selectionReferencedControl;
    private IReferenceControl containerReferencedControl;
    public Class<?> myClass;
    protected Color colorRed = ResourceGetter.getColor((int)255, (int)0, (int)0);
    protected Composite parent;
    protected boolean inLastUsed;
    protected static final String MSG_TROP_DONNEES = Messages.getString((String)"MSG_TROP_DONNEES", (String[])new String[0]);
    protected static final String MSG_AUCUNES_DONNEES = Messages.getString((String)"MSG_AUCUNES_DONNEES", (String[])new String[0]);
    protected int selectedItem = -1;
    protected String searchInList = "";
    protected int decompte = 2000;
    protected long lastTimeLetterEntered = 0L;
    protected int whichItemInList = 1;
    private boolean pined;
    private boolean uiAutoColumnAdjust = true;
    private GenListenerManager<ISelectionChangedListener> selectionManager;
    private ISelectionProvider selectionProviderSource;
    private boolean applySoundHelper;
    protected boolean isWithTemplateTool;
    protected XCompletionProposalType templateType;
    private XTemplate currentTemplate;
    private Map<String, IControl> searchControls;
    private Map<String, SearchControlAdapter> searchControlsAdapter;
    private MyButton btnListTemplates;
    private MyButton btnTemplateActionMenu;
    private SearchColumnChoicePopup searchColumnPopup;
    protected boolean putFocusInResultField = true;
    protected TemplateContentProposalAdapter templateContentProposalAdapter;
    private Map<SearchItem, IEditorPart> editorsFromSearchItem;
    public static final String CONTEXT_MENU_ID = "ca.infodata.ofys.ui.controls.contextmenu";
    private boolean closeSearchItemRelatedEditorOnCustomCallback;
    protected static final String defaultMessageKey = "default";
    private List<Message> messageList = new ArrayList<Message>();

    public BaseSearchComposite(Composite parent, int style) {
        this(parent, null, style, false);
    }

    public BaseSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        this(parent, toolkit, style, false);
    }

    public BaseSearchComposite(Composite parent, int style, boolean applySoundHelper) {
        this(parent, null, style, applySoundHelper);
    }

    public BaseSearchComposite(Composite parent, FormToolkit toolkit, int style, boolean applySoundHelper) {
        this.searchControls = new HashMap<String, IControl>();
        this.searchControlsAdapter = new HashMap<String, SearchControlAdapter>();
        this.createMyPartControl(parent, toolkit, style);
        this.selectionManager = new GenListenerManager(ISelectionChangedListener.class);
        this.applySoundHelper = applySoundHelper;
        this.editorsFromSearchItem = new HashMap<SearchItem, IEditorPart>();
    }

    protected KeyAdapter getKeyAdpater() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    e.doit = false;
                    BaseSearchComposite.this.searchButtonSelected();
                } else if (e.character == '\u001b') {
                    BaseSearchComposite.this.internClose();
                }
            }
        };
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        System.out.println("BaseSC :: createMyControl");
        this.parent = theParent;
        if (toolkit == null) {
            toolkit = UI.createToolKit((Widget)theParent);
        }
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 4;
        toolkit.adapt(this.parent);
        this.comViewSelect = new FontAwareComposite(this.parent, 0);
        toolkit.adapt((Composite)this.comViewSelect);
        this.comTopSearch = new FontAwareComposite(this.parent, 0);
        toolkit.adapt((Composite)this.comTopSearch);
        this.comSearch = new FontAwareComposite(this.parent, 0);
        toolkit.adapt((Composite)this.comSearch);
        FontAwareComposite compBtn = new FontAwareComposite(this.parent, 0);
        toolkit.adapt((Composite)compBtn);
        this.parent.setLayout((Layout)layout);
        this.comViewSelect.setLayout((Layout)new FormLayout());
        compBtn.setLayout((Layout)layout);
        this.enterCtrlEnterListener = this.getKeyAdpater();
        this.tblSearch = new FontAwareTable(this.comSearch, 67584);
        this.tblSearch.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (BaseSearchComposite.this.tblSearch.getSelectionCount() > 0 && BaseSearchComposite.this.tblSearch.getSelection()[0].getData() != null) {
                    BaseSearchComposite.this.itemSelected((SearchItem)BaseSearchComposite.this.tblSearch.getSelection()[0].getData());
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
                BaseSearchComposite.this.selectedItem = BaseSearchComposite.this.tblSearch.getSelectionIndex();
            }
        });
        this.tblSearch.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                e.doit = false;
                BaseSearchComposite.this.selectedItem = BaseSearchComposite.this.tblSearch.getSelectionIndex();
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    if (BaseSearchComposite.this.tblSearch.getSelectionCount() > 0) {
                        BaseSearchComposite.this.itemSelected((SearchItem)BaseSearchComposite.this.tblSearch.getSelection()[0].getData());
                    }
                } else if (e.keyCode == 0x1000001) {
                    e.doit = false;
                    BaseSearchComposite.this.selectItem(-1);
                } else if (e.keyCode == 0x1000002) {
                    e.doit = false;
                    BaseSearchComposite.this.selectItem(1);
                } else if (e.character == '\u001b') {
                    BaseSearchComposite.this.internClose();
                } else if (e.stateMask == 0) {
                    e.doit = false;
                    int index = 0;
                    String s = String.valueOf(e.character).toLowerCase();
                    if (e.character == ' ' && BaseSearchComposite.this.searchInList.length() > 0) {
                        index = BaseSearchComposite.this.findInTable(BaseSearchComposite.this.searchInList, ++BaseSearchComposite.this.whichItemInList);
                    } else if ("0".compareTo(s) <= 0 && "z".compareTo(s) >= 0) {
                        long now = System.currentTimeMillis();
                        if (now - BaseSearchComposite.this.lastTimeLetterEntered > (long)BaseSearchComposite.this.decompte || BaseSearchComposite.this.whichItemInList > 1) {
                            BaseSearchComposite.this.searchInList = "";
                        }
                        BaseSearchComposite.this.whichItemInList = 1;
                        BaseSearchComposite.this.lastTimeLetterEntered = now;
                        BaseSearchComposite.this.searchInList = String.valueOf(BaseSearchComposite.this.searchInList) + String.valueOf(e.character).toLowerCase();
                        index = BaseSearchComposite.this.findInTable(BaseSearchComposite.this.searchInList, BaseSearchComposite.this.whichItemInList);
                    }
                    if (index != 0) {
                        BaseSearchComposite.this.selectedItem = index;
                        BaseSearchComposite.this.tblSearch.setSelection(BaseSearchComposite.this.selectedItem);
                        BaseSearchComposite.this.tblSearch.select(BaseSearchComposite.this.selectedItem);
                    }
                }
            }
        });
        this.tblSearch.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = false;
                    BaseSearchComposite.this.setFocus();
                }
                if (e.detail == 64 || e.detail == 32) {
                    e.doit = false;
                }
            }
        });
        this.tblSearch.addListener(35, new Listener(){

            public void handleEvent(Event e) {
                SearchColumnChoiceElement[] elements;
                boolean header;
                Point pt = BaseSearchComposite.this.tblSearch.getDisplay().map(null, (Control)BaseSearchComposite.this.tblSearch, new Point(e.x, e.y));
                Rectangle clientArea = BaseSearchComposite.this.tblSearch.getClientArea();
                boolean bl = clientArea.y <= pt.y && pt.y < clientArea.y + BaseSearchComposite.this.tblSearch.getHeaderHeight() * (UI.OS_MAC ? 2 : 1) ? true : (header = false);
                if (header && (elements = BaseSearchComposite.this.getSearchColumnChoiceElements()) != null) {
                    if (BaseSearchComposite.this.searchColumnPopup == null || !BaseSearchComposite.this.searchColumnPopup.isOpen()) {
                        BaseSearchComposite.this.searchColumnPopup = new SearchColumnChoicePopup(e, elements, BaseSearchComposite.this.tblSearch, BaseSearchComposite.this.getPreferencesKeys());
                    }
                    if (!BaseSearchComposite.this.searchColumnPopup.isOpen()) {
                        BaseSearchComposite.this.searchColumnPopup.open(e);
                    }
                }
            }
        });
        this.tblSearch.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (BaseSearchComposite.this.tblSearch.getSelectionCount() == 1 && UI.rightClick((MouseEvent)e)) {
                    BaseSearchComposite.this.showContextMenu((Control)BaseSearchComposite.this.tblSearch);
                }
            }
        });
        this.tblSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseSearchComposite.this.fireSelectionChanged();
            }
        });
        this.createLoadingTableColumns();
        this.btnSearch = new MyButton(compBtn, Messages.getString((String)"RECHERCHER", (String[])new String[0]), 8, toolkit);
        this.btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSearchComposite.this.searchButtonSelected();
            }
        });
        this.btnSearch.setToolTipText(Messages.getString((String)"RETOUR", (String[])new String[0]));
        if (this.isWithTemplateTool) {
            this.createTemplateToolControl(compBtn, toolkit);
        }
        this.btnNew = new MyButton(compBtn, Messages.getString((String)"NOUVEAU", (String[])new String[0]), 8, toolkit);
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseSearchComposite.this.createNew();
                BaseSearchComposite.this.internClose();
            }
        });
        this.btnCustom = new MyButton(compBtn, "", 8, toolkit);
        this.btnCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseSearchComposite.this.customReferenceControl != null) {
                    if (BaseSearchComposite.this.closeSearchItemRelatedEditorOnCustomCallback) {
                        BaseSearchComposite.this.closeSearchItemRelatedEditor();
                    }
                    BaseSearchComposite.this.customReferenceControl.callback(BaseSearchComposite.this.getSelectedItemData());
                }
            }
        });
        this.parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)BaseSearchComposite.this.colorRed);
                ResourceGetter.removeListener((IRefreshFont)BaseSearchComposite.this);
            }
        });
        this.lblMessage = new MyLabel(this.comSearch, "", 64, toolkit);
        this.lblMessage.setForeground(this.colorRed);
        FormLayout layout2 = new FormLayout();
        layout2.marginHeight = 5;
        layout2.marginWidth = 5;
        layout2.spacing = 4;
        this.comSearch.setLayout((Layout)layout2);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.comViewSelect.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.comViewSelect);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.comTopSearch.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.comTopSearch);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        compBtn.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)compBtn, -5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.comSearch.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 0;
        this.lblMessage.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.lblMessage.getControl());
        data.right = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.tblSearch.setLayoutData(data);
        this.buildBtnBar(compBtn, this.btnSearch, this.btnNew, this.btnCustom, toolkit, this.btnListTemplates, this.btnTemplateActionMenu);
        this.createMyControl(this.comTopSearch, toolkit);
        toolkit.paintBordersFor((Composite)this.comTopSearch);
        toolkit.paintBordersFor((Composite)this.comSearch);
        ResourceGetter.addListener((IRefreshFont)this);
    }

    protected void closeSearchItemRelatedEditor() {
        SearchItem searchItem = this.getSelectedSearchItem();
        if (searchItem != null) {
            try {
                IWorkbenchPage page;
                IEditorSite editorSite;
                IEditorPart editor = this.getEditorsFromSearchItem().get(searchItem);
                if (editor != null && (editorSite = editor.getEditorSite()) != null && (page = editorSite.getPage()) != null) {
                    page.closeEditor(editor, true);
                    return;
                }
            }
            finally {
                this.getEditorsFromSearchItem().remove(searchItem);
            }
        }
    }

    protected Object getSelectedItemData() {
        if (this.tblSearch != null && !this.tblSearch.isDisposed() && this.tblSearch.getSelectionCount() > 0) {
            TableItem item = this.tblSearch.getSelection()[0];
            SearchItem searchItem = (SearchItem)item.getData();
            return searchItem.getData();
        }
        return null;
    }

    protected SearchItem getSelectedSearchItem() {
        if (this.tblSearch != null && !this.tblSearch.isDisposed() && this.tblSearch.getSelectionCount() > 0) {
            TableItem item = this.tblSearch.getSelection()[0];
            SearchItem searchItem = (SearchItem)item.getData();
            return searchItem;
        }
        return null;
    }

    private void createTemplateToolControl(Composite parent, FormToolkit toolkit) {
        this.btnListTemplates = new MyButton(parent, "\u25bc", 64, toolkit);
        this.btnListTemplates.setToolTipText(Messages.getString((String)"LISTTEMPLATES", (String[])new String[0]));
        ControlContentAdapter cca = new ControlContentAdapter();
        this.templateContentProposalAdapter = new TemplateContentProposalAdapter(this.btnListTemplates.getControl(), this.templateType, cca){

            @Override
            protected ProviderAR<XTemplate, TemplateContentProposalItem> initContentProposalItemFactory() {
                return new ProviderAR<XTemplate, TemplateContentProposalItem>(){

                    public TemplateContentProposalItem get(XTemplate t) {
                        return new TemplateContentProposalItem(this.getAccessor(), t){

                            @Override
                            public String getDescription() {
                                return super.getDescription();
                            }
                        };
                    }
                };
            }
        };
        XTemplate fixedResetTemplate = new XTemplate();
        fixedResetTemplate.setId(Integer.valueOf(-1));
        fixedResetTemplate.setName(EFFACER_CRIT_RECHERCHE);
        fixedResetTemplate.setText("");
        fixedResetTemplate.setType(Integer.valueOf(this.templateType.id));
        fixedResetTemplate.setType2();
        fixedResetTemplate.setIsHtml(Boolean.valueOf(false));
        this.templateContentProposalAdapter.getMyContentProposalProvider().setFixed(Arrays.asList(fixedResetTemplate));
        this.btnListTemplates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseSearchComposite.this.templateContentProposalAdapter.showContentProposalPopup();
            }
        });
        this.templateContentProposalAdapter.getContentProposalAdapter().addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal e) {
                try {
                    TemplateContentProposalItem t = (TemplateContentProposalItem)e;
                    t.loadFully();
                    BaseSearchComposite.this.currentTemplate = t.getTemplate();
                    Properties prop = new Properties();
                    prop.load(new StringReader(t.getContent()));
                    BaseSearchComposite.this.setSearchProperties(prop);
                }
                catch (IOException e1) {
                    logger.log(Level.WARNING, "Failed to parse template " + e, e1);
                }
            }
        });
        this.btnTemplateActionMenu = new MyButton(parent, "+", 64, toolkit);
        this.btnTemplateActionMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu(BaseSearchComposite.this.btnTemplateActionMenu.getControl());
                menu.setVisible(true);
                final Properties prop = BaseSearchComposite.this.getSearchProperties();
                if (prop != null) {
                    final XTemplate template = BaseSearchComposite.this.currentTemplate;
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText(ADD_NEW_TEMPLATE);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AbstractSingleInputWindows dialog = new AbstractSingleInputWindows((this).BaseSearchComposite.this.parent.getShell(), "Ajout d'un nouveau template", "Nom du template : "){

                                @Override
                                protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
                                    MyText text = new MyText(parent, toolkit, 2052);
                                    text.setLayoutData(UI.newFillFormData());
                                    if (template != null) {
                                        text.setText(template.getName());
                                    }
                                    return text;
                                }

                                @Override
                                protected boolean btnPressed(int btnId) {
                                    if (btnId == 0) {
                                        this.input = ((MyText)this.control).getText();
                                        return ca.infodata.util1.StringUtils.isNotBlank((String)((String)this.input));
                                    }
                                    return true;
                                }
                            };
                            dialog.open();
                            if (dialog.getInput() != null) {
                                try {
                                    XTemplate template2 = new XTemplate();
                                    template2.setId(null);
                                    template2.setName((String)dialog.getInput());
                                    template2.setType(Integer.valueOf((this).BaseSearchComposite.this.templateType.id));
                                    StringWriter writer = new StringWriter();
                                    prop.store(writer, "");
                                    template2.setText(writer.toString());
                                    XTemplate templateSaved = (this).BaseSearchComposite.this.templateContentProposalAdapter.getAccessor().save(template2);
                                    template.setId(templateSaved.getId());
                                    template.setUserId(templateSaved.getUserId());
                                }
                                catch (Exception e2) {
                                    logger.log(Level.SEVERE, "", e2);
                                }
                            }
                        }
                    });
                    if (template != null && template.getId() != null && template.getId() != -1) {
                        item = new MenuItem(menu, 8);
                        item.setText("Sauvegarder le template");
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                AbstractSingleInputWindows dialog = new AbstractSingleInputWindows((this).BaseSearchComposite.this.parent.getShell(), "Modification d'un template", "Nom du template : "){

                                    @Override
                                    protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
                                        MyText text = new MyText(parent, toolkit, 2052);
                                        text.setLayoutData(UI.newFillFormData());
                                        if (template != null) {
                                            text.setText(template.getName());
                                        }
                                        return text;
                                    }

                                    @Override
                                    protected boolean btnPressed(int btnId) {
                                        if (btnId == 0) {
                                            this.input = ((MyText)this.control).getText();
                                            return ca.infodata.util1.StringUtils.isNotBlank((String)((String)this.input));
                                        }
                                        return true;
                                    }
                                };
                                dialog.open();
                                if (dialog.getInput() != null) {
                                    try {
                                        XTemplate template2 = new XTemplate();
                                        template2.setId(template.getId());
                                        template2.setName((String)dialog.getInput());
                                        template2.setType(Integer.valueOf((this).BaseSearchComposite.this.templateType.id));
                                        StringWriter writer = new StringWriter();
                                        prop.store(writer, "");
                                        template2.setText(writer.toString());
                                        (this).BaseSearchComposite.this.templateContentProposalAdapter.getAccessor().save(template2);
                                    }
                                    catch (Exception e2) {
                                        logger.log(Level.SEVERE, "", e2);
                                    }
                                }
                            }
                        });
                        item = new MenuItem(menu, 8);
                        item.setText("Supprimer le template");
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                (this).BaseSearchComposite.this.templateContentProposalAdapter.getAccessor().delete(template.getId());
                            }
                        });
                    }
                }
            }
        });
    }

    protected Properties getSearchProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, IControl> e : this.searchControls.entrySet()) {
            JoinList joinList;
            ArrayList list;
            IControl table;
            SearchControlAdapter adapter;
            IControl c = e.getValue();
            String name = e.getKey();
            String value = "null";
            if (c instanceof AssistText) {
                value = ((AssistText)c).getText();
            } else if (c instanceof MyMaskedText) {
                value = ((MyMaskedText)c).getRawText();
            } else if (c instanceof MyText) {
                value = ((MyText)c).getText();
            } else if (c.getControl() instanceof Text) {
                value = ((Text)c.getControl()).getText();
            } else if (c instanceof MyCalendarText) {
                if (((MyCalendarText)c).getTextControl().getAllowRelative()) {
                    IRelativeDate relative = ((MyCalendarText)c).getTextControl().getRelativeDate();
                    value = relative == null ? "null" : relative.store();
                }
            } else if (c instanceof ICombo) {
                Object selection = ((ICombo)((Object)c)).getMyComboSelection();
                SearchControlAdapter adapter2 = this.searchControlsAdapter.get(name);
                value = selection instanceof IDataObject ? (selection == null ? "null" : "dataObject;" + ((IDataObject)selection).getId()) : (selection instanceof EnumWithValue ? String.valueOf("dataObject;" + ((EnumWithValue)selection).getValue()) : (adapter2 != null ? String.valueOf(adapter2.store(selection)) : String.valueOf(selection)));
            } else if (c.getControl() instanceof Button) {
                Button button = (Button)c.getControl();
                if (UI.containsStyle((int)32, (int)button.getStyle()) || UI.containsStyle((int)2, (int)button.getStyle())) {
                    boolean selection = button.getSelection();
                    value = String.valueOf(selection);
                }
            } else if (c instanceof MyTable) {
                adapter = this.searchControlsAdapter.get(name);
                if (adapter != null) {
                    table = (MyTable)c;
                    list = new ArrayList();
                    if (UI.containsStyle((int)32, (int)((MyTable)table).getStyle())) {
                        list.addAll(((MyTable)table).getCheckedItems());
                    } else {
                        list.addAll(((MyTable)table).getSelection());
                    }
                    joinList = new JoinList(",");
                    for (Object o : list) {
                        joinList.add(adapter.store(o).intValue());
                    }
                    value = joinList.size() == 0 ? "null" : joinList.toString();
                } else {
                    logger.warning("no adapter for control with name " + name);
                }
            } else if (c instanceof MyTable2) {
                adapter = this.searchControlsAdapter.get(name);
                if (adapter != null) {
                    table = (MyTable2)c;
                    list = new ArrayList();
                    if (UI.containsStyle((int)32, (int)((MyTable2)table).getStyle())) {
                        list.addAll(((MyTable2)table).getCheckedSelection());
                    } else {
                        list.addAll(((MyTable2)table).getSelection());
                    }
                    joinList = new JoinList(",");
                    for (Object o : list) {
                        joinList.add(adapter.store(o).intValue());
                    }
                    value = joinList.size() == 0 ? "null" : joinList.toString();
                } else {
                    logger.warning("no adapter for control with name " + name);
                }
            } else if (c instanceof MyList) {
                adapter = this.searchControlsAdapter.get(name);
                if (adapter != null) {
                    table = (MyList)c;
                    list = new ArrayList();
                    list.addAll(((MyList)table).getSelection2());
                    joinList = new JoinList(",");
                    for (Object o : list) {
                        joinList.add(adapter.store(o).intValue());
                    }
                    value = joinList.size() == 0 ? "null" : joinList.toString();
                } else {
                    logger.warning("no adapter for control with name " + name);
                }
            } else if (c instanceof MySearchText) {
                MySearchText text = (MySearchText)c;
                Integer id = text.getDataObjectId();
                value = id == null ? "null" : String.valueOf(id);
            }
            properties.setProperty(name, value);
        }
        if (properties.isEmpty()) {
            return null;
        }
        return properties;
    }

    protected void setSearchProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        HashMap<String, IControl> searchControls2 = new HashMap<String, IControl>(this.searchControls);
        for (String name : properties.stringPropertyNames()) {
            String s;
            int n;
            int n2;
            String[] stringArray;
            String[] split;
            ArrayList<Object> list;
            IControl table;
            IControl c;
            String value = properties.getProperty(name);
            if ("null".equals(value)) {
                value = null;
            }
            if ((c = searchControls2.remove(name)) == null) continue;
            if (c instanceof AssistText) {
                ((AssistText)c).setText(value);
                continue;
            }
            if (c instanceof MyMaskedText) {
                ((MyMaskedText)c).setRawText(value);
                continue;
            }
            if (c instanceof MyText) {
                ((MyText)c).setText(value);
                continue;
            }
            if (c.getControl() instanceof Text) {
                ((Text)c.getControl()).setText(value == null ? "" : value);
                continue;
            }
            if (c instanceof MyCalendarText) {
                if (value == null) {
                    ((MyCalendarText)c).setDate(null);
                    continue;
                }
                IRelativeDate date = DateUtil.restoreDate((String)value);
                if (((MyCalendarText)c).getTextControl().getAllowRelative()) {
                    ((MyCalendarText)c).setRelativeDate(date);
                    continue;
                }
                if (!(date instanceof IPartialDate)) continue;
                ((MyCalendarText)c).setDate((IPartialDate)date);
                continue;
            }
            if (c instanceof ICombo) {
                if (value == null) {
                    ((ICombo)((Object)c)).setMyComboSelect(null);
                    continue;
                }
                if (value.startsWith("dataObject")) {
                    String[] split2 = value.split(";");
                    if (split2[1].equals("null")) {
                        ((ICombo)((Object)c)).setMyComboSelect(null);
                        continue;
                    }
                    int id = Integer.parseInt(split2[1]);
                    SearchControlAdapter adapter = this.searchControlsAdapter.get(name);
                    if (adapter != null) {
                        ((ICombo)((Object)c)).setMyComboSelect(adapter.restore(id));
                        continue;
                    }
                    logger.warning("no adapter for control with name " + name);
                    continue;
                }
                ((ICombo)((Object)c)).setMyComboSelect(value);
                continue;
            }
            if (c.getControl() instanceof Button) {
                Button button = (Button)c.getControl();
                if (!UI.containsStyle((int)32, (int)button.getStyle()) && !UI.containsStyle((int)2, (int)button.getStyle())) continue;
                button.setSelection(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (c instanceof MyTable) {
                table = (MyTable)c;
                SearchControlAdapter adapter = this.searchControlsAdapter.get(name);
                if (adapter == null) {
                    logger.warning("no adapter for control with name " + name);
                    continue;
                }
                list = new ArrayList<Object>();
                if (value != null) {
                    stringArray = split = value.split(",");
                    n2 = split.length;
                    n = 0;
                    while (n < n2) {
                        s = stringArray[n];
                        list.add(adapter.restore(Integer.parseInt(s)));
                        ++n;
                    }
                }
                if (UI.containsStyle((int)32, (int)((MyTable)table).getStyle())) {
                    ((MyTable)table).setChecked(list);
                    continue;
                }
                ((MyTable)table).select(list);
                continue;
            }
            if (c instanceof MyTable2) {
                table = (MyTable2)c;
                SearchControlAdapter adapter = this.searchControlsAdapter.get(name);
                if (adapter == null) {
                    logger.warning("no adapter for control with name " + name);
                    continue;
                }
                list = new ArrayList();
                if (value != null) {
                    stringArray = split = value.split(",");
                    n2 = split.length;
                    n = 0;
                    while (n < n2) {
                        s = stringArray[n];
                        list.add(adapter.restore(Integer.parseInt(s)));
                        ++n;
                    }
                }
                if (!UI.containsStyle((int)32, (int)((MyTable2)table).getStyle())) continue;
                ((MyTable2)table).setChecked(list);
                continue;
            }
            if (c instanceof MyList) {
                MyList myList = (MyList)c;
                SearchControlAdapter adapter = this.searchControlsAdapter.get(name);
                if (adapter == null) {
                    logger.warning("no adapter for control with name " + name);
                    continue;
                }
                list = new ArrayList();
                if (value != null) {
                    stringArray = split = value.split(",");
                    n2 = split.length;
                    n = 0;
                    while (n < n2) {
                        s = stringArray[n];
                        list.add(adapter.restore(Integer.parseInt(s)));
                        ++n;
                    }
                }
                myList.select(list);
                continue;
            }
            if (!(c instanceof MySearchText)) continue;
            if (value == null) {
                ((MySearchText)c).setDataObject(null);
                continue;
            }
            ((MySearchText)c).setDataObjectId(Integer.parseInt(value));
        }
        for (IControl c : searchControls2.values()) {
            if (c instanceof AssistText) {
                ((AssistText)c).setText(null);
                continue;
            }
            if (c instanceof MyText) {
                ((MyText)c).setText(null);
                continue;
            }
            if (c instanceof MyMaskedText) {
                ((MyMaskedText)c).setRawText(null);
                continue;
            }
            if (c.getControl() instanceof Text) {
                ((Text)c.getControl()).setText("");
                continue;
            }
            if (c instanceof MyCalendarText) {
                ((MyCalendarText)c).setDate(null);
                continue;
            }
            if (c instanceof MyCombo) {
                ((MyCombo)c).select(null);
                continue;
            }
            if (c.getControl() instanceof Button) {
                Button button = (Button)c.getControl();
                if (!UI.containsStyle((int)32, (int)button.getStyle()) && !UI.containsStyle((int)2, (int)button.getStyle())) continue;
                button.setSelection(false);
                continue;
            }
            if (c instanceof MyTable) {
                MyTable table = (MyTable)c;
                if (!UI.containsStyle((int)32, (int)table.getStyle())) continue;
                table.setChecked(Collections.emptyList());
                table.select(Collections.emptyList());
                continue;
            }
            if (c instanceof MyList) {
                MyList myList = (MyList)c;
                myList.deselectAll();
                continue;
            }
            if (!(c instanceof MySearchText)) continue;
            ((MySearchText)c).setDataObject(null);
        }
    }

    protected void btnTemplateSelected() {
    }

    public abstract void setFocus();

    protected void showContextMenu(Control parent) {
        Menu menu = parent.getMenu();
        if (menu != null) {
            menu.dispose();
            parent.setMenu(null);
        }
        this.extendsContextMenuWithContributions(parent);
        menu = parent.getMenu();
        if (menu != null) {
            menu.setVisible(true);
        }
    }

    public void extendsContextMenuWithContributions(Control control) {
        if (this.getElementId() == null) {
            return;
        }
        ISelection selection = this.getSelection();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTEXT_MENU_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String targetId = e.getAttribute("targetId");
                if (this.getElementId().equals(targetId)) {
                    Object instance = e.createExecutableExtension("class");
                    if (instance instanceof ISearchSelectionContextMenuContribution) {
                        ((ISearchSelectionContextMenuContribution)instance).contributeContextMenuTo(selection, control);
                    } else {
                        throw new RuntimeException("ca.infodata.ofys.ui.controls.contextmenu class attribute must be instanceof ISearchSelectionContextMenuContribution " + instance);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            logger.log(Level.WARNING, "Failed to extendsContextMenuWithContributions for " + this.getClass().getName(), ex);
        }
    }

    protected void selectItem(int next) {
        int itemCount = this.tblSearch.getItemCount();
        int itemSelected = this.selectedItem--;
        switch (next) {
            case -1: {
                if (itemSelected == 0) {
                    this.selectedItem = itemCount - 1;
                }
                break;
            }
            case 1: {
                if (itemSelected + 1 == itemCount) {
                    this.selectedItem = 0;
                    break;
                }
                ++this.selectedItem;
                break;
            }
        }
        this.tblSearch.select(this.selectedItem);
        this.tblSearch.showSelection();
        if (itemSelected != this.selectedItem) {
            this.fireSelectionChanged();
        }
    }

    protected int findInTable(String filterText, int itemInList) {
        int z = 0;
        int item = 1;
        int i = 0;
        while (i < this.tblSearch.getItemCount()) {
            if (this.tblSearch.getItem(i).getText().toLowerCase().indexOf(filterText) != -1) {
                if (itemInList > item) {
                    ++item;
                } else {
                    z = i;
                    break;
                }
            }
            ++i;
        }
        return z;
    }

    protected void loadSearchListInTable(SearchItem[] aSearchItemList) {
        System.out.println("LOADING " + aSearchItemList.length + " ITEMS");
        if (!this.tblSearch.isDisposed()) {
            this.tblSearch.clearAll();
            TableItem item = null;
            if (aSearchItemList != null) {
                this.tblSearch.removeAll();
                ArrayList<Integer> dcdItems = new ArrayList<Integer>();
                int i = 0;
                while (i < aSearchItemList.length) {
                    XPatient pt;
                    item = this.newTableItem(this.tblSearch, aSearchItemList[i]);
                    if (aSearchItemList[i].getData() != null && aSearchItemList[i].getData() instanceof XPatient && (pt = (XPatient)aSearchItemList[i].getData()) != null && XPatientInactiveRaison.DCD.equals((Object)pt.getInactiveRaison())) {
                        dcdItems.add(i);
                    }
                    ++i;
                }
                if (this.uiAutoColumnAdjust) {
                    UI.autoAdjustColumnWidthToContent((Table)this.tblSearch);
                }
                if (item != null) {
                    this.tblSearch.showItem(item);
                }
                if (this.tblSearch.getItemCount() > 0) {
                    if (this.putFocusInResultField) {
                        this.tblSearch.setFocus();
                    }
                    this.selectedItem = 0;
                    this.tblSearch.select(0);
                    this.tblSearch.showSelection();
                    this.fireSelectionChanged();
                    if (this.applySoundHelper) {
                        this.applySoundHelper();
                    }
                    for (Integer iItem : dcdItems) {
                        this.tblSearch.getItem(iItem).setBackground(ResourceGetter.getColor((int)230, (int)230, (int)230));
                        this.tblSearch.getItem(iItem).setForeground(ResourceGetter.getColor((int)255, (int)50, (int)50));
                        this.tblSearch.getItem(iItem).setFont(ResourceGetter.getFontBold());
                    }
                }
            }
        }
    }

    protected TableItem newTableItem(Table table, SearchItem searchItem) {
        TableItem item = new TableItem(table, 0);
        item.setText(searchItem.getText());
        item.setData((Object)searchItem);
        return item;
    }

    protected void applySoundHelper() {
        if (this.tblSearch != null) {
            ArrayList<TableItem> tItems = new ArrayList<TableItem>();
            int i = 0;
            while (i < this.tblSearch.getItemCount()) {
                tItems.add(this.tblSearch.getItem(i));
                ++i;
            }
            int colorCounter = 0;
            int[] gris = new int[]{110, 110, 110};
            while (tItems.size() > 1) {
                String[] names = this.generateSoundexStringTableFrom((TableItem)tItems.get(0));
                boolean findOne = false;
                int j = 1;
                while (j < tItems.size()) {
                    String itemName = this.getSoundexTextFrom((TableItem)tItems.get(j)).toLowerCase().trim();
                    boolean correspond = false;
                    int treshold = 0;
                    int il = itemName.length();
                    int i2 = 0;
                    while (i2 < names.length) {
                        int minL;
                        String nameTrim = names[i2].toLowerCase().trim();
                        int inl = nameTrim.length();
                        int n = minL = il > inl ? inl : il;
                        treshold = minL > 35 ? 7 : (minL > 30 ? 6 : (minL > 25 ? 5 : (minL > 20 ? 4 : (minL > 14 ? 3 : 2))));
                        if (StringUtils.getLevenshteinDistance((CharSequence)nameTrim, (CharSequence)itemName) < treshold) {
                            correspond = true;
                            break;
                        }
                        ++i2;
                    }
                    if (correspond) {
                        findOne = true;
                        int[] color = this.getColorValue(colorCounter);
                        ((TableItem)tItems.get(j)).setForeground(ResourceGetter.getColor((int)color[0], (int)color[1], (int)color[2]));
                        if (color[0] + color[1] + color[2] > 440) {
                            ((TableItem)tItems.get(j)).setBackground(ResourceGetter.getColor((int[])gris));
                        } else {
                            ((TableItem)tItems.get(j)).setFont(ResourceGetter.getFontBold());
                        }
                        tItems.remove(j);
                        --j;
                    }
                    ++j;
                }
                if (findOne) {
                    int[] color = this.getColorValue(colorCounter);
                    ((TableItem)tItems.get(0)).setForeground(ResourceGetter.getColor((int)color[0], (int)color[1], (int)color[2]));
                    if (color[0] + color[1] + color[2] > 440) {
                        ((TableItem)tItems.get(0)).setBackground(ResourceGetter.getColor((int[])gris));
                    } else {
                        ((TableItem)tItems.get(0)).setFont(ResourceGetter.getFontBold());
                    }
                    ++colorCounter;
                }
                tItems.remove(0);
            }
        }
    }

    private int[] getColorValue(int index) {
        int[] color = new int[]{index * 47 % 255, (index * 73 + 96) % 255, (index * 113 + 196) % 255};
        return MiscUtil.pastelColor((int[])color);
    }

    private String[] generateSoundexStringTableFrom(TableItem item) {
        String[] baseParts = this.getSoundexTextTableFrom(item);
        String[] parts = new String[Math.min(2, baseParts.length)];
        int i = 0;
        while (i < parts.length) {
            parts[i] = baseParts[i];
            ++i;
        }
        String[][] gen = MiscUtil.getPossibilityFrom((String[])parts);
        String[] names = new String[gen.length];
        int i2 = 0;
        while (i2 < gen.length) {
            String st = "";
            int j = 0;
            while (j < gen[i2].length) {
                st = String.valueOf(st) + gen[i2][j] + " ";
                ++j;
            }
            names[i2] = st;
            ++i2;
        }
        return names;
    }

    protected String[] getSoundexTextTableFrom(TableItem item) {
        String[] t = new String[]{item.getText()};
        return t;
    }

    protected String getSoundexTextFrom(TableItem item) {
        return item.getText();
    }

    protected void createLoadingTableColumns() {
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(false);
        this.tableColumns = new ArrayList<SearchColumn>();
        this.tableColumns.add(new SearchColumn<String>((Table)this.tblSearch, ""){

            @Override
            public String getText(String e) {
                return e;
            }
        });
    }

    protected SearchItem newSearchItem(Object data) {
        String[] text = new String[this.tableColumns.size()];
        int i = 0;
        while (i < this.tableColumns.size()) {
            String s = this.tableColumns.get(i).getText(data);
            text[i] = s == null ? "" : s;
            ++i;
        }
        return new SearchItem(data, text);
    }

    protected void disposeTableColumns() {
        if (!this.tblSearch.isDisposed()) {
            TableColumn[] columns;
            TableColumn[] tableColumnArray = columns = this.tblSearch.getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                c.dispose();
                ++n2;
            }
        }
    }

    protected void callbackContainerReferenceControlFromTableItems() {
        TableItem[] items = this.tblSearch.getItems();
        if (this.getContainerReferenceControl() != null) {
            Object[] datas = new Object[items.length];
            int i = 0;
            while (i < datas.length) {
                datas[i] = items[i].getData();
                ++i;
            }
            this.getContainerReferenceControl().callback(datas);
        }
    }

    protected void callbackContainerReferenceControl(List<?> items) {
        if (items == null) {
            items = Collections.emptyList();
        }
        if (this.getContainerReferenceControl() != null) {
            Object[] datas = new Object[items.size()];
            int i = 0;
            while (i < datas.length) {
                datas[i] = items.get(i);
                ++i;
            }
            this.getContainerReferenceControl().callback(datas);
        }
    }

    protected void callbackContainerReferenceControl(Object[] items) {
        if (items == null) {
            items = new Object[]{};
        }
        if (this.getContainerReferenceControl() != null) {
            this.getContainerReferenceControl().callback(items);
        }
    }

    protected void searchButtonSelected() {
        long la = System.currentTimeMillis();
        SearchItem[] searchItemList = new SearchItem[]{new SearchItem(null, Messages.getString((String)"CHARGEMENT", (String[])new String[0]))};
        this.loadSearchListInTable(searchItemList);
        try {
            this.search();
        }
        catch (ErrorWhileSearchingException errorWhileSearchingException) {
            this.loadSearchListInTable(new SearchItem[0]);
        }
        System.out.println("SEARCH TIME : " + (System.currentTimeMillis() - la));
    }

    protected void itemSelected(SearchItem item) {
        this.genericProcessSelection(item);
    }

    private void genericProcessSelection(SearchItem item) {
        if (item != null) {
            try {
                boolean cfr_ignored_0 = item.getData() instanceof IDataObject;
                if (this.getReferenceControl() instanceof IReferenceControl) {
                    ((IReferenceControl)this.getReferenceControl()).callback(item.getData());
                }
                this.processSelection(item);
                this.internClose();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error processing search item " + item, e);
            }
        }
    }

    protected abstract SearchColumnChoiceElement[] getSearchColumnChoiceElements();

    protected abstract void processSelection(SearchItem var1);

    protected abstract void createMyControl(Composite var1, FormToolkit var2);

    protected abstract void search() throws ErrorWhileSearchingException;

    protected abstract void createNew();

    @Override
    public Object getReferenceControl() {
        return this.selectionReferencedControl;
    }

    @Override
    public void setReferenceControl(Object referencedControl) {
        this.selectionReferencedControl = referencedControl;
    }

    @Override
    public void setSelectionReferenceControl(Object referenceControl) {
        this.selectionReferencedControl = referenceControl;
    }

    @Override
    public Object getSelectionReferenceControl() {
        return this.selectionReferencedControl;
    }

    @Override
    public IReferenceControl getContainerReferenceControl() {
        return this.containerReferencedControl;
    }

    @Override
    public void setContainerReferenceControl(IReferenceControl referenceControl) {
        this.containerReferencedControl = referenceControl;
    }

    public void setMessage(String message) {
        this.messageList.clear();
        this.addMessage(message);
        this.updateLblMessage();
    }

    public void addMessage(String message) {
        this.addMessage(null, message);
    }

    public void addMessage(String key, String message) {
        if (ca.infodata.util1.StringUtils.isNotBlank((String)message)) {
            this.messageList.add(new Message(key, message));
        }
        this.updateLblMessage();
    }

    public void clearMessage() {
        this.messageList.clear();
        this.updateLblMessage();
    }

    public void clearMessage(String key) {
        Iterator<Message> iterator = this.messageList.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            if (!message.key.equals(key)) continue;
            iterator.remove();
        }
        this.updateLblMessage();
    }

    public void updateLblMessage() {
        JoinList list = new JoinList("\n", this.messageList);
        list.setAllowBlank(false);
        list.setNoDuplicate(true);
        list.setTrim(true);
        this.lblMessage.setText(list.toString());
        this.setLblMessageActif(list.size() > 0);
    }

    public void setIsWithButtonNew(boolean isWithButtonNew) {
        this.btnNew.setVisible(isWithButtonNew);
    }

    public void setLblMessageActif(boolean isLblMessageActif) {
        FormData data = new FormData();
        data = new FormData();
        data.top = new FormAttachment(this.btnSearch.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = Math.max(this.lblMessage.computeSize((int)-1, (int)-1).y, 38);
        if (!isLblMessageActif) {
            data.height = 0;
        }
        this.lblMessage.setLayoutData(data);
        this.parent.setSize(this.parent.getSize().x - 1, this.parent.getSize().y - 1);
        this.parent.setSize(this.parent.getSize().x + 1, this.parent.getSize().y + 1);
        this.lblMessage.setVisible(isLblMessageActif);
    }

    public void setViewSelectInactive() {
        this.comViewSelect.setVisible(false);
        FormData data = new FormData();
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 0;
        this.comViewSelect.setLayoutData(data);
    }

    public void reset() {
        this.setReferenceControl(null);
        this.tblSearch.removeAll();
    }

    public Control getControl() {
        return this.parent;
    }

    public void setVisible(boolean visible) {
        this.parent.setVisible(visible);
    }

    protected void internClose() {
        if (this.pined) {
            return;
        }
        this.close();
    }

    @Override
    public void close() {
    }

    protected boolean isDisposed() {
        return this.parent.isDisposed();
    }

    @Override
    public void pin(boolean value) {
        this.pined = value;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionManager.addListener((Object)listener);
    }

    public ISelection getSelection() {
        Object selection;
        int selectionIndex = this.tblSearch.getSelectionIndex();
        if (selectionIndex == -1) {
            selection = new MyEmptySelection();
        } else {
            Object data = this.tblSearch.getItem(selectionIndex).getData();
            if (data instanceof SearchItem) {
                data = ((SearchItem)data).getData();
            }
            selection = data == null ? new MyEmptySelection() : new MySelection<Object>(data);
        }
        return selection;
    }

    protected void fireSelectionChanged() {
        ISelection selection = this.getSelection();
        ISelectionProvider source = this.getSelectionProviderSource();
        source = source == null ? this : source;
        ((ISelectionChangedListener)this.selectionManager.getProxy()).selectionChanged(new SelectionChangedEvent(source, selection));
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionManager.removeListener((Object)listener);
    }

    public void setSelection(ISelection selection) {
        System.out.println("BaseSearchComposite.setSelection()");
    }

    public ISelectionProvider getSelectionProviderSource() {
        return this.selectionProviderSource;
    }

    public void setSelectionProviderSource(ISelectionProvider selectionProviderSource) {
        this.selectionProviderSource = selectionProviderSource;
    }

    public boolean isApplySoundHelper() {
        return this.applySoundHelper;
    }

    public void setApplySoundHelper(boolean applySoundHelper) {
        this.applySoundHelper = applySoundHelper;
    }

    public void doSearch() {
        this.searchButtonSelected();
    }

    public void addSearchControl(String name, IControl c) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (c == null) {
            throw new NullPointerException("c");
        }
        if (this.searchControls.containsKey(name)) {
            throw new RuntimeException("control " + name + "already added as search control");
        }
        this.searchControls.put(name, c);
    }

    public void addSearchControl(String name, IControl c, SearchControlAdapter adapter) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (c == null) {
            throw new NullPointerException("c");
        }
        if (adapter == null) {
            throw new NullPointerException("adapter");
        }
        if (this.searchControls.containsKey(name)) {
            throw new RuntimeException("control " + name + "already added as search control");
        }
        this.searchControls.put(name, c);
        this.searchControlsAdapter.put(name, adapter);
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    protected abstract String getPreferencesKeys();

    protected void buildBtnBar(Composite parent, MyButton btnSearch, MyButton btnNew, MyButton btnCustom, FormToolkit toolkit, MyButton btnListTemplates, MyButton btnTemplateActionMenu) {
        FormData data;
        int newBtnRight = 32;
        if (this.isWithTemplateTool) {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(newBtnRight, 5);
            data.right = new FormAttachment(btnListTemplates.getControl(), 0);
            data.width = MyButton.getStandardButtonWidth();
            btnSearch.setLayoutData(data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.right = new FormAttachment(btnTemplateActionMenu.getControl(), 0);
            btnListTemplates.setLayoutData(data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.right = new FormAttachment(100);
            btnTemplateActionMenu.setLayoutData(data);
        } else {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(50, 5);
            data.right = new FormAttachment(100);
            data.width = MyButton.getStandardButtonWidth();
            btnSearch.setLayoutData(data);
        }
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(this.isWithTemplateTool ? newBtnRight : 50);
        data.width = MyButton.getStandardButtonWidth();
        btnNew.setLayoutData(data);
        btnNew.setVisible(false);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(this.isWithTemplateTool ? newBtnRight : 50);
        data.width = MyButton.getStandardButtonWidth();
        btnCustom.setLayoutData(data);
        btnCustom.setVisible(false);
    }

    public void refreshFont() {
        this.comSearch.refreshFont();
        this.comViewSelect.refreshFont();
        this.comTopSearch.refreshFont();
        this.parent.layout(true, true);
    }

    public void configureBtnCustom(String buttonText, IReferenceControl customReferenceControl, boolean closeSearchItemRelatedEditorOnCustomCallback) {
        this.btnCustom.setText(buttonText);
        this.btnCustom.setVisible(true);
        this.btnCustom.getParent().layout();
        this.customReferenceControl = customReferenceControl;
        this.closeSearchItemRelatedEditorOnCustomCallback = closeSearchItemRelatedEditorOnCustomCallback;
    }

    public Map<SearchItem, IEditorPart> getEditorsFromSearchItem() {
        return this.editorsFromSearchItem;
    }

    public final boolean isUiAutoColumnAdjust() {
        return this.uiAutoColumnAdjust;
    }

    public final void setUiAutoColumnAdjust(boolean uiAutoColumnAdjust) {
        this.uiAutoColumnAdjust = uiAutoColumnAdjust;
    }

    public TablePdf getPrintTable(String title, List<Paragraph> comments) {
        TablePdf pdf = new TablePdf();
        pdf.setTitle(title);
        pdf.setComments(comments);
        pdf.setPrintedBy(String.valueOf(Messages.getString((String)"PRINTED_BY", (String[])new String[0])) + " " + Application.get().getGlobalInstances().getSession().getUser().getName() + " " + FastDateFormat.getInstance((String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")).format(new Date()) + " - " + Messages.getString((String)"CONFIDENTIAL", (String[])new String[0]));
        int i = 0;
        while (i < this.tblSearch.getColumnCount()) {
            TableColumn column = this.tblSearch.getColumn(i);
            pdf.getHeaders().add(column.getText());
            ++i;
        }
        TableItem[] tableItemArray = this.tblSearch.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ArrayList<String> row = new ArrayList<String>();
            int i2 = 0;
            while (i2 < this.tblSearch.getColumnCount()) {
                row.add(item.getText(i2));
                ++i2;
            }
            pdf.getRows().add(row);
            ++n2;
        }
        return pdf;
    }

    public byte[] printToPdf(String title, List<Paragraph> comments) {
        try {
            TablePdf pdf = this.getPrintTable(title, comments);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            pdf.generatePdf((OutputStream)bao);
            return bao.toByteArray();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate pdf from search table", e);
            return null;
        }
    }

    public static byte[] printToPdf(TablePdf pdf) {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            pdf.generatePdf((OutputStream)bao);
            return bao.toByteArray();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate pdf from search table", e);
            return null;
        }
    }

    private static class Message {
        public String key;
        public String text;

        public Message(String key, String text) {
            this.key = key == null ? BaseSearchComposite.defaultMessageKey : key;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

