/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.handlers;

import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.actions.CloseEditorRunnable;
import ca.infodata.ofys.ui.controls.actions.RunTaskWhenDoneProgressMonitor;
import ca.infodata.ofys.ui.controls.handlers.AbstractEditionHandler;
import ca.infodata.ofys.ui.controls.handlers.InternalHandlerUtil;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class SaveAndCloseHandler
extends AbstractEditionHandler {
    private static final Logger logger = Logger.getLogger(SaveAndCloseHandler.class.getName());

    public SaveAndCloseHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) {
        ISaveablePart saveablePart = this.getSaveablePart(event);
        if (saveablePart == null) {
            return null;
        }
        if (saveablePart instanceof IBaseEditor) {
            CloseEditorRunnable closeEditorRunnable = new CloseEditorRunnable((IEditorPart)saveablePart);
            ((IBaseEditor)((Object)saveablePart)).doSave(closeEditorRunnable);
        } else if (saveablePart instanceof IEditorPart) {
            IEditorPart iEditorPart = (IEditorPart)saveablePart;
            CloseEditorRunnable closeEditorRunnable = new CloseEditorRunnable(iEditorPart);
            saveablePart.doSave(new RunTaskWhenDoneProgressMonitor(closeEditorRunnable));
        } else {
            logger.warning("SaveAndCloseAction works only for editorPart that are instanceof IBaseEditor and IEditorPart or IEditorPart ");
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext context) {
        IWorkbenchWindow window = InternalHandlerUtil.getActiveWorkbenchWindow(context);
        if (window == null) {
            return EvaluationResult.FALSE;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return EvaluationResult.FALSE;
        }
        ISaveablePart saveablePart = this.getSaveablePart(context);
        if (saveablePart == null) {
            return EvaluationResult.FALSE;
        }
        if (saveablePart != null && saveablePart.isSaveAllowed()) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }
}

