/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.calendar.grid.AutoResetingBufferedLocalDateParser;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarCell;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarGrid;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarSelection;
import ca.infodata.ofys.ui.controls.calendar.grid.ICalendarGridData;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.CellRendererFactory;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.Closure;
import ca.infodata.util1.Predicate;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SuperCalendarGrid
extends Composite {
    private int verticalMarginWidth = 24;
    private int horizontalMarginHeight = 24;
    private final CalendarGrid<ICalendarGridData> calendar;
    private final Canvas myCanvas;
    private MyButton btnPreviousMonth;
    private MyButton btnNextMonth;
    private MyButton btnToday;
    private MyLabel labelMonth;
    private boolean firstPaint = true;
    private GC gcBuffer;
    private final AutoResetingBufferedLocalDateParser dateParser;
    private final Color purple = ResourceGetter.getColor((int)200, (int)200, (int)220);
    private final Color purple2 = ResourceGetter.getColor((int)225, (int)225, (int)245);
    private Color colorText = ResourceGetter.getColor((int)0, (int)0, (int)0);
    private Color colorMargin = this.purple;
    private boolean isDisposed;
    private boolean ignoreNextCanvasFocusLost;
    private Predicate autofocusPredicate;

    public SuperCalendarGrid(Composite parent, int style) {
        super(parent, style);
        this.btnToday = new MyButton(this, UI.OS_MAC ? 8 : 0x800008);
        this.btnToday.setText(Messages.getString((String)"AUJOURDHUI", (String[])new String[0]));
        this.btnPreviousMonth = new MyButton(this, UI.OS_MAC ? 8 : 0x800008);
        this.btnPreviousMonth.setText("\u25c4");
        this.btnNextMonth = new MyButton(this, UI.OS_MAC ? 8 : 0x800008);
        this.btnNextMonth.setText("\u25ba");
        this.labelMonth = new MyLabel(this, 131072);
        this.labelMonth.setBackground(this.colorMargin);
        this.labelMonth.setFont(5, 1);
        this.setBackground(this.colorMargin);
        this.myCanvas = new Canvas((Composite)this, 262144);
        this.calendar = new CalendarGrid(this.myCanvas, this.verticalMarginWidth, this.horizontalMarginHeight);
        this.calendar.setOffsetListener(new Closure(){

            public void execute() {
                SuperCalendarGrid.this.updateLabelMonth();
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                if (!SuperCalendarGrid.this.myCanvas.isFocusControl() && SuperCalendarGrid.this.shouldAutofocus()) {
                    SuperCalendarGrid.this.myCanvas.setFocus();
                }
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
                if (!SuperCalendarGrid.this.myCanvas.isFocusControl() && SuperCalendarGrid.this.shouldAutofocus()) {
                    SuperCalendarGrid.this.myCanvas.setFocus();
                }
            }
        });
        this.myCanvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                if (!SuperCalendarGrid.this.myCanvas.isFocusControl() && SuperCalendarGrid.this.shouldAutofocus()) {
                    SuperCalendarGrid.this.myCanvas.setFocus();
                }
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
                if (!SuperCalendarGrid.this.myCanvas.isFocusControl() && SuperCalendarGrid.this.shouldAutofocus()) {
                    SuperCalendarGrid.this.myCanvas.setFocus();
                }
            }
        });
        FocusListener focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                SuperCalendarGrid.this.updateFocusLost();
            }

            public void focusGained(FocusEvent e) {
                SuperCalendarGrid.this.updateFocusGained();
            }
        };
        this.myCanvas.addFocusListener(focusListener);
        MouseTrackAdapter mouseTrackAdapter = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent arg0) {
                SuperCalendarGrid.this.ignoreNextCanvasFocusLost = false;
            }

            public void mouseEnter(MouseEvent arg0) {
                SuperCalendarGrid.this.ignoreNextCanvasFocusLost = true;
            }
        };
        this.btnNextMonth.addMouseTrackListener((MouseTrackListener)mouseTrackAdapter);
        this.btnPreviousMonth.addMouseTrackListener((MouseTrackListener)mouseTrackAdapter);
        this.btnToday.addMouseTrackListener((MouseTrackListener)mouseTrackAdapter);
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.spacing = UI.OS_MAC ? 0 : 5;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0, this.verticalMarginWidth);
        this.btnPreviousMonth.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnPreviousMonth.getControl());
        this.btnToday.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnToday.getControl());
        this.btnNextMonth.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.btnNextMonth.getControl(), 0, 0x1000000);
        data.right = new FormAttachment(100, -10);
        data.left = new FormAttachment(this.btnNextMonth.getControl());
        this.labelMonth.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.btnToday.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.myCanvas.setLayoutData((Object)data);
        this.myCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SuperCalendarGrid.this.mouseDown(e);
            }
        });
        this.myCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SuperCalendarGrid.this.paintControl(e);
            }
        });
        this.btnNextMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDate date = SuperCalendarGrid.this.calendar.getFirstDate();
                if (date != null) {
                    LocalDate date2 = date.plusMonth(1).withDay(1);
                    SuperCalendarGrid.this.calendar.revealMonth(date2, true, true);
                    SuperCalendarGrid.this.track(date2, true, true);
                }
                SuperCalendarGrid.this.ignoreNextCanvasFocusLost = true;
                SuperCalendarGrid.this.myCanvas.setFocus();
            }
        });
        this.btnPreviousMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDate date = SuperCalendarGrid.this.calendar.getFirstDate();
                if (date != null) {
                    if (date.day == 1) {
                        LocalDate date2 = date.plusMonth(-1);
                        SuperCalendarGrid.this.calendar.revealMonth(date2, true, true);
                        SuperCalendarGrid.this.track(date2, true, true);
                    } else {
                        LocalDate date2 = date.withDay(1);
                        SuperCalendarGrid.this.calendar.revealMonth(date2, true, true);
                        SuperCalendarGrid.this.track(date2, true, true);
                    }
                }
                SuperCalendarGrid.this.ignoreNextCanvasFocusLost = true;
                SuperCalendarGrid.this.myCanvas.setFocus();
            }
        });
        this.btnToday.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDate date = LocalDate.today();
                SuperCalendarGrid.this.calendar.revealMonth(date, true, true);
                SuperCalendarGrid.this.track(date, true, true);
                SuperCalendarGrid.this.ignoreNextCanvasFocusLost = true;
                SuperCalendarGrid.this.myCanvas.setFocus();
            }
        });
        this.dateParser = new AutoResetingBufferedLocalDateParser(3000L);
        this.setKeyEvents();
    }

    protected void updateFocusGained() {
        if (this.colorMargin == this.purple) {
            this.colorMargin = this.purple2;
            this.labelMonth.setBackground(this.colorMargin);
            this.setBackground(this.colorMargin);
            this.calendar.redraw();
        }
    }

    protected void updateFocusLost() {
        if (this.ignoreNextCanvasFocusLost) {
            this.ignoreNextCanvasFocusLost = false;
            return;
        }
        this.colorMargin = this.purple;
        this.labelMonth.setBackground(this.colorMargin);
        this.setBackground(this.colorMargin);
        this.calendar.redraw();
    }

    protected void updateLabelMonth() {
        LocalDate date = this.calendar.getFirstDate();
        if (date == null) {
            this.labelMonth.setText("");
        } else {
            int width = this.labelMonth.getBounds().width;
            if (width < 150) {
                this.labelMonth.setText(DateUtil.toMonthString((int)(date.month - 1)));
            } else {
                this.labelMonth.setText(String.valueOf(DateUtil.toMonthString((int)(date.month - 1))) + " " + date.year);
            }
        }
    }

    protected void paintControl(PaintEvent e) {
        this.gcBuffer = e.gc;
        this.drawHorizontalMargin();
        this.drawVerticalMargin();
        if (this.firstPaint) {
            this.updateLabelMonth();
            this.firstPaint = false;
        }
    }

    private void mouseDown(MouseEvent e) {
        this.myCanvas.setFocus();
        if (e.x < this.verticalMarginWidth && e.y > this.horizontalMarginHeight) {
            Object endCell;
            Point point = this.calendar.offsetPoint(e.x + this.verticalMarginWidth, e.y);
            Cell startCell = this.calendar.getCellFromGCPoint(point);
            LocalDate date = null;
            if (startCell instanceof CalendarCell) {
                date = ((CalendarCell)startCell).getDate();
            } else if (startCell != null && (endCell = this.getData().getCell(this.getData().getAbsoluteEndColumn(), startCell.line)) instanceof CalendarCell) {
                date = ((CalendarCell)endCell).getDate();
            }
            if (date != null) {
                CalendarSelection selection = this.getSelection();
                selection.clear();
                selection.addWeek(date);
                selection.finalizeSelection();
            }
        }
    }

    private void drawVerticalMargin() {
        Integer first = this.calendar.firstVisibleLine();
        Integer last = this.calendar.lastVisibleLine();
        if (first != null && last != null) {
            this.gcBuffer.setBackground(this.colorMargin);
            this.gcBuffer.setForeground(this.colorText);
            this.gcBuffer.fillRectangle(0, 0, this.verticalMarginWidth, this.getCanvas().getBounds().height);
            int column = this.getData().getAbsoluteStartColumn();
            int line = first;
            while (line <= last) {
                if (!this.getData().isMonthCellLine(line)) {
                    Rectangle rect = this.calendar.getRectangleFromCell((Cell)this.getData().getCell(column, line));
                    String text = String.valueOf(this.getWeekOfYear(line));
                    Point textExtent = this.gcBuffer.textExtent(text, 0x40000000);
                    this.gcBuffer.drawText(text, 3, this.horizontalMarginHeight + rect.y + rect.height / 2 - textExtent.y / 2, true);
                }
                ++line;
            }
        }
    }

    private int getWeekOfYear(int line) {
        LocalDate referenceDate = this.getData().getDate(this.getData().getAbsoluteStartColumn(), line);
        if (referenceDate == null) {
            referenceDate = this.getData().getDate(this.getData().getAbsoluteEndColumn(), line);
        }
        return referenceDate.weekOfYear;
    }

    private void drawHorizontalMargin() {
        this.gcBuffer.setBackground(this.colorMargin);
        this.gcBuffer.setForeground(this.colorText);
        this.gcBuffer.fillRectangle(this.verticalMarginWidth, 0, this.getCanvas().getBounds().width, this.horizontalMarginHeight);
        Point point = new Point(this.verticalMarginWidth, 0);
        int columnWidth = this.calendar.getColumnWidth(this.getData().getAbsoluteStartColumn());
        int column = this.getData().getAbsoluteStartColumn();
        while (column <= this.getData().getAbsoluteEndColumn()) {
            String text = this.getStringDayofWeek(column);
            Point textExtent = this.gcBuffer.textExtent(text, 1);
            int x = point.x + columnWidth / 2 - textExtent.x / 2;
            int y = point.y + this.horizontalMarginHeight / 2 - textExtent.y / 2;
            this.gcBuffer.drawText(text, x, y, true);
            point.x += this.calendar.getColumnWidth(column);
            ++column;
        }
    }

    private String getStringDayofWeek(int column) {
        int canvasWidth = this.getCanvas().getSize().x;
        FontMetrics fm = this.gcBuffer.getFontMetrics();
        int charWidth = fm.getAverageCharWidth();
        boolean shortText = canvasWidth < charWidth * 63;
        boolean reallyShortText = canvasWidth < charWidth * 28;
        String dayOfWeek = DateUtil.toDayWeekString((int)column, (boolean)false);
        if (reallyShortText) {
            dayOfWeek = dayOfWeek.substring(0, 1);
        } else if (shortText) {
            dayOfWeek = dayOfWeek.substring(0, 3);
        }
        return dayOfWeek;
    }

    private void setKeyEvents() {
        this.myCanvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    LocalDate date = SuperCalendarGrid.this.dateParser.parseAndReset(SuperCalendarGrid.this.getLastSelectedItem());
                    if (date != null) {
                        SuperCalendarGrid.this.calendar.getSelection().clearAddAndFinalize(date);
                        SuperCalendarGrid.this.calendar.revealMonth(date);
                    }
                } else if (UI.ESC((KeyEvent)e)) {
                    SuperCalendarGrid.this.dateParser.reset();
                } else if (UI.NUMBER((KeyEvent)e)) {
                    SuperCalendarGrid.this.dateParser.feed(e.character);
                } else if (UI.SHIFT((KeyEvent)e)) {
                    if (e.keyCode == 0x1000007) {
                        SuperCalendarGrid.this.extendSelectionToToday();
                    } else if (e.keyCode == 0x1000005 && UI.CTRL((KeyEvent)e)) {
                        SuperCalendarGrid.this.extendSelectionByOneYearBackward();
                    } else if (e.keyCode == 0x1000006 && UI.CTRL((KeyEvent)e)) {
                        SuperCalendarGrid.this.extendSelectionByOneYearForward();
                    } else if (e.keyCode == 0x1000005) {
                        SuperCalendarGrid.this.extendSelectionByOneMonthBackward();
                    } else if (e.keyCode == 0x1000006) {
                        SuperCalendarGrid.this.extendSelectionByOneMonthForward();
                    } else if (e.keyCode == 0x1000001) {
                        SuperCalendarGrid.this.extendSelectionToPreviousDayOfWeek();
                    } else if (e.keyCode == 0x1000002) {
                        SuperCalendarGrid.this.extendSelectionToNextDayOfWeek();
                    } else if (e.keyCode == 0x1000003) {
                        SuperCalendarGrid.this.selectYesterday(false);
                    } else if (e.keyCode == 0x1000004) {
                        SuperCalendarGrid.this.selectTomorrow(false);
                    }
                } else if (e.keyCode == 0x1000007) {
                    SuperCalendarGrid.this.selectToday();
                } else if (e.keyCode == 0x1000005 && UI.CTRL((KeyEvent)e)) {
                    SuperCalendarGrid.this.selectOneYearBackward(true);
                } else if (e.keyCode == 0x1000006 && UI.CTRL((KeyEvent)e)) {
                    SuperCalendarGrid.this.selectOneYearForward(true);
                } else if (e.keyCode == 0x1000005) {
                    SuperCalendarGrid.this.selectOneMonthBackward(true);
                } else if (e.keyCode == 0x1000006) {
                    SuperCalendarGrid.this.selectOneMonthForward(true);
                } else if (e.keyCode == 0x1000001) {
                    SuperCalendarGrid.this.selectPreviousDayOfWeek(!UI.CTRL((KeyEvent)e));
                } else if (e.keyCode == 0x1000002) {
                    SuperCalendarGrid.this.selectNextDayOfWeek(!UI.CTRL((KeyEvent)e));
                } else if (e.keyCode == 0x1000003) {
                    SuperCalendarGrid.this.selectYesterday(!UI.CTRL((KeyEvent)e));
                } else if (e.keyCode == 0x1000004) {
                    SuperCalendarGrid.this.selectTomorrow(!UI.CTRL((KeyEvent)e));
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void selectToday() {
        this.track(LocalDate.today(), true, true);
    }

    public void selectOneYearBackward(boolean clearOldSelection) {
        this.track(this.getLastSelectedItem().plusYear(1), clearOldSelection, true);
    }

    public void selectOneYearForward(boolean clearOldSelection) {
        this.track(this.getLastSelectedItem().plusYear(1), clearOldSelection, false);
    }

    public void selectOneMonthBackward(boolean clearOldSelection) {
        this.track(this.getLastSelectedItem().plusMonth(-1), clearOldSelection, true);
    }

    public void selectOneMonthForward(boolean clearOldSelection) {
        this.track(this.getLastSelectedItem().plusMonth(1), clearOldSelection, false);
    }

    public void selectXMonths(LocalDate ld) {
        this.track(ld, true, true);
    }

    private void track(LocalDate date, boolean clearOldSelection, boolean revealAtTop) {
        CalendarSelection selection = this.getSelection();
        if (clearOldSelection) {
            selection.clear();
        }
        selection.track(date);
        selection.finalizeSelection();
        this.calendar.reveal(date, revealAtTop, false);
    }

    public void selectYesterday(boolean clearOldSelection) {
        this.track(this.getLastSelectedItem().plusDay(-1), clearOldSelection, true);
    }

    public void selectNextDayOfWeek(boolean clearOldSelection) {
        this.track(this.getLastSelectedItem().plusDay(7), clearOldSelection, false);
    }

    public void selectPreviousDayOfWeek(boolean clearOldSelection) {
        this.track(this.getLastSelectedItem().plusDay(-7), clearOldSelection, true);
    }

    public void selectTomorrow(boolean clearOldSelection) {
        this.track(this.getLastSelectedItem().plusDay(1), clearOldSelection, false);
    }

    public void extendSelectionToNextDayOfWeek() {
        this.dragDownTo(this.getLastSelectedItem().plusDay(7));
    }

    public void extendSelectionToPreviousDayOfWeek() {
        this.dragUpTo(this.getLastSelectedItem().plusDay(-7));
    }

    public void extendSelectionToToday() {
        LocalDate lastSelectedItem;
        LocalDate today = LocalDate.today();
        if (today.before((IPartialDate)(lastSelectedItem = this.getLastSelectedItem()))) {
            this.dragUpTo(today);
        } else {
            this.dragDownTo(today);
        }
    }

    public void extendSelectionByOneYearBackward() {
        this.dragUpTo(this.getLastSelectedItem().plusYear(-1));
    }

    public void extendSelectionByOneYearForward() {
        this.dragDownTo(this.getLastSelectedItem().plusYear(1));
    }

    public void extendSelectionByOneMonthBackward() {
        this.dragUpTo(this.getLastSelectedItem().plusMonth(-1));
    }

    public void extendSelectionByOneMonthForward() {
        this.dragDownTo(this.getLastSelectedItem().plusMonth(1));
    }

    public void dragUpTo(LocalDate date) {
        CalendarSelection selection = this.getSelection();
        LocalDate first = (LocalDate)selection.first();
        LocalDate last = (LocalDate)selection.last();
        if (date.before((IPartialDate)first)) {
            selection.clear();
            selection.dragTo(last);
            selection.dragTo(date);
        } else {
            selection.clear();
            selection.dragTo(first);
            selection.dragTo(date);
        }
        selection.finalizeSelection();
        this.calendar.revealMonth(date);
    }

    public void dragDownTo(LocalDate date) {
        CalendarSelection selection = this.getSelection();
        LocalDate first = (LocalDate)selection.first();
        LocalDate last = (LocalDate)selection.last();
        if (date.after((IPartialDate)last)) {
            selection.clear();
            selection.dragTo(first);
            selection.dragTo(date);
        } else {
            selection.clear();
            selection.dragTo(last);
            selection.dragTo(date);
        }
        selection.finalizeSelection();
        this.calendar.revealMonth(date);
    }

    private LocalDate getLastSelectedItem() {
        LocalDate lastSelectedItem = (LocalDate)this.getSelection().getLastSelectedItem();
        if (lastSelectedItem == null) {
            return LocalDate.today();
        }
        return lastSelectedItem;
    }

    public LocalDate getDateFromGCPoint(Point point) {
        Cell cell = this.getCellFromGCPoint(point);
        if (cell instanceof CalendarCell) {
            return ((CalendarCell)cell).getDate();
        }
        return null;
    }

    public ICalendarGridData getData() throws IllegalStateException {
        return this.calendar.getData();
    }

    public Composite getCanvas() {
        return this.myCanvas;
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        ResourceGetter.dispose((Object)this.colorMargin);
        ResourceGetter.dispose((Object)this.colorText);
        if (!this.myCanvas.isDisposed()) {
            this.myCanvas.dispose();
        }
        this.calendar.dispose();
    }

    public Cell getCellFromGCPoint(Point gcPoint) {
        Point point = this.calendar.offsetPoint(gcPoint.x, gcPoint.y);
        return this.calendar.getCellFromGCPoint(point);
    }

    public boolean isFixedCellHeight() {
        return this.calendar.isFixedCellHeight();
    }

    public boolean isFixedCellWidth() {
        return this.calendar.isFixedCellWidth();
    }

    public void redraw() {
        this.calendar.redraw();
    }

    public void selectLine(int weekLine) {
        this.calendar.selectLine(weekLine);
    }

    public void setData(ICalendarGridData data) {
        this.calendar.setData(data);
    }

    public void setFixedCellHeight(boolean fixedCellHeight) {
        this.calendar.setFixedCellHeight(fixedCellHeight);
    }

    public void setFixedCellWidth(boolean fixedCellWidth) {
        this.calendar.setFixedCellWidth(fixedCellWidth);
    }

    public CellRendererFactory getCellRendererFactory() {
        return this.calendar.getCellRendererFactory();
    }

    public void setCellRendererFactory(CellRendererFactory cellRendererFactory) {
        this.calendar.setCellRendererFactory(cellRendererFactory);
    }

    public CalendarSelection getSelection() {
        return this.calendar.getSelection();
    }

    public void reveal(LocalDate date) {
        this.calendar.reveal(date, true, false);
    }

    public void revealMonth(LocalDate dateInTheMonth) {
        this.calendar.revealMonth(dateInTheMonth);
    }

    public boolean isVisible(Cell cell, boolean strict) {
        return !this.calendar.isNotVisibleColumn(cell.column, strict) && !this.calendar.isNotVisibleLine(cell.line, strict);
    }

    public LocalDate getEndDate() {
        return this.calendar.getEndDate();
    }

    public void revealMonth(LocalDate dateInTheMonth, boolean force, Boolean revealAtTop) throws IllegalArgumentException, IllegalStateException {
        this.calendar.revealMonth(dateInTheMonth, force, revealAtTop);
    }

    public MyButton getBtnPreviousMonth() {
        return this.btnPreviousMonth;
    }

    public MyButton getBtnNextMonth() {
        return this.btnNextMonth;
    }

    public MyButton getBtnToday() {
        return this.btnToday;
    }

    public Predicate getAutofocusPredicate() {
        return this.autofocusPredicate;
    }

    public void setAutofocusPredicate(Predicate autofocusPredicate) {
        this.autofocusPredicate = autofocusPredicate;
    }

    public boolean shouldAutofocus() {
        return this.autofocusPredicate != null && this.autofocusPredicate.evaluate();
    }
}

