/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.MyTableCombo;
import ca.infodata.ofys.ui.controls.MyTableComboDataAdapter;
import ca.infodata.ofys.ui.controls.TableItemComparator;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MyTableComboSortListener<E>
implements Listener {
    private static final Logger logger = Logger.getLogger(MyTableComboSortListener.class.getName());
    private Table table;
    private MyTableComboDataAdapter<E> adapter;

    public MyTableComboSortListener(MyTableCombo tableCombo, MyTableComboDataAdapter<E> adapter) {
        this.adapter = adapter;
        this.table = tableCombo.getTable();
    }

    public void handleEvent(Event e) {
        System.out.println(new JoinList("\n", this.adapter.getItems()));
        TableColumn selectedColumn = (TableColumn)e.widget;
        this.table.setSortColumn(selectedColumn);
        TableColumn sortColumn = this.table.getSortColumn();
        int dir = this.table.getSortDirection();
        dir = sortColumn == selectedColumn ? (dir == 128 || dir == 0 ? 1024 : 128) : 128;
        Object data = selectedColumn.getData("comparator");
        if (data instanceof TableItemComparator) {
            this.sortWithTableItemComparator(dir, (TableItemComparator)data);
        } else if (data instanceof Comparator) {
            this.sortWithAdapterItemComparator(dir, (Comparator)data);
        } else {
            logger.info("no sort comparator for column " + selectedColumn.getText());
        }
        this.table.setSortDirection(dir);
    }

    private void sortWithTableItemComparator(int dir, Comparator<TableItem> comparator) {
        Object[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setData("i", (Object)i);
            ++i;
        }
        ArrayList itemList = new ArrayList();
        MiscUtil.addArrayToList((Object[])items, itemList);
        if (dir == 1024) {
            comparator = Collections.reverseOrder(comparator);
        }
        Collections.sort(itemList, comparator);
        ArrayList<Object> list = new ArrayList<Object>();
        for (TableItem item : itemList) {
            list.add(item.getData());
        }
        this.adapter.setItems(list);
    }

    private void sortWithAdapterItemComparator(int dir, Comparator<E> comparator) {
        List<E> items = this.adapter.getItems();
        if (dir == 1024) {
            comparator = Collections.reverseOrder(comparator);
        }
        Collections.sort(items, comparator);
        this.adapter.setItems(items);
    }
}

