/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.util1.StringUtils;
import java.util.Arrays;

public class MyMask {
    public static final int NONE = 0;
    public static final int CASE_NORMAL = 8;
    public static final int CASE_UPPER = 16;
    public static final int CASE_LOWER = 32;
    public static final int CASE_ONLY_ALPHANUMERIC = 64;
    public static final int CASE_ONLY_ALPHANUMERIC_EXTENDED = 128;
    private final int style;
    private final String mask;
    private final boolean lower;
    private final boolean upper;
    private final boolean onlyAlphaNum;
    private final boolean onlyAlphaNumEx;

    public static String toLength(char theMaskChar, int lengthOfMask) {
        if (lengthOfMask < 0) {
            return "";
        }
        char[] s = new char[lengthOfMask];
        Arrays.fill(s, theMaskChar);
        return String.valueOf(s);
    }

    public MyMask(char theMaskChar, int lengthOfMask) {
        this(theMaskChar, lengthOfMask, 0);
    }

    public MyMask(char theMaskChar, int lengthOfMask, int style) {
        this(MyMask.toLength(theMaskChar, lengthOfMask), style);
    }

    public MyMask(String mask) {
        this(mask, 0);
    }

    public MyMask(String mask, int style) {
        if (mask == null) {
            throw new NullPointerException("mask");
        }
        this.mask = mask;
        this.style = style;
        this.lower = (style | 0x20) == style;
        this.upper = (style | 0x10) == style;
        this.onlyAlphaNum = (style | 0x40) == style;
        this.onlyAlphaNumEx = (style | 0x40) == style;
    }

    public boolean valid(CharSequence text) {
        int length;
        boolean valid = true;
        if (text == null) {
            text = "";
        }
        if ((length = text.length()) > this.mask.length()) {
            valid = false;
        } else {
            int i = 0;
            while (valid && i < length) {
                valid = this.valid(this.mask.charAt(i), text.charAt(i));
                ++i;
            }
        }
        return valid;
    }

    private boolean valid(char m, char c) {
        boolean valid = false;
        switch (m) {
            case 'A': {
                valid = this.isAlpha(c);
                break;
            }
            case '9': {
                valid = StringUtils.isNumeric((char)c);
                break;
            }
            case '!': {
                valid = true;
                break;
            }
            case '#': {
                valid = this.isAlpha(c) || StringUtils.isNumeric((char)c);
                break;
            }
            default: {
                valid = m == c;
            }
        }
        return valid;
    }

    public String feed(String base, char c) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        return this.feed(base, base.length(), c);
    }

    public String feed(String base, int offset, char c) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (offset < 0 || offset > base.length()) {
            throw new ArrayIndexOutOfBoundsException("offset out of range: " + offset);
        }
        if (this.valid(base)) {
            boolean ok;
            StringBuilder b = new StringBuilder(base);
            this.feedWithMarker(b, base, offset);
            if ((offset += b.length() - base.length()) == b.length()) {
                ok = this.append(b, c);
            } else {
                b.insert(offset, this.applyCaseMask(c));
                ok = this.valid(b);
            }
            if (ok) {
                return b.toString();
            }
        }
        return base;
    }

    private boolean feedWithMarker(StringBuilder b, String text, int offset) {
        boolean modified = false;
        if (offset < this.mask.length() && offset >= 0) {
            int i = offset;
            if (this.mask.length() > text.length()) {
                while (i < this.mask.length() && !this.isMaskMarker(this.mask.charAt(i))) {
                    b.append(this.mask.charAt(i));
                    ++i;
                    modified = true;
                }
            }
        }
        return modified;
    }

    private boolean append(StringBuilder b, char c) {
        char m;
        if (this.mask.length() > b.length() && this.valid(m = this.mask.charAt(b.length()), c = this.applyCaseMask(c))) {
            b.append(c);
            return true;
        }
        return false;
    }

    public String starve(String base, int count) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        return this.starve(base, base.length(), count);
    }

    public String starve(String base, int endOffset, int count) {
        boolean modified;
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (count < 0 || count > base.length()) {
            throw new ArrayIndexOutOfBoundsException("count out of range: " + count);
        }
        if (endOffset < 0 || endOffset > base.length()) {
            throw new ArrayIndexOutOfBoundsException("offset out of range: " + count);
        }
        StringBuilder b = new StringBuilder(base);
        b.delete(endOffset - count, endOffset);
        boolean bl = modified = b.length() != base.length();
        if (this.valid(b)) {
            boolean bl2 = modified = this.starveOfMarker(b, base, endOffset - count - 1) || modified;
            if (modified) {
                return b.toString();
            }
        }
        return base;
    }

    public String starve2(String base, int from, int to) {
        boolean modified;
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (from < 0 || from > base.length()) {
            throw new ArrayIndexOutOfBoundsException("from out of range: " + from);
        }
        if (to < 0 || to > base.length()) {
            throw new ArrayIndexOutOfBoundsException("to out of range: " + to);
        }
        if (to < from) {
            throw new IllegalArgumentException("to is < from : from=" + from + " to=" + to);
        }
        StringBuilder b = new StringBuilder(base);
        b.delete(from, to);
        boolean bl = modified = b.length() != base.length();
        if (this.valid(b)) {
            boolean bl2 = modified = this.starveOfMarker(b, base, b.length() - 1) || modified;
            if (modified) {
                return b.toString();
            }
        }
        return base;
    }

    private boolean starveOfMarker(StringBuilder b, String text, int offset) {
        boolean modified = false;
        if (offset < this.mask.length() && offset >= 0) {
            int i = offset;
            while (i >= 0 && !this.isMaskMarker(this.mask.charAt(i))) {
                b.deleteCharAt(i);
                --i;
                modified = true;
            }
        }
        return modified;
    }

    public String unapply(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        text = this.unapplyCharMask(text);
        return text;
    }

    private String unapplyCharMask(String text) {
        StringBuilder b = new StringBuilder(this.mask.length());
        int i = 0;
        int j = 0;
        while (i < this.mask.length() && j < text.length()) {
            char m;
            char c = text.charAt(j);
            if (c != (m = this.mask.charAt(i)) || this.isMaskMarker(m)) {
                b.append(c);
            }
            ++i;
            ++j;
        }
        if (j < text.length()) {
            b.append(text.substring(j));
        }
        return b.toString();
    }

    public String apply(String text) {
        if (text == null) {
            return null;
        }
        text = this.applyCaseMask(text);
        text = this.applyLimitMask(text);
        text = this.applyCharMask(text);
        return text;
    }

    private String applyCharMask(String text) {
        StringBuilder b = new StringBuilder(this.mask.length());
        int i = 0;
        int j = 0;
        while (i < this.mask.length() && j < text.length()) {
            char c = text.charAt(j);
            char m = this.mask.charAt(i);
            switch (m) {
                case 'A': {
                    if (!this.isAlpha(c)) break;
                    b.append(c);
                    break;
                }
                case '9': {
                    if (!StringUtils.isNumeric((char)c)) break;
                    b.append(c);
                    break;
                }
                case '!': {
                    b.append(c);
                    break;
                }
                case '#': {
                    if (!this.isAlpha(c) && !StringUtils.isNumeric((char)c)) break;
                    b.append(c);
                    break;
                }
                default: {
                    b.append(m);
                    if (c == m) break;
                    --j;
                }
            }
            ++i;
            ++j;
        }
        return b.toString();
    }

    private boolean isMaskMarker(char c) {
        return c == 'A' || c == '9' || c == '!' || c == '#';
    }

    private boolean isAlpha(char c) {
        boolean is = false;
        is = this.lower ? (this.onlyAlphaNumEx ? StringUtils.isAlphaLower((char)c) || StringUtils.isAccentLower((char)c) : StringUtils.isAlphaLower((char)c)) : (this.upper ? (this.onlyAlphaNumEx ? StringUtils.isAlphaUpper((char)c) || StringUtils.isAccentUpper((char)c) : StringUtils.isAlphaUpper((char)c)) : (this.onlyAlphaNumEx ? StringUtils.isAlpha((char)c) || StringUtils.isAccent((char)c) : StringUtils.isAlpha((char)c)));
        return is;
    }

    private String applyLimitMask(String text) {
        if (text.length() > this.mask.length()) {
            return text.substring(0, this.mask.length());
        }
        return text;
    }

    private char applyCaseMask(char c) {
        if (this.lower) {
            return Character.toLowerCase(c);
        }
        if (this.upper) {
            return Character.toUpperCase(c);
        }
        return c;
    }

    private String applyCaseMask(String text) {
        if (this.onlyAlphaNum) {
            text = StringUtils.toAlphanumeric((String)text);
        }
        if (this.onlyAlphaNumEx) {
            text = StringUtils.toAlphanumericExtended((String)text);
        }
        StringBuilder b = new StringBuilder(this.mask.length());
        int i = 0;
        int j = 0;
        while (i < this.mask.length() && j < text.length()) {
            char m;
            char c = text.charAt(j);
            if (c != (m = this.mask.charAt(i)) || this.isMaskMarker(m)) {
                b.append(this.applyCaseMask(c));
            } else {
                b.append(c);
            }
            ++i;
            ++j;
        }
        if (j < text.length()) {
            if (this.lower) {
                b.append(text.substring(j).toLowerCase());
            } else if (this.upper) {
                b.append(text.substring(j).toUpperCase());
            }
        }
        return b.toString();
    }

    public int getStyle() {
        return this.style;
    }

    public String getMask() {
        return this.mask;
    }
}

