/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.IImportance;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator2;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.OrderedDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.OrderedDataObjectList;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ListTable<E extends EditableDataObject>
extends Composite {
    protected IEditableDataObjectList<E> statusList;
    private ProviderAR<E, String[]> labelProvider;
    protected ArrayList<IRowCountListener> lstRowListener = new ArrayList();
    private ArrayList<IToolTipChanged> lstToolTipListener = new ArrayList();
    protected FontAwareTable tabList2;
    private MyButton btnNew;
    private MyButton btnDelete;
    private MyButton btnUp;
    private MyButton btnDown;
    protected int style;
    public static final int LEFT = Integer.parseInt("00000001", 2);
    public static final int RIGHT = Integer.parseInt("00000010", 2);
    public static final int TOP = Integer.parseInt("00000100", 2);
    public static final int BOTTOM = Integer.parseInt("00001000", 2);
    public static final int HIDE_UP_DOWN = Integer.parseInt("00010000", 2);
    public static final int HIDE_NEW_DELETE = Integer.parseInt("00100000", 2);
    public static final int RELATIVE_LAYOUT = Integer.parseInt("01000000", 2);
    private boolean newObjectEdition = false;
    private E itemInEditionOldVersion;
    private E itemInEdition;
    private IBaseEditor2 parentEditor;
    private PredicateA<E> displayPredicate;
    private ArrayList<IListTableModificationListener<E>> lstTableModificationListener = new ArrayList();
    private IPreValidator preValidator;
    private IPreValidator2<E> preValidator2;
    private List<E> lstBeforeModification;

    public ListTable(Composite parent, IBaseEditor2 parentEditor, FormToolkit toolkit, int style) {
        super(parent, 0);
        this.style = style;
        this.parentEditor = parentEditor;
        FormLayout layout = new FormLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.spacing = 2;
        toolkit.adapt((Composite)this);
        this.setLayout((Layout)layout);
        this.tabList2 = new FontAwareTable(this, 67588);
        this.tabList2.setLinesVisible(true);
        toolkit.adapt((Composite)this.tabList2);
        this.tabList2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent arg0) {
                if (ListTable.this.tabList2.getSelectionCount() == 0 && ListTable.this.tabList2.getItemCount() > 0) {
                    ListTable.this.tabList2.select(0);
                }
            }
        });
        this.tabList2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ListTable.this.refreshButton();
            }
        });
        this.tabList2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (ListTable.this.tabList2.getSelectionCount() > 0) {
                    ListTable.this.editItem((EditableDataObject)ListTable.this.tabList2.getSelection()[0].getData());
                }
            }
        });
        this.tabList2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && ListTable.this.tabList2.getSelectionCount() > 0) {
                    ListTable.this.editItem((EditableDataObject)ListTable.this.tabList2.getSelection()[0].getData());
                }
            }
        });
        this.tabList2.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableItem[] items;
                FontAwareTable source = (FontAwareTable)((Object)e.getSource());
                TableItem[] tableItemArray = items = source.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem t = tableItemArray[n2];
                    if (t.getData() != null && t.getData() instanceof EditableDataObject) {
                        String text;
                        EditableDataObject ed = (EditableDataObject)t.getData();
                        if (ed.isStatusDeleted()) {
                            t.setForeground(ResourceGetter.getRedWarningColor());
                            t.setFont(ResourceGetter.getFontBold());
                            text = t.getText(0);
                            if (!text.startsWith("[D]")) {
                                t.setText(0, "[D]" + text);
                            }
                        } else {
                            t.setForeground(null);
                            t.setFont(ResourceGetter.getFontNormal());
                            text = t.getText(0);
                            if (text.startsWith("[D]")) {
                                t.setText(0, text.substring(3));
                            }
                        }
                    }
                    ++n2;
                }
            }
        });
        if ((style & HIDE_NEW_DELETE) != HIDE_NEW_DELETE) {
            this.btnNew = new MyButton(this, Messages.getString((String)"AJOUTER", (String[])new String[0]), 8, toolkit);
            this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ListTable.this.editNewItem();
                }
            });
            this.btnDelete = new MyButton(this, Messages.getString((String)"SUPPRIMER", (String[])new String[0]), 8, toolkit);
            this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ListTable.this.delete();
                    ListTable.this.tabList2.redraw();
                }
            });
        }
        if ((style & HIDE_UP_DOWN) != HIDE_UP_DOWN) {
            this.btnUp = new MyButton(this, Messages.getString((String)"HAUT", (String[])new String[0]), 8, toolkit);
            this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ListTable.this.upField();
                }
            });
            this.btnDown = new MyButton(this, Messages.getString((String)"BAS", (String[])new String[0]), 8, toolkit);
            this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ListTable.this.downField();
                }
            });
        }
        this.setTabList(new Control[]{this.tabList2});
        this.setButtonPosition();
        toolkit.paintBordersFor((Composite)this);
    }

    public E getFirstSelectedItem() {
        TableItem[] selection = this.tabList2.getSelection();
        if (selection == null || selection.length == 0) {
            return null;
        }
        return (E)((EditableDataObject)selection[0].getData());
    }

    public void addListSelectionChangeListener(SelectionListener listener) {
        this.tabList2.addSelectionListener(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = this.tabList2.computeSize(wHint, hHint, changed);
        if (size.y < 120) {
            size.y = 120;
        }
        return size;
    }

    public void addColumn(int width) {
        TableColumn tblCol = new TableColumn((Table)this.tabList2, 0);
        tblCol.setWidth(width);
        this.tabList2.setHeaderVisible(false);
    }

    public void addColumn(int width, String title) {
        TableColumn tblCol = new TableColumn((Table)this.tabList2, 0);
        tblCol.setWidth(width);
        tblCol.setText(title);
        this.tabList2.setHeaderVisible(true);
    }

    private void setButtonPosition() {
        Control ctrlTempDelete = null;
        Control ctrlAttach = null;
        FormData datatabList = new FormData();
        FormData dataBtnDown = new FormData();
        FormData dataBtnUp = new FormData();
        FormData dataBtnDelete = new FormData();
        FormData dataBtnNew = new FormData();
        if ((this.style & RELATIVE_LAYOUT) != RELATIVE_LAYOUT) {
            dataBtnNew.width = MyButton.getStandardButtonWidth();
            dataBtnDelete.width = MyButton.getStandardButtonWidth();
            dataBtnUp.width = MyButton.getStandardButtonWidth();
            dataBtnDown.width = MyButton.getStandardButtonWidth();
        }
        if ((this.style & LEFT) == LEFT) {
            if ((this.style & HIDE_NEW_DELETE) != HIDE_NEW_DELETE) {
                dataBtnNew.top = new FormAttachment(0);
                dataBtnNew.left = new FormAttachment(0);
                dataBtnDelete.top = new FormAttachment(this.btnNew.getControl());
                dataBtnDelete.left = new FormAttachment(0);
                ctrlTempDelete = this.btnDelete.getControl();
                ctrlAttach = this.btnDelete.getControl();
            }
            if ((this.style & HIDE_UP_DOWN) != HIDE_UP_DOWN) {
                dataBtnUp.top = ctrlTempDelete != null ? new FormAttachment(this.btnDelete.getControl(), 3) : new FormAttachment(0);
                dataBtnUp.left = new FormAttachment(0);
                dataBtnDown.top = new FormAttachment(this.btnUp.getControl());
                dataBtnDown.left = new FormAttachment(0);
                ctrlAttach = this.btnUp.getControl();
            }
            datatabList.right = new FormAttachment(100);
            datatabList.left = new FormAttachment(ctrlAttach);
            datatabList.top = new FormAttachment(0);
            datatabList.bottom = new FormAttachment(100);
        } else if ((this.style & RIGHT) == RIGHT) {
            if ((this.style & HIDE_NEW_DELETE) != HIDE_NEW_DELETE) {
                dataBtnNew.top = new FormAttachment(0);
                dataBtnNew.right = new FormAttachment(100);
                dataBtnDelete.top = new FormAttachment(this.btnNew.getControl());
                dataBtnDelete.right = new FormAttachment(100);
                ctrlTempDelete = this.btnDelete.getControl();
                ctrlAttach = this.btnDelete.getControl();
            }
            if ((this.style & HIDE_UP_DOWN) != HIDE_UP_DOWN) {
                dataBtnUp.top = ctrlTempDelete != null ? new FormAttachment(this.btnDelete.getControl(), 3) : new FormAttachment(0);
                dataBtnUp.right = new FormAttachment(100);
                dataBtnDown.top = new FormAttachment(this.btnUp.getControl());
                dataBtnDown.right = new FormAttachment(100);
                ctrlAttach = this.btnUp.getControl();
            }
            datatabList.right = new FormAttachment(ctrlAttach);
            datatabList.left = new FormAttachment(0);
            datatabList.top = new FormAttachment(0);
            datatabList.bottom = new FormAttachment(100);
        } else if ((this.style & TOP) == TOP) {
            if ((this.style & HIDE_NEW_DELETE) != HIDE_NEW_DELETE) {
                dataBtnNew.top = new FormAttachment(0);
                dataBtnNew.left = new FormAttachment(0);
                dataBtnDelete.top = new FormAttachment(0);
                dataBtnDelete.left = new FormAttachment(this.btnNew.getControl());
                if ((this.style & RELATIVE_LAYOUT) == RELATIVE_LAYOUT) {
                    dataBtnNew.right = new FormAttachment(40);
                    dataBtnDelete.right = new FormAttachment(80);
                }
                ctrlTempDelete = this.btnDelete.getControl();
                ctrlAttach = this.btnDelete.getControl();
            }
            if ((this.style & HIDE_UP_DOWN) != HIDE_UP_DOWN) {
                dataBtnUp.top = new FormAttachment(0);
                dataBtnUp.left = ctrlTempDelete != null ? new FormAttachment(this.btnDelete.getControl(), 7) : new FormAttachment(0);
                dataBtnDown.top = new FormAttachment(0);
                dataBtnDown.left = new FormAttachment(this.btnUp.getControl());
                ctrlAttach = this.btnUp.getControl();
            }
            datatabList.right = new FormAttachment(100);
            datatabList.left = new FormAttachment(0);
            datatabList.top = new FormAttachment(ctrlAttach);
            datatabList.bottom = new FormAttachment(100);
        } else if ((this.style & BOTTOM) == BOTTOM) {
            if ((this.style & HIDE_NEW_DELETE) != HIDE_NEW_DELETE) {
                dataBtnNew.left = new FormAttachment(0);
                dataBtnNew.bottom = new FormAttachment(100);
                dataBtnDelete.left = new FormAttachment(this.btnNew.getControl());
                dataBtnDelete.bottom = new FormAttachment(100);
                if ((this.style & RELATIVE_LAYOUT) == RELATIVE_LAYOUT) {
                    dataBtnNew.right = new FormAttachment(40);
                    dataBtnDelete.right = new FormAttachment(80);
                }
                ctrlTempDelete = this.btnDelete.getControl();
                ctrlAttach = this.btnDelete.getControl();
            }
            if ((this.style & HIDE_UP_DOWN) != HIDE_UP_DOWN) {
                dataBtnUp.left = ctrlTempDelete != null ? new FormAttachment(this.btnDelete.getControl(), 7) : new FormAttachment(0);
                dataBtnUp.bottom = new FormAttachment(100);
                dataBtnDown.left = new FormAttachment(this.btnUp.getControl());
                dataBtnDown.bottom = new FormAttachment(100);
                ctrlAttach = this.btnUp.getControl();
            }
            datatabList.right = new FormAttachment(100);
            datatabList.left = new FormAttachment(0);
            datatabList.top = new FormAttachment(0);
            datatabList.bottom = new FormAttachment(ctrlAttach);
        }
        if ((this.style & HIDE_NEW_DELETE) != HIDE_NEW_DELETE) {
            this.btnNew.setLayoutData(dataBtnNew);
            this.btnDelete.setLayoutData(dataBtnDelete);
        }
        if ((this.style & HIDE_UP_DOWN) != HIDE_UP_DOWN) {
            this.btnUp.setLayoutData(dataBtnUp);
            this.btnDown.setLayoutData(dataBtnDown);
        }
        this.tabList2.setLayoutData(datatabList);
    }

    protected abstract void enterEditionMode(E var1);

    protected abstract void leaveEditionMode();

    public abstract E initializeNewDataObject();

    public abstract IPreValidator getPreValidatorNewInstance();

    public abstract IPreValidator2<E> getPreValidatorNewInstance2();

    public IBaseEditor2 getParentEditor() {
        return this.parentEditor;
    }

    public void addRowListener(IRowCountListener listener) {
        this.lstRowListener.add(listener);
    }

    public void addToolTipListener(IToolTipChanged listener) {
        this.lstToolTipListener.add(listener);
    }

    public void refreshRowCount() {
        int numberOfRow = this.tabList2.getItemCount();
        int i = 0;
        while (i < this.lstRowListener.size()) {
            this.lstRowListener.get(i).rowCountChanged(numberOfRow);
            ++i;
        }
        String toolTip = this.getToolTip();
        int i2 = 0;
        while (i2 < this.lstToolTipListener.size()) {
            this.lstToolTipListener.get(i2).toolTipChanged(toolTip);
            ++i2;
        }
    }

    private void refreshButton() {
        if ((this.style & HIDE_NEW_DELETE) != HIDE_NEW_DELETE) {
            this.btnDelete.setEnabled(this.tabList2.getSelectionCount() > 0);
        }
    }

    public String getToolTip() {
        String toolTipText = "";
        int i = 0;
        while (i < this.tabList2.getItemCount()) {
            if (toolTipText.length() > 0) {
                toolTipText = String.valueOf(toolTipText) + '\r';
            }
            toolTipText = String.valueOf(toolTipText) + this.tabList2.getItem(i).getData().toString();
            ++i;
        }
        return toolTipText;
    }

    private void upField() {
        int selection = this.tabList2.getSelectionIndex();
        if (selection > 0) {
            ArrayList<Object> lstFields = new ArrayList<Object>();
            int i = 0;
            while (i < this.tabList2.getItemCount()) {
                if (i == selection) {
                    lstFields.add(this.tabList2.getItem(i - 1).getData());
                } else if (i == selection - 1) {
                    lstFields.add(this.tabList2.getItem(i + 1).getData());
                } else {
                    lstFields.add(this.tabList2.getItem(i).getData());
                }
                ++i;
            }
            this.tabList2.removeAll();
            this.setImportanceToFields(lstFields);
            this.tabList2.select(selection - 1);
            this.getParentEditor().checkDirty();
        }
    }

    private void downField() {
        int selection = this.tabList2.getSelectionIndex();
        if (selection > -1 && selection + 1 != this.tabList2.getItemCount()) {
            ArrayList<Object> lstFields = new ArrayList<Object>();
            int i = 0;
            while (i < this.tabList2.getItemCount()) {
                if (i == selection) {
                    lstFields.add(this.tabList2.getItem(i + 1).getData());
                } else if (i == selection + 1) {
                    lstFields.add(this.tabList2.getItem(i - 1).getData());
                } else {
                    lstFields.add(this.tabList2.getItem(i).getData());
                }
                ++i;
            }
            this.tabList2.removeAll();
            this.setImportanceToFields(lstFields);
            this.tabList2.select(selection + 1);
            this.getParentEditor().checkDirty();
        }
    }

    private void setImportanceToFields(ArrayList<Object> lstFields) {
        int imp = 0;
        int i = 0;
        while (i < lstFields.size()) {
            IImportance field = (IImportance)lstFields.get(i);
            if (!ModificationStatus.STATUS_DELETED.equals(((EditableDataObject)lstFields.get((int)i)).modificationStatus.get())) {
                if (field.getImportance() != imp) {
                    field.setImportance(Short.valueOf((short)imp));
                    ((EditableDataObject)lstFields.get((int)i)).modificationStatus.set((Object)ModificationStatus.STATUS_UPDATED_ORDER);
                }
                imp += 256;
            }
            TableItem item = new TableItem((Table)this.tabList2, 0);
            item.setText(this.getTextForItem((EditableDataObject)field));
            item.setData((Object)field);
            ++i;
        }
    }

    public void editItem(E dataObject) {
        if (this.validForEdition(dataObject)) {
            this.lstBeforeModification = this.statusList.getNotDeleted();
            boolean bl = this.newObjectEdition = !this.statusList.contains(dataObject);
            if (!this.newObjectEdition) {
                this.itemInEditionOldVersion = dataObject;
                if (dataObject != null) {
                    int indexOldVersion = this.statusList.indexOf(dataObject);
                    dataObject = dataObject.clone();
                    this.tabList2.getSelection()[0].setData(dataObject);
                    dataObject.setUpdated();
                    this.statusList.set(indexOldVersion, dataObject);
                }
            } else {
                this.statusList.add(dataObject);
            }
            this.itemInEdition = dataObject;
            this.getParentEditor().checkDirty();
            this.enterEditionMode(dataObject);
        } else {
            this.showError();
        }
    }

    public void editNewItem() {
        this.editItem(this.initializeNewDataObject());
    }

    public boolean save() {
        boolean ret = true;
        if (this.validForSave(this.itemInEdition)) {
            boolean done = this.saving(this.itemInEdition);
            if (done) {
                if (this.newObjectEdition) {
                    this.itemInEdition.setNew();
                    TableItem item = new TableItem((Table)this.tabList2, 0);
                    item.setText(this.getTextForItem(this.itemInEdition));
                    item.setData(this.itemInEdition);
                    this.tabList2.select(0);
                    if (this.itemInEdition instanceof OrderedDataObject && (this.style & HIDE_UP_DOWN) != HIDE_UP_DOWN) {
                        if (this.tabList2.getItemCount() == 1) {
                            ((OrderedDataObject)this.itemInEdition).setIsFirst(Boolean.valueOf(true));
                        } else if (this.tabList2.getItemCount() > 1) {
                            ((OrderedDataObject)this.itemInEdition).setIsFirst(Boolean.valueOf(false));
                            ((OrderedDataObject)this.tabList2.getItem(this.tabList2.getItemCount() - 2).getData()).setNext((OrderedDataObject)this.itemInEdition);
                            ((OrderedDataObject)this.tabList2.getItem(this.tabList2.getItemCount() - 2).getData()).setUpdatedOrder();
                            this.orderUpdated((EditableDataObject)this.tabList2.getItem(this.tabList2.getItemCount() - 2).getData());
                        }
                    } else if (this.itemInEdition instanceof IImportance && (this.style & HIDE_UP_DOWN) != HIDE_UP_DOWN) {
                        ((IImportance)this.itemInEdition).setImportance(Short.valueOf((short)(256 * (this.tabList2.getItemCount() - 1))));
                    }
                    EditableDataObject dataObject = (EditableDataObject)this.tabList2.getSelection()[0].getData();
                    this.tabList2.getSelection()[0].setText(this.getTextForItem(dataObject));
                    this.refreshRowCount();
                    this.saved(this.itemInEdition);
                } else {
                    if (this.tabList2.getSelectionIndex() > -1) {
                        if (this.tabList2.getSelectionIndex() > 0 && this.tabList2.getItem(this.tabList2.getSelectionIndex() - 1).getData() instanceof OrderedDataObject) {
                            OrderedDataObject previousItem = (OrderedDataObject)this.tabList2.getItem(this.tabList2.getSelectionIndex() - 1).getData();
                            previousItem.setNext((OrderedDataObject)this.tabList2.getSelection()[0].getData());
                            previousItem.setUpdatedOrder();
                            this.orderUpdated(previousItem);
                        }
                        EditableDataObject dataObject = (EditableDataObject)this.tabList2.getSelection()[0].getData();
                        this.tabList2.getSelection()[0].setText(this.getTextForItem(dataObject));
                    }
                    this.updated(this.itemInEdition);
                }
                this.leaveEditionMode();
            }
        } else {
            ret = false;
            this.showError();
        }
        return ret;
    }

    public void cancel() {
        if (this.newObjectEdition) {
            this.statusList.remove(this.itemInEdition);
        } else {
            TableItem[] selection = this.tabList2.getSelection();
            if (selection != null && selection.length >= 1) {
                this.lstBeforeModification = this.statusList.getNotDeleted();
                int indexOldVersion = this.statusList.indexOf(this.itemInEdition);
                selection[0].setData(this.itemInEditionOldVersion);
                this.statusList.set(indexOldVersion, this.itemInEditionOldVersion);
                this.updated(this.itemInEditionOldVersion);
            }
        }
        this.getParentEditor().checkDirty();
        this.leaveEditionMode();
    }

    public void refresh() {
        int i = 0;
        while (i < this.tabList2.getItemCount()) {
            EditableDataObject dataObject = (EditableDataObject)this.tabList2.getItem(i).getData();
            this.tabList2.getItem(i).setText(this.getTextForItem(dataObject));
            ++i;
        }
    }

    public boolean delete() {
        boolean ret = true;
        int selection = this.tabList2.getSelectionIndex();
        if (selection > -1) {
            EditableDataObject e = (EditableDataObject)this.tabList2.getItem(selection).getData();
            if (this.validForDelete(e)) {
                boolean done = this.deleting(e);
                if (done) {
                    this.lstBeforeModification = this.statusList.getNotDeleted();
                    EditableDataObject toDelete = e;
                    toDelete.setDeleted();
                    this.tabList2.notifyListeners(13, new Event());
                    this.refreshRowCount();
                    this.getParentEditor().checkDirty();
                    this.deleted(toDelete);
                }
            } else {
                ret = false;
                this.showError();
            }
        }
        return ret;
    }

    public int getItemCount() {
        return this.tabList2.getItemCount();
    }

    public void setStatusList(IEditableDataObjectList<E> statusList) {
        if (statusList == null) {
            throw new NullPointerException("statusList");
        }
        this.tabList2.removeAll();
        this.statusList = statusList;
        if (statusList instanceof OrderedDataObjectList) {
            OrderedDataObjectList orderedList = (OrderedDataObjectList)this.statusList;
            OrderedDataObject dataObject = orderedList.getFirst();
            while (dataObject != null) {
                if (!this.displayable(dataObject)) continue;
                TableItem item = new TableItem((Table)this.tabList2, 0);
                item.setText(this.getTextForItem(dataObject));
                item.setData((Object)dataObject);
                dataObject = dataObject.getNext();
            }
        } else {
            int i = 0;
            while (i < statusList.size()) {
                EditableDataObject dataObject = (EditableDataObject)statusList.get(i);
                if (this.displayable(dataObject)) {
                    TableItem item = new TableItem((Table)this.tabList2, 0);
                    item.setText(this.getTextForItem(dataObject));
                    item.setData((Object)dataObject);
                }
                ++i;
            }
        }
        this.refreshRowCount();
    }

    private String[] getTextForItem(E item) {
        if (this.labelProvider != null) {
            return (String[])this.labelProvider.get(item);
        }
        return new String[]{String.valueOf(item)};
    }

    public ProviderAR<E, String[]> getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ProviderAR<E, String[]> labelProvider) {
        this.labelProvider = labelProvider;
    }

    public Table getTable() {
        return this.tabList2;
    }

    public void addTableModificationListener(IListTableModificationListener<E> listener) {
        this.lstTableModificationListener.add(listener);
    }

    protected boolean saving(E dataObject) {
        return true;
    }

    protected boolean deleting(E dataObject) {
        return true;
    }

    private void saved(E dataObject) {
        int i = 0;
        while (i < this.lstTableModificationListener.size()) {
            this.lstTableModificationListener.get(i).saved(this.lstBeforeModification, this.statusList.getNotDeleted(), dataObject);
            ++i;
        }
    }

    private void updated(E dataObject) {
        int i = 0;
        while (i < this.lstTableModificationListener.size()) {
            this.lstTableModificationListener.get(i).updated(this.lstBeforeModification, this.statusList.getNotDeleted(), dataObject);
            ++i;
        }
    }

    private void orderUpdated(E dataObject) {
        int i = 0;
        while (i < this.lstTableModificationListener.size()) {
            this.lstTableModificationListener.get(i).orderUpdated(dataObject);
            ++i;
        }
    }

    private void deleted(E dataObject) {
        int i = 0;
        while (i < this.lstTableModificationListener.size()) {
            this.lstTableModificationListener.get(i).deleted(this.lstBeforeModification, this.statusList.getNotDeleted(), dataObject);
            ++i;
        }
    }

    private boolean validForEdition(E dataObject) {
        boolean valid = true;
        if (this.getPreValidator() != null) {
            valid = this.getPreValidator().validForEdition(dataObject, ((EditorInput)this.getParentEditor().getEditorInput()).getCompleteDataObject());
        }
        if (this.getPreValidator2() != null) {
            valid = this.getPreValidator2().validForEdition(dataObject);
        }
        return valid;
    }

    private boolean validForSave(E dataObject) {
        boolean valid = true;
        if (this.getPreValidator() != null) {
            valid = this.getPreValidator().validForSave(dataObject, ((EditorInput)this.getParentEditor().getEditorInput()).getCompleteDataObject());
        }
        if (this.getPreValidator2() != null) {
            valid = this.getPreValidator2().validForSave(dataObject);
        }
        return valid;
    }

    private boolean validForDelete(E dataObject) {
        boolean valid = true;
        if (this.getPreValidator() != null) {
            valid = this.getPreValidator().validForDelete(dataObject, ((EditorInput)this.getParentEditor().getEditorInput()).getCompleteDataObject());
        }
        if (this.getPreValidator2() != null) {
            valid = this.getPreValidator2().validForDelete(dataObject);
        }
        return valid;
    }

    private void showError() {
        IPreValidator2<E> validator2;
        IPreValidator validator = this.getPreValidator();
        if (validator != null) {
            MyMessageDialogBuilder dialog = new MyMessageDialogBuilder();
            dialog.useWarningBundle();
            dialog.setMessage(validator.getError() == null ? "" : validator.getError());
            dialog.buildAndOpen();
        }
        if ((validator2 = this.getPreValidator2()) != null) {
            MyMessageDialogBuilder dialog = new MyMessageDialogBuilder();
            dialog.useWarningBundle();
            dialog.setMessage(validator2.getError() == null ? "" : validator2.getError());
            dialog.buildAndOpen();
        }
    }

    private IPreValidator getPreValidator() {
        if (this.preValidator == null) {
            this.preValidator = this.getPreValidatorNewInstance();
        }
        return this.preValidator;
    }

    private IPreValidator2<E> getPreValidator2() {
        if (this.preValidator2 == null) {
            this.preValidator2 = this.getPreValidatorNewInstance2();
        }
        return this.preValidator2;
    }

    public void select(int index) {
        this.tabList2.select(index);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tabList2.setEnabled(enabled);
        if (this.btnDelete != null) {
            this.btnDelete.setEnabled(enabled);
        }
        if (this.btnNew != null) {
            this.btnNew.setEnabled(enabled);
        }
        if (this.btnUp != null) {
            this.btnUp.setEnabled(enabled);
        }
        if (this.btnDown != null) {
            this.btnDown.setEnabled(enabled);
        }
    }

    public void setBtnDeleteEnabled(boolean enabled) {
        if (this.btnDelete != null) {
            this.btnDelete.setEnabled(enabled);
        }
    }

    public IEditableDataObjectList<E> getStatusList() {
        return this.statusList;
    }

    private boolean displayable(E e) {
        return this.displayPredicate == null || this.displayPredicate.evaluate(e);
    }

    public PredicateA<E> getDisplayPredicate() {
        return this.displayPredicate;
    }

    public void setDisplayPredicate(PredicateA<E> displayPredicate) {
        this.displayPredicate = displayPredicate;
    }

    public static interface IListTableModificationListener<E extends EditableDataObject> {
        public void saved(List<E> var1, List<E> var2, E var3);

        public void updated(List<E> var1, List<E> var2, E var3);

        public void orderUpdated(E var1);

        public void deleted(List<E> var1, List<E> var2, E var3);
    }

    public static interface IRowCountListener {
        public void rowCountChanged(int var1);
    }

    public static interface IToolTipChanged {
        public void toolTipChanged(String var1);
    }
}

