/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FontAwareSection
extends Section
implements IRefreshFont {
    private int fontSizeIncrement = 0;
    private int fontStyle = 1;

    public FontAwareSection(Composite parent, int style, FormToolkit formToolkit) {
        this(parent, style);
        this.setBackground(formToolkit.getColors().getBackground());
        int sectionStyle = style;
        FormColors colors = formToolkit.getColors();
        FontAwareSection section = this;
        if ((sectionStyle & 0x100) != 0 || (sectionStyle & 0x200) != 0) {
            colors.initializeSectionToolBarColors();
            section.setTitleBarBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
            section.setTitleBarBorderColor(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        }
        section.setTitleBarForeground(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
    }

    public FontAwareSection(Composite parent, int style) {
        super(parent, style);
        this.setFont(this.fontSizeIncrement, this.fontStyle);
    }

    public void setFont(int fontSizeIncrement, int fontStyle) {
        this.fontSizeIncrement = fontSizeIncrement;
        this.fontStyle = fontStyle;
        this.setFont(ResourceGetter.getFont((int)fontSizeIncrement, (int)fontStyle));
    }

    public void refreshFont() {
        this.setFont(this.fontSizeIncrement, this.fontStyle);
        FontAwareComposite.refreshFont(this.getChildren());
    }

    protected void checkSubclass() {
    }
}

