/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.QuickProposalEdition;
import ca.infodata.ofys.ui.controls.browser.BrowserComposite;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public final class ControlDecorator {
    private static final Logger logger = Logger.getLogger(ControlDecorator.class.getName());

    public static void decorateWithEditProposal(final TemplateAssistText assistText, int position) {
        if (assistText == null) {
            throw new NullPointerException("assistText");
        }
        String EDITER = Messages.getString((String)"EDIT_GABARIT", (String[])new String[0]);
        Image fieldDecorationRequiredImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        ControlDecoration editDecoration = new ControlDecoration(assistText.getControl(), position);
        editDecoration.setMarginWidth(1);
        editDecoration.setImage(fieldDecorationRequiredImage);
        editDecoration.setDescriptionText(EDITER);
        editDecoration.show();
        editDecoration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickProposalEdition.editProposal(assistText);
            }
        });
    }

    public static void decorateWithCustomRunnable(Control control, int position, final Runnable runnable, String description) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        Image fieldDecorationRequiredImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        ControlDecoration editDecoration = new ControlDecoration(control, position);
        editDecoration.setMarginWidth(1);
        editDecoration.setImage(fieldDecorationRequiredImage);
        editDecoration.setDescriptionText(description);
        editDecoration.show();
        if (runnable != null) {
            editDecoration.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    runnable.run();
                }
            });
        }
    }

    public static void decorateWithRequiredField(Control control) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        Image fieldDecorationRequiredImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage();
        ControlDecoration controlDecorationRequired = new ControlDecoration(control, 0x1004000);
        controlDecorationRequired.setMarginWidth(0);
        controlDecorationRequired.setImage(fieldDecorationRequiredImage);
        controlDecorationRequired.setDescriptionText(Messages.getString((String)"CASE_OBLIGATOIRE", (String[])new String[0]));
    }

    public static void decorateWithHelp(Control control, Runnable runnable) {
        ControlDecorator.decorateWithHelp(control, runnable, 1, 0x1020000);
    }

    public static void decorateWithHelp(final Control control, final Runnable runnable, int marginWidth, int decorationStyle) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        Image image = ResourceGetter.getImage((String)"images/help.gif");
        ControlDecoration decoration = new ControlDecoration(control, decorationStyle);
        decoration.setMarginWidth(marginWidth);
        decoration.setImage(image);
        decoration.setDescriptionText(Messages.getString((String)"AIDE", (String[])new String[0]));
        decoration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    runnable.run();
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "Failed to show help for control " + control, e2);
                }
            }
        });
    }

    public static void decorateWithHelpToolip(Control control, String text, int marginWidth, int decorationStyle) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        Image image = ResourceGetter.getImage((String)"images/help.gif");
        ControlDecoration decoration = new ControlDecoration(control, decorationStyle);
        decoration.setMarginWidth(marginWidth);
        decoration.setImage(image);
        decoration.setDescriptionText(text);
    }

    public static void decorateWithInformationToolip(Control control, String text, int marginWidth, int decorationStyle) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        ControlDecoration decoration = new ControlDecoration(control, decorationStyle);
        decoration.setMarginWidth(marginWidth);
        decoration.setImage(image);
        decoration.setDescriptionText(text);
    }

    public static void decorateWithHelp(Control control, String text) {
        Runnable runnable = ControlDecorator.newInfoMessageRunnable(control, text);
        ControlDecorator.decorateWithHelp(control, runnable);
    }

    public static Runnable newInfoMessageRunnable(final Control control, final String text) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            MessageUtil.infoMsg((Shell)control.getShell(), (String)text);
                        }
                    }
                });
            }
        };
        return runnable;
    }

    public static void decorateWithHelpWeb(final Control control, final String url) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            Program.launch((String)url);
                        }
                    }
                });
            }
        };
        ControlDecorator.decorateWithHelp(control, runnable);
    }

    public static void decorateWithHelpHandler(final Control control, final String section) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                            Command command = service.getCommand("ca.infodata.ofys.ui.help.commands.helpCommand");
                            try {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("section", section);
                                params.put("modal", "true");
                                ExecutionEvent event = new ExecutionEvent(command, params, null, null);
                                command.executeWithChecks(event);
                            }
                            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                                logger.log(Level.SEVERE, "ERROR Command ca.infodata.ofys.ui.help.commands.helpCommand", e);
                            }
                        }
                    }
                });
            }
        };
        ControlDecorator.decorateWithHelp(control, runnable);
    }

    public static void decorateWithHelpHtml(final Control control, final String innerUtf8Body) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            MyMessageDialogBuilder dialogBuilder = new MyMessageDialogBuilder(){

                                @Override
                                protected Control createCustomArea(Composite parent) {
                                    return super.createCustomArea(parent);
                                }

                                @Override
                                protected Control createMessageArea(Composite composite) {
                                    BrowserComposite browser = new BrowserComposite(composite, UI.createToolKit((Widget)composite));
                                    browser.setHtml("<html><head><meta charset=\"utf-8\"></head><body>" + innerUtf8Body + "</body>" + "</html>");
                                    GridDataFactory.fillDefaults().align(4, 1).grab(true, true).hint(this.convertHorizontalDLUsToPixels(400), this.convertHeightInCharsToPixels(12)).applyTo((Control)browser);
                                    return composite;
                                }
                            };
                            dialogBuilder.setButtonLabels(MessageUtil.OK);
                            dialogBuilder.setBlockOnOpen(true);
                            dialogBuilder.buildAndOpen();
                        }
                    }
                });
            }
        };
        ControlDecorator.decorateWithHelp(control, runnable);
    }

    public static ControlDecoration decorateWithError(Control control) {
        ControlDecoration dec = new ControlDecoration(control, 16512);
        FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        dec.setImage(errorFieldIndicator.getImage());
        dec.setDescriptionText(errorFieldIndicator.getDescription());
        return dec;
    }
}

