/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.WebSocketResponse;
import ca.infodata.util1.ProviderR;
import java.util.Collection;

public class WebSocketChannelForwarder
implements IWebSocketChannel {
    private Collection<? extends IWebSocketChannel> channels;

    public WebSocketChannelForwarder(Collection<? extends IWebSocketChannel> channels) {
        this.channels = channels;
    }

    public String getId() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? null : first.getId();
    }

    private final IWebSocketChannel getFirstOpenOrJustFirst() {
        IWebSocketChannel first = this.channels.stream().filter(c -> c.isOpen()).findFirst().orElse(null);
        if (first == null) {
            first = this.channels.stream().findFirst().orElse(null);
        }
        return first;
    }

    public String getHttpSessionId() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? null : first.getHttpSessionId();
    }

    public Integer getXClientId() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? null : first.getXClientId();
    }

    public void send(WebSocketResponse wsResponse) {
        this.channels.stream().filter(c -> c.isOpen()).forEach(c -> c.send(wsResponse));
    }

    public void send(String msg) {
        this.channels.stream().filter(c -> c.isOpen()).forEach(c -> c.send(msg));
    }

    public void send(ProviderR<String> msgDelegate) {
        this.channels.stream().filter(c -> c.isOpen()).forEach(c -> c.send(msgDelegate));
    }

    public boolean isOpen() {
        IWebSocketChannel first = this.getFirstOpenOrJustFirst();
        return first == null ? false : first.isOpen();
    }

    public Integer getXSessionId() {
        return Application.get().getGlobalInstances().getSession() == null ? null : Application.get().getGlobalInstances().getSession().getId();
    }
}

