/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import ca.infodata.ofys.ui.browser.resource.BadResource;
import ca.infodata.ofys.ui.browser.resource.URLResource2;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.framework.BundleContext;

public class ClasspathResourceHandler
extends ResourceHandler {
    private static final Logger logger = Logger.getLogger(ClasspathResourceHandler.class.getName());
    private PathMap pathMap;

    public void addClassLoader(String pattern, BundleContext context) {
        if (context == null) {
            throw new NullPointerException("classLoader");
        }
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException("pattern");
        }
        if (this.pathMap == null) {
            this.pathMap = new PathMap(true);
        }
        this.pathMap.put(pattern, (Object)context);
    }

    public void removeClassLoader(String pattern) {
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException("pattern");
        }
        if (this.pathMap != null && this.pathMap.containsKey((Object)pattern)) {
            this.pathMap.remove((Object)pattern);
        }
    }

    public Resource getResource(String path) throws MalformedURLException {
        PathMap.MappedEntry match;
        if (this.pathMap != null && (match = this.pathMap.getMatch(path)) != null) {
            BundleContext loader = (BundleContext)match.getValue();
            String path2 = PathMap.pathMatch((String)match.getKey(), (String)path);
            String path3 = PathMap.pathInfo((String)match.getKey(), (String)path);
            URL url = loader.getBundle().getResource(String.valueOf(path2) + path3);
            if (url != null) {
                path2 = URIUtil.canonicalPath((String)path);
                Resource r = ClasspathResourceHandler.newResource(url, true);
                return r;
            }
            System.out.println("no resource found for path " + path2 + path3);
        }
        return null;
    }

    protected static Resource newResource(URL url, boolean useCaches) {
        if (url == null) {
            return null;
        }
        String url_string = url.toExternalForm();
        if (url_string.startsWith("file:")) {
            try {
                FileResource fileResource = new FileResource(url);
                return fileResource;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error loading resource with url " + url, e);
                return new BadResource(url, e.toString());
            }
        }
        if (url_string.startsWith("jar:file:")) {
            logger.severe("unsupported resource type jar:file with url " + url);
            return new BadResource(url, "unsupported resource type jar:file");
        }
        if (url_string.startsWith("jar:")) {
            logger.severe("unsupported resource type jar: with url " + url);
            return new BadResource(url, "unsupported resource type jar:");
        }
        return new URLResource2(url, null, useCaches);
    }
}

