/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class BrowserSockets
extends WebSocketAdapter {
    private static final Logger logger = Log.getLogger(BrowserSockets.class);
    private Session session;
    private RemoteEndpoint remote;
    private static Map<String, BrowserSockets> instances = new ConcurrentHashMap<String, BrowserSockets>();
    private String clientUid;

    public static Map<String, BrowserSockets> getInstances() {
        return instances;
    }

    public void sendMessage(String message) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            logger.info("Sending message [{}]", new Object[]{message});
            this.remote.sendStringByFuture(message);
        }
    }

    public final String getClientUid() {
        return this.clientUid;
    }

    public final void setClientUid(String clientUid) {
        this.clientUid = clientUid;
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.session = null;
        this.remote = null;
        instances.remove(this.getClientUid());
        logger.info("WebSocket Close: {} - {}", new Object[]{statusCode, reason});
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        this.session.setIdleTimeout(TimeUnit.HOURS.toMillis(2L));
        this.remote = this.session.getRemote();
        Map parameterMap = this.session.getUpgradeRequest().getParameterMap();
        logger.info("WebSocket Connect: {}", new Object[]{session});
        logger.info("clientUid: {}", new Object[]{parameterMap.get("u")});
        List list = (List)parameterMap.get("u");
        if (list != null && !list.isEmpty()) {
            String uid = (String)list.get(0);
            this.setClientUid(uid);
            instances.put(uid, this);
        } else {
            System.out.println("u est nul??? ");
        }
    }

    public void onWebSocketError(Throwable cause) {
        logger.warn("WebSocket Error", cause);
    }

    public void onWebSocketText(String message) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            logger.info("Echoing back text message [{}]", new Object[]{message});
            this.remote.sendStringByFuture(message);
        }
    }
}

