/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.search;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.appointment.search.ComplexSearchController;
import ca.infodata.ofys.ui.appointment.search.ListBasedCriteriaControl;
import ca.infodata.ofys.ui.site.SitePlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SiteCriteriaControl
extends ListBasedCriteriaControl<XSite> {
    private List<XSite> list = SiteCriteriaControl.getSites();

    public SiteCriteriaControl(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, Messages.getString((String)"SITES", (String[])new String[0]), toolkit);
    }

    private static List<XSite> getSites() {
        ArrayList<XSite> sites = new ArrayList<XSite>(SitePlugin.getDefault().getWorkSites());
        Iterator iterator = sites.iterator();
        while (iterator.hasNext()) {
            XSite site = (XSite)iterator.next();
            if (site.isActive()) continue;
            iterator.remove();
        }
        return sites;
    }

    @Override
    protected List<XSite> getList() {
        return this.list;
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 2 || propertyId == 11) {
            this.refreshPopup();
        }
    }

    @Override
    protected void dataSelectedInControl(XSite e, boolean selected) {
        ComplexSearchController controller = this.getController();
        if (controller != null) {
            if (selected) {
                controller.getSites().add(e);
            } else {
                controller.getSites().remove(e);
            }
        }
    }

    @Override
    protected boolean isDataSelectedInController(XSite e) {
        if (this.getController() == null) {
            return false;
        }
        return this.getController().getSites().contains(e);
    }

    @Override
    protected String getTextForItem(XSite e) {
        return e.getNameCommon();
    }

    @Override
    protected void reset() {
        if (this.getController() != null) {
            this.getController().getSites().clear();
            this.refreshPopup();
        }
    }
}

