/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditor;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditorInput;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElementsContextMenuContribution;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.menu.element.ProfessionnalElements;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;

public class ProfessionnalElementsContextMenuContribution
implements ITreeElementsContextMenuContribution {
    private static final String VOIR_L_HORAIRE = Messages.getString((String)"VOIR_LHORAIRE", (String[])new String[0]);

    public void contributeContextMenuTo(ITreeElements element, Control control) {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && Application.get().getGlobalInstances().hasRight(XRight.APPOINTMENT)) {
            XBaseProfessionnal professionnal;
            Menu menu = control.getMenu();
            if (menu == null || menu.isDisposed()) {
                menu = new Menu(control);
                menu.setVisible(true);
                control.setMenu(menu);
            }
            if ((professionnal = ((ProfessionnalElements)element).getProfessionnal()) != null && professionnal.getId() != null && professionnal.useAppointment) {
                MenuItem item = new MenuItem(menu, 64);
                item.setText(VOIR_L_HORAIRE);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ProfessionnalElementsContextMenuContribution.this.openScheduleEditor(professionnal);
                    }
                });
            }
        }
    }

    private void openScheduleEditor(XBaseProfessionnal professionnal) {
        try {
            AppointmentMainEditorInput input = new AppointmentMainEditorInput("AppointmentMainEditor");
            input.setProfessional(professionnal);
            input.setMode(IAppointmentMode.Mode.APPOINTMENT);
            BaseEditor.openEditor((IEditorInput)input, (String)AppointmentMainEditor.class.getName());
        }
        catch (Exception e) {
            Log.severe((String)"Erreur", (Exception)e);
        }
    }
}

