/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.XAppointmentFormatter;
import ca.infodata.ofys.ui.appointment.control.AppointmentPrintDialog;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElements2;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;

public final class PatientAppointmentElements
implements ITreeElements2,
IFontProvider {
    private static final Logger logger = Logger.getLogger(PatientAppointmentElements.class.getName());
    private final ITreeElements parent;
    private final IAppointment appointment;
    private boolean showPatientName;

    public PatientAppointmentElements(ITreeElements parent, IAppointment appointment) {
        if (parent == null || appointment == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.appointment = appointment;
        this.showPatientName = false;
    }

    public Object[] getChildren() {
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getText() {
        try {
            return XAppointmentFormatter.format(this.appointment, true, true, this.showPatientName, false, true);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/rendez-vous.gif");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public IAppointment getAppointment() {
        return this.appointment;
    }

    public void showContextMenu(Control control) {
        if (this.appointment != null && this.appointment.getId() != null) {
            Menu menu = new Menu(control);
            MenuItem item = new MenuItem(menu, 8);
            item.setText(Messages.getString((String)"PTARRIVE", (String[])new String[0]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    try {
                        AppointmentAccessorClient.getInstance().setPatientArrived(PatientAppointmentElements.this.appointment.hashCode(), Application.get().getGlobalInstances().getSession(), PatientAppointmentElements.this.appointment.getId().intValue(), (ICallback)new Callback((IStatusHandler)DefaultStatusHandler.getInstance()));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to set appointment-patient arrived. " + StringUtils.safeToString((Logger)logger, (Object)PatientAppointmentElements.this.appointment), e);
                    }
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(Messages.getString((String)"PTVU", (String[])new String[0]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    try {
                        AppointmentAccessorClient.getInstance().setPatientSeen(PatientAppointmentElements.this.appointment.hashCode(), Application.get().getGlobalInstances().getSession(), PatientAppointmentElements.this.appointment.getId().intValue(), (ICallback)new Callback((IStatusHandler)DefaultStatusHandler.getInstance()));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to set appointment-patient seen. " + StringUtils.safeToString((Logger)logger, (Object)PatientAppointmentElements.this.appointment), e);
                    }
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(Messages.getString((String)"OUVRIR_FICHE_PATIENT", (String[])new String[0]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    try {
                        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                            PersonMultiEditorFactory.openPatient((IPatient)PatientAppointmentElements.this.appointment.getPatient());
                        } else {
                            BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)PatientAppointmentElements.this.appointment.getPatient()), (String)PatientMultiEditor.class.getName());
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed open patient file from appointment. " + StringUtils.safeToString((Logger)logger, (Object)PatientAppointmentElements.this.appointment), e);
                    }
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(Messages.getString((String)"IMPRIMER", (String[])new String[0]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new AppointmentPrintDialog(UI.getWorkbenchShell(), PatientAppointmentElements.this.getAppointment()).open();
                }
            });
            menu.setVisible(true);
        }
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.appointment.hashCode() + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof PatientAppointmentElements && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void doDoubleClick() {
        AppointmentPlugin.getDefault().openAppointmentEditor("PatientAppointmentElements", this.appointment);
    }

    public void doSelect() {
    }

    public boolean isShowPatientName() {
        return this.showPatientName;
    }

    public void setShowPatientName(boolean showPatientName) {
        this.showPatientName = showPatientName;
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }

    public Font getFont(Object element) {
        return ResourceGetter.getFontNormal();
    }
}

