/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.menu.ListPatientFutureAppointments;
import ca.infodata.ofys.ui.appointment.menu.ListPatientFutureFamillyAppointments;
import ca.infodata.ofys.ui.appointment.menu.ListPatientPastAppointments;
import ca.infodata.ofys.ui.appointment.menu.PatientAppointmentElements;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public final class ListPatientAppointment
implements ITreeElements,
IFontProvider {
    private static final Logger logger = Logger.getLogger(ListPatientAppointment.class.getName());
    private ITreeElements parent;
    private IPatient patient;
    private boolean isLoading;
    private ITreeElements[] children;

    public ListPatientAppointment(ITreeElements parent, IPatient patient) {
        if (patient == null || parent == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.patient = patient;
    }

    public Object[] getChildren() {
        if (this.notLoaded()) {
            this.fillAsLoading();
        }
        return this.children;
    }

    private void fillAsLoading() {
        this.isLoading = true;
        this.children = new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        this.findTodayAppointments();
    }

    private boolean notLoaded() {
        return this.children == null || this.isLoading;
    }

    private void findTodayAppointments() {
        JobCallback callback = new JobCallback(Messages.getString((String)"ListPatientAppointment.TROUVER_LES_RENDEZVOUS_DAUJOURHDUI", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                ArrayList obj = (ArrayList)response.getObj();
                if (obj == null) {
                    obj = new ArrayList(0);
                }
                ListPatientAppointment.this.fill(obj);
            }
        };
        try {
            AppointmentAccessorClient.getInstance().findTodayAppointmentsByPatient(this.patient.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, this.patient.getId().intValue());
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            callback.kill();
            this.fill(new ArrayList<IAppointment>(0));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            callback.kill();
            this.fill(new ArrayList<IAppointment>(0));
        }
    }

    private void fill(List<IAppointment> apps) {
        Collections.sort(apps, AppointmentPlugin.getDefault().getXAppointmentComparator(true));
        ArrayList<Object> listChild = new ArrayList<Object>(apps.size() + 2);
        for (IAppointment appointment : apps) {
            if (Boolean.TRUE.equals(appointment.getIsDeleted()) || appointment.getPatientStatus() == XPatientStatus.CANCEL || appointment.getPatientStatus() == XPatientStatus.CANCEL_LESS_24H) continue;
            listChild.add(new PatientAppointmentElements(this, appointment));
        }
        listChild.add(new ListPatientPastAppointments(this, this.patient));
        listChild.add(new ListPatientFutureAppointments(this, this.patient));
        listChild.add(new ListPatientFutureFamillyAppointments(this, this.patient));
        this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        this.isLoading = false;
        DossierPlugin.getDefault().refreshTree((ITreeElements)this.getParent());
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return Messages.getString((String)"RENDEZVOUS", (String[])new String[0]);
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/rendez-vous.gif");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListPatientAppointment && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }

    public Font getFont(Object element) {
        return ResourceGetter.getFontNormal();
    }
}

