/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.appointment.XAppointmentFormatter;
import ca.infodata.ofys.ui.appointment.control.AppointmentPrintDialog;
import ca.infodata.ofys.ui.appointment.menu.AbstractProgressMonitor;
import ca.infodata.ofys.ui.appointment.menu.AppointmentElementController;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElements2;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.patient.XPatientFormatter;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public final class AppointmentElements
implements ITreeElements2,
IFontProvider,
IColorProvider,
IPropertyListener {
    private static final Logger logger = Logger.getLogger(AppointmentElements.class.getName());
    private static final String RDVS_GIVEN_DATE = Messages.getString((String)"RDVS_GIVEN_DATE", (String[])new String[0]);
    private static final String RDVS_MODIFIED_DATE = Messages.getString((String)"RDVS_MODIFIED_DATE", (String[])new String[0]);
    private static final String PAR = Messages.getString((String)"PAR", (String[])new String[0]);
    private final ITreeElements parent;
    private final AppointmentElementController controller;
    private boolean showPatientName;
    protected final boolean usingTabletPerspective;

    public AppointmentElements(ITreeElements parent, AppointmentElementController appointment) {
        if (parent == null || appointment == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.controller = appointment;
        PropertyListenerManager.addListener((Object)this.controller, (IPropertyListener)this);
        this.showPatientName = true;
        IWorkbenchPage page = BaseView.getPage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        this.usingTabletPerspective = perspective != null && perspective.getId().equals("ca.infodata.ofys.ui.menu.EncounterPerspective");
    }

    public Object[] getChildren() {
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getText() {
        try {
            return XAppointmentFormatter.format(this.controller.getReadOnlyAppointment(), false, false, this.showPatientName, true, true);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String getTooltipText() {
        List<? extends IPatient> patients;
        IAppointment appointment = this.controller.getReadOnlyAppointment();
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getText());
        if (appointment.getDateCreated() != null) {
            sb.append("\n" + RDVS_GIVEN_DATE + " " + DateUtil.ttoc((long)appointment.getDateCreated(), (boolean)true));
            if (appointment.getDateEntryLast() != null) {
                boolean notSameDates;
                long diff = Math.abs(appointment.getDateEntryLast() - appointment.getDateCreated());
                Long dateEntryLast = appointment.getDateEntryLast();
                boolean bl = notSameDates = diff > 60000L;
                if (notSameDates) {
                    sb.append(String.valueOf(RDVS_MODIFIED_DATE) + " " + DateUtil.ttoc((long)dateEntryLast, (boolean)true) + " " + PAR + " " + appointment.getNameUser());
                }
            }
        }
        if ((patients = this.controller.getReadOnlyPatients()).size() == 1) {
            sb.append("\n").append(XPatientFormatter.formatComplete((IPatient)patients.get(0)));
        } else {
            for (IPatient iPatient : patients) {
                sb.append("\n\n").append(iPatient.getName());
                sb.append(XPatientFormatter.formatComplete((IPatient)iPatient));
            }
        }
        return sb.toString();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/enc-icon32.png");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
        Menu menu = new Menu(control);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Messages.getString((String)"PTARRIVE", (String[])new String[0]));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            AppointmentElements.this.controller.setPatientArrived();
                        }
                    }, (boolean)true, (IProgressMonitor)new AbstractProgressMonitor(), (Display)event.display);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to set patient arrived for appointment " + AppointmentElements.this.controller.getReadOnlyAppointment(), e);
                }
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.getString((String)"PTVU", (String[])new String[0]));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            AppointmentElements.this.controller.setPatientSeen();
                        }
                    }, (boolean)true, (IProgressMonitor)new AbstractProgressMonitor(), (Display)event.display);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to set patient seen for appointment " + AppointmentElements.this.controller.getReadOnlyAppointment(), e);
                }
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.getString((String)"IMPRIMER", (String[])new String[0]));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new AppointmentPrintDialog(UI.getWorkbenchShell(), AppointmentElements.this.controller.getReadOnlyAppointment()).open();
            }
        });
        List<IPatient> editablePatients = this.controller.getClonePatients();
        if (editablePatients.size() > 0) {
            Menu subMenu = menu;
            for (final IPatient patient : editablePatients) {
                MenuItem i1 = new MenuItem(subMenu, 64);
                i1.setText(patient.getNameBirthdateSex());
                Menu subMenu1 = new Menu(subMenu);
                i1.setMenu(subMenu1);
                MenuItem i2 = new MenuItem(subMenu1, 8);
                i2.setText(Messages.getString((String)"OUVRIR_FICHE_PATIENT", (String[])new String[0]));
                i2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        try {
                            if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                                PersonMultiEditorFactory.openPatient((IPatient)patient);
                            } else {
                                BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)patient), (String)PatientMultiEditor.class.getName());
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "failed to opent patient editor from appointment. " + StringUtils.safeToString((Logger)logger, (Object)AppointmentElements.this.controller), e);
                        }
                    }
                });
            }
        }
        menu.setVisible(true);
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.controller.hashCode() + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof AppointmentElements && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void doDoubleClick() {
    }

    public void doSelect() {
        if (this.usingTabletPerspective) {
            this.doDoubleClick();
        }
    }

    public boolean isShowPatientName() {
        return this.showPatientName;
    }

    public void setShowPatientName(boolean showPatientName) {
        this.showPatientName = showPatientName;
    }

    public Font getFont(Object element) {
        if (element instanceof AppointmentElements) {
            IAppointment a = ((AppointmentElements)element).controller.getReadOnlyAppointment();
            XPatientStatus patientStatus = a.getPatientStatus();
            if ((patientStatus == XPatientStatus.ARRIVED || patientStatus == XPatientStatus.ARRIVED_LATE) && a.getArrivedTime() != null) {
                return ResourceGetter.getFontBold();
            }
            if (patientStatus == XPatientStatus.SEEN && a.getSeenTime() != null) {
                return ResourceGetter.getFontItalic();
            }
            return ResourceGetter.getFontNormal();
        }
        return ResourceGetter.getFontNormal();
    }

    public Color getForeground(Object element) {
        IAppointment a;
        XPatientStatus patientStatus;
        if (element instanceof AppointmentElements && XPatientStatus.NOT_CAME.equals((Object)(patientStatus = (a = ((AppointmentElements)element).controller.getReadOnlyAppointment()).getPatientStatus()))) {
            int o = 0;
            return ResourceGetter.getColor((int[])new int[]{255, o, o});
        }
        return null;
    }

    public Color getBackground(Object element) {
        IAppointment a;
        IPatient patient;
        if (element instanceof AppointmentElements && (patient = (a = ((AppointmentElements)element).controller.getReadOnlyAppointment()).getPatientOrAdhoc((IJsonReader)Application.get().getGsonProcessor())) == null && (a.getPatients() == null || a.getPatients().isEmpty())) {
            int o = 242;
            return ResourceGetter.getColor((int[])new int[]{255, o, o});
        }
        return null;
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DossierPlugin.getDefault().getTreeViewer().refresh((Object)AppointmentElements.this);
                }
            });
        }
    }
}

