/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.preferences;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.ui.appointment.editor.preferences.AppointmentTypeListForm;
import ca.infodata.ofys.ui.appointment.editor.preferences.AppointmentTypeListRow;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miginfocom.swt.MigLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class AppointmentTypeList
extends Composite {
    private final MyLabel lblColor;
    private final MyLabel lblCode;
    private final MyLabel lblDuree;
    private final MyLabel lblDescription;
    private final MyLabel lblProfessional;
    private final MyLabel lblSurveyId;
    private final MyLabel lblStatus;
    private final MyLabel lblActif;
    private final MyButton btnAddType;
    private final Composite list;
    private final AppointmentTypeListForm form;
    private LinkedHashMap<XAppointmentType, AppointmentTypeListRow> items;
    private final FormToolkit toolkit;
    private final Image btnAddTypeImage;
    private final IBaseEditor editor;

    public AppointmentTypeList(IBaseEditor editor, Composite parent, int style, FormToolkit toolkit) {
        super(parent, 0);
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (toolkit == null) {
            throw new NullPointerException("toolkit");
        }
        this.editor = editor;
        this.toolkit = toolkit;
        this.items = new LinkedHashMap();
        this.form = new AppointmentTypeListForm(editor, this, 0, toolkit);
        toolkit.adapt((Composite)this.form);
        this.list = this;
        toolkit.adapt(this.list);
        this.lblColor = new MyLabel(this.list, AppointmentTypeListRow.COULEUR, 0, toolkit);
        this.lblColor.setFont(0, 1);
        this.lblCode = new MyLabel(this.list, AppointmentTypeListRow.CODE, 0, toolkit);
        this.lblCode.setFont(0, 1);
        this.lblDuree = new MyLabel(this.list, AppointmentTypeListRow.DUREE_RDVS, 0, toolkit);
        this.lblDuree.setFont(0, 1);
        this.lblDescription = new MyLabel(this.list, AppointmentTypeListRow.DESCRIPTION, 0, toolkit);
        this.lblDescription.setFont(0, 1);
        this.lblProfessional = new MyLabel(this.list, AppointmentTypeListRow.PROFESSIONNEL, 0, toolkit);
        this.lblProfessional.setFont(0, 1);
        this.lblSurveyId = new MyLabel(this.list, "Q. ID", 0, toolkit);
        this.lblSurveyId.setToolTipText(AppointmentTypeListRow.QUESTION_ID);
        this.lblSurveyId.setFont(0, 1);
        this.lblStatus = new MyLabel(this.list, AppointmentTypeListRow.STATUS, 0, toolkit);
        this.lblStatus.setFont(0, 1);
        this.lblActif = new MyLabel(this.list, AppointmentTypeListRow.ACTIF, 0, toolkit);
        this.lblActif.setFont(0, 1);
        this.btnAddType = new MyButton(this.list, null, 0, toolkit);
        this.btnAddTypeImage = ResourceGetter.getImage((String)"images/nouveau.gif");
        this.btnAddType.setImage(this.btnAddTypeImage);
        this.btnAddType.setToolTipText(Messages.getString((String)"APPOINTEMENT.BTN_AJOUTER", (String[])new String[0]));
        this.form.getBtnSave().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentTypeList.this.save();
            }
        });
        this.form.getBtnUndo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentTypeList.this.undo();
            }
        });
        this.btnAddType.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)editor, 13){

            public void edited(Event e) {
                XAppointmentType type = AppointmentTypeList.this.getNewXAppointmentType();
                if (type != null) {
                    AppointmentTypeList.this.items.put(type, AppointmentTypeList.this.addNewRow(null, type));
                    AppointmentTypeList.this.showForm(type);
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)AppointmentTypeList.this.btnAddTypeImage);
            }
        });
        this.form.setVisible(false);
        this.form.setLayoutData("pos 0 0 100% n");
        this.list.setLayout((Layout)new MigLayout("fillx, gapy 5, hidemode 3", "[50!, c]15[c]15[c]15[c]15[c]15[c]15[c]15[c]15[center, 30!]5[c, 30!]"));
        this.list.setVisible(true);
        this.list.setLayoutData((Object)"grow");
        this.lblColor.setLayoutData((Object)"cell 0 0, c");
        this.lblCode.setLayoutData((Object)"cell 1 0, c");
        this.lblDuree.setLayoutData((Object)"cell 2 0, c");
        this.lblDescription.setLayoutData((Object)"cell 3 0, c");
        this.lblProfessional.setLayoutData((Object)"cell 4 0, c");
        this.lblSurveyId.setLayoutData((Object)"cell 5 0, c");
        this.lblStatus.setLayoutData((Object)"cell 6 0, c");
        this.lblActif.setLayoutData((Object)"cell 7 0, c");
        this.btnAddType.setLayoutData((Object)"cell 8 0, w 24!, h 24!, c");
        toolkit.adapt((Composite)this);
    }

    public void save() {
        this.form.save();
        this.editor.checkDirty();
        this.showList();
    }

    public void undo() {
        if (this.form.getType() == null) {
            this.showList();
        } else if (this.form.isModified()) {
            this.form.undo();
        } else if (this.form.getType().isNew()) {
            this.removeRow(this.form.getType());
            this.showList();
        } else {
            this.showList();
        }
    }

    public final void setTypes(List<XAppointmentType> types) {
        if (types == null) {
            throw new NullPointerException("types");
        }
        for (AppointmentTypeListRow control : this.items.values()) {
            control.dispose();
        }
        this.items.clear();
        for (XAppointmentType type : types) {
            this.items.put(type, this.addNewRow(null, type));
        }
        this.layoutChanged();
    }

    public final void showDataObject() {
        for (Map.Entry<XAppointmentType, AppointmentTypeListRow> item : this.items.entrySet()) {
            item.getValue().showDataObject();
        }
    }

    private AppointmentTypeListRow addNewRow(AppointmentTypeListRow reusableControl, XAppointmentType type) {
        AppointmentTypeListRow control = reusableControl != null ? reusableControl : new AppointmentTypeListRow(this.editor, this.list, 0, this.toolkit);
        control.setType(type);
        this.setRowEvent(control);
        this.setRowLayout(control, this.items.size() + 1);
        return control;
    }

    private void setRowEvent(final AppointmentTypeListRow control) {
        control.getBtnDelete().addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.editor, 13){

            public void edited(Event e) {
                AppointmentTypeList.this.removeRow(control.getType());
            }
        });
        control.getBtnEdit().addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.editor, 13){

            public void edited(Event e) {
                AppointmentTypeList.this.showForm(control.getType());
            }
        });
    }

    private void setRowLayout(AppointmentTypeListRow control, int irow) {
        String row = String.valueOf(irow);
        control.getCvsColor().setLayoutData((Object)"cell 0 row, w 15!, h 15!, shp 100, c".replaceFirst("row", row));
        control.getLblCode().setLayoutData((Object)"cell 1 row, shp 100, c".replaceFirst("row", row));
        control.getLblDuree().setLayoutData((Object)"cell 2 row, shp 100, c".replaceFirst("row", row));
        control.getLblDescription().setLayoutData((Object)"cell 3 row, shp 75, c".replaceFirst("row", row));
        control.getLblProfessional().setLayoutData((Object)"cell 4 row, shp 75, c".replaceFirst("row", row));
        control.getLblSurveyId().setLayoutData((Object)"cell 5 row, shp 75, c".replaceFirst("row", row));
        control.getLblStatus().setLayoutData((Object)"cell 6 row, shp 75, c".replaceFirst("row", row));
        control.getLblActif().setLayoutData((Object)"cell 7 row, shp 75, c".replaceFirst("row", row));
        control.getBtnDelete().setLayoutData((Object)"cell 8 row, w 24!, h 24!, shp 100, c".replaceFirst("row", row));
        control.getBtnEdit().setLayoutData((Object)"cell 8 row, w 24!, h 24!, shp 100, c".replaceFirst("row", row));
    }

    private void removeRow(XAppointmentType type) {
        this.deleteXAppointmentType(type);
        AppointmentTypeListRow control = (AppointmentTypeListRow)((Object)this.items.remove(type));
        if (control != null) {
            control.dispose();
        }
        int i = 1;
        for (Map.Entry<XAppointmentType, AppointmentTypeListRow> item : this.items.entrySet()) {
            this.setRowLayout(item.getValue(), i);
            ++i;
        }
        this.layoutChanged();
    }

    public void showForm(XAppointmentType type) {
        this.form.setType(type);
        this.form.setVisible(true);
        this.layoutChanged();
    }

    public void showList() {
        this.form.setVisible(false);
        this.form.setType(null);
        this.layoutChanged();
        this.showDataObject();
        this.list.setVisible(true);
        this.layoutChanged();
    }

    private void layoutChanged() {
        this.layout(true, true);
        this.reflow();
    }

    private void reflow() {
        AppointmentTypeList c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    protected abstract XAppointmentType getNewXAppointmentType();

    protected abstract void deleteXAppointmentType(XAppointmentType var1);
}

