/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.model2;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentCompleteDataContainer;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.ui.appointment.editor.model2.IServer;
import ca.infodata.ofys.ui.appointment.editor.model2.XAppointmentDateMap;
import ca.infodata.ofys.ui.appointment.editor.model2.XAppointmentDateTable;
import ca.infodata.ofys.ui.appointment.editor.model2.XAppointmentDateTemplateSet;
import ca.infodata.ofys.ui.appointment.editor.model2.XAppointmentTable;
import ca.infodata.ofys.ui.appointment.editor.model2.XAppointmentWeekTemplateSet;
import ca.infodata.ofys.ui.appointment.editor.model2.XBaseAppointmentDateMap;
import ca.infodata.ofys.ui.appointment.editor.model2.XReservedAppointmentTable;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class Data {
    private static final Logger logger = Logger.getLogger(Data.class.getName());
    static final List managedClasses = Arrays.asList(XAppointmentDate.class, XBaseAppointmentDate.class, XAppointmentDateTemplate.class, XAppointmentWeekTemplate.class, XAppointment.class, XAppointmentPeriod.class, XAppointmentType.class, XAppointmentPeriodType.class, XBaseProfessionnal.class, XReservedAppointment.class);
    private XAppointmentDateTemplateSet lstAppointmentDateTemplate;
    private XAppointmentWeekTemplateSet lstAppointmentWeekTemplate;
    private XAppointmentDateTable appointmentDates;
    private XAppointmentTable appointmentTable;
    private XReservedAppointmentTable reservedAppointmentTable;
    private IAppointment cutTemp;
    private IAppointment copyTemp;
    private IServer server;

    public Data(IServer server) {
        this.server = server;
        this.appointmentTable = new XAppointmentTable();
        this.reservedAppointmentTable = new XReservedAppointmentTable();
        this.lstAppointmentDateTemplate = new XAppointmentDateTemplateSet();
        this.lstAppointmentWeekTemplate = new XAppointmentWeekTemplateSet();
        this.appointmentDates = new XAppointmentDateTable(new PredicateA<Object>(){

            public boolean evaluate(Object object) {
                return object != null && (object instanceof XAppointmentDate && ((XAppointmentDate)object).isDeleted() == false || object instanceof XBaseAppointmentDate);
            }
        });
    }

    void objectModified(EditableDataObject object) {
        if (object instanceof XAppointmentDateTemplate) {
            if (Boolean.TRUE.equals(((XAppointmentDateTemplate)object).getIsDeleted())) {
                this.lstAppointmentDateTemplate.remove(object);
            }
        } else if (object instanceof XAppointmentWeekTemplate && Boolean.TRUE.equals(((XAppointmentWeekTemplate)object).getIsDeleted())) {
            this.lstAppointmentWeekTemplate.remove(object);
        }
    }

    void initBlock(XAppointmentCompleteDataContainer container) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("initBlock --> " + container);
        }
        if (container != null) {
            this.lstAppointmentDateTemplate.addAll(container.appointmentDateTemplates);
            this.lstAppointmentWeekTemplate.addAll(container.appointmentWeekTemplates);
            this.appointmentDates.getAppointmentDates().addAll(container.appointmentDates);
            this.appointmentDates.getBaseAppointmentDates().addAll(container.baseAppointmentDates);
            this.appointmentTable.addAll(container.appointments);
            this.reservedAppointmentTable.addAll(container.reservedAppointments);
        }
    }

    public XAppointmentDateTemplateSet getLstAppointmentDateTemplate() {
        return this.lstAppointmentDateTemplate;
    }

    public XAppointmentWeekTemplateSet getLstAppointmentWeekTemplate() {
        return this.lstAppointmentWeekTemplate;
    }

    public XAppointmentDateMap getAppointmentDates() {
        return this.appointmentDates.getAppointmentDates();
    }

    public IEditableDataObjectList<XAppointment> getAppointments(Integer idProf, LocalDate date) {
        return this.appointmentTable.get(idProf, date);
    }

    public XAppointmentTable getAppointments() {
        return this.appointmentTable;
    }

    public IEditableDataObjectList<XReservedAppointment> getReservedAppointments(Integer idProf, LocalDate date) {
        return this.reservedAppointmentTable.get(idProf, date);
    }

    public XReservedAppointmentTable getReservedAppointments() {
        return this.reservedAppointmentTable;
    }

    public XBaseAppointmentDateMap getBaseAppointmentDates() {
        return this.appointmentDates.getBaseAppointmentDates();
    }

    public Collection<XBaseProfessionnal> getLstProfessional() {
        return this.server.getLstProfessional_sync();
    }

    public Collection<XPersonGroup> getLstPersonGroup() {
        return this.server.getLstPersonGroup_sync();
    }

    void dispose() {
        this.reset();
        this.reservedAppointmentTable.dispose();
    }

    public void reset() {
        this.lstAppointmentDateTemplate.clear();
        this.lstAppointmentWeekTemplate.clear();
        this.getAppointmentDates().clear();
        this.getBaseAppointmentDates().clear();
        this.appointmentTable.clear();
        this.copyTemp = null;
        this.cutTemp = null;
    }

    public Collection<XAppointmentDate> remove(Integer prof, Collection<LocalDate> dates) {
        ArrayList<XAppointmentDate> xdates = new ArrayList<XAppointmentDate>();
        for (LocalDate date : dates) {
            XAppointmentDate a = this.appointmentDates.getAppointmentDates().get(date, prof);
            if (a == null) continue;
            xdates.add(a);
        }
        this.appointmentDates.getAppointmentDates().removeAll(xdates);
        for (LocalDate date : dates) {
            this.appointmentTable.remove(prof, date);
            this.reservedAppointmentTable.remove(prof, date);
        }
        return xdates;
    }

    public IAppointment getCutTemp() {
        return this.cutTemp;
    }

    public void setCutTemp(IAppointment cutTemp) {
        this.cutTemp = cutTemp;
    }

    public IAppointment getCopyTemp() {
        return this.copyTemp;
    }

    public void setCopyTemp(IAppointment copyTemp) {
        this.copyTemp = copyTemp;
    }
}

