/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.controls.dnd.DayTransfert;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.date.DateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SmallAppointmentDateControl
extends Composite {
    private static final Logger logger = Logger.getLogger(SmallAppointmentDateControl.class.getName());
    private final Canvas canvas;
    private final Color colorAppointmentDefault = ResourceGetter.getColor((int)0, (int)192, (int)128);
    private final Color colorAppointmentDefaultDark = ResourceGetter.getColor((int[])this.darkenColor(0, 192, 128));
    private final Color colorBackground = ResourceGetter.getColor((int)224, (int)224, (int)224);
    private final Color colorBackgroundDark = ResourceGetter.getColor((int[])this.darkenColor(224, 224, 224));
    private final Color colorBorder = ResourceGetter.getColor((int)0, (int)0, (int)0);
    private final Color colorWhite = ResourceGetter.getColor((int)255, (int)255, (int)255);
    private final Color colorWhiteDark = ResourceGetter.getColor((int[])this.darkenColor(255, 255, 255));
    private AppointmentMainController controller;
    private boolean isDark = false;
    private final Label lblDate;
    private final Label lblEnd;
    private final Label lblStart;
    private final List<ISmallAppointmentDateListener> lstListener = new ArrayList<ISmallAppointmentDateListener>();
    private final DateListener dateListener;
    private final WeekListener weekListener;
    private XAppointmentWeekTemplate weekTemplate;
    private XAppointmentDateTemplate internal_dateTemplate;
    private final int dayOfWeek;
    private static boolean selecting;
    final String empty = "          ";

    public SmallAppointmentDateControl(Composite parent, int style, int dayOfWeek, AppointmentMainController controller) {
        super(parent, style);
        this.dayOfWeek = dayOfWeek;
        this.controller = controller;
        this.dateListener = new DateListener();
        this.weekListener = new WeekListener();
        this.lblDate = new Label((Composite)this, 0);
        this.lblDate.setBackground(this.getColorWhite());
        this.lblDate.setText(DateUtil.toDayWeekString((int)dayOfWeek, (boolean)false));
        this.lblStart = new Label((Composite)this, 0);
        this.lblStart.setText("          ");
        this.lblStart.setBackground(this.getColorWhite());
        this.canvas = new Canvas((Composite)this, 262144);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SmallAppointmentDateControl.this.drawControl(e.gc);
            }
        });
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SmallAppointmentDateControl.this.disposeColors();
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                logger.log(Level.FINE, String.valueOf(SmallAppointmentDateControl.this.dayOfWeek) + ".mouse down event");
                selecting = true;
                if (UI.rightClick((MouseEvent)e)) {
                    SmallAppointmentDateControl.this.showContextMenu();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (selecting && !UI.rightClick((MouseEvent)e)) {
                    logger.log(Level.FINE, String.valueOf(SmallAppointmentDateControl.this.dayOfWeek) + ".selection event");
                    Event event = new Event();
                    event.x = e.x;
                    event.y = e.y;
                    event.button = e.button;
                    event.data = e.data;
                    event.display = e.display;
                    event.stateMask = e.stateMask;
                    event.time = e.time;
                    event.widget = SmallAppointmentDateControl.this;
                    SmallAppointmentDateControl.this.widgetSelected(new MouseEvent(event));
                    SmallAppointmentDateControl.this.darkenMe();
                }
            }
        });
        this.lblEnd = new Label((Composite)this, 0);
        this.lblEnd.setText("          ");
        this.lblEnd.setBackground(this.getColorWhite());
        DragSource source = new DragSource((Control)this.canvas, 19);
        Transfer[] types = new Transfer[]{DayTransfert.getInstance()};
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                if (DayTransfert.getInstance().isSupportedType(event.dataType)) {
                    XAppointmentDateTemplate dateTemplate = SmallAppointmentDateControl.this.getDateTemplate();
                    String key = dateTemplate == null ? "null" : String.valueOf(dateTemplate.hashCode());
                    DayTransfert.getInstance().put(key, (Object)dateTemplate);
                    event.data = key;
                }
            }

            public void dragStart(DragSourceEvent event) {
                logger.log(Level.FINE, String.valueOf(SmallAppointmentDateControl.this.dayOfWeek) + ".drag event");
                selecting = false;
            }
        });
        DropTarget target = new DropTarget((Control)this.canvas, 19);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (this.isSupportedType(event)) {
                    SmallAppointmentDateControl.this.darkenMe();
                }
            }

            public void dragLeave(DropTargetEvent event) {
                SmallAppointmentDateControl.this.lightenMe();
            }

            boolean isSupportedType(DropTargetEvent event) {
                return DayTransfert.getInstance().isSupportedType(event.currentDataType);
            }

            public void drop(DropTargetEvent event) {
                XAppointmentDateTemplate dateTemplate;
                if (this.isSupportedType(event) && (dateTemplate = (XAppointmentDateTemplate)DayTransfert.getInstance().pop((String)event.data)) != SmallAppointmentDateControl.this.getDateTemplate()) {
                    if (event.detail == 1) {
                        SmallAppointmentDateControl.this.copyDateTemplateToWeekTemplate(dateTemplate, SmallAppointmentDateControl.this.dayOfWeek);
                    } else if (event.detail == 2 && dateTemplate != null && SmallAppointmentDateControl.this.getWeekTemplate() != null) {
                        int fromDayOfWeek = SmallAppointmentDateControl.this.getWeekTemplate().getDayOfWeek(dateTemplate);
                        if (fromDayOfWeek != -1) {
                            SmallAppointmentDateControl.this.moveDateTemplateWithinWeekTemplate(fromDayOfWeek, SmallAppointmentDateControl.this.dayOfWeek);
                        } else {
                            SmallAppointmentDateControl.this.copyDateTemplateToWeekTemplate(dateTemplate, SmallAppointmentDateControl.this.dayOfWeek);
                        }
                    }
                }
            }
        });
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData(0x1000000, 0x1000000, true, false);
        this.lblDate.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000000, true, false);
        this.lblStart.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000000, true, false);
        this.lblEnd.setLayoutData((Object)data);
        data = new GridData(1808);
        this.canvas.setLayoutData((Object)data);
    }

    private void widgetSelected(MouseEvent e) {
        for (ISmallAppointmentDateListener listener : this.lstListener) {
            listener.widgetSelected(e);
        }
    }

    private int[] darkenColor(int r, int g, int b) {
        return new int[]{(int)((double)r * 0.75), (int)((double)g * 0.75), (int)((double)b * 0.75)};
    }

    protected void showContextMenu() {
        if (this.getDateTemplate() != null) {
            Menu menu = new Menu((Control)this);
            menu.setVisible(true);
            MenuItem erase = new MenuItem(menu, 8);
            erase.setText(Messages.getString((String)"EFFACER_LA_JOURNEE", (String[])new String[0]));
            erase.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (SmallAppointmentDateControl.this.getWeekTemplate() != null) {
                        SmallAppointmentDateControl.this.getController().deleteDateTemplate(SmallAppointmentDateControl.this.getDateTemplate(), SmallAppointmentDateControl.this.getWeekTemplate(), SmallAppointmentDateControl.this.getDayOfWeek());
                    } else {
                        SmallAppointmentDateControl.this.getController().deleteDateTemplate(SmallAppointmentDateControl.this.getDateTemplate());
                    }
                }
            });
        }
    }

    public void dispose() {
        this.lstListener.clear();
        ObjectListenerManager.removeListener((IObjectListener)this.weekListener);
        ObjectListenerManager.removeListener((IObjectListener)this.dateListener);
        this.controller = null;
        super.dispose();
    }

    private void disposeColors() {
        ResourceGetter.dispose((Object)this.colorBorder);
        ResourceGetter.dispose((Object)this.colorAppointmentDefault);
        ResourceGetter.dispose((Object)this.colorBackground);
        ResourceGetter.dispose((Object)this.colorWhite);
        ResourceGetter.dispose((Object)this.colorAppointmentDefaultDark);
        ResourceGetter.dispose((Object)this.colorBackgroundDark);
        ResourceGetter.dispose((Object)this.colorWhiteDark);
    }

    protected void copyDateTemplateToWeekTemplate(XAppointmentDateTemplate dragDropAppointmentDateTemplate, int dayOfWeek) {
        this.getController().copyDateTemplateToWeekTemplate(dragDropAppointmentDateTemplate, this.getWeekTemplate(), dayOfWeek);
    }

    protected Color darkenColor(RGB colorToFade) {
        return ResourceGetter.getColor((int)((int)((double)colorToFade.red * 0.75)), (int)((int)((double)colorToFade.green * 0.75)), (int)((int)((double)colorToFade.blue * 0.75)));
    }

    protected void drawControl(GC gc) {
        logger.finer(String.valueOf(this.dayOfWeek) + ".drawControl");
        int canvasHeight = this.canvas.getBounds().height;
        int canvasWidth = this.canvas.getBounds().width;
        Image buffer = new Image((Device)Display.getDefault(), canvasWidth, canvasHeight);
        GC gcBuffer = new GC((Drawable)buffer);
        gcBuffer.setForeground(this.getColorBorder());
        gcBuffer.setBackground(this.getColorBackground());
        gcBuffer.fillRectangle(0, 0, canvasWidth - 1, canvasHeight - 1);
        gcBuffer.drawRectangle(0, 0, canvasWidth - 1, canvasHeight - 1);
        XAppointmentDateTemplate dateTemplate = this.getDateTemplate();
        if (dateTemplate != null) {
            int startTime = dateTemplate.getStartHour().intValue() * 60;
            int endTime = dateTemplate.getEndHour().intValue() * 60;
            double sizeMinuteInPixel = (double)canvasHeight / ((double)endTime - (double)startTime);
            List periods = dateTemplate.getPeriods().getNotDeleted();
            int i = 0;
            while (i < periods.size()) {
                XAppointmentPeriod period = (XAppointmentPeriod)periods.get(i);
                int periodStart = (int)((period.getStartTime().doubleValue() - (double)startTime) * sizeMinuteInPixel);
                int periodEnd = (int)((period.getEndTime().doubleValue() - (double)startTime) * sizeMinuteInPixel) - periodStart;
                gcBuffer.setBackground(this.getColorAppointmentDefault());
                gcBuffer.fillRectangle(0, periodStart, canvasWidth - 1, periodEnd - 1);
                gcBuffer.drawRectangle(0, periodStart, canvasWidth - 1, periodEnd - 1);
                ++i;
            }
            this.lblStart.setText(DateUtil.convertTimeToString((Integer)startTime, (Character)Character.valueOf(':')));
            this.lblEnd.setText(DateUtil.convertTimeToString((Integer)endTime, (Character)Character.valueOf(':')));
        } else {
            logger.finer(String.valueOf(this.dayOfWeek) + ".drawControl getDateTemplate is null");
            this.lblStart.setText("          ");
            this.lblEnd.setText("          ");
        }
        gc.drawImage(buffer, 0, 0);
        gcBuffer.dispose();
        buffer.dispose();
    }

    public AppointmentMainController getController() {
        return this.controller;
    }

    public void setController(AppointmentMainController controller) {
        if (controller == null) {
            throw new NullPointerException("controller");
        }
        this.controller = controller;
    }

    public XAppointmentDateTemplate getDateTemplate() {
        if (this.getWeekTemplate() != null) {
            XAppointmentDateTemplate dateTemplate = this.getWeekTemplate().getDay(this.dayOfWeek);
            if (this.internal_dateTemplate != dateTemplate) {
                logger.log(Level.FINE, "internal_dateTemplate != dateTemplate", dateTemplate);
                if (this.internal_dateTemplate != null) {
                    ObjectListenerManager.removeListener((Object)this.internal_dateTemplate, (IObjectListener)this.dateListener);
                }
                if (dateTemplate != null) {
                    ObjectListenerManager.addListener((Object)dateTemplate, (IObjectListener)this.dateListener);
                }
                this.internal_dateTemplate = dateTemplate;
                this.refresh();
            }
            return this.internal_dateTemplate;
        }
        return null;
    }

    protected XAppointmentWeekTemplate getWeekTemplate() {
        return this.weekTemplate;
    }

    protected void moveDateTemplateWithinWeekTemplate(int fromDayOfWeek, int dayOfWeek) {
        this.getController().moveDateTemplateWithinWeekTemplate(this.getWeekTemplate(), fromDayOfWeek, dayOfWeek);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.canvas.addMouseListener(mouseListener);
    }

    public void addSmallAppointmentDateListener(ISmallAppointmentDateListener smallAppointmentDateListener) {
        this.lstListener.add(smallAppointmentDateListener);
    }

    public void removeSmallAppointmentDateListener(ISmallAppointmentDateListener smallAppointmentDateListener) {
        this.lstListener.remove(smallAppointmentDateListener);
    }

    public Point computeSize(int x, int y, boolean b) {
        return new Point(150, y);
    }

    public void darkenMe() {
        this.isDark = true;
        this.canvas.redraw();
    }

    public Color getColorAppointmentDefault() {
        return this.isDark ? this.colorAppointmentDefaultDark : this.colorAppointmentDefault;
    }

    public Color getColorBackground() {
        return this.isDark ? this.colorBackgroundDark : this.colorBackground;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public Color getColorWhite() {
        return this.isDark ? this.colorWhiteDark : this.colorWhite;
    }

    public void lightenMe() {
        this.isDark = false;
        this.canvas.redraw();
    }

    public void refresh() {
        logger.fine(String.valueOf(this.dayOfWeek) + ".refresh");
        XAppointmentDateTemplate dateTemplate = this.getDateTemplate();
        if (dateTemplate != null) {
            if (dateTemplate == this.getController().getCurrentDateTemplate()) {
                this.darkenMe();
            } else {
                this.lightenMe();
            }
        } else {
            this.lightenMe();
        }
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setWeekTemplate(XAppointmentWeekTemplate weekTemplate) {
        if (this.weekTemplate != null) {
            ObjectListenerManager.removeListener((Object)this.weekTemplate, (IObjectListener)this.weekListener);
        }
        if (weekTemplate != null) {
            ObjectListenerManager.addListener((Object)weekTemplate, (IObjectListener)this.weekListener);
        }
        this.weekTemplate = weekTemplate;
    }

    private class DateListener
    implements IObjectListener<XAppointmentDateTemplate> {
        private DateListener() {
        }

        public void objectModified(XAppointmentDateTemplate object) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(String.valueOf(SmallAppointmentDateControl.this.dayOfWeek) + ".SmallAppointmentDateControl.modelModified()");
                    SmallAppointmentDateControl.this.canvas.redraw();
                }
            });
        }
    }

    public static interface ISmallAppointmentDateListener {
        public void widgetSelected(MouseEvent var1);
    }

    private class WeekListener
    implements IObjectListener<XAppointmentWeekTemplate> {
        private WeekListener() {
        }

        public void objectModified(XAppointmentWeekTemplate object) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(String.valueOf(SmallAppointmentDateControl.this.dayOfWeek) + ".SmallAppointmentDateControl.weekModified()");
                    SmallAppointmentDateControl.this.refresh();
                }
            });
        }
    }
}

