/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.ui.appointment.control.AppointmentDateControl;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.IAppointmentVisualStructureListener;
import ca.infodata.ofys.ui.appointment.control.ThermometerDrawer;
import ca.infodata.ofys.ui.library.log.Log;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class AppointmentThermometerControl
extends Composite {
    private static final Logger logger = Logger.getLogger(MyAppointmentVisualStructureListener.class.getName());
    protected Canvas canvas;
    private ThermometerDrawer drawer;
    private AppointmentDateControl appointmentControl;
    private AppointmentVisualStructure myAppointmentVisualStructure;
    private MyAppointmentVisualStructureListener visualStructureListener;
    private boolean isRefreshing;
    private final int index;

    public AppointmentThermometerControl(Composite parent, int type, AppointmentVisualStructure structure, int index) {
        super(parent, 512);
        if (structure == null) {
            throw new NullPointerException("structure");
        }
        this.myAppointmentVisualStructure = structure;
        this.visualStructureListener = new MyAppointmentVisualStructureListener();
        this.myAppointmentVisualStructure.addListener(this.visualStructureListener);
        this.index = index;
        this.createControls(this);
    }

    private void createControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas((Composite)this, 264192);
        this.getVerticalBar().setVisible(false);
        this.drawer = new ThermometerDrawer(this.canvas, this.getVerticalBar());
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (AppointmentThermometerControl.this.canvas.getSize().x > 20) {
                    AppointmentThermometerControl.this.drawer.drawControl(e.gc);
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AppointmentThermometerControl.this.select(new Point(e.x, e.y));
            }
        });
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                AppointmentThermometerControl.this.drawer.dispose();
            }
        });
    }

    public void select() {
        this.select(null);
    }

    public void select(Point selection) {
        this.appointmentControl.setVisualStructure(this.getVisualStructure());
        if (selection != null) {
            this.drawer.setSelection(selection.x, selection.y);
        }
        this.appointmentControl.redraw();
        this.appointmentControl.setFocus();
    }

    public boolean setFocus() {
        if (this.getParent().getVerticalBar() != null) {
            return this.getParent().setFocus();
        }
        return this.canvas.setFocus();
    }

    public void setVisualStructure(AppointmentVisualStructure visualStructure) {
        Log.log((Logger)logger, (String)(String.valueOf(this.index) + ".AppointmentThermometerControl.setVisualStructure"), (String[])new String[]{"visualStructure"}, (Object[])new Object[]{visualStructure});
        this.myAppointmentVisualStructure.removeListener(this.visualStructureListener);
        this.myAppointmentVisualStructure = visualStructure;
        if (this.myAppointmentVisualStructure != null) {
            this.myAppointmentVisualStructure.addListener(this.visualStructureListener);
        }
        if (this.myAppointmentVisualStructure == null || this.myAppointmentVisualStructure.isUnusable()) {
            this.drawer.setVisualStructure(null);
        } else {
            this.drawer.setVisualStructure(this.myAppointmentVisualStructure);
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setAppointmentControl(AppointmentDateControl appointmentControl) {
        this.appointmentControl = appointmentControl;
        this.drawer.setAppointmentControl(appointmentControl);
        appointmentControl.getCanvas().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                AppointmentThermometerControl.this.canvas.redraw();
            }
        });
    }

    public void showTime(boolean b) {
        this.drawer.setShowTime(b);
    }

    public void showSelection(boolean b) {
        this.drawer.setDrawSelection(b);
    }

    public AppointmentVisualStructure getVisualStructure() {
        return this.myAppointmentVisualStructure;
    }

    private void refresh(boolean refreshAlsoVisualStructure) {
        if (this.isRefreshing) {
            return;
        }
        Log.log((Logger)logger, (String)(String.valueOf(this.index) + ".AppointmentThermometerControl.refresh"), (String[])new String[]{"refreshAlsoVisualStructure"}, (Object[])new Object[]{refreshAlsoVisualStructure});
        this.isRefreshing = true;
        this.drawer.redraw();
        if (refreshAlsoVisualStructure && this.appointmentControl.getAppointmentVisualStructure() == this.getVisualStructure()) {
            this.appointmentControl.refresh();
        }
        this.isRefreshing = false;
    }

    public void refresh() {
        boolean refreshAlsoVisualStructure = true;
        this.refresh(refreshAlsoVisualStructure);
    }

    public XAppointmentDate getAppointmentDate() {
        return this.myAppointmentVisualStructure.getAppointmentDate();
    }

    public XAppointmentDateTemplate getAppointmentDateTemplate() {
        return this.myAppointmentVisualStructure.getAppointmentDateTemplate();
    }

    public void addMouseListener(MouseListener listener) {
        this.canvas.addMouseListener(listener);
    }

    public void dispose() {
        logger.fine("dispose");
        this.setVisualStructure(null);
        this.visualStructureListener = null;
        this.myAppointmentVisualStructure = null;
        this.canvas.dispose();
        this.canvas = null;
        this.drawer = null;
        this.appointmentControl = null;
        super.dispose();
    }

    public class MyAppointmentVisualStructureListener
    implements IAppointmentVisualStructureListener {
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                if (!AppointmentThermometerControl.this.isDisposed()) {
                    boolean refreshAlsoVisualStructure = false;
                    AppointmentThermometerControl.this.refresh(refreshAlsoVisualStructure);
                }
            }
        };
        private final Runnable redraw = new Runnable(){

            @Override
            public void run() {
                if (!AppointmentThermometerControl.this.isDisposed()) {
                    AppointmentThermometerControl.this.redraw();
                }
            }
        };

        @Override
        public void mustRefresh() {
            Display.getDefault().asyncExec(this.refresh);
        }

        @Override
        public void unusableStateChanged(final boolean unusable) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Log.log((Logger)logger, (String)(String.valueOf(AppointmentThermometerControl.this.index) + ".TC MyAppointmentVisualStructureListener.unusableStateChanged"), (String[])new String[]{"unusable"}, (Object[])new Object[]{unusable});
                    if (AppointmentThermometerControl.this.drawer != null) {
                        if (unusable) {
                            AppointmentThermometerControl.this.drawer.setVisualStructure(null);
                        } else {
                            AppointmentThermometerControl.this.drawer.setVisualStructure(AppointmentThermometerControl.this.myAppointmentVisualStructure);
                        }
                    }
                }
            });
        }

        @Override
        public void mustRedraw() {
            Display.getDefault().asyncExec(this.redraw);
        }

        @Override
        public void selectionChanged(AppointmentVisualStructure.VsPoint newSelection) {
            Display.getDefault().asyncExec(this.redraw);
        }
    }
}

