/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XClient;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.DefaultXClientPreferences;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.ui.appointment.control.AppointmentDateControl;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.IAppointmentDateControlContentProvider;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.control.IAppointmentVisualStructureContentProvider;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AppointmentDateControlTest {
    public static void main(String[] args) throws Exception {
        Application.set((Application)new Application());
        XSession session = new XSession();
        session.id = 1;
        session.client = new XClient();
        session.client.clientCode = "ofys16147";
        session.setClientPreferences((XClientPreferences)new DefaultXClientPreferences());
        Application.get().getGlobalInstances().setSession(session);
        Display display = new Display();
        Shell shell = new Shell(display);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        shell.setLayout((Layout)layout);
        DefaultContentProvider contentProvider = new DefaultContentProvider();
        final AppointmentDateControl control = new AppointmentDateControl((Composite)shell, 0, contentProvider);
        AppointmentVisualStructure structure = new AppointmentVisualStructure(contentProvider, 0);
        structure.setMode(IAppointmentMode.Mode.APPOINTMENT);
        structure.refresh();
        control.setVisualStructure(structure);
        final Text text = new Text((Composite)shell, 18436);
        text.setSize(100, 30);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    System.out.println("CR.keyPressed()");
                    try {
                        int startTime = Integer.parseInt(text.getText());
                        AppointmentVisualStructure vs = control.getVisualStructure();
                        AppointmentVisualStructure.VsPoint point = new AppointmentVisualStructure.VsPoint(0, vs.getLine(startTime));
                        vs.setSelection(point);
                        control.reveal(point, true);
                    }
                    catch (Exception exception) {}
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(90);
        control.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(90);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        text.setLayoutData((Object)data);
        shell.setSize(400, 600);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        control.dispose();
        text.dispose();
        display.dispose();
    }

    private static final class DefaultContentProvider
    implements IAppointmentDateControlContentProvider,
    IAppointmentVisualStructureContentProvider {
        private XAppointmentDate appointmentDate = new XAppointmentDate();
        private XAppointmentDateTemplate appointmentDateTemplate;

        private DefaultContentProvider() {
            this.appointmentDate.professionnal.plain_set((Object)1);
            this.appointmentDateTemplate = new XAppointmentDateTemplate();
            this.appointmentDate.dateTemplate.plain_set((Object)this.appointmentDateTemplate);
            XAppointmentPeriod period = new XAppointmentPeriod();
            period.startTime = 600;
            period.endTime = 645;
            period.defaultLength = 5;
            period.nomPeriod = "period test";
            ((IEditableDataObjectList)this.appointmentDateTemplate.lstPeriods.get()).add((IMinimalEditableDataObject)period);
            XPatient patient = new XPatient();
            patient.firstName = "steeve";
            patient.lastName = "st-laurent";
        }

        @Override
        public XAppointmentDate getAppointmentDate(LocalDate date) {
            return this.appointmentDate;
        }

        @Override
        public XAppointmentDateTemplate getAppointmentDateTemplate() {
            return this.appointmentDateTemplate;
        }

        public void deletePeriod(XAppointmentPeriod period) {
            this.appointmentDateTemplate.getPeriods().remove((Object)period);
        }

        @Override
        public LocalDate getDate() {
            return LocalDate.today();
        }

        @Override
        public XAppointmentPeriod createNewPeriod(XAppointmentDateTemplate dateTemplate, int startTime, int endTime) {
            return null;
        }

        @Override
        public XBaseAppointmentDate getBaseAppointmentDate(LocalDate date) {
            return null;
        }

        public IEditableDataObjectList<IAppointment> getAppointments(XAppointmentDate date) {
            return EditableDataObjectList.emptyList();
        }

        @Override
        public IVisualAppointment getAppointment(IVisualAppointment appointemnt) {
            return null;
        }

        @Override
        public void setEndTime(IVisualAppointment appointment, int t) {
        }

        @Override
        public void setTimes(IVisualAppointment appointment, int start, int end) {
        }

        @Override
        public boolean canSeeAndModifyAppointment(IVisualAppointment appointment) {
            return true;
        }

        @Override
        public boolean canResize() {
            return false;
        }

        @Override
        public boolean canMove() {
            return false;
        }

        @Override
        public IEditableDataObjectList<XReservedAppointment> getReservedAppointments(XAppointmentDate date) {
            return null;
        }
    }
}

