/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class TextTable {
    private List<String> headers = new ArrayList<String>();
    private List<List<String>> rows = new ArrayList<List<String>>();
    private List<String> row;
    private String linePrefix;
    private String lineSuffix;
    private boolean printHeader;
    private String columnSeparator;
    private boolean padLeft;

    public String getLinePrefix() {
        return this.linePrefix;
    }

    public void setLinePrefix(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public String getLineSuffix() {
        return this.lineSuffix;
    }

    public void setLineSuffix(String lineSuffix) {
        this.lineSuffix = lineSuffix;
    }

    public boolean isPadLeft() {
        return this.padLeft;
    }

    public void setPadLeft(boolean padLeft) {
        this.padLeft = padLeft;
    }

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void addHeader(String s) {
        this.headers.add(s);
    }

    public void newRow() {
        this.row = new ArrayList<String>();
    }

    public void endRow() {
        this.rows.add(this.row);
    }

    public void addValue(String s) {
        this.row.add(String.valueOf(s));
    }

    public void add(String s) {
        this.addValue(s);
    }

    public int[] computeColumnWidth() {
        int[] widths = new int[this.headers.size()];
        for (int i = 0; i < widths.length; ++i) {
            widths[i] = Math.max(widths[i], this.headers.get(i).length());
        }
        for (List<String> row : this.rows) {
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = Math.max(widths[i], row.get(i).length());
            }
        }
        return widths;
    }

    public String toString() {
        int[] widths = new int[this.headers.size()];
        if (this.printHeader) {
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = Math.max(widths[i], this.headers.get(i).length());
            }
        }
        for (List<String> row : this.rows) {
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = Math.max(widths[i], row.get(i).length());
            }
        }
        String linePrefix2 = this.linePrefix == null ? "" : this.linePrefix;
        String lineSuffix2 = this.lineSuffix == null ? "" : this.lineSuffix;
        JoinList lines = new JoinList(linePrefix2);
        if (this.printHeader) {
            JoinList line = new JoinList(this.getColumnSeparator() == null ? "" : this.getColumnSeparator());
            line.setTrim(false);
            line.setAllowBlank(true);
            line.setNoDuplicate(false);
            for (int i = 0; i < this.headers.size(); ++i) {
                if (this.padLeft) {
                    line.add((CharSequence)StringUtils.leftPad((String)this.headers.get(i), (int)widths[i], (char)' '));
                    continue;
                }
                line.add((CharSequence)StringUtils.rightPad((String)this.headers.get(i), (int)widths[i], (char)' '));
            }
            lines.add((CharSequence)(line.toString() + lineSuffix2));
        }
        for (List<String> row : this.rows) {
            JoinList line = new JoinList(this.getColumnSeparator() == null ? "" : this.getColumnSeparator());
            line.setTrim(false);
            line.setAllowBlank(true);
            line.setNoDuplicate(false);
            for (int i = 0; i < row.size(); ++i) {
                if (this.padLeft) {
                    line.add((CharSequence)StringUtils.leftPad((String)row.get(i), (int)widths[i], (char)' '));
                    continue;
                }
                line.add((CharSequence)StringUtils.rightPad((String)row.get(i), (int)widths[i], (char)' '));
            }
            lines.add((CharSequence)(line.toString() + lineSuffix2));
        }
        return linePrefix2 + lines.toString();
    }
}

