/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import ca.infodata.ofys.util.ClientKryoSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;

public class LZMAClientSerialiser {
    private static final Logger logger = Logger.getLogger(LZMAClientSerialiser.class.getName());
    private static final LZMA2Options options = new LZMA2Options();
    private static final ClientKryoSerializer kryoComp = new ClientKryoSerializer(true);
    private static final ClientKryoSerializer kryo = new ClientKryoSerializer(false);

    public static <T> T clone(T t) {
        if (t == null) {
            return null;
        }
        Object t2 = null;
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(fos);
            out.writeObject(t);
            byte[] bytes = fos.toByteArray();
            out.close();
            fos.close();
            ByteArrayInputStream fis = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(fis);
            in.readObject();
            t2 = in.readObject();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to serialize-clone object " + t, ex);
        }
        return (T)t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(InputStream fis) {
        Object ret = null;
        if (fis != null) {
            try {
                fis.mark(Integer.MAX_VALUE);
                byte[] p = new byte[5];
                fis.read(p);
                String pdf = new String(p).substring(1);
                if (!"7zXZ".equals(pdf)) {
                    fis.reset();
                    Object object = LZMAClientSerialiser.deserializePlain(fis);
                    return object;
                }
            }
            catch (IOException e1) {
                logger.log(Level.SEVERE, "Failed to deserialize InputStream", e1);
                Object var3_9 = null;
                return var3_9;
            }
            try {
                fis.reset();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failed to reset InputStream", e);
            }
            try {
                ret = kryoComp.read(fis);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "LZMAClientSerializer deserialize " + (fis == null ? "object est null" : fis.getClass().toString()), ex);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return ret;
    }

    public static byte[] serialize(Object object) {
        return LZMAClientSerialiser.serialize(object, false);
    }

    public static byte[] serialize(Object object, boolean compress) {
        if (compress) {
            return LZMAClientSerialiser.serializeLzma(object);
        }
        return LZMAClientSerialiser.serializePlain(object);
    }

    private static byte[] serializePlain(Object object) {
        byte[] bytes = new byte[]{};
        try {
            bytes = kryo.write(object, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "LZMAClientSerializer serializePlain " + (object == null ? "object est null" : object.getClass().toString()), e);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializePlain(Object object, OutputStream fos) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(fos);
            out.writeObject(object);
            out.close();
            fos.close();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "serializePlain non kryo " + (object == null ? "object est null" : object.getClass().toString()), ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static byte[] serializeLzma(Object object) {
        byte[] bytes = new byte[]{};
        try {
            bytes = kryoComp.write(object, options);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "LZMAClientSerializer serializeLzma " + (object == null ? "object est null" : object.getClass().toString()), e);
        }
        return bytes;
    }

    public static Object deserialize(byte[] object) {
        if (object == null) {
            return null;
        }
        byte[] p = new byte[4];
        for (int i = 1; i < 5 && i < object.length; ++i) {
            p[i - 1] = object[i];
        }
        String pdf = new String(p);
        return LZMAClientSerialiser.deserialize(object, "7zXZ".equals(pdf));
    }

    public static Object deserialize(byte[] object, boolean wasCompressed) {
        if (wasCompressed) {
            return LZMAClientSerialiser.deserializeLzma(object);
        }
        return LZMAClientSerialiser.deserializePlain(object);
    }

    public static Object deserializePlain(byte[] object) {
        if (object == null) {
            return null;
        }
        try {
            return LZMAClientSerialiser.deserializePlain(new ByteArrayInputStream(object));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "LZMAClientSerializer deserializePlain " + (object == null ? "object est null" : object.getClass().toString()), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializePlain(InputStream fis) {
        Object ret = null;
        if (fis != null) {
            ObjectInputStream in = null;
            try {
                ret = kryo.read(fis);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "LZMAClientSerializer deserializePlain ", ex);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeLzma(byte[] object) {
        Object ret = null;
        if (object != null) {
            ByteArrayInputStream fis = null;
            try {
                fis = new ByteArrayInputStream(object);
                ret = kryoComp.read(fis);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "LZMAClientSerializer deserializeLzma " + (object == null ? "object est null" : object.getClass().toString()), ex);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return ret;
    }

    static {
        try {
            options.setLc(4);
            options.setPreset(1);
        }
        catch (UnsupportedOptionsException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

