/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.search;

import ca.infodata.ofys.data.middle.dataobjects.search.AndGroup;
import ca.infodata.ofys.data.middle.dataobjects.search.OrGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Group
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private ArrayList<Group> items = new ArrayList();

    public List<Group> items() {
        return this.items;
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public abstract Group add(Group var1);

    public Group clone() {
        try {
            Group c = (Group)super.clone();
            c.items = new ArrayList(this.items.size());
            for (Group group : this.items) {
                c.items.add(group.clone());
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void simplifiy(Group g) {
        Group.simplifyGroup(g);
    }

    private static boolean simplifyGroup(Group g) {
        if (g instanceof AndGroup) {
            return Group.simplifyAnd((AndGroup)g);
        }
        if (g instanceof OrGroup) {
            return Group.simplifyOr((OrGroup)g);
        }
        return false;
    }

    private static boolean simplifyOr(OrGroup g) {
        boolean simplified;
        do {
            simplified = false;
            for (Group e : g.items()) {
                simplified = Group.simplifyGroup(e) | simplified;
            }
        } while (simplified);
        simplified = false;
        ArrayList<Group> items2 = new ArrayList<Group>();
        for (Group group : g.items()) {
            if (group instanceof OrGroup) {
                items2.addAll(group.items());
                simplified = true;
                continue;
            }
            items2.add(group);
        }
        if (simplified) {
            g.items().clear();
            g.items().addAll(items2);
        }
        return simplified;
    }

    private static boolean simplifyAnd(AndGroup g) {
        boolean simplified;
        do {
            simplified = false;
            for (Group e : g.items()) {
                simplified = Group.simplifyGroup(e) | simplified;
            }
        } while (simplified);
        simplified = false;
        ArrayList<Group> items2 = new ArrayList<Group>();
        for (Group group : g.items()) {
            if (group instanceof AndGroup) {
                items2.addAll(group.items());
                simplified = true;
                continue;
            }
            items2.add(group);
        }
        if (simplified) {
            g.items().clear();
            g.items().addAll(items2);
        }
        return simplified;
    }
}

