/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.prevalidator;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;

public class AppointmentPreValidator
implements IPreValidator {
    private StringBuffer error = new StringBuffer();

    @Override
    public boolean validForDelete(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    @Override
    public boolean validForEdition(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    @Override
    public boolean validForSave(EditableDataObject dataObject, EditableDataObject editorInput) {
        boolean valid = true;
        this.error = new StringBuffer();
        XAppointment appointment = (XAppointment)dataObject;
        if (appointment.getStartTime() == null) {
            this.error.append(Messages.getString("ENTREZ_UNE_HEURE_DE_DEBUT", new String[0])).append("\r\n");
            valid = false;
        }
        if (appointment.getEndTime() == null) {
            this.error.append(Messages.getString("ENTREZ_UNE_HEURE_DE_FIN", new String[0])).append("\r\n");
            valid = false;
        } else if (appointment.getEndTime().intValue() >= 1440) {
            this.error.append(Messages.getString("_LHEURE_DE_FIN_EST_PLUS_GRANDE_QUE_24", new String[0])).append("\r\n");
            valid = false;
        }
        if (appointment.getArrivedTime() != null && appointment.getArrivedTime().intValue() >= 1440) {
            this.error.append(Messages.getString("_LHEURE_DARRIVEE_EST_PLUS_GRANDE_QUE_24", new String[0])).append("\r\n");
            valid = false;
        }
        if (appointment.getSeenTime() != null && appointment.getArrivedTime().intValue() >= 1440) {
            this.error.append(Messages.getString("_LHEURE_VUE_EST_PLUS_GRANDE_QUE_24", new String[0])).append("\r\n");
            valid = false;
        }
        return valid;
    }

    @Override
    public String getError() {
        return this.error.toString();
    }
}

