/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.medication;

import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDomains;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocaleProvider;

public enum XMyRouteOfAdministration {
    SO_NA(new Integer(0), "Voir d\u00e9tails", "See details"),
    OT(new Integer(180000), "instillation, otique", "instillation, otic"),
    ICORNTA(new Integer(66000), "application topique, corn\u00e9enne", "topical application, intracorneal"),
    BUC(new Integer(8000), "application topique, buccal", "topical application, buccal"),
    DOUCHE(new Integer(20000), "douche, vaginal", "douche, vaginal"),
    DISSOLVE(new Integer(19000), "dissoudre, oral", "dissolve, oral"),
    GARGLE(new Integer(36000), "se gargariser", "gargle"),
    ENEMA(new Integer(25000), "lavement, rectal", "enema, rectal"),
    ISYNINJ(new Integer(119000), "injection, synoviale", "injection, intrasynovial"),
    ILESINJ(new Integer(87000), "injection, intral\u00e9sionnelle", "injection, intralesional"),
    IM(new Integer(93000), "injection, intramusculaire", "injection, intramuscular"),
    ITENDINJ(new Integer(121000), "injection, tendineuse", "injection, intratendinous"),
    IU(new Integer(130000), "insertion, uterine", "insertion, intrauterine"),
    IV(new Integer(135000), "infusion, intraveineuse", "infusion, intravenous"),
    IVC(new Integer(136000), "infusion, par cath\u00e9ter intraveineux", "infusion, intravenous catheter"),
    TOPICAL(new Integer(224000), "topique", "topical"),
    SCALP(new Integer(201000), "application topique, cuir chevelu", "topical application, scalp"),
    MUC(new Integer(156000), "application topique, membrane muqueuse", "topical application, mucous membrane"),
    LARYNGTA(new Integer(154000), "application topique, laryng\u00e9e", "topical application, laryngeal"),
    NAIL(new Integer(157000), "application topique, ongle", "topical application, nail"),
    NASAL(new Integer(158000), "application topique, nasale", "topical application, nasal"),
    RECTAL(new Integer(199000), "application topique, rectale", "topical application, rectal"),
    LPINS(new Integer(155000), "insertion, voies lacrymales", "insertion, lacrimal puncta"),
    NASALINSTIL(new Integer(159000), "instillation, nasale", "instillation, nasal"),
    NASINHL(new Integer(160000), "inhalation, nasale", "inhalation, nasal"),
    NASNEB(new Integer(165000), "inhalation, n\u00e9bulisation nasale", "inhalation, nebulization, nasal"),
    ORNEB(new Integer(166000), "inhalation, n\u00e9bulisation orale", "inhalation, nebulization, oral"),
    ORMUC(new Integer(177000), "application topique, oromucosal", "topical application, oromucosal"),
    SKIN(new Integer(205000), "application topique, \u00e0 la peau", "topical application, skin"),
    VAGINS(new Integer(239000), "application topique, vaginale", "topical application, vaginal"),
    PAINJ(new Integer(181000), "injection, p\u00e9ri-articulaire", "injection, periarticular"),
    PO(new Integer(193000), "per OS", "per OS"),
    PR(new Integer(194000), "insertion, rectale", "insertion, rectal"),
    RECIRR(new Integer(198000), "irrigation, rectale", "irrigation, rectal"),
    RETENEMA(new Integer(200000), "lavement, r\u00e9tention rectale", "enema, rectal retention"),
    SQ(new Integer(212000), "injection, sous-cutan\u00e9e", "injection, subcutaneous"),
    SQIMPLNT(new Integer(213000), "implatation, sous-cutan\u00e9e", "implantation, subcutaneous"),
    SCINJ(new Integer(202000), "injection, sous-conjonctivale", "injection, subconjunctival"),
    SHAMPOO(new Integer(203000), "shampooing", "shampoo"),
    SININSTIL(new Integer(204000), "instillation, sinus sans pr\u00e9cision", "instillation, sinus, unspecified"),
    SL(new Integer(206000), "dissoudre, sublingual", "dissolve, sublingual"),
    SLESINJ(new Integer(207000), "injection, sous-l\u00e9sionnelle", "injection, sublesional"),
    IARTINJ(new Integer(51000), "injection, articulaire", "injection, intraarticular"),
    IBURSINJ(new Integer(53000), "injection, bourse", "injection, intrabursal"),
    AMNINJ(new Integer(1000), "injection, liquide amniotique", "injection, amniotic fluid"),
    BILINJ(new Integer(2000), "injection, voie biliaire", "injection, biliary tract"),
    BLADINJ(new Integer(3000), "injection, vessie", "injection, urinary bladder"),
    BLADINSTL(new Integer(4000), "instillation, catheter urinaire", "instillation, urinary catheter"),
    BLADIRR(new Integer(5000), "irrigation, vessie", "irrigation, urinary bladder"),
    BLADIRRC(new Integer(6000), "irrigation continue, vessie", "irrigation, urinary bladder, continuous"),
    BLADIRRT(new Integer(7000), "irrigation intermittente, vessie", "irrigation, urinary bladder, tidal"),
    CAPDINSTL(new Integer(9000), "instillation, port de dialyse p\u00e9riton\u00e9ale ambulatoire continue", "instillation, continuous ambulatory peritoneal dialysis port"),
    CECINSTL(new Integer(10000), "instillation, c\u00e9costomie", "instillation, cecostomy"),
    CERV(new Integer(11000), "application topique, cervicale", "topical application, cervical"),
    CERVINJ(new Integer(12000), "injection, cervicale", "injection, cervical"),
    CERVINS(new Integer(13000), "insertion, cervicale (uterus)", "insertion, cervical (uterine)"),
    CHEW(new Integer(14000), "m\u00e2cher, oral", "chew, oral"),
    CHOLINJ(new Integer(15000), "injection, pour cholangiographie", "injection, for cholangiography"),
    CTINSTL(new Integer(16000), "instillation, tube thoracique", "instillation, chest tube"),
    DEN(new Integer(17000), "application topique, dentaire", "topical application, dental"),
    DENRINSE(new Integer(18000), "rin\u00e7age, dentaire", "rinse, dental"),
    DRESS(new Integer(21000), "application topique, pansement imbib\u00e9", "topical application, soaked dressing"),
    EFT(new Integer(22000), "instillation, tube ent\u00e9rique", "instillation, enteral feeding tube"),
    ELECTOSMOS(new Integer(23000), "\u00e9lectro-osmose", "electro-osmosis"),
    ENDOSININJ(new Integer(24000), "injection, sinusale", "injection, endosinusial"),
    ENTINSTL(new Integer(26000), "instillation, ent\u00e9rique", "instillation, enteral"),
    EPI(new Integer(27000), "infusion, \u00e9pidurale", "infusion, epidural"),
    EPIDURINJ(new Integer(28000), "injection, \u00e9pidurale", "injection, epidural"),
    EPIINJ(new Integer(29000), "injection, \u00e9pidurale en bolus", "injection, epidural, push"),
    EPINJSP(new Integer(30000), "injection, \u00e9pidurale en bolus lent", "injection, epidural, slow push"),
    ETINSTL(new Integer(31000), "instillation, tube endo-tracheal", "instillation, endotracheal tube"),
    ETNEB(new Integer(32000), "n\u00e9bulisation, tube endo-tracheal", "nebulization, endotracheal tube"),
    EXTCORPDIF(new Integer(33000), "diffusion, extracorporelle", "diffusion, extracorporeal"),
    EXTCORPINJ(new Integer(34000), "injection, extracorporelle", "injection, extracorporeal"),
    EXTRAMNINJ(new Integer(35000), "injection, extra-amiotique", "injection, extra-amniotic"),
    GBINJ(new Integer(37000), "injection, gastrique", "injection, gastric button"),
    GIN(new Integer(38000), "application topique, gingivale", "topical application, gingival"),
    GINGINJ(new Integer(39000), "injection, gingivale", "injection, gingival"),
    GJT(new Integer(40000), "instillation, tude de gastro-j\u00e9junostomie", "instillation, gastro-jejunostomy tube"),
    GT(new Integer(41000), "instillation, tube de gastrostomie", "instillation, gastrostomy tube"),
    GUIRR(new Integer(42000), "irrigation, g\u00e9nito-urinaire", "irrigation, genitourinary"),
    HAIR(new Integer(43000), "application topique, cheveux", "topical application, hair"),
    HEMODIFF(new Integer(44000), "diffusion, h\u00e9modialyse", "diffusion, hemodialysis"),
    HEMOPORT(new Integer(45000), "injection, port d'h\u00e9modialyse", "injection, hemodialysis port"),
    IA(new Integer(46000), "infusion, cath\u00e9ter art\u00e9riel", "infusion, intraarterial catheter"),
    IABDINJ(new Integer(47000), "injection, intra-abdominale", "injection, intra-abdominal"),
    IAINJ(new Integer(48000), "injection, art\u00e9rielle", "injection, intraarterial"),
    IAINJP(new Integer(49000), "injection, art\u00e9rielle, bolus", "injection, intraarterial, push"),
    IAINJSP(new Integer(50000), "injection, art\u00e9rielle, bolus lent", "injection, intraarterial, slow push"),
    IBRONCHINSTIL(new Integer(52000), "instillation, bronchique", "instillation, intrabronchial"),
    IC(new Integer(54000), "infusion, intra-cardiaque", "infusion, intracardiac"),
    ICARDINJ(new Integer(55000), "injection, intra-cardiaque", "injection, intracardiac"),
    ICARDINJRP(new Integer(56000), "injection, intra-cardiaque, bolus rapide", "injection, intracardiac, rapid push"),
    ICARDINJSP(new Integer(57000), "injection, intra-cardiaque, bolus lent", "injection, intracardiac, slow push"),
    ICARINJP(new Integer(58000), "injection, intra-cardiaque, bolus", "injection, intracardiac, push"),
    ICARTINJ(new Integer(59000), "injection, cartilagineuse", "injection, intracartilaginous"),
    ICAUDINJ(new Integer(60000), "injection, caudale", "injection, intracaudal"),
    ICAVINJ(new Integer(61000), "injection, corps caverneux", "injection, intracavernous"),
    ICAVITINJ(new Integer(62000), "injection, cavitaire", "injection, intracavitary"),
    ICEREBINJ(new Integer(63000), "injection, c\u00e9r\u00e9brale", "injection, intracerebral"),
    ICISTERNINJ(new Integer(64000), "injection, cisternale", "injection, intracisternal"),
    ICOR(new Integer(65000), "infusion, coronarienne", "infusion, intracoronary"),
    ICORONINJ(new Integer(67000), "injection, intra-coronarienne", "injection, intracoronary"),
    ICORONINJP(new Integer(68000), "injection, intra-coronarienne, bolus", "injection, intracoronary, push"),
    ICORONTA(new Integer(69000), "application topique, couronne dentaire", "topical application, intracoronal (dental)"),
    ICORPCAVINJ(new Integer(70000), "injection, corps caverneux", "injection, intracorpus cavernosum"),
    IDIMPLNT(new Integer(71000), "implantation, intra-dermique", "implantation, intradermal"),
    IDINJ(new Integer(72000), "injection, intra-dermique", "injection, intradermal"),
    IDISCINJ(new Integer(73000), "injection, intra-discale", "injection, intradiscal"),
    IDOUDMAB(new Integer(74000), "absorption muqueuse intraduod\u00e9nale", "mucosal absorption, intraduodenal"),
    IDUCTINJ(new Integer(75000), "injection, intra-ductale", "injection, intraductal"),
    IDUODINSTIL(new Integer(76000), "instillation, duod\u00e9nale", "instillation, intraduodenal"),
    IDURINJ(new Integer(77000), "injection, durale", "injection, intradural"),
    IEPIDINJ(new Integer(78000), "injection, intra-\u00e9pidermique", "injection, intraepidermal"),
    IEPITHINJ(new Integer(79000), "injection, intra-\u00e9pith\u00e9liale", "injection, intraepithelial"),
    IESOPHINSTIL(new Integer(80000), "instillation, oesophagienne", "instillation, intraesophageal"),
    IESOPHTA(new Integer(81000), "application topique, oesophagienne", "topical application, intraesophageal"),
    IGASTINSTIL(new Integer(82000), "instillation, gastrique", "instillation, intragastric"),
    IGASTIRR(new Integer(83000), "irrigation, gastrique", "irrigation, intragastric"),
    IGASTLAV(new Integer(84000), "lavage, gastrique", "lavage, intragastric"),
    IILEALINJ(new Integer(85000), "instillation, il\u00e9ale", "instillation, intraileal"),
    IILEALTA(new Integer(86000), "application topique, il\u00e9ale", "topical application, intraileal"),
    ILESIRR(new Integer(88000), "irrigation, intral\u00e9sionnelle", "irrigation, intralesional"),
    ILTOP(new Integer(89000), "application topique, intral\u00e9sionnelle", "topical application, intralesional"),
    ILUMINJ(new Integer(90000), "injection, intraluminal", "injection, intraluminal"),
    ILUMTA(new Integer(91000), "application topique, intraluminal", "topical application, intraluminal"),
    ILYMPJINJ(new Integer(92000), "injection, intralymphatique", "injection, intralymphatic"),
    IMD(new Integer(94000), "injection, intramusculaire profond", "injection, intramuscular, deep"),
    IMZ(new Integer(95000), "injection, intramusculaire en z", "injection, intramuscular, z track"),
    IMEDULINJ(new Integer(96000), "injection, intram\u00e9dullaire", "injection, intramedullary"),
    INSUF(new Integer(97000), "insufflation", "insufflation"),
    INTERMENINJ(new Integer(98000), "injection, interamening\u00e9e", "injection, interameningeal"),
    INTERSTITINJ(new Integer(99000), "injection, interstitielle", "injection, interstitial"),
    IOINJ(new Integer(100000), "injection, intraoculaire", "injection, intraocular"),
    IOINSTL(new Integer(101000), "instillation, intraoculaire", "instillation, intraocular"),
    IOIRR(new Integer(102000), "irrigation, intraoculaire", "irrigation, intraocular"),
    IONTO(new Integer(103000), "application topique, ionophor\u00e8se", "topical application, iontophoresis"),
    IOSSC(new Integer(104000), "infusion, intra-osseux continue", "infusion, intraosseous, continuous"),
    IOSSINJ(new Integer(105000), "injection, intra-osseux", "injection, intraosseous"),
    IOSURGINS(new Integer(106000), "injection, intra-oculaire, chirurgicale", "insertion, intraocular, surgical"),
    IOTOP(new Integer(107000), "application topique, intra-oculaire", "topical application, intraocular"),
    IOVARINJ(new Integer(108000), "injection, intra-ovarienne", "injection, intraovarian"),
    IPCARDINJ(new Integer(109000), "injection, intrap\u00e9ricardique", "injection, intrapericardial"),
    IPERINJ(new Integer(110000), "injection, intrap\u00e9riton\u00e9ale", "injection, intraperitoneal"),
    IPINJ(new Integer(111000), "injection, intrapulmonaire", "injection, intrapulmonary"),
    IPLRINJ(new Integer(112000), "injection, pleural", "injection, intrapleural"),
    IPPB(new Integer(113000), "inhalation, resp pression positive intermittente", "inhalation, intermittent positive pressure breathing (ippb)"),
    IPROSTINJ(new Integer(114000), "injection, prostatique", "injection, intraprostatic"),
    IPUMPINJ(new Integer(115000), "injection, pompe \u00e0 insuline", "injection, insulin pump"),
    ISININSTIL(new Integer(116000), "instillation, sinusale", "instillation, intrasinal"),
    ISINJ(new Integer(117000), "injection, spinale", "injection, intraspinal"),
    ISTERINJ(new Integer(118000), "injection, sternale", "injection, intrasternal"),
    IT(new Integer(120000), "infusion, th\u00e9cale", "infusion, intrathecal"),
    ITESTINJ(new Integer(122000), "injection, testiculaire", "injection, intratesticular"),
    ITHORINJ(new Integer(123000), "injection, thoracique", "injection, intrathoracic"),
    ITINJ(new Integer(124000), "injection, th\u00e9cale", "injection, intrathecal"),
    ITRACHINSTIL(new Integer(125000), "instillation, trach\u00e9ale", "instillation, intratracheal"),
    ITRACHMAB(new Integer(126000), "absorption muqueuse, trach\u00e9ale", "mucosal absorption, intratracheal"),
    ITUBINJ(new Integer(127000), "injection, tubulaire", "injection, intratubular"),
    ITUMINJ(new Integer(128000), "injection, tumorale", "injection, intratumor"),
    ITYMPINJ(new Integer(129000), "injection, tympanique", "injection, intratympanic"),
    IUINJ(new Integer(131000), "injection, ut\u00e9rine", "injection, intrauterine"),
    IUINJC(new Integer(132000), "injection, cervicale (uterus)", "injection, intracervical (uterus)"),
    IUINSTL(new Integer(133000), "instillation, ut\u00e9rine", "instillation, intrauterine"),
    IURETINJ(new Integer(134000), "injection, ur\u00e9trale, retrograde", "injection, intraureteral, retrograde"),
    IVCC(new Integer(137000), "infusion, par cath\u00e9ter intraveineux en continue", "infusion, intravenous catheter, continuous"),
    IVCI(new Integer(138000), "infusion, par cath\u00e9ter intraveineux intermittent", "infusion, intravenous catheter, intermittent"),
    PCA(new Integer(139000), "infusion, par cath\u00e9ter intraveineux avec pompe", "infusion, intravenous catheter, pca pump"),
    IVASCINFUS(new Integer(140000), "infusion, intravasculaire", "infusion, intravascular"),
    IVASCINJ(new Integer(141000), "injection, intravasculaire", "injection, intravascular"),
    IVENTINJ(new Integer(142000), "injection, intraventriculaire (coeur)", "injection, intraventricular (heart)"),
    IVESINJ(new Integer(143000), "injection, intrav\u00e9siculaire", "injection, intravesicle"),
    IVFLUSH(new Integer(144000), "rin\u00e7age, catheter intraveineux", "flush, intravenous catheter"),
    IVINJ(new Integer(145000), "injection, intraveineux", "injection, intravenous"),
    IVINJBOL(new Integer(146000), "injection, bolus intraveineux", "injection, intravenous, bolus"),
    IVPUSH(new Integer(147000), "injection, bolus-push intraveineux", "injection, intravenous, push"),
    IVRPUSH(new Integer(148000), "injection, bolus rapide intraveineux", "injection, intravenous, rapid push"),
    IVSPUSH(new Integer(149000), "injection, bolus lent intraveineux", "injection, intravenous, slow push"),
    IVITIMPLNT(new Integer(150000), "implantation, vitr\u00e9", "implantation, intravitreal"),
    IVITINJ(new Integer(151000), "injection, vitr\u00e9", "injection, intravitreal"),
    JJTINSTL(new Integer(152000), "instillation, tube de j\u00e9nunostomie", "instillation, jejunostomy tube"),
    LARYNGINSTIL(new Integer(153000), "instillation, laryng\u00e9e", "instillation, laryngeal"),
    NASINHLC(new Integer(161000), "inhalation, canule nasale", "inhalation, nasal cannula"),
    NP(new Integer(162000), "inhalation, canule nasale", "inhalation, nasal cannula"),
    NASOGASINSTIL(new Integer(163000), "instillation, nasogastrique", "instillation, nasogastric"),
    NEB(new Integer(164000), "inhalation, n\u00e9bulisation", "inhalation, nebulization"),
    NGT(new Integer(167000), "instillation, tube nasogastrique", "instillation, nasogastric tube"),
    NTT(new Integer(168000), "instillation, tube nasotracheal", "instillation, nasotracheal tube"),
    OCDRESTA(new Integer(169000), "pansement occlusif", "occlusive dressing technique"),
    OGT(new Integer(170000), "instillation, tube orogastrique", "instillation, orogastric tube"),
    OJJ(new Integer(171000), "instillation, tube oroj\u00e9junal", "instillation, orojejunum tube"),
    OPTHALTA(new Integer(172000), "application topique, ophtalmique", "topical application, ophthalmic"),
    ORALTA(new Integer(173000), "application topique, oral", "topical application, oral"),
    ORINHL(new Integer(174000), "inhalation, respiratoire", "inhalation, respiratory"),
    ORIFINHL(new Integer(175000), "inhalation, d\u00e9bit oral intermittent", "inhalation, oral intermittent flow"),
    REBREATH(new Integer(176000), "inhalation, masque \u00e0 recirculation", "inhalation, oral rebreather mask"),
    OROPHARTA(new Integer(178000), "application topique, oropharyng\u00e9e", "topical application, oropharyngeal"),
    ORRINSE(new Integer(179000), "rineage, oral", "rinse, oral"),
    PARENTINJ(new Integer(182000), "injection, parent\u00e9rale", "injection, parenteral"),
    PDONTINJ(new Integer(183000), "injection, p\u00e9riodontale", "injection, periodontal"),
    PDONTTA(new Integer(184000), "application topique, p\u00e9riodontale", "topical application, periodontal"),
    PDPINJ(new Integer(185000), "injection, port de dialyse p\u00e9riton\u00e9ale", "injection, peritoneal dialysis port"),
    PDPINSTL(new Integer(186000), "instillation, port de dialyse p\u00e9riton\u00e9ale", "instillation, peritoneal dialysis port"),
    PDURINJ(new Integer(187000), "injection, p\u00e9ridurale", "injection, peridural"),
    PERIANAL(new Integer(188000), "application topique, p\u00e9rianale", "topical application, perianal"),
    PERINEAL(new Integer(189000), "application topique, p\u00e9rin\u00e9ale", "topical application, perineal"),
    PNINJ(new Integer(190000), "injection, p\u00e9rineural", "injection, perineural"),
    PNSINJ(new Integer(191000), "injection, sinus paranasales", "injection, paranasal sinuses"),
    PNSINSTL(new Integer(192000), "instillation, sinus paranasales", "instillation, paranasal sinuses"),
    RBINJ(new Integer(195000), "injection, r\u00e9trobulbaire", "injection, retrobulbar"),
    RECINSTL(new Integer(196000), "instillation, rectale", "instillation, rectal"),
    RECTINSTL(new Integer(197000), "instillation, tube rectale", "instillation, rectal tube"),
    SMUCMAB(new Integer(208000), "absorption muqueuse, sous-mucosal", "mucosal absorption, submucosal"),
    SOAK(new Integer(209000), "immersion (tremp\u00e9)", "immersion (soak)"),
    SOFTISINJ(new Integer(210000), "injection, tissu mou", "injection, soft tissue"),
    SOFTISINSTIL(new Integer(211000), "instillation, tissu mou", "instillation, soft tissue"),
    SQINFUS(new Integer(214000), "infusion, sous-cutan\u00e9e", "infusion, subcutaneous"),
    SQSURGINS(new Integer(215000), "insertion, sous-cutan\u00e9e chirurgicale", "insertion, subcutaneous, surgical"),
    SUBARACHINJ(new Integer(216000), "injection, sous-arachnoedienne", "injection, subarachnoid"),
    SUBCONJTA(new Integer(217000), "sousconjonctivale", "subconjunctival"),
    SUBMUCINJ(new Integer(218000), "injection, sous-muqueuse", "injection, submucosal"),
    SUCK(new Integer(219000), "sucer, oromucosal", "suck, oromucosal"),
    SWAB(new Integer(220000), "application topique, tampon", "topical application, swab"),
    SWISHSPIT(new Integer(221000), "rincer et cracher, oromucusal", "swish and spit out, oromucosal"),
    SWISHSWAL(new Integer(222000), "rincer et avaler, oromucosal", "swish and swallow, oromucosal"),
    TMUCTA(new Integer(223000), "application topique, transmucosale", "topical application, transmucosal"),
    TRACH(new Integer(225000), "inhalation, trach\u00e9ostomie", "inhalation, tracheostomy"),
    TRACHINSTL(new Integer(226000), "instillation, trach\u00e9ostomie", "instillation, tracheostomy"),
    TRNSDERM(new Integer(227000), "transdermique", "transdermal"),
    TRNSDERMD(new Integer(228000), "diffusion, transdermique", "diffusion, transdermal"),
    TRNSLING(new Integer(229000), "sublingual", "sublingual"),
    TRPLACINJ(new Integer(230000), "injection, plancentaire", "injection, transplacental"),
    TRTRACHINJ(new Integer(231000), "injection, trach\u00e9ale", "injection, transtracheal"),
    TRTYMPINSTIL(new Integer(232000), "instillation, tympanique", "instillation, transtympanic"),
    TTYMPTABSORP(new Integer(233000), "application topique, tympanique", "topical absorption, transtympanic"),
    URETHINJ(new Integer(234000), "injection, ur\u00e9trale", "injection, urethral"),
    URETHINS(new Integer(235000), "injection, ur\u00e9trale", "insertion, urethral"),
    URETHINSTL(new Integer(236000), "instillation, ur\u00e9trale", "instillation, urethral"),
    URETHSUP(new Integer(237000), "suppositoire, ur\u00e9trale", "suppository, urethral"),
    URETINJ(new Integer(238000), "injection, ur\u00e9trale", "injection, ureteral"),
    VAGINSI(new Integer(240000), "insertion, vaginale", "insertion, vaginal"),
    VENT(new Integer(241000), "inhalation, ventilateur", "inhalation, ventilator"),
    VENTMASK(new Integer(242000), "inhalation, ventimasque", "inhalation, ventimask");

    private final Integer id;
    private final String descFr;
    private final String descEn;

    private XMyRouteOfAdministration(Integer i, String dFr, String dEn) {
        this.id = i;
        this.descFr = dFr;
        this.descEn = dEn;
    }

    public String value() {
        return this.name();
    }

    public int getId() {
        return this.id;
    }

    public String description() {
        if (LocaleProvider.isEnglish()) {
            return this.descEn;
        }
        return this.descFr;
    }

    public static XMyRouteOfAdministration getRoute(Integer i) {
        return XPrescriptionDomains.getOnlyRoute(i);
    }

    public static XMyRouteOfAdministration getRoute(String s) {
        XMyRouteOfAdministration route = null;
        if (!StringUtils.isBlank((CharSequence)s)) {
            if ((s = s.toUpperCase()).indexOf("S.C.") > -1 || s.indexOf("SUBCUTANEOUS") > -1) {
                return SQ;
            }
            if (s.indexOf("VAG.") > -1 && s.indexOf("ANNEAU") > -1) {
                return VAGINSI;
            }
            if (s.indexOf("VAG.") > -1 || s.indexOf("VAGINAL") > -1) {
                return VAGINSI;
            }
            if (s.indexOf("S.LING.") > -1 || s.indexOf("S.-LING.") > -1 || s.indexOf("SUBLINGUAL") > -1) {
                return SL;
            }
            if (s.indexOf("TOP.") > -1 || s.indexOf("TOPICAL") > -1) {
                return TOPICAL;
            }
            if (s.indexOf("TRANSDERMAL") > -1) {
                return TRNSDERM;
            }
            if (s.indexOf("UTER.") > -1) {
                return IU;
            }
            if (s.indexOf(" OPH.") > -1 || s.indexOf("OPHTHALMIC") > -1) {
                return OPTHALTA;
            }
            if (s.indexOf("INTRACERVICAL") > -1) {
                return CERVINJ;
            }
            if (s.indexOf("RECT") > -1 || s.indexOf("RECTAL") > -1) {
                return RECTAL;
            }
            if (s.indexOf("I.M.") > -1 || s.indexOf("INTRAMUSCULAR") > -1) {
                return IM;
            }
            if (s.indexOf("I.V") > -1 || s.indexOf("INTRAVENOUS") > -1) {
                return IV;
            }
            if (s.indexOf(" OR.") > -1 || s.indexOf("ORAL") == 0 || s.indexOf(" ORAL") > -1) {
                return PO;
            }
            if (s.indexOf("INH.") > -1 && s.indexOf("NAS.") > -1) {
                return NASINHL;
            }
            if (s.indexOf("INH.") > -1 || s.indexOf("INHALATION") > -1) {
                return ORINHL;
            }
            if (s.indexOf("EPI.") > -1) {
                return IEPIDINJ;
            }
            if (s.indexOf("NAS.") > -1) {
                return NASAL;
            }
            if (s.indexOf(" OT.") > -1 || s.indexOf("OTIC") > -1) {
                return OT;
            }
            if (s.indexOf("UROL.") > -1) {
                return URETHINS;
            }
            if (s.indexOf("CUT.") > -1) {
                return TOPICAL;
            }
            if (s.indexOf(" OTIC") > -1) {
                return OT;
            }
            if (s.indexOf("SUSPEN.") > -1) {
                return OPTHALTA;
            }
            if (s.indexOf("INTRALESIONAL") > -1) {
                return ILESINJ;
            }
            if (s.indexOf("INTRASYNOVIAL") > -1) {
                return ISYNINJ;
            }
            if (s.indexOf("IRRIGATION") > -1) {
                return GUIRR;
            }
            if (s.indexOf("DISINFECTANT") > -1) {
                return TOPICAL;
            }
            if (s.indexOf("INFILTRATION") > -1) {
                return ILESINJ;
            }
            if (s.indexOf("INTRAPERITONEAL") > -1) {
                return IPERINJ;
            }
            if (s.indexOf("INTRA-ARTICULAR") > -1) {
                return IARTINJ;
            }
        }
        return route;
    }
}

