/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.inspq.immunization;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeZoneProvider;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class XNormalizedDate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String year;
    private String month;
    private String day;

    public XNormalizedDate(String source) {
        this.from(source);
    }

    String getYear() {
        return this.year;
    }

    String getMonth() {
        return this.month;
    }

    String getDay() {
        return this.day;
    }

    public String get() {
        StringBuilder b = new StringBuilder(10);
        b.append(this.year);
        b.append('-');
        b.append(this.month);
        b.append('-');
        b.append(this.day);
        return b.toString();
    }

    public LocalDate toLocalDate() {
        return LocalDate.from((int)Integer.valueOf(this.day), (int)Integer.valueOf(this.month), (int)Integer.valueOf(this.year));
    }

    public Date toDate() {
        try {
            FastDateFormat format = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)TimeZoneProvider.getTimeZone(), (Locale)LocaleProvider.getLocale());
            Date date = format.parse(this.get());
            return date;
        }
        catch (ParseException e) {
            throw new IllegalStateException("inner date is not formated as yyyy-MM-dd " + this.get(), e);
        }
    }

    public void set(String source) {
        this.from(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void from(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            throw new IllegalArgumentException("blank source does not represent a valid date");
        }
        if (source.length() != 10) throw new IllegalArgumentException("source is not in a supported format");
        if (source.indexOf(45) >= 0) {
            this.from('-', source);
            return;
        } else {
            if (source.indexOf(47) < 0) throw new IllegalArgumentException("source is not in a supported format");
            this.from('/', source);
        }
    }

    private void from(char separator, String source) {
        String dayS;
        String monthS;
        String yearS;
        block6: {
            String[] split = source.split(String.valueOf(separator));
            if (split.length == 3) {
                yearS = split[0];
                monthS = split[1];
                dayS = split[2];
                if (yearS.length() != 4 || monthS.length() != 2 || dayS.length() != 2) {
                    throw new IllegalArgumentException("source is not formatted like yyyy-MM-dd");
                }
                try {
                    Integer.valueOf(yearS);
                    Integer month = Integer.valueOf(monthS);
                    if (month < 1 || month > 12) {
                        throw new IllegalArgumentException("source does not represent a valid date");
                    }
                    Integer day = Integer.valueOf(dayS);
                    if (day < 1 || day > 31) {
                        throw new IllegalArgumentException("source does not represent a valid date");
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("source is not formatted like yyyy-MM-dd");
                }
            }
            throw new IllegalArgumentException("source is not formatted like yyyy-MM-dd but contains - char");
        }
        this.year = yearS;
        this.month = monthS;
        this.day = dayS;
    }

    public String toString() {
        return this.get();
    }
}

