/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart;

import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Age;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.GrowChartPdfUtil;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Language;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.SEX_N_LANGUAGE;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Sex;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HFA_WFA219 {
    private String fullname;
    private LocalDate birthdate;
    private String recordnumber;
    private Float motherHeight;
    private Float fatherHeight;
    private Sex sex;
    private Language language;
    private boolean blackAndWhite;
    private List<DATA> datas;

    public byte[] render() throws Exception {
        int m;
        if (this.datas == null) {
            throw new NullPointerException("datas");
        }
        Collections.sort(this.datas, new Comparator<DATA>(){

            @Override
            public int compare(DATA o1, DATA o2) {
                return o1.date.compareTo((IPartialDate)o2.date);
            }
        });
        byte[] pdf = GrowChartPdfUtil.readFile("HFA-WFA_2-19", this.getSex(), this.getLanguage(), this.isBlackAndWhite());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PdfReader reader = new PdfReader(pdf);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)output);
        boolean page = true;
        PdfContentByte overContent = stamper.getOverContent(1);
        BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        overContent.setFontAndSize(font, 10.0f);
        overContent.beginText();
        SEX_N_LANGUAGE sexLang = this.getSexLang();
        float x = 0.0f;
        float y = 0.0f;
        if (this.fullname != null) {
            switch (sexLang) {
                case BOYS_EN: {
                    x = 400.0f;
                    y = 740.0f;
                    break;
                }
                case GIRLS_FR: {
                    x = 400.0f;
                    y = 735.0f;
                    break;
                }
                case GIRLS_EN: {
                    x = 403.0f;
                    y = 728.0f;
                    break;
                }
                case BOYS_FR: {
                    x = 400.0f;
                    y = 735.0f;
                }
            }
            overContent.showTextAligned(0, this.fullname, x, y, 0.0f);
        }
        if (this.birthdate != null) {
            switch (sexLang) {
                case BOYS_EN: {
                    x = 395.0f;
                    y = 726.0f;
                    break;
                }
                case GIRLS_FR: {
                    x = 395.0f;
                    y = 721.0f;
                    break;
                }
                case GIRLS_EN: {
                    x = 400.0f;
                    y = 716.0f;
                    break;
                }
                case BOYS_FR: {
                    x = 395.0f;
                    y = 721.0f;
                }
            }
            overContent.showTextAligned(0, this.birthdate.formatSlash(), x, y, 0.0f);
        }
        if (this.getRecordnumber() != null) {
            switch (sexLang) {
                case BOYS_EN: {
                    x = 526.0f;
                    y = 726.0f;
                    break;
                }
                case GIRLS_FR: {
                    x = 535.0f;
                    y = 721.0f;
                    break;
                }
                case GIRLS_EN: {
                    x = 535.0f;
                    y = 716.0f;
                    break;
                }
                case BOYS_FR: {
                    x = 535.0f;
                    y = 721.0f;
                }
            }
            overContent.showTextAligned(0, this.getRecordnumber(), x, y, 0.0f);
        }
        if (this.getMotherHeight() != null) {
            switch (sexLang) {
                case BOYS_EN: {
                    x = 170.0f;
                    y = 676.0f;
                    break;
                }
                case GIRLS_FR: {
                    x = 180.0f;
                    y = 674.0f;
                    break;
                }
                case GIRLS_EN: {
                    x = 180.0f;
                    y = 668.0f;
                    break;
                }
                case BOYS_FR: {
                    x = 180.0f;
                    y = 674.0f;
                }
            }
            overContent.setFontAndSize(font, 7.0f);
            overContent.showTextAligned(0, String.valueOf(this.getMotherHeight()) + " cm", x, y, 0.0f);
        }
        if (this.getFatherHeight() != null) {
            switch (sexLang) {
                case BOYS_EN: {
                    x = 170.0f;
                    y = 665.0f;
                    break;
                }
                case GIRLS_FR: {
                    x = 175.0f;
                    y = 662.0f;
                    break;
                }
                case GIRLS_EN: {
                    x = 180.0f;
                    y = 656.0f;
                    break;
                }
                case BOYS_FR: {
                    x = 175.0f;
                    y = 663.0f;
                }
            }
            overContent.setFontAndSize(font, 7.0f);
            overContent.showTextAligned(0, String.valueOf(this.getMotherHeight()) + " cm", x, y, 0.0f);
        }
        float rx = 0.0f;
        float ry = 0.0f;
        float rw = 0.0f;
        float rh = 0.0f;
        switch (sexLang) {
            case BOYS_EN: {
                rx = 102.8f;
                ry = 588.0f;
                rw = 222.8f;
                rh = 70.0f;
                break;
            }
            case GIRLS_FR: {
                rx = 113.0f;
                ry = 584.6f;
                rw = 222.8f;
                rh = 70.0f;
                break;
            }
            case GIRLS_EN: {
                rx = 112.5f;
                ry = 578.0f;
                rw = 222.8f;
                rh = 70.0f;
                break;
            }
            case BOYS_FR: {
                rx = 112.6f;
                ry = 587.6f;
                rw = 222.8f;
                rh = 70.0f;
            }
        }
        overContent.setColorStroke(Color.WHITE);
        overContent.setColorFill(Color.WHITE);
        overContent.rectangle(rx, ry, rw, rh);
        overContent.fill();
        overContent.setColorFill(Color.BLACK);
        overContent.setColorStroke(Color.BLACK);
        float xStart = rx;
        float yEnd = ry + rh - 5.0f;
        float dateStart = xStart + 4.0f;
        float ageStart = dateStart + 38.0f;
        float heigthStart = ageStart + 45.0f;
        float weightStart = heigthStart + 37.0f;
        float commentStart = weightStart + 37.0f;
        overContent.setFontAndSize(font, 6.0f);
        overContent.showTextAligned(0, "DATE", dateStart, yEnd, 0.0f);
        overContent.showTextAligned(0, "AGE", ageStart, yEnd, 0.0f);
        overContent.showTextAligned(0, "HEIGTH", heigthStart, yEnd, 0.0f);
        overContent.showTextAligned(0, "WEIGHT", weightStart, yEnd, 0.0f);
        overContent.showTextAligned(0, "COMMENTS", commentStart, yEnd, 0.0f);
        int reportTextLinesNumber = 8;
        int datasOffset = Math.max(0, this.datas.size() - 8);
        int i = 0;
        while (i + datasOffset < this.datas.size()) {
            DATA data = this.datas.get(i + datasOffset);
            y = yEnd - (float)(i + 1) * 7.65f;
            x = dateStart;
            overContent.showTextAligned(0, data.date.formatSlash(), x, y, 0.0f);
            x = ageStart;
            overContent.showTextAligned(0, Age.formatYearMonth(this.birthdate, data.date), x, y, 0.0f);
            if (data.height != null) {
                x = heigthStart;
                overContent.showTextAligned(0, String.valueOf(data.height) + " cm", x, y, 0.0f);
            }
            if (data.weight != null) {
                x = weightStart;
                overContent.showTextAligned(0, String.valueOf(data.weight.floatValue() / 1000.0f) + " kg", x, y, 0.0f);
            }
            if (data.comments != null) {
                x = commentStart;
                overContent.showTextAligned(0, data.comments, x, y, 0.0f);
            }
            ++i;
        }
        float yStart = 0.0f;
        float xEnd = 0.0f;
        switch (sexLang) {
            case BOYS_EN: 
            case GIRLS_EN: {
                xStart = 112.5f;
                xEnd = 534.0f;
                yStart = 71.0f;
                yEnd = 423.0f;
                break;
            }
            case GIRLS_FR: 
            case BOYS_FR: {
                xStart = 112.5f;
                xEnd = 534.0f;
                yStart = 77.0f;
                yEnd = 429.7f;
                break;
            }
        }
        float minYValue = this.getSex() == Sex.BOYS ? 2000.0f : 2000.0f;
        float maxYValue = this.getSex() == Sex.BOYS ? 93000.0f : 93000.0f;
        float minXValue = 24.0f;
        float maxXValue = 228.0f;
        ArrayList<Point> dots = new ArrayList<Point>();
        for (DATA data : this.datas) {
            m = data.date.getMonthDiff(this.birthdate);
            if (data.weight == null) continue;
            x = xStart + (xEnd - xStart) * (((float)m - minXValue) / (maxXValue - minXValue));
            y = yStart + (yEnd - yStart) * ((data.weight.floatValue() - minYValue) / (maxYValue - minYValue));
            overContent.circle(x, y, 2.0f);
            dots.add(new Point(x, y));
        }
        for (int i2 = dots.size() - 1; i2 >= 0; --i2) {
            overContent.lineTo(((Point)dots.get((int)i2)).x, ((Point)dots.get((int)i2)).y);
        }
        switch (sexLang) {
            case GIRLS_EN: {
                xStart = 112.3f;
                xEnd = xStart + 421.6f;
                yStart = 183.1f;
                yEnd = yStart + 507.75f;
                break;
            }
            case BOYS_EN: {
                xStart = 102.4f;
                xEnd = xStart + 421.6f;
                yStart = 193.2f;
                yEnd = yStart + 507.75f;
                break;
            }
            case GIRLS_FR: 
            case BOYS_FR: {
                xStart = 112.3f;
                xEnd = 534.2f;
                yStart = 189.5f;
                yEnd = yStart + 507.8f;
                break;
            }
        }
        minYValue = this.getSex() == Sex.BOYS ? 76.0f : 71.0f;
        maxYValue = this.getSex() == Sex.BOYS ? 207.0f : 202.0f;
        minXValue = 24.0f;
        maxXValue = 228.0f;
        dots = new ArrayList();
        for (DATA data : this.datas) {
            if (data.height == null) continue;
            m = data.date.getMonthDiff(this.birthdate);
            ry = (data.height.floatValue() - minYValue) / (maxYValue - minYValue);
            rx = ((float)m - minXValue) / (maxXValue - minXValue);
            y = yStart + (yEnd - yStart) * ry;
            x = xStart + (xEnd - xStart) * rx;
            overContent.circle(x, y, 2.0f);
            dots.add(new Point(x, y));
        }
        for (int i3 = dots.size() - 1; i3 >= 0; --i3) {
            overContent.lineTo(((Point)dots.get((int)i3)).x, ((Point)dots.get((int)i3)).y);
        }
        overContent.stroke();
        overContent.endText();
        stamper.close();
        reader.close();
        return output.toByteArray();
    }

    private SEX_N_LANGUAGE getSexLang() throws Exception {
        if (this.getLanguage() == Language.EN) {
            if (this.getSex() == Sex.BOYS) {
                return SEX_N_LANGUAGE.BOYS_EN;
            }
            if (this.getSex() == Sex.GIRLS) {
                return SEX_N_LANGUAGE.GIRLS_EN;
            }
        }
        if (this.getLanguage() == Language.FR) {
            if (this.getSex() == Sex.BOYS) {
                return SEX_N_LANGUAGE.BOYS_FR;
            }
            if (this.getSex() == Sex.GIRLS) {
                return SEX_N_LANGUAGE.GIRLS_FR;
            }
        }
        throw new Exception("unsupported combinaison of sex and language " + (Object)((Object)this.getSex()) + ", " + (Object)((Object)this.getLanguage()));
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public LocalDate getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(LocalDate birthdate) {
        this.birthdate = birthdate;
    }

    public String getRecordnumber() {
        return this.recordnumber;
    }

    public void setRecordnumber(String recordnumber) {
        this.recordnumber = recordnumber;
    }

    public List<DATA> getDatas() {
        return this.datas;
    }

    public void setDatas(List<DATA> datas) {
        this.datas = datas;
    }

    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Float getMotherHeight() {
        return this.motherHeight;
    }

    public void setMotherHeight(Float motherHeight) {
        this.motherHeight = motherHeight;
    }

    public Float getFatherHeight() {
        return this.fatherHeight;
    }

    public void setFatherHeight(Float fatherHeight) {
        this.fatherHeight = fatherHeight;
    }

    public boolean isBlackAndWhite() {
        return this.blackAndWhite;
    }

    public void setBlackAndWhite(boolean blackAndWhite) {
        this.blackAndWhite = blackAndWhite;
    }

    public static void main(String[] args) throws Exception {
        String name = "Steeve St-Laurent";
        LocalDate birthdate = Age.parse("2000/08/14");
        String recordnumber = "00015";
        ArrayList<DATA> datas = new ArrayList<DATA>();
        datas.add(new DATA(Age.parse("2002/01/01"), Float.valueOf(80.0f), Float.valueOf(15000.0f), "bebe"));
        datas.add(new DATA(Age.parse("2003/02/01"), Float.valueOf(90.0f), Float.valueOf(16000.0f), "mignon"));
        datas.add(new DATA(Age.parse("2004/03/01"), Float.valueOf(100.0f), Float.valueOf(18000.0f), "joue"));
        datas.add(new DATA(Age.parse("2005/04/01"), Float.valueOf(105.0f), Float.valueOf(19000.0f), "dort"));
        datas.add(new DATA(Age.parse("2006/04/01"), Float.valueOf(120.0f), Float.valueOf(30000.0f), "rie"));
        datas.add(new DATA(Age.parse("2007/05/01"), Float.valueOf(130.0f), Float.valueOf(35000.0f), "pleure"));
        datas.add(new DATA(Age.parse("2008/06/01"), Float.valueOf(150.0f), Float.valueOf(35000.0f), "boie"));
        datas.add(new DATA(Age.parse("2009/07/01"), Float.valueOf(170.0f), Float.valueOf(35000.0f), "crie"));
        datas.add(new DATA(Age.parse("2009/08/01"), Float.valueOf(171.0f), Float.valueOf(35000.0f), "sourie"));
        datas.add(new DATA(Age.parse("2010/09/01"), Float.valueOf(174.0f), Float.valueOf(36000.0f), "marche"));
        datas.add(new DATA(Age.parse("2010/10/01"), Float.valueOf(177.0f), Float.valueOf(36000.0f), "tombe"));
        datas.add(new DATA(Age.parse("2011/11/01"), Float.valueOf(180.0f), Float.valueOf(50000.0f), "attape"));
        datas.add(new DATA(Age.parse("2012/11/01"), null, null, null));
        HFA_WFA219 report = new HFA_WFA219();
        report.setBirthdate(birthdate);
        report.setMotherHeight(Float.valueOf(170.0f));
        report.setFatherHeight(Float.valueOf(170.0f));
        report.setRecordnumber("00015");
        report.setFullname("Steeve St-Laurent");
        report.setDatas(datas);
        report.setSex(Sex.GIRLS);
        report.setLanguage(Language.FR);
        report.setBlackAndWhite(false);
        byte[] pdf = report.render();
        GrowChartPdfUtil.showWithExternalViewer(pdf);
    }

    public static class DATA {
        public LocalDate date;
        public Float height;
        public Float weight;
        public String comments;

        public DATA(LocalDate date, Float heightInCm, Float weightInGrams, String comments) {
            this.date = date;
            this.height = heightInCm;
            this.weight = weightInGrams;
            this.comments = comments;
        }
    }

    private static class Point {
        float x;
        float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

