/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter;

import ca.infodata.ofys.data.middle.dataobjects.GenericDataMapping;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnalSpeciality;
import ca.infodata.ofys.data.middle.dataobjects.consultation.XConsultationRequest;
import ca.infodata.ofys.data.middle.dataobjects.consultation.XConsultationSeverity;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.IEncounterRaison;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergy;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergyProbability;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergySeverity;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergyType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBaseEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBloodPressure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBodyTemperature;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBodyTemperatureType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCodeClassification;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCustomMeasure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnostic;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnosticEnc;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnosticStatus;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocumentType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocuments;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterBilling;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterLabel;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterNote;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterRaison;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterToBeCompleted;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterToBeRevised;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XFrequency;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XImmunization;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XIntervention;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabit;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabitFrequency;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabitType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XMeasurement;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XNoteType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPhysicalExamination;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPrevent;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPreventActionType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPreventType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRappel;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRappelResolvedStatus;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRxAllergyTypeCode;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLabType;
import ca.infodata.ofys.data.middle.dataobjects.medication.MedCalc;
import ca.infodata.ofys.data.middle.dataobjects.medication.RxUtil;
import ca.infodata.ofys.data.middle.dataobjects.medication.XChangeDose;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDevice;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyHumanSubstanceAdministrationSite;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.util.EnumWithValues;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.ofys.util.math.NumberUtils;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeZoneProvider;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public final class CEncounter
extends CEditableDataObject
implements Serializable {
    private static final Logger logger = Logger.getLogger(CEncounter.class.getName());
    private static final long serialVersionUID = 189796544L;
    public static final String DETAILS = Messages.getString("DETAILS", new String[0]);
    public String className = CEncounter.class.getSimpleName();
    public int uid;
    private Integer id;
    private Integer idAnchor;
    @FieldSerializer.NotNull
    private Integer idSite;
    @FieldSerializer.NotNull
    private Integer idProfAnchor;
    @FieldSerializer.NotNull
    private Integer idPatientAnchor;
    private Boolean isSigned;
    private Integer encounterType;
    private String encounterTypeS;
    private Long datetime;
    private String datetimeS;
    public String date;
    private XPatient xpatient;
    private Object patient;
    public Boolean fromSearch = Boolean.FALSE;
    private String[] billings;
    private List<EncounterBilling> lstBilling;
    private String[] notes;
    private List<EncounterNote> lstNote;
    private String[] notesDate;
    private String[] raisons;
    private List<EncounterRaison> lstRaison;
    private String tbc;
    private EncounterToBeCompleted tbcObj;
    private String tbr;
    private EncounterToBeRevised tbrObj;
    public Integer removeSupervisor;
    private String[] familyHistoryObjArr;
    public EncounterNote familyHistoryObj;
    private String[] medicalHistoryObjArr;
    public EncounterNote medicalHistoryObj;
    private String[] socialHistoryObjArr;
    public EncounterNote socialHistoryObj;
    private String[] ongoingConcernsObjArr;
    public EncounterNote ongoingConcernsObj;
    private String[] otherMedicationsObjArr;
    public EncounterNote otherMedicationsObj;
    private Integer encounterLanguage;
    private String[] profs;
    private String[] allergies;
    private String[] intolerances;
    private String[] interventions;
    private String[] lifeHabits;
    private String[] prevents;
    private String[] rappels;
    private String[] docs;
    private String[] immunizations;
    private String[] bps;
    private String[] bts;
    private String[] fqs;
    private String[] mss;
    private String[] pes;
    private String[] prescriptions;
    private String[] devices;
    private String[] consults;
    private String[] custMeasures;
    private String[] dxsEnc;
    private String[] dxs;
    private String[] probs;
    private List<Profs> lstProf;
    private List<Allergies> lstAllergy;
    private List<Intolerances> lstIntolerance;
    private List<Interventions> lstIntervention;
    private List<LifeHabits> lstLifeHabit;
    private List<Prevents> lstPrevent;
    private List<Rappels> lstRappel;
    private List<Docs> lstDoc;
    private List<Immunizations> lstImmunization;
    private List<BloodPres> lstBloodPres;
    private List<BodyTemp> lstBodyTemp;
    private List<Freq> lstFreq;
    private List<Measurement> lstMeasurement;
    private List<PhysicalExam> lstPhysicalExam;
    private List<Prescription> lstPrescription;
    private List<Device> lstDevice;
    private List<Consult> lstConsult;
    private List<CustMeasure> lstCustMeasure;
    private List<DxEnc> lstDxEnc;
    private List<Dx> lstDx;
    private List<Prob> lstProb;
    public Integer encLabelInt;
    public List<Integer> lstEncLabel;
    public transient EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);

    public static String getStringDateTimeFromLong(Long l) {
        if (l == null) {
            return null;
        }
        return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm", (TimeZone)TimeZoneProvider.getTimeZone(), (Locale)LocaleProvider.getLocale()).format(new Date(l));
    }

    public List<Integer> addToLstEncLabel(Integer p) {
        if (this.lstEncLabel == null) {
            this.lstEncLabel = new ArrayList<Integer>();
        }
        this.lstEncLabel.add(p);
        return this.lstEncLabel;
    }

    public void setEncLabelInt(List<Integer> lstInt) {
        this.encLabelInt = new Integer(0);
        if (lstInt != null) {
            for (Integer i : lstInt) {
                CEncounter cEncounter = this;
                Integer.valueOf(cEncounter.encLabelInt | i);
                cEncounter.encLabelInt = cEncounter.encLabelInt;
            }
        }
    }

    public EnumSet<XEncounterLabel> getEncLabel() {
        return this.encLabel;
    }

    public void setEncLabel(EnumSet<XEncounterLabel> status) {
        this.encLabel = status;
    }

    public Integer getEncLabelInt() {
        return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
    }

    public void setEncLabelInt(Integer status) {
        this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
    }

    public void removeXEncounterLabel(XEncounterLabel x) {
        this.encLabel.remove(x);
    }

    public void addXEncounterLabel(XEncounterLabel x) {
        this.encLabel.add(x);
    }

    public CEncounter() {
    }

    public CEncounter(XEncounter encounter) {
        super(encounter);
        this.init(encounter);
    }

    public CEncounter(XEncounterModificationRequest req) {
        super(req.getEncounter());
        this.init(req.getEncounter());
        if (req.getAllergies() != null) {
            for (XAllergy xAllergy : req.getAllergies()) {
                if (XAllergyType.ALLERGY.equals((Object)xAllergy.getDataType())) {
                    if (!xAllergy.isDirty()) continue;
                    this.addToLst(new Allergies(xAllergy));
                    continue;
                }
                if (!xAllergy.isDirty()) continue;
                this.addToLst(new Intolerances(xAllergy));
            }
        }
        if (req.getRappels() != null) {
            for (XRappel xRappel : req.getRappels()) {
                this.addToLst(new Rappels(xRappel));
            }
        }
        if (req.getImmunizations() != null) {
            for (XImmunization xImmunization : req.getImmunizations()) {
                this.addToLst(new Immunizations(xImmunization));
            }
        }
        if (req.getInterventions() != null) {
            for (XIntervention xIntervention : req.getInterventions()) {
                this.addToLst(new Interventions(xIntervention));
            }
        }
        if (req.getLifeHabits() != null) {
            for (XLifeHabit xLifeHabit : req.getLifeHabits()) {
                this.addToLst(new LifeHabits(xLifeHabit));
            }
        }
        if (req.getPrescriptions() != null) {
            for (XPrescription xPrescription : req.getPrescriptions()) {
                if (xPrescription.getStrength() != null) {
                    this.addToLst(new Prescription(xPrescription));
                    continue;
                }
                if (xPrescription.getDevice() == null) continue;
                this.addToLst(new Device(xPrescription));
            }
        }
        if (req.getPrevents() != null) {
            for (XPrevent xPrevent : req.getPrevents()) {
                this.addToLst(new Prevents(xPrevent));
            }
        }
        if (req.getDiagnosticEncs() != null) {
            for (XDiagnosticEnc xDiagnosticEnc : req.getDiagnosticEncs()) {
                this.addToLst(new DxEnc(xDiagnosticEnc));
            }
        }
        if (req.getDiagnostics() != null) {
            for (XDiagnostic xDiagnostic : req.getDiagnostics()) {
                if (Boolean.TRUE.equals(xDiagnostic.getIsProblem())) {
                    this.addToLst(new Prob(xDiagnostic));
                    continue;
                }
                this.addToLst(new Dx(xDiagnostic));
            }
        }
        if (req.familyHistoryObj != null) {
            this.familyHistoryObj = new EncounterNote(req.familyHistoryObj);
        }
        if (req.medicalHistoryObj != null) {
            this.medicalHistoryObj = new EncounterNote(req.medicalHistoryObj);
        }
        if (req.ongoingConcernsObj != null) {
            this.ongoingConcernsObj = new EncounterNote(req.ongoingConcernsObj);
        }
        if (req.otherMedicationsObj != null) {
            this.otherMedicationsObj = new EncounterNote(req.otherMedicationsObj);
        }
        if (req.socialHistoryObj != null) {
            this.socialHistoryObj = new EncounterNote(req.socialHistoryObj);
        }
        if (req.getDiagnostics() != null) {
            for (XDiagnostic xDiagnostic : req.getDiagnostics()) {
                this.addToLst(new Dx(xDiagnostic));
            }
        }
        if (req.getDocuments() != null) {
            for (XDocuments xDocuments : req.getDocuments()) {
                this.addToLst(new Docs(xDocuments));
            }
        }
        if (req.getBloodPressures() != null) {
            for (XBloodPressure xBloodPressure : req.getBloodPressures()) {
                this.addToLst(new BloodPres(xBloodPressure));
            }
        }
        if (req.getBodyTemperatures() != null) {
            for (XBodyTemperature xBodyTemperature : req.getBodyTemperatures()) {
                this.addToLst(new BodyTemp(xBodyTemperature));
            }
        }
        if (req.getFrequencies() != null) {
            for (XFrequency xFrequency : req.getFrequencies()) {
                this.addToLst(new Freq(xFrequency));
            }
        }
        if (req.getMeasurements() != null) {
            for (XMeasurement xMeasurement : req.getMeasurements()) {
                this.addToLst(new Measurement(xMeasurement));
            }
        }
        if (req.getPhysicalExaminations() != null) {
            for (XPhysicalExamination xPhysicalExamination : req.getPhysicalExaminations()) {
                this.addToLst(new PhysicalExam(xPhysicalExamination));
            }
        }
        if (req.getBillings() != null) {
            for (XEncounterBilling xEncounterBilling : req.getBillings()) {
                this.addToLst(new EncounterBilling(xEncounterBilling));
            }
        }
        if (req.getNotes() != null) {
            for (XEncounterNote xEncounterNote : req.getNotes()) {
                this.addToLst(new EncounterNote(xEncounterNote));
            }
        }
        if (req.getConsultations() != null) {
            for (XConsultationRequest xConsultationRequest : req.getConsultations()) {
                this.addToLst(new Consult(xConsultationRequest));
            }
        }
        if (req.getCustomMeasures() != null) {
            for (XCustomMeasure xCustomMeasure : req.getCustomMeasures()) {
                this.addToLst(new CustMeasure(xCustomMeasure));
            }
        }
        if (req.getRaisons() != null) {
            for (XEncounterRaison xEncounterRaison : req.getRaisons()) {
                this.addToLst(new EncounterRaison(xEncounterRaison));
            }
        }
        if (req.encounterToBeCompleted != null) {
            this.setTbcObj(new EncounterToBeCompleted(req.encounterToBeCompleted));
        }
        if (req.encounterToBeRevised != null) {
            this.setTbrObj(new EncounterToBeRevised(req.encounterToBeRevised));
        }
    }

    public void addToLst(EncounterRaison a) {
        if (this.lstRaison == null) {
            this.lstRaison = new ArrayList<EncounterRaison>();
        }
        this.lstRaison.add(a);
    }

    public void addToLst(Allergies a) {
        if (this.lstAllergy == null) {
            this.lstAllergy = new ArrayList<Allergies>();
        }
        this.lstAllergy.add(a);
    }

    public void addToLst(Intolerances a) {
        if (this.lstIntolerance == null) {
            this.lstIntolerance = new ArrayList<Intolerances>();
        }
        this.lstIntolerance.add(a);
    }

    public void addToLst(Interventions a) {
        if (this.lstIntervention == null) {
            this.lstIntervention = new ArrayList<Interventions>();
        }
        this.lstIntervention.add(a);
    }

    public void addToLst(LifeHabits a) {
        if (this.lstLifeHabit == null) {
            this.lstLifeHabit = new ArrayList<LifeHabits>();
        }
        this.lstLifeHabit.add(a);
    }

    public void addToLst(Prevents a) {
        if (this.lstPrevent == null) {
            this.lstPrevent = new ArrayList<Prevents>();
        }
        this.lstPrevent.add(a);
    }

    public void addToLst(Rappels a) {
        if (this.lstRappel == null) {
            this.lstRappel = new ArrayList<Rappels>();
        }
        this.lstRappel.add(a);
    }

    public void addToLst(Immunizations a) {
        if (this.lstImmunization == null) {
            this.lstImmunization = new ArrayList<Immunizations>();
        }
        this.lstImmunization.add(a);
    }

    public void addToLst(Prescription a) {
        if (this.lstPrescription == null) {
            this.lstPrescription = new ArrayList<Prescription>();
        }
        this.lstPrescription.add(a);
    }

    public void addToLst(DxEnc a) {
        if (this.lstDxEnc == null) {
            this.lstDxEnc = new ArrayList<DxEnc>();
        }
        this.lstDxEnc.add(a);
    }

    public void addToLst(Dx a) {
        if (this.lstDx == null) {
            this.lstDx = new ArrayList<Dx>();
        }
        this.lstDx.add(a);
    }

    public void addToLst(Prob a) {
        if (this.lstProb == null) {
            this.lstProb = new ArrayList<Prob>();
        }
        this.lstProb.add(a);
    }

    public void setEncounterLanguage(Integer integer) {
        this.encounterLanguage = integer;
    }

    public Integer getEncounterLanguage() {
        return this.encounterLanguage;
    }

    public void setIdPatientAnchor(Integer integer) {
        this.idPatientAnchor = integer;
    }

    public Integer getIdPatientAnchor() {
        return this.idPatientAnchor;
    }

    public Integer getIdAnchor() {
        return this.idAnchor;
    }

    public void setIdAnchor(Integer idAnchor) {
        this.idAnchor = idAnchor;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getProfessionnal() {
        return this.idProfAnchor;
    }

    public void setProfessionnal(Integer professionnal) {
        this.idProfAnchor = professionnal;
    }

    public Boolean getIsSigned() {
        return this.isSigned;
    }

    public void setIsSigned(Boolean isSigned) {
        this.isSigned = isSigned;
    }

    public Integer getEncounterType() {
        return this.encounterType;
    }

    public void setEncounterType(Integer encounterType) {
        this.encounterType = encounterType;
        XEncounterType type = XEncounterType.from(encounterType);
        this.encounterTypeS = type == null ? "" : type.toString();
    }

    public String getEncounterTypeS() {
        return this.encounterTypeS;
    }

    public void setEncounterTypeS(String encounterTypeS) {
        this.encounterTypeS = encounterTypeS;
    }

    public Long getDatetime() {
        return this.datetime;
    }

    public void setDatetime(Long datetime) {
        this.datetime = datetime;
    }

    public String getDatetimeS() {
        return this.datetimeS;
    }

    public void setDatetimeS(String datetimeS) {
        this.date = this.datetimeS = datetimeS;
    }

    public String[] getBillings() {
        return this.billings;
    }

    public void setBillings(String[] billings) {
        this.billings = billings;
    }

    public List<EncounterBilling> getLstBilling() {
        return this.lstBilling;
    }

    public void setLstBilling(List<EncounterBilling> lstBilling) {
        this.lstBilling = lstBilling;
    }

    public String[] getNotes() {
        return this.notes;
    }

    public void setNotes(String[] notes) {
        this.notes = notes;
    }

    public List<EncounterNote> getLstNote() {
        return this.lstNote;
    }

    public void setLstNote(List<EncounterNote> lstNote) {
        this.lstNote = lstNote;
    }

    public String[] getNotesDate() {
        return this.notesDate;
    }

    public void setNotesDate(String[] notesDate) {
        this.notesDate = notesDate;
    }

    public String[] getRaisons() {
        return this.raisons;
    }

    public void setRaisons(String[] raisons) {
        this.raisons = raisons;
    }

    public List<EncounterRaison> getLstRaison() {
        return this.lstRaison;
    }

    public void setLstRaison(List<EncounterRaison> lstRaison) {
        this.lstRaison = lstRaison;
    }

    public String getTbc() {
        return this.tbc;
    }

    public void setTbc(String tbs) {
        this.tbc = tbs;
    }

    public EncounterToBeCompleted getTbcObj() {
        return this.tbcObj;
    }

    public void setTbcObj(EncounterToBeCompleted tbcO) {
        this.tbcObj = tbcO;
    }

    public String getTbr() {
        return this.tbr;
    }

    public void setTbr(String tbs) {
        this.tbr = tbs;
    }

    public EncounterToBeRevised getTbrObj() {
        return this.tbrObj;
    }

    public void setTbrObj(EncounterToBeRevised tbrO) {
        this.tbrObj = tbrO;
    }

    public String[] getSocialHistoryObjArr() {
        return this.socialHistoryObjArr;
    }

    public void setSocialHistoryObjArr(String[] socialHistoryObjArr) {
        this.socialHistoryObjArr = socialHistoryObjArr;
    }

    public String[] getFamilyHistoryObjArr() {
        return this.familyHistoryObjArr;
    }

    public void setFamilyHistoryObjArr(String[] familyHistoryObjArr) {
        this.familyHistoryObjArr = familyHistoryObjArr;
    }

    public String[] getMedicalHistoryObjArr() {
        return this.medicalHistoryObjArr;
    }

    public void setMedicalHistoryObjArr(String[] medicalHistoryObjArr) {
        this.medicalHistoryObjArr = medicalHistoryObjArr;
    }

    public String[] getOngoingConcernsObjArr() {
        return this.ongoingConcernsObjArr;
    }

    public void setOngoingConcernsObjArr(String[] ongoingConcernsObjArr) {
        this.ongoingConcernsObjArr = ongoingConcernsObjArr;
    }

    public String[] getOtherMedicationsObjArr() {
        return this.otherMedicationsObjArr;
    }

    public void setOtherMedicationsObjArr(String[] otherMedicationsObjArr) {
        this.otherMedicationsObjArr = otherMedicationsObjArr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.id != null) {
            result = 31 * result + "CEncounter".hashCode();
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.idAnchor == null ? 0 : this.idAnchor.hashCode());
        } else {
            result = System.identityHashCode(this);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CEncounter)) {
            return false;
        }
        CEncounter other = (CEncounter)obj;
        return other.hashCode() == this.hashCode();
    }

    public Integer getSite() {
        return this.idSite;
    }

    public void setSite(Integer site) {
        this.idSite = site;
    }

    public String toString() {
        return super.toString();
    }

    public String[] getProfs() {
        return this.profs;
    }

    public void setProfs(String[] allergies) {
        this.profs = allergies;
    }

    public String[] getAllergies() {
        return this.allergies;
    }

    public void setAllergies(String[] allergies) {
        this.allergies = allergies;
    }

    public String[] getIntolerances() {
        return this.intolerances;
    }

    public void setIntolerances(String[] intolerances) {
        this.intolerances = intolerances;
    }

    public String[] getInterventions() {
        return this.interventions;
    }

    public void setInterventions(String[] interventions) {
        this.interventions = interventions;
    }

    public String[] getLifeHabits() {
        return this.lifeHabits;
    }

    public void setLifeHabits(String[] lifeHabits) {
        this.lifeHabits = lifeHabits;
    }

    public String[] getPrevents() {
        return this.prevents;
    }

    public void setPrevents(String[] prevents) {
        this.prevents = prevents;
    }

    public String[] getRappels() {
        return this.rappels;
    }

    public void setRappels(String[] rappels) {
        this.rappels = rappels;
    }

    public String[] getDocs() {
        return this.docs;
    }

    public void setDocs(String[] docs) {
        this.docs = docs;
    }

    public String[] getImmunizations() {
        return this.immunizations;
    }

    public void setImmunizations(String[] immunizations) {
        this.immunizations = immunizations;
    }

    public String[] getBps() {
        return this.bps;
    }

    public void setBps(String[] bps) {
        this.bps = bps;
    }

    public String[] getBts() {
        return this.bts;
    }

    public void setBts(String[] bts) {
        this.bts = bts;
    }

    public String[] getFqs() {
        return this.fqs;
    }

    public void setFqs(String[] fqs) {
        this.fqs = fqs;
    }

    public String[] getMss() {
        return this.mss;
    }

    public void setMss(String[] mss) {
        this.mss = mss;
    }

    public String[] getPes() {
        return this.pes;
    }

    public void setPes(String[] pes) {
        this.pes = pes;
    }

    public String[] getPrescriptions() {
        return this.prescriptions;
    }

    public String[] getDevices() {
        return this.devices;
    }

    public void setDevices(String[] array) {
        this.devices = array;
    }

    public void setPrescriptions(String[] prescriptions) {
        this.prescriptions = prescriptions;
    }

    public String[] getConsults() {
        return this.consults;
    }

    public void setConsults(String[] consults) {
        this.consults = consults;
    }

    public String[] getCustMeasures() {
        return this.custMeasures;
    }

    public void setCustMeasures(String[] custMeasures) {
        this.custMeasures = custMeasures;
    }

    public String[] getDxsEnc() {
        return this.dxsEnc;
    }

    public void setDxsEnc(String[] dxs) {
        this.dxsEnc = dxs;
    }

    public String[] getDxs() {
        return this.dxs;
    }

    public void setDxs(String[] dxs) {
        this.dxs = dxs;
    }

    public String[] getProbs() {
        return this.probs;
    }

    public void setProbs(String[] probs) {
        this.probs = probs;
    }

    public List<Profs> getLstProf() {
        return this.lstProf;
    }

    public void setLstProf(List<Profs> lstProf) {
        this.lstProf = lstProf;
    }

    public List<Allergies> getLstAllergy() {
        return this.lstAllergy;
    }

    public void setLstAllergy(List<Allergies> lstAllergy) {
        this.lstAllergy = lstAllergy;
    }

    public List<Intolerances> getLstIntolerance() {
        return this.lstIntolerance;
    }

    public void setLstIntolerance(List<Intolerances> lstIntolerance) {
        this.lstIntolerance = lstIntolerance;
    }

    public List<Interventions> getLstIntervention() {
        return this.lstIntervention;
    }

    public void setLstIntervention(List<Interventions> lstIntervention) {
        this.lstIntervention = lstIntervention;
    }

    public List<LifeHabits> getLstLifeHabit() {
        return this.lstLifeHabit;
    }

    public void setLstLifeHabit(List<LifeHabits> lstLifeHabit) {
        this.lstLifeHabit = lstLifeHabit;
    }

    public List<Prevents> getLstPrevent() {
        return this.lstPrevent;
    }

    public void setLstPrevent(List<Prevents> lstPrevent) {
        this.lstPrevent = lstPrevent;
    }

    public List<Rappels> getLstRappel() {
        return this.lstRappel;
    }

    public void setLstRappel(List<Rappels> lstRappel) {
        this.lstRappel = lstRappel;
    }

    public List<Docs> getLstDoc() {
        return this.lstDoc;
    }

    public void setLstDoc(List<Docs> lstDoc) {
        this.lstDoc = lstDoc;
    }

    public List<Immunizations> getLstImmunization() {
        return this.lstImmunization;
    }

    public void setLstImmunization(List<Immunizations> lstImmunization) {
        this.lstImmunization = lstImmunization;
    }

    public List<BloodPres> getLstBloodPres() {
        return this.lstBloodPres;
    }

    public void setLstBloodPres(List<BloodPres> lstBloodPres) {
        this.lstBloodPres = lstBloodPres;
    }

    public List<BodyTemp> getLstBodyTemp() {
        return this.lstBodyTemp;
    }

    public void setLstBodyTemp(List<BodyTemp> lstBodyTemp) {
        this.lstBodyTemp = lstBodyTemp;
    }

    public List<Freq> getLstFreq() {
        return this.lstFreq;
    }

    public void setLstFreq(List<Freq> lstFreq) {
        this.lstFreq = lstFreq;
    }

    public List<Measurement> getLstMeasurement() {
        return this.lstMeasurement;
    }

    public void setLstMeasurement(List<Measurement> lstMeasurement) {
        this.lstMeasurement = lstMeasurement;
    }

    public List<PhysicalExam> getLstPhysicalExam() {
        return this.lstPhysicalExam;
    }

    public void setLstPhysicalExam(List<PhysicalExam> lstPhysicalExam) {
        this.lstPhysicalExam = lstPhysicalExam;
    }

    public List<Prescription> getLstPrescription() {
        return this.lstPrescription;
    }

    public void setLstPrescription(List<Prescription> lstPrescription) {
        this.lstPrescription = lstPrescription;
    }

    public List<Device> getLstDevice() {
        return this.lstDevice;
    }

    public void setLstDevice(List<Device> lstDevice) {
        this.lstDevice = lstDevice;
    }

    public void addToLst(Device a) {
        if (this.lstDevice == null) {
            this.lstDevice = new ArrayList<Device>();
        }
        this.lstDevice.add(a);
    }

    public List<Consult> getLstConsult() {
        return this.lstConsult;
    }

    public void setLstConsult(List<Consult> lstConsult) {
        this.lstConsult = lstConsult;
    }

    public List<CustMeasure> getLstCustMeasure() {
        return this.lstCustMeasure;
    }

    public void setLstCustMeasure(List<CustMeasure> lstCustMeasure) {
        this.lstCustMeasure = lstCustMeasure;
    }

    public List<DxEnc> getLstDxEnc() {
        return this.lstDxEnc;
    }

    public void setLstDxEnc(List<DxEnc> lstDx) {
        this.lstDxEnc = lstDx;
    }

    public List<Dx> getLstDx() {
        return this.lstDx;
    }

    public void setLstDx(List<Dx> lstDx) {
        this.lstDx = lstDx;
    }

    public List<Prob> getLstProb() {
        return this.lstProb;
    }

    public void setLstProb(List<Prob> lstProb) {
        this.lstProb = lstProb;
    }

    public XPatient getXPatient() {
        return this.xpatient;
    }

    public void setXPatient(XPatient patient) {
        this.xpatient = patient;
    }

    public Object getPatient() {
        return this.patient;
    }

    public void setPatient(Object patient) {
        this.patient = patient;
    }

    public List<Profs> addToLst(Profs c) {
        if (this.lstProf == null) {
            this.lstProf = new ArrayList<Profs>();
        }
        this.lstProf.add(c);
        return this.lstProf;
    }

    public List<Docs> addToLst(Docs c) {
        if (this.lstDoc == null) {
            this.lstDoc = new ArrayList<Docs>();
        }
        this.lstDoc.add(c);
        return this.lstDoc;
    }

    public List<BloodPres> addToLst(BloodPres c) {
        if (this.lstBloodPres == null) {
            this.lstBloodPres = new ArrayList<BloodPres>();
        }
        this.lstBloodPres.add(c);
        return this.lstBloodPres;
    }

    public List<BodyTemp> addToLst(BodyTemp c) {
        if (this.lstBodyTemp == null) {
            this.lstBodyTemp = new ArrayList<BodyTemp>();
        }
        this.lstBodyTemp.add(c);
        return this.lstBodyTemp;
    }

    public List<Freq> addToLst(Freq c) {
        if (this.lstFreq == null) {
            this.lstFreq = new ArrayList<Freq>();
        }
        this.lstFreq.add(c);
        return this.lstFreq;
    }

    public List<Measurement> addToLst(Measurement c) {
        if (this.lstMeasurement == null) {
            this.lstMeasurement = new ArrayList<Measurement>();
        }
        this.lstMeasurement.add(c);
        return this.lstMeasurement;
    }

    public List<PhysicalExam> addToLst(PhysicalExam c) {
        if (this.lstPhysicalExam == null) {
            this.lstPhysicalExam = new ArrayList<PhysicalExam>();
        }
        this.lstPhysicalExam.add(c);
        return this.lstPhysicalExam;
    }

    public List<EncounterBilling> addToLst(EncounterBilling c) {
        if (this.lstBilling == null) {
            this.lstBilling = new ArrayList<EncounterBilling>();
        }
        this.lstBilling.add(c);
        return this.lstBilling;
    }

    public List<EncounterNote> addToLst(EncounterNote c) {
        if (this.lstNote == null) {
            this.lstNote = new ArrayList<EncounterNote>();
        }
        this.lstNote.add(c);
        return this.lstNote;
    }

    public List<Consult> addToLst(Consult c) {
        if (this.lstConsult == null) {
            this.lstConsult = new ArrayList<Consult>();
        }
        this.lstConsult.add(c);
        return this.lstConsult;
    }

    public List<CustMeasure> addToLst(CustMeasure c) {
        if (this.lstCustMeasure == null) {
            this.lstCustMeasure = new ArrayList<CustMeasure>();
        }
        this.lstCustMeasure.add(c);
        return this.lstCustMeasure;
    }

    public void map(CEncounterMapArg arg) {
        ArrayList lst;
        GenericDataMapping gdm = new GenericDataMapping();
        this.setDatetimeS(CEncounter.getStringDateTimeFromLong(this.getDatetime()));
        if (this.getProfs() != null && this.getProfs().length > 0) {
            this.setLstProf(new ArrayList<Profs>(this.getProfs().length));
            gdm.setList(this.getLstProf(), Profs.class, null, this.getProfs());
            for (Profs profs : this.getLstProf()) {
                if (profs.idProfessionnalAnchor == null) continue;
                profs.setProfNom((String)arg.profNameResolver.get((Object)profs.idProfessionnalAnchor));
            }
            Collections.sort(this.getLstProf(), new Comparator<Profs>(){

                @Override
                public int compare(Profs o1, Profs o2) {
                    return o1.entryDateS.compareTo(o2.entryDateS);
                }
            });
            this.setProfs(null);
        }
        if (this.getRaisons() != null && this.getRaisons().length > 0) {
            this.setLstRaison(new ArrayList<EncounterRaison>(this.getRaisons().length));
            gdm.setList(this.getLstRaison(), EncounterRaison.class, null, this.getRaisons());
            if (this.getLstRaison().size() == 0) {
                this.setLstRaison(null);
            }
            this.setRaisons(null);
        }
        if (StringUtils.isNotBlank((String)this.getTbc())) {
            lst = new ArrayList(1);
            gdm.setList(lst, EncounterToBeCompleted.class, null, new String[]{this.getTbc()});
            if (lst.size() == 1) {
                this.setTbcObj((EncounterToBeCompleted)lst.get(0));
            }
            this.setTbc(null);
        }
        if (StringUtils.isNotBlank((String)this.getTbr())) {
            lst = new ArrayList(1);
            gdm.setList(lst, EncounterToBeRevised.class, null, new String[]{this.getTbr()});
            for (EncounterToBeRevised en : lst) {
                if (en.getSupervisor() == null) continue;
                en.setSupervisorName((String)arg.profNameResolver.get((Object)en.getSupervisor()));
            }
            if (lst.size() == 1) {
                this.setTbrObj((EncounterToBeRevised)lst.get(0));
            }
            this.setTbr(null);
        }
        if (this.getBillings() != null && this.getBillings().length > 0) {
            this.setLstBilling(new ArrayList<EncounterBilling>(this.getBillings().length));
            gdm.setList(this.getLstBilling(), EncounterBilling.class, null, this.getBillings());
            if (this.getLstBilling().size() == 0) {
                this.setLstBilling(null);
            }
            this.setBillings(null);
        }
        if (this.getNotes() != null && this.getNotes().length > 0) {
            this.setLstNote(new ArrayList<EncounterNote>(this.getNotes().length));
            gdm.setList(this.getLstNote(), EncounterNote.class, null, this.getNotes());
            for (EncounterNote encounterNote : this.getLstNote()) {
                if (encounterNote.idProfessionnalAnchor == null) continue;
                encounterNote.setProfNom((String)arg.profNameResolver.get((Object)encounterNote.idProfessionnalAnchor));
            }
            if (this.getLstNote().size() == 0) {
                this.setLstNote(null);
            }
            this.setNotes(null);
        }
        if (this.getAllergies() != null && this.getAllergies().length > 0) {
            this.setLstAllergy(new ArrayList<Allergies>(this.getAllergies().length));
            gdm.setList(this.getLstAllergy(), Allergies.class, null, this.getAllergies());
            if (this.getLstAllergy().size() == 0) {
                this.setLstAllergy(null);
            }
            this.setAllergies(null);
        }
        if (this.getIntolerances() != null && this.getIntolerances().length > 0) {
            this.setLstIntolerance(new ArrayList<Intolerances>(this.getIntolerances().length));
            gdm.setList(this.getLstIntolerance(), Intolerances.class, null, this.getIntolerances());
            if (this.getLstIntolerance().size() == 0) {
                this.setLstIntolerance(null);
            }
            this.setIntolerances(null);
        }
        if (this.getInterventions() != null && this.getInterventions().length > 0) {
            this.setLstIntervention(new ArrayList<Interventions>(this.getInterventions().length));
            gdm.setList(this.getLstIntervention(), Interventions.class, null, this.getInterventions());
            if (this.getLstIntervention().size() == 0) {
                this.setLstIntervention(null);
            }
            this.setInterventions(null);
        }
        if (this.getLifeHabits() != null && this.getLifeHabits().length > 0) {
            this.setLstLifeHabit(new ArrayList<LifeHabits>(this.getLifeHabits().length));
            gdm.setList(this.getLstLifeHabit(), LifeHabits.class, null, this.getLifeHabits());
            if (this.getLstLifeHabit().size() == 0) {
                this.setLstLifeHabit(null);
            }
            this.setLifeHabits(null);
        }
        if (this.getPrevents() != null && this.getPrevents().length > 0) {
            this.setLstPrevent(new ArrayList<Prevents>(this.getPrevents().length));
            gdm.setList(this.getLstPrevent(), Prevents.class, null, this.getPrevents());
            if (this.getLstPrevent().size() == 0) {
                this.setLstPrevent(null);
            }
            this.setPrevents(null);
        }
        if (this.getRappels() != null && this.getRappels().length > 0) {
            this.setLstRappel(new ArrayList<Rappels>(this.getRappels().length));
            gdm.setList(this.getLstRappel(), Rappels.class, null, this.getRappels());
            if (this.getLstRappel().size() == 0) {
                this.setLstRappel(null);
            }
            this.setRappels(null);
        }
        if (this.getDocs() != null && this.getDocs().length > 0) {
            this.setLstDoc(new ArrayList<Docs>(this.getDocs().length));
            gdm.setList(this.getLstDoc(), Docs.class, null, this.getDocs());
            if (this.getLstDoc().size() == 0) {
                this.setLstDoc(null);
            }
            this.setDocs(null);
        }
        if (this.getImmunizations() != null && this.getImmunizations().length > 0) {
            this.setLstImmunization(new ArrayList<Immunizations>(this.getImmunizations().length));
            gdm.setList(this.getLstImmunization(), Immunizations.class, null, this.getImmunizations());
            if (this.getLstImmunization().size() == 0) {
                this.setLstImmunization(null);
            }
            this.setImmunizations(null);
        }
        if (this.getBps() != null && this.getBps().length > 0) {
            this.setLstBloodPres(new ArrayList<BloodPres>(this.getBps().length));
            gdm.setList(this.getLstBloodPres(), BloodPres.class, null, this.getBps());
            if (this.getLstBloodPres().size() == 0) {
                this.setLstBloodPres(null);
            }
            this.setBps(null);
        }
        if (this.getBts() != null && this.getBts().length > 0) {
            this.setLstBodyTemp(new ArrayList<BodyTemp>(this.getBts().length));
            gdm.setList(this.getLstBodyTemp(), BodyTemp.class, null, this.getBts());
            if (this.getLstBodyTemp().size() == 0) {
                this.setLstBodyTemp(null);
            }
            this.setBts(null);
        }
        if (this.getFqs() != null && this.getFqs().length > 0) {
            this.setLstFreq(new ArrayList<Freq>(this.getFqs().length));
            gdm.setList(this.getLstFreq(), Freq.class, null, this.getFqs());
            if (this.getLstFreq().size() == 0) {
                this.setLstFreq(null);
            }
            this.setFqs(null);
        }
        if (this.getMss() != null && this.getMss().length > 0) {
            this.setLstMeasurement(new ArrayList<Measurement>(this.getMss().length));
            gdm.setList(this.getLstMeasurement(), Measurement.class, null, this.getMss());
            if (this.getLstMeasurement().size() == 0) {
                this.setLstMeasurement(null);
            }
            this.setMss(null);
        }
        if (this.getPes() != null && this.getPes().length > 0) {
            this.setLstPhysicalExam(new ArrayList<PhysicalExam>(this.getPes().length));
            gdm.setList(this.getLstPhysicalExam(), PhysicalExam.class, null, this.getPes());
            if (this.getLstPhysicalExam().size() == 0) {
                this.setLstPhysicalExam(null);
            }
            this.setPes(null);
        }
        if (this.getNotes() != null && this.getNotes().length > 0) {
            this.setLstNote(new ArrayList<EncounterNote>(this.getNotes().length));
            gdm.setList(this.getLstNote(), EncounterNote.class, null, this.getNotes());
            if (this.getLstNote().size() == 0) {
                this.setLstNote(null);
            }
            this.setNotes(null);
        }
        if (this.getPrescriptions() != null && this.getPrescriptions().length > 0) {
            this.setLstPrescription(new ArrayList<Prescription>(this.getPrescriptions().length));
            gdm.setList(this.getLstPrescription(), Prescription.class, null, this.getPrescriptions());
            for (Prescription prescription : this.getLstPrescription()) {
                if (prescription.idProfessionnalAnchor == null) continue;
                prescription.setProfNom((String)arg.profNameResolver.get((Object)prescription.idProfessionnalAnchor));
            }
            if (this.getLstPrescription().size() == 0) {
                this.setLstPrescription(null);
            }
            this.setPrescriptions(null);
        }
        if (this.getDevices() != null && this.getDevices().length > 0) {
            this.setLstDevice(new ArrayList<Device>(this.getDevices().length));
            gdm.setList(this.getLstDevice(), Device.class, null, this.getDevices());
            for (Device device : this.getLstDevice()) {
                if (device.idProfessionnalAnchor == null) continue;
                device.setProfNom((String)arg.profNameResolver.get((Object)device.idProfessionnalAnchor));
            }
            if (this.getLstDevice().size() == 0) {
                this.setLstDevice(null);
            }
            this.setDevices(null);
        }
        if (this.getConsults() != null && this.getConsults().length > 0) {
            this.setLstConsult(new ArrayList<Consult>(this.getConsults().length));
            gdm.setList(this.getLstConsult(), Consult.class, null, this.getConsults());
            if (this.getLstConsult().size() == 0) {
                this.setLstConsult(null);
            }
            this.setConsults(null);
        }
        if (this.getCustMeasures() != null && this.getCustMeasures().length > 0) {
            this.setLstCustMeasure(new ArrayList<CustMeasure>(this.getCustMeasures().length));
            gdm.setList(this.getLstCustMeasure(), CustMeasure.class, null, this.getCustMeasures());
            if (this.getLstCustMeasure().size() == 0) {
                this.setLstCustMeasure(null);
            }
            this.setCustMeasures(null);
        }
        if (this.getDxsEnc() != null && this.getDxsEnc().length > 0) {
            this.setLstDxEnc(new ArrayList<DxEnc>(this.getDxsEnc().length));
            gdm.setList(this.getLstDxEnc(), DxEnc.class, null, this.getDxsEnc());
            if (this.getLstDxEnc().size() == 0) {
                this.setLstDxEnc(null);
            }
            this.setDxsEnc(null);
        }
        if (this.getDxs() != null && this.getDxs().length > 0) {
            this.setLstDx(new ArrayList<Dx>(this.getDxs().length));
            gdm.setList(this.getLstDx(), Dx.class, null, this.getDxs());
            if (this.getLstDx().size() == 0) {
                this.setLstDx(null);
            }
            this.setDxs(null);
        }
        if (this.getProbs() != null && this.getProbs().length > 0) {
            this.setLstProb(new ArrayList<Prob>(this.getProbs().length));
            gdm.setList(this.getLstProb(), Prob.class, null, this.getProbs());
            if (this.getLstProb().size() == 0) {
                this.setLstProb(null);
            }
            this.setProbs(null);
        }
        if (this.getMedicalHistoryObjArr() != null && this.getMedicalHistoryObjArr().length > 0) {
            lst = new ArrayList();
            gdm.setList(lst, EncounterNote.class, null, this.getMedicalHistoryObjArr());
            if (lst.size() == 1) {
                this.medicalHistoryObj = (EncounterNote)lst.get(0);
                if (this.medicalHistoryObj.idProfessionnalAnchor != null) {
                    this.medicalHistoryObj.setProfNom((String)arg.profNameResolver.get((Object)this.medicalHistoryObj.idProfessionnalAnchor));
                }
            }
            this.setMedicalHistoryObjArr(null);
        }
        if (this.getSocialHistoryObjArr() != null && this.getSocialHistoryObjArr().length > 0) {
            lst = new ArrayList();
            gdm.setList(lst, EncounterNote.class, null, this.getSocialHistoryObjArr());
            if (lst.size() == 1) {
                this.socialHistoryObj = (EncounterNote)lst.get(0);
                if (this.socialHistoryObj.idProfessionnalAnchor != null) {
                    this.socialHistoryObj.setProfNom((String)arg.profNameResolver.get((Object)this.socialHistoryObj.idProfessionnalAnchor));
                }
            }
            this.setSocialHistoryObjArr(null);
        }
        if (this.getFamilyHistoryObjArr() != null && this.getFamilyHistoryObjArr().length > 0) {
            lst = new ArrayList();
            gdm.setList(lst, EncounterNote.class, null, this.getFamilyHistoryObjArr());
            if (lst.size() == 1) {
                this.familyHistoryObj = (EncounterNote)lst.get(0);
                if (this.familyHistoryObj.idProfessionnalAnchor != null) {
                    this.familyHistoryObj.setProfNom((String)arg.profNameResolver.get((Object)this.familyHistoryObj.idProfessionnalAnchor));
                }
            }
            this.setFamilyHistoryObjArr(null);
        }
        if (this.getOtherMedicationsObjArr() != null && this.getOtherMedicationsObjArr().length > 0) {
            lst = new ArrayList();
            gdm.setList(lst, EncounterNote.class, null, this.getOtherMedicationsObjArr());
            if (lst.size() == 1) {
                this.otherMedicationsObj = (EncounterNote)lst.get(0);
                if (this.otherMedicationsObj.idProfessionnalAnchor != null) {
                    this.otherMedicationsObj.setProfNom((String)arg.profNameResolver.get((Object)this.otherMedicationsObj.idProfessionnalAnchor));
                }
            }
            this.setOtherMedicationsObjArr(null);
        }
        if (this.getOngoingConcernsObjArr() != null && this.getOngoingConcernsObjArr().length > 0) {
            lst = new ArrayList();
            gdm.setList(lst, EncounterNote.class, null, this.getOngoingConcernsObjArr());
            if (lst.size() == 1) {
                this.ongoingConcernsObj = (EncounterNote)lst.get(0);
                if (this.ongoingConcernsObj.idProfessionnalAnchor != null) {
                    this.ongoingConcernsObj.setProfNom((String)arg.profNameResolver.get((Object)this.ongoingConcernsObj.idProfessionnalAnchor));
                }
            }
            this.setOngoingConcernsObjArr(null);
        }
    }

    public void init(XEncounter enc) {
        super.init(enc);
        this.className = CEncounter.class.getSimpleName();
        this.setId(enc.getId());
        this.setIdAnchor(enc.getIdAnchor());
        this.setSite(enc.getSite());
        this.setProfessionnal(enc.getProfessionnal());
        this.setIdPatientAnchor(enc.idPatient);
        this.setEncounterType(enc.getEncounterType() == null ? XEncounterType.NO_RAISON.getValue() : enc.getEncounterType().getValue());
        this.setDatetime(enc.getDatetime());
        this.setEncLabelInt(EnumWithValues.toSet(enc.getEncLabel()));
        this.setEncLabel((EnumSet<XEncounterLabel>)enc.getEncLabel().clone());
    }

    public static CEncounter c(XEncounter x) {
        return x == null ? null : new CEncounter(x);
    }

    @Override
    public <T> CEditableDataObject convertc(T type) {
        XEncounter x = (XEncounter)XEncounter.class.cast(type);
        this.init(x);
        return this;
    }

    public XEncounter x() {
        XEncounter res = new XEncounter();
        super.x(res);
        res.setId(this.id);
        res.setIdAnchor(this.idAnchor);
        res.setSite(this.idSite);
        res.setEncounterType(this.encounterType == null ? XEncounterType.NO_RAISON : XEncounterType.from(this.encounterType));
        res.setProfessionnal(this.idProfAnchor);
        res.idPatient = this.idPatientAnchor;
        res.setDatetime(this.datetime);
        res.setEncLabel(EnumWithValues.fromSet(XEncounterLabel.class, this.encLabelInt));
        res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.from(this.modificationStatus));
        return res;
    }

    public XEncounter convertx() {
        return this.x();
    }

    public void replaceSavedObjectsInSource(CEncounter saved) {
        int i;
        CEditableDataObject c;
        ArrayList<Integer> itemsToRemove;
        HashMap<Integer, CEditableDataObject> mapItemsToReplace;
        if (this.lstDevice != null) {
            mapItemsToReplace = new HashMap<Integer, CEditableDataObject>(0);
            itemsToRemove = new ArrayList<Integer>(0);
            for (int i2 = 0; i2 < this.getLstDevice().size(); ++i2) {
                c = this.getLstDevice().get(i2);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstDevice() == null) {
                    itemsToRemove.add(i2);
                    continue;
                }
                for (Device device : saved.getLstDevice()) {
                    if (!((Device)c).tag.equals(device.tag)) continue;
                    if (c.isStatusDeleted()) {
                        itemsToRemove.add(i2);
                        continue;
                    }
                    mapItemsToReplace.put(i2, device);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstDevice().set((Integer)mi.getKey(), (Device)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstDevice().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstPrescription != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstPrescription().size(); ++i) {
                c = this.getLstPrescription().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstPrescription() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (Prescription prescription : saved.getLstPrescription()) {
                    if (!((Prescription)c).tag.equals(prescription.tag)) continue;
                    if (c.isStatusDeleted()) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, prescription);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstPrescription().set((Integer)mi.getKey(), (Prescription)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstPrescription().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.getLstImmunization() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstImmunization().size(); ++i) {
                c = this.getLstImmunization().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstImmunization() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (Immunizations immunizations : saved.getLstImmunization()) {
                    if (!((Immunizations)c).tag.equals(immunizations.tag)) continue;
                    if (c.isStatusDeleted()) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, immunizations);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstImmunization().set((Integer)mi.getKey(), (Immunizations)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstImmunization().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstBilling != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstBilling().size(); ++i) {
                c = this.getLstBilling().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstBilling() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (EncounterBilling encounterBilling : saved.getLstBilling()) {
                    if (!((EncounterBilling)c).tag.equals(encounterBilling.tag)) continue;
                    if (Boolean.TRUE.equals(encounterBilling.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, encounterBilling);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstBilling().set((Integer)mi.getKey(), (EncounterBilling)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstBilling().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstNote != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstNote().size(); ++i) {
                c = this.getLstNote().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstNote() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (EncounterNote encounterNote : saved.getLstNote()) {
                    if (!((EncounterNote)c).tag.equals(encounterNote.tag)) continue;
                    if (Boolean.TRUE.equals(encounterNote.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, encounterNote);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstNote().set((Integer)mi.getKey(), (EncounterNote)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstNote().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstRaison != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstRaison().size(); ++i) {
                c = this.getLstRaison().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstRaison() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (EncounterRaison encounterRaison : saved.getLstRaison()) {
                    if (!((EncounterRaison)c).tag.equals(encounterRaison.tag)) continue;
                    if (Boolean.TRUE.equals(encounterRaison.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, encounterRaison);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstRaison().set((Integer)mi.getKey(), (EncounterRaison)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstRaison().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.getTbcObj() != null && this.getTbcObj().isDirty()) {
            this.tbcObj = saved.getTbcObj();
        }
        if (this.getTbrObj() != null && this.getTbrObj().isDirty()) {
            this.tbrObj = saved.getTbrObj();
        }
        if (this.lstDoc != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstDoc().size(); ++i) {
                c = this.getLstDoc().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstDoc() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (Docs docs : saved.getLstDoc()) {
                    if (!((Docs)c).tag.equals(docs.tag)) continue;
                    if (Boolean.TRUE.equals(docs.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, docs);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstDoc().set((Integer)mi.getKey(), (Docs)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstDoc().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstPhysicalExam != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstPhysicalExam().size(); ++i) {
                c = this.getLstPhysicalExam().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstPhysicalExam() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (PhysicalExam physicalExam : saved.getLstPhysicalExam()) {
                    if (!((PhysicalExam)c).tag.equals(physicalExam.tag)) continue;
                    if (Boolean.TRUE.equals(physicalExam.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, physicalExam);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstPhysicalExam().set((Integer)mi.getKey(), (PhysicalExam)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstPhysicalExam().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstMeasurement != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstMeasurement().size(); ++i) {
                c = this.getLstMeasurement().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstMeasurement() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (Measurement measurement : saved.getLstMeasurement()) {
                    if (!((Measurement)c).tag.equals(measurement.tag)) continue;
                    if (Boolean.TRUE.equals(measurement.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, measurement);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstMeasurement().set((Integer)mi.getKey(), (Measurement)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstMeasurement().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstFreq != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstFreq().size(); ++i) {
                c = this.getLstFreq().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstFreq() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (Freq freq : saved.getLstFreq()) {
                    if (!((Freq)c).tag.equals(freq.tag)) continue;
                    if (Boolean.TRUE.equals(freq.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, freq);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstFreq().set((Integer)mi.getKey(), (Freq)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstFreq().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstBodyTemp != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstBodyTemp().size(); ++i) {
                c = this.getLstBodyTemp().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstBodyTemp() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (BodyTemp bodyTemp : saved.getLstBodyTemp()) {
                    if (!((BodyTemp)c).tag.equals(bodyTemp.tag)) continue;
                    if (Boolean.TRUE.equals(bodyTemp.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, bodyTemp);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstBodyTemp().set((Integer)mi.getKey(), (BodyTemp)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstBodyTemp().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstBloodPres != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstBloodPres().size(); ++i) {
                c = this.getLstBloodPres().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstBloodPres() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (BloodPres bloodPres : saved.getLstBloodPres()) {
                    if (!((BloodPres)c).tag.equals(bloodPres.tag)) continue;
                    if (Boolean.TRUE.equals(bloodPres.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, bloodPres);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstBloodPres().set((Integer)mi.getKey(), (BloodPres)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstBloodPres().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstCustMeasure != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstCustMeasure().size(); ++i) {
                c = this.getLstCustMeasure().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstCustMeasure() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (CustMeasure custMeasure : saved.getLstCustMeasure()) {
                    if (!((CustMeasure)c).tag.equals(custMeasure.tag)) continue;
                    if (Boolean.TRUE.equals(custMeasure.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, custMeasure);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstCustMeasure().set((Integer)mi.getKey(), (CustMeasure)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstCustMeasure().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstDxEnc != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstDxEnc().size(); ++i) {
                c = this.getLstDxEnc().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstDxEnc() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (DxEnc dxEnc : saved.getLstDxEnc()) {
                    if (!((DxEnc)c).tag.equals(dxEnc.tag)) continue;
                    if (Boolean.TRUE.equals(dxEnc.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, dxEnc);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstDxEnc().set((Integer)mi.getKey(), (DxEnc)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstDxEnc().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstDx != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstDx().size(); ++i) {
                c = this.getLstDx().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstDx() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (Dx dx : saved.getLstDx()) {
                    if (!((Dx)c).tag.equals(dx.tag)) continue;
                    if (Boolean.TRUE.equals(dx.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, dx);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstDx().set((Integer)mi.getKey(), (Dx)mi.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstDx().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.lstProb != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstProb().size(); ++i) {
                c = this.getLstProb().get(i);
                if (!c.isDirty()) continue;
                if (saved == null || saved.getLstProb() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (Prob prob : saved.getLstProb()) {
                    if (!((Prob)c).tag.equals(prob.tag)) continue;
                    if (Boolean.TRUE.equals(prob.deleted)) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, prob);
                }
            }
            for (Map.Entry mi : mapItemsToReplace.entrySet()) {
                this.getLstProb().set((Integer)mi.getKey(), (Prob)mi.getValue());
            }
            for (int i3 = itemsToRemove.size() - 1; i3 >= 0; --i3) {
                this.getLstProb().remove((Integer)itemsToRemove.get(i3));
            }
        }
        this.guid = null;
        this.editMode = null;
    }

    public static final class Consult
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "note", "idReferralProfessionnalAnchor", "destination", "severity", "speciality"};
        public Integer id;
        public String note;
        public Integer idReferralProfessionnalAnchor;
        public String destination;
        public Integer severity;
        public Integer speciality;
        public String title = "Demande(s) de consultation";
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", DETAILS, "Urgence", "Note"};

        public Consult() {
        }

        public Consult(XConsultationRequest c) {
            this.convertc(c);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[4];
            this.descr[0] = "";
            this.descr[1] = (StringUtils.isBlank((CharSequence)this.destination) ? "" : this.destination + " - ") + (this.speciality == null ? "" : XProfessionnalSpeciality.valueOf(this.speciality));
            this.descr[2] = XConsultationSeverity.from(this.severity).toString();
            this.descr[3] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Integer getIdReferralProfessionnalAnchor() {
            return this.idReferralProfessionnalAnchor;
        }

        public final void setIdReferralProfessionnalAnchor(Integer idReferralProfessionnalAnchor) {
            this.idReferralProfessionnalAnchor = idReferralProfessionnalAnchor;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final Integer getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        public final Integer getSpeciality() {
            return this.speciality;
        }

        public final void setSpeciality(Integer speciality) {
            this.speciality = speciality;
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            return this;
        }

        @Override
        public <T> T convertx() {
            return null;
        }
    }

    public static final class Prescription
    extends DevicePrescription {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idStrength", "version", "idNextModificationEntry", "idProfessionnalAnchor", "entryDate", "note", "name", "baseDrugName", "baseDrugType", "quantity", "strength", "route", "format", "site", "frequency", "posology", "rx", "startDate", "stopDate", "endDate", "stopReason", "dsqIt1", "dsqIt2", "dsqIt3", "dsqIt4", "dsqIt5", "fromProfExterne", "treatmentDuration", "toReprescribe", "idPrevPrescription", "din", "dosageChange", "idEncounter", "idStopEncounter", "severity", "allergy", "deleted", "dsqStatus", "encLabelInt"};
        public Integer idStrength;
        public Integer idDevice;
        public String baseDrugName;
        public String strength;
        public Integer din;
        public Integer route;
        public String routeString;
        public Integer format;
        public String formatString;
        public Integer site;
        public String siteString;
        public Integer dosageChange;
        public String dosageChangeString;
        public Integer severity;
        public String severityString;
        public Integer allergy;
        public String allergyString;
        public List<Prescription> lstInactiveRx;
        public String title = "Prescriptions";

        public Prescription() {
        }

        public Prescription(XPrescription c) {
            this.convertc(c);
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof Prescription) {
                equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
            }
            return equals;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = this.getId() == null ? super.hashCode() : ("Prescr" + this.getId().hashCode()).hashCode();
            return hashCode;
        }

        @Override
        public void setDescriptionOfObject() {
            String poso = StringUtils.isNotBlank((String)this.posology) ? this.posology + " " : "";
            String format = StringUtils.isNotBlank((String)this.formatString) ? this.formatString + " " : "";
            String freq = StringUtils.isNotBlank((String)this.frequency) ? this.frequency + " " : "";
            String sig = "sig : " + poso + format + freq;
            String ren = this.getRx() == null || this.getRx() == 0 ? "NR" : "Ren x " + this.getRx();
            this.descr = new String[5];
            String stop = StringUtils.isNotEmpty((String)this.getStopDateSD()) ? "[STOP] " : "";
            String drugName = CPrescriptionFormatter.formatDrugNameWithBrackets(this);
            String drugFormat = CPrescriptionFormatter.format(this, CPrescriptionFormatter.ShowMedFileDetail.SUPERIEUR);
            this.descr[0] = this.entryDateSD;
            this.descr[1] = stop + drugName + " " + drugFormat;
            this.descr[2] = sig;
            this.descr[3] = ren;
            String string = this.descr[4] = this.note == null ? "" : this.note;
            if (this.getAllergy() != null && this.getAllergy() > 0) {
                this.descr[2] = this.descr[2] + "<br>" + this.getAllergyS();
            }
            if (StringUtils.isNotEmpty((String)this.getStopReason())) {
                this.descr[2] = this.descr[2] + "<br>" + Messages.getString("RAISON_DARRET", new String[0]) + ": " + this.getStopReason();
            }
            Prescription.setExpiredDateAndStatus(this);
            this.hash = this.getHashForFav();
        }

        @Override
        public int getHashForFav() {
            String h = String.format("FavRx [din=%s, n=%s, qty=%s, dur=%s, rte=%s, frm=%s, st=%s, rx=%s, pos=%s, str=%s, frq=%s, tor=%s]", this.din == null ? "d0" : Integer.valueOf(this.din), this.name, this.quantity == null ? 0 : this.quantity, this.treatmentDuration == null ? 0 : this.treatmentDuration, this.route == null ? 0 : this.route, this.format == null ? 0 : this.format, this.site == null ? 0 : this.site, this.rx == null ? 0 : this.rx, this.posology, this.strength, this.frequency == null ? "" : this.frequency, Boolean.TRUE.equals(this.toReprescribeB) ? 1 : 0);
            return h.hashCode();
        }

        public Integer getIdStrength() {
            return this.idStrength;
        }

        public void setIdStrength(Integer idStrength) {
            this.idStrength = idStrength;
        }

        public final String getBaseDrugName() {
            return this.baseDrugName;
        }

        public final void setBaseDrugName(String baseDrugName) {
            this.baseDrugName = baseDrugName;
        }

        public final String getStrength() {
            return this.strength;
        }

        public final void setStrength(String strength) {
            this.strength = strength;
        }

        public Integer getIdDevice() {
            return this.idDevice;
        }

        public void setIdDevice(Integer idDevice) {
            this.idDevice = idDevice;
        }

        public final Integer getRoute() {
            return this.route;
        }

        public final void setRoute(Integer route) {
            this.routeString = XMyRouteOfAdministration.getRoute(route).toString();
            this.route = route;
        }

        @Override
        public final Integer getFormat() {
            return this.format;
        }

        public final void setFormat(Integer format) {
            this.formatString = XMyOrderableDrugForm.getDrugForm(format).toString();
            this.format = format;
        }

        public String getRouteS() {
            return this.routeString;
        }

        public void setRouteS(String routeS) {
            this.routeString = routeS;
        }

        public Integer getSite() {
            return this.site;
        }

        public void setSite(Integer site) {
            this.siteString = XMyHumanSubstanceAdministrationSite.getSite(site).toString();
            this.site = site;
        }

        public String getSiteS() {
            return this.siteString;
        }

        public void setSiteS(String siteS) {
            this.siteString = siteS;
        }

        public String getFormatS() {
            return this.formatString;
        }

        public void setFormatS(String formatS) {
            this.formatString = formatS;
        }

        public Integer getDin() {
            return this.din;
        }

        public void setDin(Integer din) {
            this.din = din;
        }

        public Integer getDosageChange() {
            return this.dosageChange;
        }

        public void setDosageChange(Integer dosageChange) {
            this.dosageChangeString = XChangeDose.from(dosageChange).toString();
            this.dosageChange = dosageChange;
        }

        public String getDosageChangeS() {
            return this.dosageChangeString;
        }

        public void setDosageChangeS(String dosageChangeS) {
            this.dosageChangeString = dosageChangeS;
        }

        public Integer getSeverity() {
            return this.severity;
        }

        public void setSeverity(Integer severity) {
            this.severityString = XAllergySeverity.from(severity).toString();
            this.severity = severity;
        }

        public String getSeverityS() {
            return this.severityString;
        }

        public void setSeverityS(String severityS) {
            this.severityString = severityS;
        }

        public Integer getAllergy() {
            return this.allergy;
        }

        public void setAllergy(Integer allergy) {
            this.allergyString = XAllergyProbability.from(allergy).toString();
            this.allergy = allergy;
        }

        public String getAllergyS() {
            return this.allergyString;
        }

        public void setAllergyS(String allergyS) {
            this.allergyString = allergyS;
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XPrescription x = (XPrescription)XPrescription.class.cast(type);
            this.init(x);
            return this;
        }

        public XPrescription x() {
            XPrescription x = new XPrescription();
            this.x(x);
            if (this.getDosageChange() != null) {
                x.dosageChange = XChangeDose.from(this.getDosageChange());
            }
            if (this.getFormat() != null) {
                x.format = XMyOrderableDrugForm.getDrugForm(this.getFormat());
            } else if (StringUtils.isNotBlank((String)this.getFormatS())) {
                x.format = XMyOrderableDrugForm.getDrugForm(this.getFormatS());
            }
            if (this.getRoute() != null) {
                x.route = XMyRouteOfAdministration.getRoute(this.getRoute());
            }
            if (this.getSite() != null) {
                x.site = XMyHumanSubstanceAdministrationSite.getSite(this.getSite());
            }
            XDrugStrength ds = new XDrugStrength();
            ds.setId(this.getIdStrength());
            ds.setStrength(this.getStrength());
            ds.setDin(this.getDin());
            x.setDin(this.getDin());
            ds.setName(this.getName());
            ds.setBaseName(this.getBaseDrugName());
            ds.setDrugType(XDrugType.from(this.getBaseDrugType()));
            if (this.getIdStrength() == null) {
                ds.setNew();
            } else {
                ds.setNeutral();
            }
            x.strength = ds;
            x.stopReason = this.getStopReason();
            if (this.allergy != null) {
                x.allergy = XAllergyProbability.from(this.allergy);
            }
            if (this.severity != null) {
                x.severity = XAllergySeverity.from(this.severity);
            }
            if (x.getId() == null) {
                x.setNew();
            } else {
                x.setModificationStatus(ModificationStatus.from(this.modificationStatus));
            }
            return x;
        }

        public static List<XPrescription> ctoxList(ArrayList<Prescription> c) {
            ArrayList<XPrescription> x = new ArrayList<XPrescription>();
            for (int i = 0; i < c.size(); ++i) {
                x.add(c.get(i).x());
            }
            return x;
        }

        @Override
        public void init(XPrescription x) {
            super.init(x);
            if (x.getDosageChange() != null) {
                this.setDosageChange(x.getDosageChange().ordinal());
                this.setDosageChangeS(x.getDosageChange().toString());
            }
            if (x.getFormat() != null) {
                this.setFormat(x.getFormat().getId());
                this.setFormatS(x.getFormat().description());
            }
            if (x.getRoute() != null) {
                this.setRoute(x.getRoute().getId());
                this.setRouteS(x.getRoute().description());
            }
            if (x.getSite() != null) {
                this.setSite(x.getSite().getId());
                this.setSiteS(x.getSite().description());
            }
            if (x.getStrength() != null) {
                this.setIdStrength(x.getStrength().getId());
                this.setDin(x.getStrength().getDin());
                this.setBaseDrugName(x.getStrength().getBaseName());
                this.setName(x.getStrength().getName());
                this.setStrength(x.getStrength().getStrength());
                if (x.getStrength().getDrugType() != null) {
                    this.setBaseDrugType(x.getStrength().getDrugType().getValue());
                }
            }
            if (x.getDevice() != null) {
                this.setIdDevice(x.getDevice().getId());
                this.setName(x.getDevice().getName());
                this.setBaseDrugType(new Integer(3));
            }
            if (x.getAllergy() != null) {
                this.setAllergy(x.getAllergy().value);
            }
            if (x.getSeverity() != null) {
                this.setSeverity(x.getSeverity().getValue());
            }
            Prescription.setExpiredDateAndStatus(this);
            this.hash = this.getHashForFav();
            this.setDescriptionOfObject();
        }

        public XPrescription convertx() {
            return this.x();
        }
    }

    public static final class Device
    extends DevicePrescription {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idDevice", "version", "idNextModificationEntry", "idProfessionnalAnchor", "entryDate", "note", "name", "quantity", "posology", "rx", "startDate", "stopDate", "endDate", "stopReason", "dsqIt1", "dsqIt2", "dsqIt3", "dsqIt4", "dsqIt5", "fromProfExterne", "treatmentDuration", "toReprescribe", "idPrevPrescription", "idEncounter", "idStopEncounter", "deleted", "dsqStatus", "encLabelInt"};
        public Integer idDevice;
        public String title = Messages.getString("FOURNITURES", new String[0]);

        public Device() {
        }

        public Device(XPrescription c) {
            this.convertc(c);
        }

        @Override
        public void setDescriptionOfObject() {
            this.descr = new String[5];
            String ren = this.getRx() == null || this.getRx() == 0 ? "NR" : "Ren x " + this.getRx();
            this.descr[0] = this.entryDateSD;
            this.descr[1] = this.name;
            this.descr[2] = this.getPosology();
            this.descr[3] = ren;
            this.descr[4] = this.note == null ? "" : this.note;
            Device.setExpiredDateAndStatus(this);
            this.hash = this.getHashForFav();
            this.baseDrugType = new Integer(3);
        }

        @Override
        public int getHashForFav() {
            String h = String.format("FavDev [n=%s, qty=%s, dur=%s, rx=%s, pos=%s, frq=%s, tor=%s]", this.name, this.quantity == null ? 0 : this.quantity, this.treatmentDuration == null ? 0 : this.treatmentDuration, this.rx == null ? 0 : this.rx, this.posology, this.frequency == null ? "" : this.frequency, Boolean.TRUE.equals(this.toReprescribeB) ? 1 : 0);
            return h.hashCode();
        }

        @Override
        public Integer getFormat() {
            return null;
        }

        public Integer getIdDevice() {
            return this.idDevice;
        }

        public void setIdDevice(Integer idDevice) {
            this.idDevice = idDevice;
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XPrescription x = (XPrescription)XPrescription.class.cast(type);
            this.init(x);
            return this;
        }

        @Override
        public void init(XPrescription x) {
            super.init(x);
            if (x.getDevice() != null) {
                this.setName(x.getDevice().getName());
                this.setIdDevice(x.getDevice().getId());
                this.setDescriptionOfObject();
                this.setBaseDrugType(new Integer(3));
            }
        }

        public XPrescription x() {
            XPrescription x = new XPrescription();
            super.x(x);
            XDevice device = new XDevice();
            device.setId(this.getIdDevice());
            device.setName(this.getName());
            if (this.getIdDevice() == null) {
                device.setNew();
            } else {
                device.setNeutral();
            }
            x.setDevice(device);
            if (x.getId() == null) {
                x.setNew();
            } else {
                x.setModificationStatus(ModificationStatus.from(this.modificationStatus));
            }
            return x;
        }

        public XPrescription convertx() {
            return this.x();
        }
    }

    public static abstract class DevicePrescription
    extends CEditableDataObject {
        private static final long serialVersionUID = 1L;
        public static Comparator<DevicePrescription> compare = new Comparator<DevicePrescription>(){

            @Override
            public int compare(DevicePrescription o1, DevicePrescription o2) {
                int c = ObjectUtils.compare((Comparable)((Object)o2.startDateSD), (Comparable)((Object)o1.startDateSD));
                return c == 0 ? ObjectUtils.compare((Comparable)((Object)o1.descr[1].toLowerCase()), (Comparable)((Object)o2.descr[1].toLowerCase())) : c;
            }
        };
        public Integer id;
        public Integer idAnchor;
        public Integer idNextModificationEntry;
        public Integer idProfessionnalAnchor;
        public String profNom;
        public Long entryDate;
        public String entryDateSD;
        public String note;
        public Integer quantity;
        public String name;
        public Integer baseDrugType;
        public String frequency;
        public String posology;
        public Integer rx;
        public Long startDate;
        public String startDateSD;
        public Long stopDate;
        public String stopDateSD;
        public Long endDate;
        public String endDateSD;
        public String stopReason;
        public Integer idEncounter;
        public Integer idStopEncounter;
        public String dsqIt1;
        public String dsqIt2;
        public String dsqIt3;
        public String dsqIt4;
        public String dsqIt5;
        public Integer fromProfExterne;
        public Boolean fromProfExterneB;
        public Integer treatmentDuration;
        public Integer toReprescribe;
        public Boolean toReprescribeB;
        public Integer idPrevPrescription;
        public Integer expiredStatus = new Integer(0);
        public String expiredDateSD;
        public Integer encLabelInt;
        public Boolean deleted;
        public Integer dsqStatus;
        public String dsqStatusStr = "";
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public static final Integer DSQ_IMPORTED = 1;
        public static final Integer DSQ_A_PENDING = 2;
        public static final Integer DSQ_EXPORTED = 3;
        public static final Integer DSQ_XPORTED_NO_NIU = 4;
        public static final String[] dsqStatusText = new String[]{"", "[I.dsq] ", "[A.dsq] ", "[E.dsq] ", "[X.dsq] "};
        public List<XPrescription.RxData> lstRxData = new ArrayList<XPrescription.RxData>();
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Produit/Product", "Sig", "X", "Note"};
        public int hash;

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public String getDsqStatus(Integer i) {
            return i == null ? "" : dsqStatusText[i];
        }

        public abstract void setDescriptionOfObject();

        public abstract Integer getFormat();

        public abstract int getHashForFav();

        public static void setExpiredDateAndStatus(DevicePrescription p) {
            LocalDate today = LocalDate.today();
            LocalDate presumedDateToRenvew = null;
            LocalDate start = null;
            if (p.getStartDate() != null) {
                start = LocalDate.fromTimeInMillisLOCAL((Long)p.getStartDate());
            }
            if (Boolean.TRUE.equals(p.getToReprescribeB())) {
                presumedDateToRenvew = p.getPresumedDateToRenew();
            }
            LocalDate endDate = null;
            if (p.getEndDate() != null) {
                endDate = LocalDate.fromTimeInMillisLOCAL((Long)p.getEndDate());
                if (presumedDateToRenvew == null || endDate.before((IPartialDate)presumedDateToRenvew)) {
                    presumedDateToRenvew = endDate;
                }
            }
            if (start != null && presumedDateToRenvew == null) {
                presumedDateToRenvew = start.plusYear(2);
            }
            if (presumedDateToRenvew != null) {
                p.expiredDateSD = (presumedDateToRenvew.equals((Object)endDate) ? "" : "~") + presumedDateToRenvew.formatHyphen();
                if (p.getStopDate() == null && today.plusDay(1).after((IPartialDate)presumedDateToRenvew)) {
                    p.expiredStatus = 1;
                    if (today.plusMonth(-6).after((IPartialDate)presumedDateToRenvew)) {
                        p.expiredStatus = 2;
                    }
                } else {
                    p.expiredStatus = 0;
                }
            } else {
                p.expiredDateSD = "????-??-??";
                p.expiredStatus = 0;
            }
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public Integer getDsqStatus() {
            return this.dsqStatus;
        }

        public void setDsqStatus(Integer dsqStatus) {
            this.dsqStatus = dsqStatus;
            this.dsqStatusStr = this.getDsqStatus(dsqStatus);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer idProfessionnalAnchor) {
            this.idProfessionnalAnchor = idProfessionnalAnchor;
        }

        public String getProfNom() {
            return this.profNom;
        }

        public void setProfNom(String profNom) {
            this.profNom = profNom;
            this.setDescriptionOfObject();
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateSD() {
            return this.entryDateSD;
        }

        public final void setEntryDateSD(String entryDateS) {
            this.entryDateSD = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public Integer getBaseDrugType() {
            return this.baseDrugType;
        }

        public void setBaseDrugType(Integer baseDrugType) {
            this.baseDrugType = baseDrugType;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getPosology() {
            return this.posology;
        }

        public final void setPosology(String posology) {
            this.posology = posology;
        }

        public final Integer getRx() {
            return this.rx;
        }

        public final void setRx(Integer rx) {
            this.rx = rx;
        }

        public final Long getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Long startDate) {
            this.startDate = startDate;
        }

        public final String getStartDateSD() {
            return this.startDateSD;
        }

        public final void setStartDateSD(String startDateS) {
            this.startDateSD = startDateS;
        }

        public final Long getStopDate() {
            return this.stopDate;
        }

        public final void setStopDate(Long stopDate) {
            this.stopDate = stopDate;
        }

        public final String getStopDateSD() {
            return this.stopDateSD;
        }

        public final void setStopDateSD(String stopDateS) {
            this.stopDateSD = stopDateS;
        }

        public final Long getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Long endDate) {
            this.endDate = endDate;
        }

        public final String getEndDateSD() {
            return this.endDateSD;
        }

        public final void setEndDateSD(String endDateS) {
            this.endDateSD = endDateS;
        }

        public final String getStopReason() {
            return this.stopReason;
        }

        public final void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        public final String getDsqIt1() {
            return this.dsqIt1;
        }

        public final void setDsqIt1(String dsqIt1) {
            this.dsqIt1 = dsqIt1;
        }

        public final String getDsqIt2() {
            return this.dsqIt2;
        }

        public final void setDsqIt2(String dsqIt2) {
            this.dsqIt2 = dsqIt2;
        }

        public final String getDsqIt3() {
            return this.dsqIt3;
        }

        public final void setDsqIt3(String dsqIt3) {
            this.dsqIt3 = dsqIt3;
        }

        public final String getDsqIt4() {
            return this.dsqIt4;
        }

        public final void setDsqIt4(String dsqIt4) {
            this.dsqIt4 = dsqIt4;
        }

        public final String getDsqIt5() {
            return this.dsqIt5;
        }

        public final void setDsqIt5(String dsqIt5) {
            this.dsqIt5 = dsqIt5;
        }

        public Integer getFromProfExterne() {
            return this.fromProfExterne;
        }

        public void setFromProfExterne(Integer fromProfExterne) {
            this.fromProfExterne = fromProfExterne;
        }

        public Boolean getFromProfExterneB() {
            return this.fromProfExterneB;
        }

        public void setFromProfExterneB(Boolean fromProfExterneB) {
            this.fromProfExterneB = fromProfExterneB;
        }

        public Integer getTreatmentDuration() {
            return this.treatmentDuration;
        }

        public void setTreatmentDuration(Integer treatmentDuration) {
            this.treatmentDuration = treatmentDuration;
        }

        public Integer getToReprescribe() {
            return this.toReprescribe;
        }

        public void setToReprescribe(Integer toReprescribe) {
            this.toReprescribe = toReprescribe;
        }

        public Boolean getToReprescribeB() {
            return this.toReprescribeB;
        }

        public void setToReprescribeB(Boolean toReprescribeB) {
            this.toReprescribeB = toReprescribeB;
        }

        public Integer getIdPrevPrescription() {
            return this.idPrevPrescription;
        }

        public void setIdPrevPrescription(Integer idPrevPrescription) {
            this.idPrevPrescription = idPrevPrescription;
        }

        public Integer getIdEncounter() {
            return this.idEncounter;
        }

        public void setIdEncounter(Integer idEncounter) {
            this.idEncounter = idEncounter;
        }

        public Integer getIdStopEncounter() {
            return this.idStopEncounter;
        }

        public void setIdStopEncounter(Integer idStopEncounter) {
            this.idStopEncounter = idStopEncounter;
        }

        public Integer getExpiredStatus() {
            return this.expiredStatus;
        }

        public void setExpiredStatus(Integer expiredStatus) {
            this.expiredStatus = expiredStatus;
        }

        public String getExpiredDateSD() {
            return this.expiredDateSD;
        }

        public void setExpiredDateSD(String expiredDateSD) {
            this.expiredDateSD = expiredDateSD;
        }

        public LocalDate getPresumedDateToRenew() {
            LocalDate ld = null;
            LocalDate start = null;
            LocalDate stop = null;
            LocalDate end = null;
            LocalDate realEnd = null;
            Integer nbJr = null;
            int nbRx = 1;
            int qte = 0;
            if (this.getStartDate() != null) {
                start = LocalDate.fromTimeInMillisLOCAL((Long)this.getStartDate());
            }
            if (start != null) {
                boolean isComptable;
                LocalDate max2y = start.plusYear(2);
                if (this.getStopDate() != null) {
                    stop = LocalDate.fromTimeInMillisLOCAL((Long)this.getStopDate());
                }
                if (this.getEndDate() != null) {
                    end = LocalDate.fromTimeInMillisLOCAL((Long)this.getEndDate());
                }
                realEnd = stop == null ? end : (end == null ? stop : (end.before((IPartialDate)stop) ? end : stop));
                if (this.getTreatmentDuration() != null && this.getTreatmentDuration() > 0) {
                    nbJr = this.getTreatmentDuration();
                }
                if (this.getRx() != null && this.getRx() > 0) {
                    nbRx = this.getRx() + 1;
                }
                if (this.getQuantity() != null && this.getQuantity() > 0) {
                    qte = this.getQuantity() * nbRx;
                }
                boolean bl = isComptable = this.getFormat() != null && XMyOrderableDrugForm.setFormatComptable.contains(this.getFormat());
                if (nbJr != null) {
                    ld = start.plusDay(nbJr * nbRx);
                } else if (!isComptable) {
                    ld = start.plusYear(2);
                } else if (qte > 0 && this.getFrequency() != null && this.getFrequency() != null) {
                    Double nbPerDay = RxUtil.findNPerDay(this.getFrequency(), false);
                    double quantityText = RxUtil.getDoubleQuantityFromQuantityText(this.getPosology());
                    if (nbPerDay.equals(0.0)) {
                        ld = start.plusYear(2);
                    } else {
                        int duree = (int)((double)qte / (nbPerDay * quantityText));
                        ld = start.plusDay(duree);
                    }
                }
                if (ld != null && realEnd != null && realEnd.before((IPartialDate)ld)) {
                    ld = realEnd;
                }
                if (ld != null && ld.after((IPartialDate)max2y)) {
                    ld = max2y;
                }
            }
            return ld;
        }

        public XPrescription x(XPrescription x) {
            LocalDate localDate;
            x.id = this.getId();
            x.idAnchor = this.getIdAnchor();
            x.isDeleted = this.isStatusDeleted() || Boolean.TRUE.equals(this.isDeleted());
            XBaseEncounter xBaseEncounter = new XBaseEncounter();
            xBaseEncounter.setId(this.getIdEncounter());
            xBaseEncounter.setProfessionnal(this.getIdProfessionnalAnchor());
            xBaseEncounter.setNeutral();
            if (this.getIdEncounter() != null) {
                x.encounter = xBaseEncounter;
            }
            if (this.getIdStopEncounter() != null) {
                XBaseEncounter xStopBaseEncounter = new XBaseEncounter();
                xStopBaseEncounter.setId(this.getIdStopEncounter());
                xStopBaseEncounter.setNeutral();
                x.stopEncounter = xStopBaseEncounter;
            }
            x.prevPrescriptionId = this.getIdPrevPrescription();
            x.toReprescribe = Boolean.TRUE.equals(this.getToReprescribeB());
            x.treatmentDuration = this.getTreatmentDuration();
            x.quantity = this.getQuantity();
            x.rx = this.getRx() == null ? new Integer(0) : this.getRx();
            x.posology = this.getPosology();
            x.frequency = this.getFrequency();
            x.encLabel = this.getEncLabel() != null ? this.getEncLabel().clone() : EnumSet.noneOf(XEncounterLabel.class);
            x.note = this.getNote();
            x.fromProfExterne = Boolean.TRUE.equals(this.getFromProfExterneB());
            if (StringUtils.isNotEmpty((String)this.getStartDateSD())) {
                try {
                    x.startDate = localDate = LocalDateFormat.parse((String)this.getStartDateSD().trim(), (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (x.startDate == null) {
                x.startDate = LocalDate.today();
            }
            x.entryDate = this.entryDate;
            if (StringUtils.isNotEmpty((String)this.getEndDateSD())) {
                try {
                    x.endDate = localDate = LocalDateFormat.parse((String)this.getEndDateSD().trim(), (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (StringUtils.isNotEmpty((String)this.getStopDateSD())) {
                try {
                    x.stopDate = localDate = LocalDateFormat.parse((String)this.getStopDateSD().trim(), (String)"yyyy-MM-dd");
                    if (x.stopEncounter == null) {
                        x.stopEncounter = xBaseEncounter;
                    }
                }
                catch (ParseException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            x.dsqIt1 = this.getDsqIt1();
            x.dsqIt2 = this.getDsqIt2();
            x.dsqIt3 = this.getDsqIt3();
            x.dsqIt4 = this.getDsqIt4();
            x.dsqIt5 = this.getDsqIt5();
            x.dsqPrescriptionId = this.getDsqStatus() == null || this.getDsqStatus() == 0 ? null : this.getDsqStatus(this.getDsqStatus());
            this.setTag();
            x.setTag(this.tag);
            return x;
        }

        public void init(XPrescription x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            if (x.getEncounter() != null) {
                this.setIdEncounter(x.getEncounter().getId());
                this.setIdProfessionnalAnchor(x.getEncounter().getProfessionnal());
                if (this.getIdProfessionnalAnchor() != null) {
                    // empty if block
                }
            }
            if (x.getStopEncounter() != null) {
                this.setIdStopEncounter(x.getStopEncounter().getId());
            }
            this.setIdPrevPrescription(x.getPrevPrescriptionId());
            this.setTreatmentDuration(x.getTreatmentDuration());
            this.setQuantity(x.getQuantity());
            this.setRx(x.getRx());
            this.setPosology(x.getPosology());
            this.setFrequency(x.getFrequency());
            this.setEncLabel((EnumSet<XEncounterLabel>)x.getEncLabel().clone());
            this.setEncLabelInt(EnumWithValues.toSet(x.getEncLabel()));
            this.setNote(x.getNote());
            this.setFromProfExterne(Boolean.TRUE.equals(x.getFromProfExterne()) ? new Integer(1) : new Integer(0));
            this.setFromProfExterneB(Boolean.TRUE.equals(x.getFromProfExterne()));
            if (x.getStartDate() != null) {
                this.setStartDate(x.getStartDate().toTimeInMillisUTC());
                this.setStartDateSD(x.getStartDate().formatHyphen());
            }
            if (x.getEndDate() != null) {
                this.setEndDate(x.getEndDate().toTimeInMillisUTC());
                this.setEndDateSD(x.getEndDate().formatHyphen());
            }
            if (x.getStopDate() != null) {
                this.setStopDate(x.getStopDate().toTimeInMillisUTC());
                this.setStopDateSD(x.getStopDate().formatHyphen());
            }
            if (x.getEntryDate() != null) {
                this.setEntryDate(x.getEntryDate());
                this.setEntryDateSD(DateUtil.calendarToFormatedStringDate((Calendar)DateUtil.getCalendarFromLong((long)x.getEntryDate())));
            }
            this.setStopReason(x.getStopReason());
            this.setToReprescribeB(Boolean.TRUE.equals(x.getToReprescribe()));
            DevicePrescription.setExpiredDateAndStatus(this);
            this.setDsqIt1(x.getDsqIt1());
            this.setDsqIt2(x.getDsqIt2());
            this.setDsqIt3(x.getDsqIt3());
            this.setDsqIt4(x.getDsqIt4());
            this.setDsqIt5(x.getDsqIt5());
            this.deleted = x.getIsDeleted();
            if (x.lstRxData != null) {
                this.lstRxData.addAll(x.lstRxData);
            }
        }
    }

    public static final class CEncounterMapArg {
        public ProviderAR<Integer, String> profNameResolver;
    }

    public static final class Prob
    extends Dx {
        private static final long serialVersionUID = 1L;

        public Prob() {
        }

        public Prob(XDiagnostic c) {
            this.convertc(c);
        }

        @Override
        public XDiagnostic x() {
            XDiagnostic x = super.x();
            x.setIsProblem(true);
            return x;
        }
    }

    public static class Dx
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "codeId", "sinceDate", "solvedDate", "status", "classificationDiagnostic", "cciCode", "cciDescrShort", "cciDescrLong", "cim10Code", "cim10DescrShort", "cim10DescrLong", "cim9Code", "cim9DescrShort", "cim9DescrLong", "icpc2Code", "icpc2DescrShort", "icpc2DescrLong", "deleted", "encLabelInt", "importance"};
        public static Comparator<Dx> compare = new Comparator<Dx>(){

            @Override
            public int compare(Dx o1, Dx o2) {
                int c = ObjectUtils.compare((Comparable)o2.importance, (Comparable)o1.importance);
                c = c == 0 ? ObjectUtils.compare((Comparable)((Object)o2.entryDateSD), (Comparable)((Object)o1.entryDateSD)) : c;
                return c == 0 ? ObjectUtils.compare((Comparable)((Object)o1.descr[1].toLowerCase()), (Comparable)((Object)o2.descr[1].toLowerCase())) : c;
            }
        };
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateSD;
        public String note;
        public Long sinceDate;
        public String sinceDateSP;
        public Long solvedDate;
        public String solvedDateSP;
        public Integer status;
        public Integer importance;
        public Integer importanceTemp;
        public Integer codeId;
        public String classificationDiagnostic;
        public String code;
        public String descrShort;
        public String descrLong;
        public String cciCode;
        public String cciDescrShort;
        public String cciDescrLong;
        public String cim10Code;
        public String cim10DescrShort;
        public String cim10DescrLong;
        public String cim9Code;
        public String cim9DescrShort;
        public String cim9DescrLong;
        public String icpc2Code;
        public String icpc2DescrShort;
        public String icpc2DescrLong;
        public XCode dxCode;
        public Boolean deleted;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = Messages.getString("DX_DU_SOMMAIRE", new String[0]);
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", DETAILS};

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public Dx() {
        }

        public Dx(XDiagnostic c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            if (this.getClassificationDiagnostic() != null) {
                if (XCodeClassification.CCI.id.equals(this.getClassificationDiagnostic())) {
                    this.code = this.getCciCode();
                    this.descrShort = this.getCciDescrShort();
                    this.descrLong = this.getCciDescrLong();
                } else if (XCodeClassification.CIM9.id.equals(this.getClassificationDiagnostic())) {
                    if (!"0000".equals(this.cim9Code)) {
                        this.code = this.getCim9Code();
                        this.descrShort = this.getCim9DescrShort();
                        this.descrLong = this.getCim9DescrLong();
                    }
                } else if (XCodeClassification.CIM10.id.equals(this.getClassificationDiagnostic())) {
                    this.code = this.getCim10Code();
                    this.descrShort = this.getCim10DescrShort();
                    this.descrLong = this.getCim10DescrLong();
                } else if (XCodeClassification.ICPC2.id.equals(this.getClassificationDiagnostic())) {
                    this.code = this.getIcpc2Code();
                    this.descrShort = this.getIcpc2DescrShort();
                    this.descrLong = this.getIcpc2DescrLong();
                }
            }
            StringBuilder s = new StringBuilder();
            if (this.descrShort != null) {
                s.append(this.descrShort);
            }
            if (StringUtils.isNotEmpty((String)this.note)) {
                s.append(s.length() > 0 ? " - " : "").append(this.note);
            }
            this.descr = new String[2];
            this.descr[0] = this.sinceDateSP != null ? this.sinceDateSP : "";
            this.descr[1] = s.toString();
        }

        public String formatCode() {
            StringBuilder s = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.cciDescrShort)) {
                s.append(this.cciDescrShort);
            } else if (StringUtils.isNotEmpty((String)this.cim10DescrShort)) {
                s.append(this.cim10DescrShort);
            } else if (StringUtils.isNotEmpty((String)this.cim9DescrShort)) {
                if (!"0000".equals(this.cim9Code)) {
                    s.append(this.cim9DescrShort);
                }
            } else if (StringUtils.isNotEmpty((String)this.icpc2DescrShort)) {
                s.append(this.icpc2DescrShort);
            }
            return s.toString();
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateSD() {
            return this.entryDateSD;
        }

        public final void setEntryDateSD(String entryDateS) {
            this.entryDateSD = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Integer getCodeId() {
            return this.codeId;
        }

        public final void setCodeId(Integer codeId) {
            this.codeId = codeId;
        }

        public final Long getSinceDate() {
            return this.sinceDate;
        }

        public final void setSinceDate(Long declaredDate) {
            this.sinceDate = declaredDate;
        }

        public final String getSinceDateSP() {
            return this.sinceDateSP;
        }

        public final void setSinceDateSP(String declaredDateS) {
            this.sinceDateSP = declaredDateS;
        }

        public final Long getSolvedDate() {
            return this.solvedDate;
        }

        public final void setSolvedDate(Long solvedDate) {
            this.solvedDate = solvedDate;
        }

        public final String getSolvedDateSP() {
            return this.solvedDateSP;
        }

        public final void setSolvedDateSP(String solvedDateS) {
            this.solvedDateSP = solvedDateS;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getImportance() {
            return this.importance;
        }

        public void setImportance(Integer importance) {
            this.importance = importance;
            this.importanceTemp = importance;
        }

        public final String getClassificationDiagnostic() {
            return this.classificationDiagnostic;
        }

        public final void setClassificationDiagnostic(String classificationDiagnostic) {
            this.classificationDiagnostic = classificationDiagnostic;
        }

        public final String getCciCode() {
            return this.cciCode;
        }

        public final void setCciCode(String s) {
            this.cciCode = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCciDescrShort() {
            return this.cciDescrShort;
        }

        public final void setCciDescrShort(String s) {
            this.cciDescrShort = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCim10Code() {
            return this.cim10Code;
        }

        public final void setCim10Code(String s) {
            this.cim10Code = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCim10DescrShort() {
            return this.cim10DescrShort;
        }

        public final void setCim10DescrShort(String s) {
            this.cim10DescrShort = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCim9Code() {
            return this.cim9Code;
        }

        public final void setCim9Code(String s) {
            this.cim9Code = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCim9DescrShort() {
            return this.cim9DescrShort;
        }

        public final void setCim9DescrShort(String s) {
            this.cim9DescrShort = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getIcpc2Code() {
            return this.icpc2Code;
        }

        public final void setIcpc2Code(String s) {
            this.icpc2Code = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getIcpc2DescrShort() {
            return this.icpc2DescrShort;
        }

        public final void setIcpc2DescrShort(String s) {
            this.icpc2DescrShort = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescrShort() {
            return this.descrShort;
        }

        public void setDescrShort(String descrShort) {
            this.descrShort = descrShort;
        }

        public String getDescrLong() {
            return this.descrLong;
        }

        public void setDescrLong(String descrLong) {
            this.descrLong = descrLong;
        }

        public String getCciDescrLong() {
            return this.cciDescrLong;
        }

        public void setCciDescrLong(String cciDescrLong) {
            this.cciDescrLong = cciDescrLong;
        }

        public String getCim10DescrLong() {
            return this.cim10DescrLong;
        }

        public void setCim10DescrLong(String cim10DescrLong) {
            this.cim10DescrLong = cim10DescrLong;
        }

        public String getCim9DescrLong() {
            return this.cim9DescrLong;
        }

        public void setCim9DescrLong(String cim9DescrLong) {
            this.cim9DescrLong = cim9DescrLong;
        }

        public String getIcpc2DescrLong() {
            return this.icpc2DescrLong;
        }

        public void setIcpc2DescrLong(String icpc2DescrLong) {
            this.icpc2DescrLong = icpc2DescrLong;
        }

        public XCode getDxCode() {
            return this.dxCode;
        }

        public void setDxCode(XCode c) {
            this.dxCode = c;
            if (c.getClassification() != null) {
                this.classificationDiagnostic = c.getClassification().id;
                if (XCodeClassification.CCI.equals((Object)c.getClassification())) {
                    this.cciCode = c.getCode();
                    this.cciDescrShort = c.getDescriptionShort();
                } else if (XCodeClassification.CIM9.equals((Object)c.getClassification())) {
                    this.cim9Code = c.getCode();
                    this.cim9DescrShort = c.getDescriptionShort();
                } else if (XCodeClassification.CIM10.equals((Object)c.getClassification())) {
                    this.cim10Code = c.getCode();
                    this.cim10DescrShort = c.getDescriptionShort();
                } else if (XCodeClassification.ICPC2.equals((Object)c.getClassification())) {
                    this.icpc2Code = c.getCode();
                    this.icpc2DescrShort = c.getDescriptionShort();
                }
            }
        }

        public void init(XDiagnostic x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setEntryDate(x.getEntryDate().toTimeInMillisUTC());
            this.setEntryDateSD(x.getEntryDate().formatHyphen());
            this.setIdProfessionnalAnchor(x.getEncounter() != null ? x.getEncounter().getProfessionnal() : null);
            this.setImportance(x.getImportance());
            if (x.getSinceDate() != null) {
                this.setSinceDate(x.getSinceDate().toAbsoluteDate().toTimeInMillisUTC());
                this.setSinceDateSP(x.getSinceDate().formatHyphen());
            }
            if (x.getSolvedDate() != null) {
                this.setSolvedDate(x.getSolvedDate().toAbsoluteDate().toTimeInMillisUTC());
                this.setSolvedDateSP(x.getSolvedDate().formatHyphen());
            }
            this.setNote(x.getNote());
            if (x.getDiagnosticCode() != null) {
                XCode dxCode = new XCode();
                dxCode.setId(x.getDiagnosticCode().getId());
                dxCode.setClassification(x.getDiagnosticCode().getClassification());
                dxCode.setCode(x.getDiagnosticCode().getCode());
                dxCode.setDescriptionShort(x.getDiagnosticCode().getDescriptionShort());
                dxCode.setDescriptionLong(x.getDiagnosticCode().getDescriptionLong());
                this.setDxCode(dxCode);
                this.codeId = dxCode.getId();
                this.classificationDiagnostic = dxCode.getClassification().id;
                this.code = dxCode.getCode();
                this.descrShort = dxCode.getDescriptionShort();
                this.descrLong = dxCode.getDescriptionLong();
            }
            this.deleted = x.getIsDeleted();
            this.setStatus(x.getStatus().getValue());
            this.setEncLabelInt(EnumWithValues.toSet(x.getEncLabel()));
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XDiagnostic x = (XDiagnostic)XDiagnostic.class.cast(type);
            this.init(x);
            return this;
        }

        public XDiagnostic x() {
            XDiagnostic res = new XDiagnostic();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setEntryDate(LocalDate.fromTimeInMillisUTC((Long)this.entryDate));
            if (StringUtils.isNotEmpty((String)this.sinceDateSP)) {
                res.setSinceDate(MiscUtil.getPartialDate(this.sinceDateSP.trim()));
            } else if (this.sinceDate != null) {
                res.setSinceDate((IPartialDate)LocalDate.fromTimeInMillisLOCAL((Long)this.sinceDate));
            }
            if (StringUtils.isNotEmpty((String)this.solvedDateSP)) {
                res.setSolvedDate(MiscUtil.getPartialDate(this.solvedDateSP.trim()));
            } else if (this.solvedDate != null) {
                res.setSolvedDate((IPartialDate)LocalDate.fromTimeInMillisLOCAL((Long)this.solvedDate));
            }
            res.setIsSolved(this.solvedDate != null);
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            res.setIsProblem(false);
            res.setImportance(this.importance);
            if (this.codeId != null && this.classificationDiagnostic != null) {
                XCode dxCode = new XCode();
                dxCode.setId(this.codeId);
                dxCode.setClassification(XCodeClassification.from(this.classificationDiagnostic.toLowerCase()));
                dxCode.setCode(this.code);
                dxCode.setDescriptionShort(this.descrShort);
                dxCode.setDescriptionLong(this.descrLong);
                res.setDiagnosticCode(dxCode);
            } else {
                res.setDiagnosticCode(null);
            }
            res.setStatus(XDiagnosticStatus.from(this.status));
            res.setEncLabel((EnumSet<XEncounterLabel>)this.getEncLabel().clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XDiagnostic convertx() {
            return this.x();
        }
    }

    public static class DxEnc
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "codeId", "status", "classificationDiagnostic", "cciCode", "cciDescrShort", "cciDescrLong", "cim10Code", "cim10DescrShort", "cim10DescrLong", "cim9Code", "cim9DescrShort", "cim9DescrLong", "icpc2Code", "icpc2DescrShort", "icpc2DescrLong", "deleted"};
        public static Comparator<DxEnc> compare = new Comparator<DxEnc>(){

            @Override
            public int compare(DxEnc o1, DxEnc o2) {
                int c = ObjectUtils.compare((Comparable)((Object)o2.entryDateSD), (Comparable)((Object)o1.entryDateSD));
                return c == 0 ? ObjectUtils.compare((Comparable)((Object)o1.descr[1].toLowerCase()), (Comparable)((Object)o2.descr[1].toLowerCase())) : c;
            }
        };
        public Integer id;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateSD;
        public String note;
        public Integer status;
        public Integer codeId;
        public String classificationDiagnostic;
        public String code;
        public String descrShort;
        public String descrLong;
        public String cciCode;
        public String cciDescrShort;
        public String cciDescrLong;
        public String cim10Code;
        public String cim10DescrShort;
        public String cim10DescrLong;
        public String cim9Code;
        public String cim9DescrShort;
        public String cim9DescrLong;
        public String icpc2Code;
        public String icpc2DescrShort;
        public String icpc2DescrLong;
        public XCode dxCode;
        public Boolean deleted;
        public String title = Messages.getString("DX_DE_RENCONTRE", new String[0]);
        public String[] descr;
        public String[] descrTitle = new String[]{DETAILS};

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public DxEnc() {
        }

        public DxEnc(XDiagnosticEnc c) {
            this.convertc(c);
        }

        public void setDescriptionOfObject() {
            if (this.getClassificationDiagnostic() != null) {
                if (XCodeClassification.CCI.id.equals(this.getClassificationDiagnostic())) {
                    this.code = this.getCciCode();
                    this.descrShort = this.getCciDescrShort();
                    this.descrLong = this.getCciDescrLong();
                } else if (XCodeClassification.CIM9.id.equals(this.getClassificationDiagnostic())) {
                    if (!"0000".equals(this.cim9Code)) {
                        this.code = this.getCim9Code();
                        this.descrShort = this.getCim9DescrShort();
                        this.descrLong = this.getCim9DescrLong();
                    }
                } else if (XCodeClassification.CIM10.id.equals(this.getClassificationDiagnostic())) {
                    this.code = this.getCim10Code();
                    this.descrShort = this.getCim10DescrShort();
                    this.descrLong = this.getCim10DescrLong();
                } else if (XCodeClassification.ICPC2.id.equals(this.getClassificationDiagnostic())) {
                    this.code = this.getIcpc2Code();
                    this.descrShort = this.getIcpc2DescrShort();
                    this.descrLong = this.getIcpc2DescrLong();
                }
            }
            StringBuilder s = new StringBuilder();
            if (this.descrShort != null) {
                s.append(this.descrShort);
            }
            if (StringUtils.isNotEmpty((String)this.note)) {
                s.append(s.length() > 0 ? " - " : "").append(this.note);
            }
            this.descr = new String[1];
            this.descr[0] = s.toString();
        }

        public String formatCode() {
            StringBuilder s = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.cciDescrShort)) {
                s.append(this.cciDescrShort);
            } else if (StringUtils.isNotEmpty((String)this.cim10DescrShort)) {
                s.append(this.cim10DescrShort);
            } else if (StringUtils.isNotEmpty((String)this.cim9DescrShort)) {
                if (!"0000".equals(this.cim9Code)) {
                    s.append(this.cim9DescrShort);
                }
            } else if (StringUtils.isNotEmpty((String)this.icpc2DescrShort)) {
                s.append(this.icpc2DescrShort);
            }
            return s.toString();
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateSD() {
            return this.entryDateSD;
        }

        public final void setEntryDateSD(String entryDateS) {
            this.entryDateSD = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Integer getCodeId() {
            return this.codeId;
        }

        public final void setCodeId(Integer codeId) {
            this.codeId = codeId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getClassificationDiagnostic() {
            return this.classificationDiagnostic;
        }

        public final void setClassificationDiagnostic(String classificationDiagnostic) {
            this.classificationDiagnostic = classificationDiagnostic;
        }

        public final String getCciCode() {
            return this.cciCode;
        }

        public final void setCciCode(String s) {
            this.cciCode = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCciDescrShort() {
            return this.cciDescrShort;
        }

        public final void setCciDescrShort(String s) {
            this.cciDescrShort = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCim10Code() {
            return this.cim10Code;
        }

        public final void setCim10Code(String s) {
            this.cim10Code = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCim10DescrShort() {
            return this.cim10DescrShort;
        }

        public final void setCim10DescrShort(String s) {
            this.cim10DescrShort = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCim9Code() {
            return this.cim9Code;
        }

        public final void setCim9Code(String s) {
            this.cim9Code = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getCim9DescrShort() {
            return this.cim9DescrShort;
        }

        public final void setCim9DescrShort(String s) {
            this.cim9DescrShort = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getIcpc2Code() {
            return this.icpc2Code;
        }

        public final void setIcpc2Code(String s) {
            this.icpc2Code = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public final String getIcpc2DescrShort() {
            return this.icpc2DescrShort;
        }

        public final void setIcpc2DescrShort(String s) {
            this.icpc2DescrShort = StringUtils.isBlank((CharSequence)s) ? null : s;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescrShort() {
            return this.descrShort;
        }

        public void setDescrShort(String descrShort) {
            this.descrShort = descrShort;
        }

        public String getDescrLong() {
            return this.descrLong;
        }

        public void setDescrLong(String descrLong) {
            this.descrLong = descrLong;
        }

        public String getCciDescrLong() {
            return this.cciDescrLong;
        }

        public void setCciDescrLong(String cciDescrLong) {
            this.cciDescrLong = cciDescrLong;
        }

        public String getCim10DescrLong() {
            return this.cim10DescrLong;
        }

        public void setCim10DescrLong(String cim10DescrLong) {
            this.cim10DescrLong = cim10DescrLong;
        }

        public String getCim9DescrLong() {
            return this.cim9DescrLong;
        }

        public void setCim9DescrLong(String cim9DescrLong) {
            this.cim9DescrLong = cim9DescrLong;
        }

        public String getIcpc2DescrLong() {
            return this.icpc2DescrLong;
        }

        public void setIcpc2DescrLong(String icpc2DescrLong) {
            this.icpc2DescrLong = icpc2DescrLong;
        }

        public XCode getDxCode() {
            return this.dxCode;
        }

        public void setDxCode(XCode c) {
            this.dxCode = c;
            if (c.getClassification() != null) {
                this.classificationDiagnostic = c.getClassification().id;
                if (XCodeClassification.CCI.equals((Object)c.getClassification())) {
                    this.cciCode = c.getCode();
                    this.cciDescrShort = c.getDescriptionShort();
                } else if (XCodeClassification.CIM9.equals((Object)c.getClassification())) {
                    this.cim9Code = c.getCode();
                    this.cim9DescrShort = c.getDescriptionShort();
                } else if (XCodeClassification.CIM10.equals((Object)c.getClassification())) {
                    this.cim10Code = c.getCode();
                    this.cim10DescrShort = c.getDescriptionShort();
                } else if (XCodeClassification.ICPC2.equals((Object)c.getClassification())) {
                    this.icpc2Code = c.getCode();
                    this.icpc2DescrShort = c.getDescriptionShort();
                }
            }
        }

        public void init(XDiagnosticEnc x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setEntryDate(x.getEntryDate().toTimeInMillisUTC());
            this.setEntryDateSD(x.getEntryDate().formatHyphen());
            this.setIdProfessionnalAnchor(x.getEncounter() != null ? x.getEncounter().getProfessionnal() : null);
            this.setNote(x.getNote());
            if (x.getDiagnosticCode() != null) {
                XCode dxCode = new XCode();
                dxCode.setId(x.getDiagnosticCode().getId());
                dxCode.setClassification(x.getDiagnosticCode().getClassification());
                dxCode.setCode(x.getDiagnosticCode().getCode());
                dxCode.setDescriptionShort(x.getDiagnosticCode().getDescriptionShort());
                dxCode.setDescriptionLong(x.getDiagnosticCode().getDescriptionLong());
                this.setDxCode(dxCode);
                this.codeId = dxCode.getId();
                this.classificationDiagnostic = dxCode.getClassification().id;
                this.code = dxCode.getCode();
                this.descrShort = dxCode.getDescriptionShort();
                this.descrLong = dxCode.getDescriptionLong();
            }
            this.deleted = x.getIsDeleted();
            this.setStatus(x.getStatus().getValue());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XDiagnosticEnc x = (XDiagnosticEnc)XDiagnosticEnc.class.cast(type);
            this.init(x);
            return this;
        }

        public XDiagnosticEnc x() {
            XDiagnosticEnc res = new XDiagnosticEnc();
            res.setId(this.id);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setEntryDate(LocalDate.fromTimeInMillisUTC((Long)this.entryDate));
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            if (this.codeId != null && this.classificationDiagnostic != null) {
                XCode dxCode = new XCode();
                dxCode.setId(this.codeId);
                dxCode.setClassification(XCodeClassification.from(this.classificationDiagnostic.toLowerCase()));
                dxCode.setCode(this.code);
                dxCode.setDescriptionShort(this.descrShort);
                dxCode.setDescriptionLong(this.descrLong);
                res.setDiagnosticCode(dxCode);
            } else {
                res.setDiagnosticCode(null);
            }
            res.setStatus(XDiagnosticStatus.from(this.status));
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.from(this.modificationStatus));
            return res;
        }

        public XDiagnosticEnc convertx() {
            return this.x();
        }
    }

    public static final class CustMeasure
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "typeId", "typeCode", "typeName", "typeUnit", "avalue", "typeInterval", "timeVitalSign", "flags"};
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Boolean deleted;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Integer typeId;
        public String typeCode;
        public String typeName;
        public String typeUnit;
        public String avalue;
        public String typeInterval;
        public Long timeVitalSign;
        public String timeVitalSignS;
        public String flags;
        public String title = "Mesures personalis\u00e9es";
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Nom", "Valeur", "Unit\u00e9", "Interval", "Note"};

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public CustMeasure() {
        }

        public CustMeasure(XCustomMeasure c) {
            this.convertc(c);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[6];
            this.descr[0] = this.entryDateS;
            this.descr[1] = this.typeName;
            this.descr[2] = this.avalue;
            this.descr[3] = this.typeUnit;
            this.descr[4] = this.typeInterval;
            this.descr[5] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Integer getTypeId() {
            return this.typeId;
        }

        public final void setTypeId(Integer typeId) {
            this.typeId = typeId;
        }

        public final String getTypeCode() {
            return this.typeCode;
        }

        public final void setTypeCode(String typeCode) {
            this.typeCode = typeCode;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getTypeUnit() {
            return this.typeUnit;
        }

        public final void setTypeUnit(String typeUnit) {
            this.typeUnit = typeUnit;
        }

        public final String getAvalue() {
            return this.avalue;
        }

        public final void setAvalue(String avalue) {
            this.avalue = avalue;
        }

        public final String getTypeInterval() {
            return this.typeInterval;
        }

        public final void setTypeInterval(String typeInterval) {
            this.typeInterval = typeInterval;
        }

        public final Long getTimeVitalSign() {
            return this.timeVitalSign;
        }

        public final void setTimeVitalSign(Long timeVitalSign) {
            this.timeVitalSign = timeVitalSign;
            this.timeVitalSignS = CEncounter.getStringDateTimeFromLong(timeVitalSign);
        }

        public final String getTimeVitalSignS() {
            if (this.timeVitalSignS == null && this.timeVitalSign != null) {
                this.timeVitalSignS = CEncounter.getStringDateTimeFromLong(this.timeVitalSign);
            }
            return this.timeVitalSignS;
        }

        public final void setTimeVitalSignS(String timeVitalSignS) {
            this.timeVitalSignS = timeVitalSignS;
        }

        public final String getFlags() {
            return this.flags;
        }

        public final void setFlags(String flags) {
            this.flags = flags;
        }

        public void init(XCustomMeasure x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.deleted = x.getIsDeleted();
            this.setEntryDate(x.getEntryDatetime());
            this.setEntryDateS(CEncounter.getStringDateTimeFromLong(x.getEntryDatetime()));
            this.setTimeVitalSign(x.getTimeVitalSign());
            this.setTimeVitalSignS(CEncounter.getStringDateTimeFromLong(x.getTimeVitalSign()));
            this.setTypeId(x.getLabType().getId());
            this.setTypeCode(x.getLabType().getCode());
            this.setTypeName(x.getLabType().getName());
            this.setTypeUnit(x.getLabType().getUnit());
            this.setTypeInterval(x.getLabType().getInterval());
            this.setAvalue(x.getValue());
            this.setFlags(x.getFlags());
            this.setNote(x.getNote());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XCustomMeasure x = (XCustomMeasure)XCustomMeasure.class.cast(type);
            this.init(x);
            return this;
        }

        public XCustomMeasure x() {
            Calendar dataStringToCalendar;
            XCustomMeasure res = new XCustomMeasure();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            if (StringUtils.isNotEmpty((String)this.entryDateS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.entryDateS.replaceAll("[// /:/-]", ""));
                res.setEntryDatetime(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            if (StringUtils.isNotEmpty((String)this.timeVitalSignS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.timeVitalSignS.replaceAll("[// /:/-]", ""));
                res.setTimeVitalSign(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            XLabType ltype = new XLabType();
            ltype.setId(this.typeId);
            ltype.setCode(this.typeCode);
            ltype.setName(this.typeName);
            ltype.setUnit(this.typeUnit);
            ltype.setInterval(this.typeInterval);
            res.setLabType(ltype);
            res.setValue(this.avalue);
            res.setFlags(this.flags);
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XCustomMeasure convertx() {
            return this.x();
        }
    }

    public static final class EncounterToBeCompleted
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "version", "idNextModificationEntry", "deleted"};
        public Integer id;
        public Boolean deleted;
        public Integer idNextModificationEntry;
        public String[] descr;
        public String[] descrTitle = new String[]{"A compl\u00e9ter"};

        public EncounterToBeCompleted() {
        }

        public EncounterToBeCompleted(XEncounterToBeCompleted c) {
            this.convertc(c);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[1];
            this.descr[0] = "X";
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public void init(XEncounterToBeCompleted x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.deleted = x.getIsDeleted();
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XEncounterToBeCompleted x = (XEncounterToBeCompleted)XEncounterToBeCompleted.class.cast(type);
            this.init(x);
            return this;
        }

        public XEncounterToBeCompleted x() {
            if (Boolean.TRUE.equals(this.isDeleted()) && this.getId() == null) {
                return null;
            }
            XEncounterToBeCompleted x = new XEncounterToBeCompleted();
            x.setId(this.getId());
            x.setIdNextModificationEntry(this.getIdNextModificationEntry());
            x.setIsDeleted(this.isDeleted());
            this.setTag();
            x.setTag(this.tag);
            x.modificationStatus.plain_set(ModificationStatus.valueOf(this.modificationStatus));
            return x;
        }

        public XEncounterToBeCompleted convertx() {
            return this.x();
        }
    }

    public static final class EncounterToBeRevised
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "version", "idNextModificationEntry", "supervisor", "deleted"};
        public Integer id;
        public Integer idNextModificationEntry;
        public Boolean deleted;
        public Integer supervisor;
        public String supervisorNom;
        public String[] descr;
        public String[] descrTitle = new String[]{"R\u00e9viseur"};

        public EncounterToBeRevised() {
        }

        public EncounterToBeRevised(XEncounterToBeRevised c) {
            this.convertc(c);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[1];
            this.descr[0] = StringUtils.isNotEmpty((String)this.supervisorNom) ? this.supervisorNom : "";
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public Integer getSupervisor() {
            return this.supervisor;
        }

        public void setSupervisor(Integer supervisor) {
            this.supervisor = supervisor;
        }

        public String getSupervisorNom() {
            return this.supervisorNom;
        }

        public void setSupervisorName(String supervisorNom) {
            this.supervisorNom = supervisorNom;
            this.setDescriptionOfObject();
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public void init(XEncounterToBeRevised x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.deleted = x.getIsDeleted();
            this.setSupervisor(x.getSupervisor());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XEncounterToBeRevised x = (XEncounterToBeRevised)XEncounterToBeRevised.class.cast(type);
            this.init(x);
            return this;
        }

        public XEncounterToBeRevised x() {
            if (this.getId() == null && Boolean.TRUE.equals(this.isDeleted())) {
                return null;
            }
            XEncounterToBeRevised x = new XEncounterToBeRevised();
            x.setId(this.getId());
            x.setIdNextModificationEntry(this.getIdNextModificationEntry());
            x.setSupervisor(this.supervisor);
            x.setIsDeleted(this.isDeleted());
            this.setTag();
            x.setTag(this.tag);
            x.modificationStatus.plain_set(ModificationStatus.valueOf(this.modificationStatus));
            return x;
        }

        public XEncounterToBeRevised convertx() {
            return this.x();
        }
    }

    public static final class EncounterRaison
    extends CEditableDataObject
    implements Serializable,
    IEncounterRaison {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "version", "reason", "idVisitReason", "classificationVisitReason", "cciCode", "cciDescrShort", "cciDescrLong", "cim10Code", "cim10DescrShort", "cim10DescrLong", "cim9Code", "cim9DescrShort", "cim9DescrLong", "icpc2Code", "icpc2DescrShort", "icpc2DescrLong"};
        public Integer id;
        public Boolean deleted;
        public String reason;
        public XCode visitReason = new XCode();
        public Integer idVisitReason;
        public String classificationVisitReason;
        public transient String cciCode;
        public transient String cciDescrShort;
        public transient String cciDescrLong;
        public transient String cim10Code;
        public transient String cim10DescrShort;
        public transient String cim10DescrLong;
        public transient String cim9Code;
        public transient String cim9DescrShort;
        public transient String cim9DescrLong;
        public transient String icpc2Code;
        public transient String icpc2DescrShort;
        public transient String icpc2DescrLong;
        public String[] descr;
        public String[] descrTitle = new String[]{"Raison"};

        public EncounterRaison() {
        }

        public EncounterRaison(XEncounterRaison c) {
            this.convertc(c);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[1];
            this.descr[0] = StringUtils.isBlank((CharSequence)this.reason) ? (this.visitReason == null || this.visitReason.getCode() == null ? "" : this.visitReason.getDescriptionShort()) : this.reason;
        }

        public static void setVisitReasonFromValues(IEncounterRaison e) {
            if (e.getIdVisitReason() != null && StringUtils.isNotEmpty((String)e.getClassificationVisitReason())) {
                XCode c = null;
                if (e.getVisitReason() == null) {
                    c = new XCode();
                    e.setVisitReason(c);
                } else {
                    c = e.getVisitReason();
                }
                c.setId(e.getIdVisitReason());
                String cf = e.getClassificationVisitReason();
                if (StringUtils.isNotEmpty((String)cf)) {
                    c.setClassification(XCodeClassification.from(e.getClassificationVisitReason()));
                }
                if (XCodeClassification.CCI.id.equals(cf)) {
                    c.setCode(e.getCciCode());
                    c.setDescriptionShort(e.getCciDescrShort());
                    c.setDescriptionLong(e.getCciDescrLong());
                } else if (XCodeClassification.CIM10.id.equals(cf)) {
                    c.setCode(e.getCim10Code());
                    c.setDescriptionShort(e.getCim10DescrShort());
                    c.setDescriptionLong(e.getCim10DescrLong());
                } else if (XCodeClassification.CIM9.id.equals(cf)) {
                    c.setCode(e.getCim9Code());
                    c.setDescriptionShort(e.getCim9DescrShort());
                    c.setDescriptionLong(e.getCim9DescrLong());
                } else if (XCodeClassification.ICPC2.id.equals(cf)) {
                    c.setCode(e.getIcpc2Code());
                    c.setDescriptionShort(e.getIcpc2DescrShort());
                    c.setDescriptionLong(e.getIcpc2DescrLong());
                }
            }
        }

        public String formatCode() {
            StringBuilder s = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.cciDescrShort)) {
                s.append(this.cciDescrShort);
            } else if (StringUtils.isNotEmpty((String)this.cim10DescrShort)) {
                s.append(this.cim10DescrShort);
            } else if (StringUtils.isNotEmpty((String)this.cim9DescrShort)) {
                if (!"0000".equals(this.cim9Code)) {
                    s.append(this.cim9DescrShort);
                }
            } else if (StringUtils.isNotEmpty((String)this.icpc2DescrShort)) {
                s.append(this.icpc2DescrShort);
            }
            return s.toString();
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public void setVisitReason(XCode visitReason) {
            this.visitReason = visitReason;
            this.setDescriptionOfObject();
        }

        @Override
        public String getClassificationVisitReason() {
            return this.classificationVisitReason;
        }

        public void setClassificationVisitReason(String classificationVisitReason) {
            this.classificationVisitReason = classificationVisitReason;
        }

        @Override
        public Integer getIdVisitReason() {
            return this.idVisitReason;
        }

        public void setIdVisitReason(Integer idVisitReason) {
            this.idVisitReason = idVisitReason;
        }

        @Override
        public final String getCciCode() {
            return this.cciCode;
        }

        public final void setCciCode(String cciCode) {
            this.cciCode = cciCode;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getCciDescrShort() {
            return this.cciDescrShort;
        }

        public final void setCciDescrShort(String cciDescrShortFr) {
            this.cciDescrShort = cciDescrShortFr;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getCciDescrLong() {
            return this.cciDescrLong;
        }

        public final void setCciDescrLong(String cciDescrShortEn) {
            this.cciDescrLong = cciDescrShortEn;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getCim10Code() {
            return this.cim10Code;
        }

        public final void setCim10Code(String cim10Code) {
            this.cim10Code = cim10Code;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getCim10DescrShort() {
            return this.cim10DescrShort;
        }

        public final void setCim10DescrShort(String cim10DescrShortFr) {
            this.cim10DescrShort = cim10DescrShortFr;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getCim10DescrLong() {
            return this.cim10DescrLong;
        }

        public final void setCim10DescrLong(String cim10DescrShortEn) {
            this.cim10DescrLong = cim10DescrShortEn;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getCim9Code() {
            return this.cim9Code;
        }

        public final void setCim9Code(String cim9Code) {
            this.cim9Code = cim9Code;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getCim9DescrShort() {
            return this.cim9DescrShort;
        }

        public final void setCim9DescrShort(String cim9DescrShortFr) {
            this.cim9DescrShort = cim9DescrShortFr;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getCim9DescrLong() {
            return this.cim9DescrLong;
        }

        public final void setCim9DescrLong(String cim9DescrShortEn) {
            this.cim9DescrLong = cim9DescrShortEn;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getIcpc2Code() {
            return this.icpc2Code;
        }

        public final void setIcpc2Code(String icpc2Code) {
            this.icpc2Code = icpc2Code;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getIcpc2DescrShort() {
            return this.icpc2DescrShort;
        }

        public final void setIcpc2DescrShort(String icpc2DescrShortFr) {
            this.icpc2DescrShort = icpc2DescrShortFr;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        @Override
        public final String getIcpc2DescrLong() {
            return this.icpc2DescrLong;
        }

        public final void setIcpc2DescrLong(String icpc2DescrShortEn) {
            this.icpc2DescrLong = icpc2DescrShortEn;
            EncounterRaison.setVisitReasonFromValues(this);
        }

        public void init(XEncounterRaison x) {
            super.init(x);
            this.setId(x.getId());
            this.deleted = x.getIsDeleted();
            this.setReason(x.getReason());
            if (x.getVisitReason() != null) {
                XCode vr = x.getVisitReason();
                this.setVisitReason(vr);
                this.setIdVisitReason(vr.getId());
                String cf = x.getClassificationVisitReason();
                this.setClassificationVisitReason(cf);
                if (XCodeClassification.CIM10.id.equals(cf)) {
                    this.cim10Code = vr.getCode();
                    this.cim10DescrShort = vr.getDescriptionShort();
                    this.cim10DescrLong = vr.getDescriptionLong();
                } else if (XCodeClassification.CIM9.id.equals(cf)) {
                    this.cim9Code = vr.getCode();
                    this.cim9DescrShort = vr.getDescriptionShort();
                    this.cim9DescrLong = vr.getDescriptionLong();
                } else if (XCodeClassification.ICPC2.id.equals(cf)) {
                    this.icpc2Code = vr.getCode();
                    this.icpc2DescrShort = vr.getDescriptionShort();
                    this.icpc2DescrLong = vr.getDescriptionLong();
                } else if (XCodeClassification.CCI.id.equals(cf)) {
                    this.cciCode = vr.getCode();
                    this.cciDescrShort = vr.getDescriptionShort();
                    this.cciDescrLong = vr.getDescriptionLong();
                }
            }
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XEncounterRaison x = (XEncounterRaison)XEncounterRaison.class.cast(type);
            this.init(x);
            return this;
        }

        public XEncounterRaison x() {
            XEncounterRaison x = new XEncounterRaison();
            x.setId(this.getId());
            x.setReason(this.getReason());
            x.setVisitReason(this.visitReason);
            x.setIsDeleted(this.isStatusDeleted());
            this.setDescriptionOfObject();
            this.setTag();
            x.setTag(this.tag);
            x.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return x;
        }

        public XEncounterRaison convertx() {
            return this.x();
        }

        @Override
        public XCode getVisitReason() {
            return this.visitReason;
        }
    }

    public static final class EncounterBilling
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "version", "dxcode", "entryDate", "timeBilling", "cod1", "ctx1", "cod2", "ctx2", "cod3", "ctx3", "note", "deleted"};
        public Integer id;
        public String dxcode;
        public Long entryDate;
        public String entryDateS;
        public Long timeBilling;
        public String timeBillingS;
        public String cod1;
        public String ctx1;
        public String cod2;
        public String ctx2;
        public String cod3;
        public String ctx3;
        public String note;
        public String title = "Facturation";
        public Boolean deleted;
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Codes;Ctx", "Note"};

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public EncounterBilling() {
        }

        public EncounterBilling(XEncounterBilling n) {
            this.convertc(n);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[3];
            JoinList lstCod = new JoinList("/");
            if (StringUtils.isNotEmpty((String)this.cod1)) {
                if (StringUtils.isNotEmpty((String)this.ctx1)) {
                    lstCod.add((CharSequence)(this.cod1 + ";" + this.ctx1));
                } else {
                    lstCod.add((CharSequence)this.cod1);
                }
            }
            if (StringUtils.isNotEmpty((String)this.cod2)) {
                if (StringUtils.isNotEmpty((String)this.ctx2)) {
                    lstCod.add((CharSequence)(this.cod2 + ";" + this.ctx2));
                } else {
                    lstCod.add((CharSequence)this.cod2);
                }
            }
            if (StringUtils.isNotEmpty((String)this.cod3)) {
                if (StringUtils.isNotEmpty((String)this.ctx3)) {
                    lstCod.add((CharSequence)(this.cod3 + ";" + this.ctx3));
                } else {
                    lstCod.add((CharSequence)this.cod3);
                }
            }
            this.descr[0] = this.timeBillingS;
            this.descr[1] = lstCod.toString();
            this.descr[2] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public String getDxcode() {
            return this.dxcode;
        }

        public void setDxcode(String dxcode) {
            this.dxcode = dxcode;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public Long getTimeBilling() {
            return this.timeBilling;
        }

        public void setTimeBilling(Long timeBilling) {
            this.timeBilling = timeBilling;
        }

        public String getTimeBillingS() {
            return this.timeBillingS;
        }

        public void setTimeBillingS(String timeBillingS) {
            this.timeBillingS = timeBillingS;
        }

        public String getCod1() {
            return this.cod1;
        }

        public void setCod1(String cod1) {
            this.cod1 = cod1;
        }

        public String getCtx1() {
            return this.ctx1;
        }

        public void setCtx1(String ctx1) {
            this.ctx1 = ctx1;
        }

        public String getCod2() {
            return this.cod2;
        }

        public void setCod2(String cod2) {
            this.cod2 = cod2;
        }

        public String getCtx2() {
            return this.ctx2;
        }

        public void setCtx2(String ctx2) {
            this.ctx2 = ctx2;
        }

        public String getCod3() {
            return this.cod3;
        }

        public void setCod3(String cod3) {
            this.cod3 = cod3;
        }

        public String getCtx3() {
            return this.ctx3;
        }

        public void setCtx3(String ctx3) {
            this.ctx3 = ctx3;
        }

        public Boolean getDeleted() {
            return this.deleted;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public void init(XEncounterBilling x) {
            super.init(x);
            this.setId(x.getId());
            this.setDeleted(Boolean.TRUE.equals(x.getIsDeleted()));
            this.setEntryDate(x.getEntryDate());
            this.setEntryDateS(CEncounter.getStringDateTimeFromLong(x.getEntryDate()));
            this.setTimeBilling(x.getTimeBilling());
            this.setTimeBillingS(CEncounter.getStringDateTimeFromLong(x.getTimeBilling()));
            this.setDxcode(x.getDxcode());
            this.setCod1(x.getCod1());
            this.setCtx1(x.getCtx1());
            this.setCod2(x.getCod2());
            this.setCtx2(x.getCtx2());
            this.setCod3(x.getCod3());
            this.setCtx3(x.getCtx3());
            this.setNote(x.getNote());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XEncounterBilling x = (XEncounterBilling)XEncounterBilling.class.cast(type);
            this.init(x);
            return this;
        }

        public XEncounterBilling convertx() {
            Calendar dataStringToCalendar;
            XEncounterBilling x = new XEncounterBilling();
            x.setId(this.getId());
            x.setDxcode(this.getDxcode());
            if (StringUtils.isNotEmpty((String)this.entryDateS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.entryDateS.replaceAll("[// /:/-]", ""));
                x.setEntryDate(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            if (StringUtils.isNotEmpty((String)this.timeBillingS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.timeBillingS.replaceAll("[// /:/-]", ""));
                x.setTimeBilling(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            x.setCod1(this.getCod1());
            x.setCtx1(this.getCtx1());
            x.setCod2(this.getCod2());
            x.setCtx2(this.getCtx2());
            x.setCod3(this.getCod3());
            x.setCtx3(this.getCtx3());
            x.setNote(this.getNote());
            x.setNote(this.getNote());
            x.setIsDeleted(this.isStatusDeleted());
            this.setTag();
            x.setTag(this.tag);
            x.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return x;
        }
    }

    public static final class EncounterNote
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "version", "idNextModificationEntry", "entryDate", "note", "idProfessionnalAnchor", "noteType", "deleted", "idUserAnchor", "encLabelInt"};
        public Integer id;
        public Integer idNextModificationEntry;
        public Integer idProfessionnalAnchor;
        public String profNom;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Integer noteType;
        public String title = "Note de rencontre";
        public Boolean deleted;
        public Integer idUserAnchor;
        public Boolean isPrivate;
        public Boolean isReadOnly = Boolean.FALSE;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String[] descr;
        public String[] descrTitle = new String[]{"Type", "Prof", "Note"};

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public EncounterNote() {
        }

        public EncounterNote(XEncounterNote n) {
            this.convertc(n);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            XNoteType xNoteType = XNoteType.from(this.noteType);
            this.descr = new String[3];
            this.descr[0] = xNoteType == null ? "" : xNoteType.toString();
            this.descr[1] = this.profNom;
            this.descr[2] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public final void setIdProfessionnalAnchor(Integer id) {
            this.idProfessionnalAnchor = id;
        }

        public String getProfNom() {
            return this.profNom;
        }

        public void setProfNom(String profNom) {
            this.profNom = profNom;
            this.setDescriptionOfObject();
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public Integer getNoteType() {
            return this.noteType;
        }

        public void setNoteType(Integer noteType) {
            this.noteType = noteType;
        }

        public Integer getIdUserAnchor() {
            return this.idUserAnchor;
        }

        public void setIdUserAnchor(Integer idUserAnchor) {
            this.idUserAnchor = idUserAnchor;
        }

        public void init(XEncounterNote x) {
            super.init(x);
            this.setId(x.getId());
            this.setDeleted(Boolean.TRUE.equals(x.getIsDeleted()));
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setEntryDate(x.getEntryDatetime());
            this.setEntryDateS(CEncounter.getStringDateTimeFromLong(x.getEntryDatetime()));
            this.setNoteType(x.getType().getValue());
            this.setNote(x.getNote());
            this.setIdProfessionnalAnchor(x.getProfessionnal());
            this.setEncLabel((EnumSet<XEncounterLabel>)x.getEncLabel().clone());
            this.setDescriptionOfObject();
            this.idUserAnchor = x.getIdUserAnchor();
            this.isPrivate = this.idUserAnchor != null ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XEncounterNote x = (XEncounterNote)XEncounterNote.class.cast(type);
            this.init(x);
            return this;
        }

        public XEncounterNote convertx() {
            XEncounterNote x = new XEncounterNote();
            x.setId(this.getId());
            x.setIdNextModificationEntry(this.getIdNextModificationEntry());
            x.setEntryDatetime(this.getEntryDate());
            x.setType(XNoteType.from(this.getNoteType()));
            x.setNote(this.getNote());
            x.setIsDeleted(this.isStatusDeleted());
            x.setIdUserAnchor(this.getIdUserAnchor());
            x.setProfessionnal(this.getIdProfessionnalAnchor());
            x.setEncLabel((EnumSet<XEncounterLabel>)this.getEncLabel().clone());
            this.setTag();
            x.setTag(this.tag);
            x.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return x;
        }
    }

    public static final class PhysicalExam
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "timeVitalSign", "encLabelInt"};
        public Integer id;
        public Integer idAnchor;
        public Boolean deleted;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Long timeVitalSign;
        public String timeVitalSignS;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = "Autres mesures de l'examen physique";
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Note"};

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public PhysicalExam() {
        }

        public PhysicalExam(XPhysicalExamination c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[2];
            this.descr[0] = this.timeVitalSignS == null ? "" : this.timeVitalSignS;
            this.descr[1] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final Long getTimeVitalSign() {
            return this.timeVitalSign;
        }

        public final void setTimeVitalSign(Long timeVitalSign) {
            this.timeVitalSign = timeVitalSign;
            this.timeVitalSignS = CEncounter.getStringDateTimeFromLong(timeVitalSign);
        }

        public final String getTimeVitalSignS() {
            if (this.timeVitalSignS == null && this.timeVitalSign != null) {
                this.timeVitalSignS = CEncounter.getStringDateTimeFromLong(this.timeVitalSign);
            }
            return this.timeVitalSignS;
        }

        public final void setTimeVitalSignS(String timeVitalSignS) {
            this.timeVitalSignS = timeVitalSignS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public void init(XPhysicalExamination x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.deleted = x.getIsDeleted();
            this.setEntryDate(x.getEntryDatetime());
            this.setEntryDateS(CEncounter.getStringDateTimeFromLong(x.getEntryDatetime()));
            this.setTimeVitalSign(x.getTimeVitalSign());
            this.setTimeVitalSignS(CEncounter.getStringDateTimeFromLong(x.getTimeVitalSign()));
            this.setNote(x.getNote());
            this.setEncLabel((EnumSet<XEncounterLabel>)x.getEncLabel().clone());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XPhysicalExamination x = (XPhysicalExamination)XPhysicalExamination.class.cast(type);
            this.init(x);
            return this;
        }

        public XPhysicalExamination x() {
            Calendar dataStringToCalendar;
            XPhysicalExamination res = new XPhysicalExamination();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            if (StringUtils.isNotEmpty((String)this.timeVitalSignS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.timeVitalSignS.replaceAll("[// /:/-]", ""));
                res.setTimeVitalSign(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            if (StringUtils.isNotEmpty((String)this.entryDateS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.entryDateS.replaceAll("[// /:/-]", ""));
                res.setEntryDatetime(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XPhysicalExamination convertx() {
            return this.x();
        }
    }

    public static final class Measurement
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "height", "weight", "waistMeasurement", "headCirc", "nbJrsPremature", "timeVitalSign", "encLabelInt"};
        public Integer id;
        public Boolean deleted;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Double height;
        public Double weight;
        public Double waistMeasurement;
        public Double headCirc;
        public String heightS1;
        public String weightS2;
        public String waistMeasurementS1;
        public String headCircS1;
        public Integer nbJrsPremature;
        public Long timeVitalSign;
        public String timeVitalSignS;
        public Double IMC;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = Messages.getString("EncounterModificationRequestDAO.MESURES_CORPORELLES", new String[0]);
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", Messages.getString("Measurement.POIDS", new String[0]), Messages.getString("Measurement.TAILLE", new String[0]), Messages.getString("Measurement.TOUR_DE_TAILLE", new String[0]), Messages.getString("Measurement.PER_CR", new String[0]), Messages.getString("Measurement.JRS_PREM", new String[0]), Messages.getString("IMC", new String[0]), "Note"};

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Measurement() {
        }

        public Measurement(XMeasurement c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[8];
            this.descr[0] = this.timeVitalSignS == null ? "" : this.timeVitalSignS;
            this.descr[1] = this.weightS2 == null ? "" : this.weightS2 + " kg (" + String.format("%.1f", this.weight * 2.204622622) + " lbs)";
            this.descr[2] = this.heightS1 == null ? "" : this.heightS1 + " cm (" + String.format("%.1f", this.height * 0.3937007874) + " pce)";
            this.descr[3] = this.waistMeasurementS1 == null ? "" : this.waistMeasurementS1 + " cm (" + String.format("%.1f", this.waistMeasurement * 0.3937007874) + " pce)";
            this.descr[4] = this.headCircS1 == null ? "" : this.headCircS1 + " cm (" + String.format("%.1f", this.headCirc * 0.3937007874) + " pce)";
            String string = this.descr[5] = this.nbJrsPremature == null ? "" : this.nbJrsPremature.toString();
            if (this.weight != null && this.height != null) {
                this.IMC = MedCalc.IMC(Float.valueOf(this.weight.floatValue()), Float.valueOf(this.height.floatValue()));
                this.descr[6] = this.IMC == null ? "" : String.format("%.1f", this.IMC);
            } else {
                this.descr[6] = "";
            }
            this.descr[7] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final Long getTimeVitalSign() {
            return this.timeVitalSign;
        }

        public final void setTimeVitalSign(Long timeVitalSign) {
            this.timeVitalSign = timeVitalSign;
            this.timeVitalSignS = CEncounter.getStringDateTimeFromLong(timeVitalSign);
        }

        public final String getTimeVitalSignS() {
            if (this.timeVitalSignS == null && this.timeVitalSign != null) {
                this.timeVitalSignS = CEncounter.getStringDateTimeFromLong(this.timeVitalSign);
            }
            return this.timeVitalSignS;
        }

        public final void setTimeVitalSignS(String timeVitalSignS) {
            this.timeVitalSignS = timeVitalSignS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Double getHeight() {
            return this.height;
        }

        public final void setHeight(Double height) {
            this.height = height;
        }

        public final Double getWeight() {
            return this.weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        public final Double getWaistMeasurement() {
            return this.waistMeasurement;
        }

        public final void setWaistMeasurement(Double waistMeasurement) {
            this.waistMeasurement = waistMeasurement;
        }

        public String getHeightS1() {
            return this.heightS1;
        }

        public void setHeightS1(String heightS1) {
            this.heightS1 = heightS1;
        }

        public String getWeightS2() {
            return this.weightS2;
        }

        public void setWeightS2(String weightS1) {
            this.weightS2 = weightS1;
        }

        public String getWaistMeasurementS1() {
            return this.waistMeasurementS1;
        }

        public void setWaistMeasurementS1(String waistMeasurementS1) {
            this.waistMeasurementS1 = waistMeasurementS1;
        }

        public String getHeadCircS1() {
            return this.headCircS1;
        }

        public void setHeadCircS1(String headCircS1) {
            this.headCircS1 = headCircS1;
        }

        public final Double getHeadCirc() {
            return this.headCirc;
        }

        public final void setHeadCirc(Double headCirc) {
            this.headCirc = headCirc;
        }

        public final Integer getNbJrsPremature() {
            return this.nbJrsPremature;
        }

        public final void setNbJrsPremature(Integer nbJrsPremature) {
            this.nbJrsPremature = nbJrsPremature;
        }

        public void init(XMeasurement x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.deleted = x.getIsDeleted();
            this.setEntryDate(x.getEntryDatetime());
            this.setEntryDateS(CEncounter.getStringDateTimeFromLong(x.getEntryDatetime()));
            this.setTimeVitalSign(x.getTimeVitalSign());
            this.setTimeVitalSignS(CEncounter.getStringDateTimeFromLong(x.getTimeVitalSign()));
            Double d = x.getHeight() == null ? null : new Double(x.getHeight().doubleValue());
            this.setHeight(d);
            if (d != null) {
                this.setHeightS1(String.format("%.1f", d));
            }
            d = x.getWeight() == null ? null : new Double(x.getWeight().doubleValue());
            this.setWeight(d);
            if (d != null) {
                this.setWeightS2(String.format("%.2f", d));
            }
            d = x.getWaistMeasurement() == null ? null : new Double(x.getWaistMeasurement().doubleValue());
            this.setWaistMeasurement(d);
            if (d != null) {
                this.setWaistMeasurementS1(String.format("%.1f", d));
            }
            d = x.getHeadCirc() == null ? null : new Double(x.getHeadCirc().doubleValue());
            this.setHeadCirc(d);
            if (d != null) {
                this.setHeadCircS1(String.format("%.1f", d));
            }
            this.setNbJrsPremature(x.getNbJrsPremature());
            this.setNote(x.getNote());
            this.setEncLabel((EnumSet<XEncounterLabel>)x.getEncLabel().clone());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XMeasurement x = (XMeasurement)XMeasurement.class.cast(type);
            this.init(x);
            return this;
        }

        public XMeasurement x() {
            Calendar dataStringToCalendar;
            XMeasurement x = new XMeasurement();
            x.id = this.id;
            x.setIdAnchor(this.idAnchor);
            x.setIdNextModificationEntry(this.idNextModificationEntry);
            if (StringUtils.isNotEmpty((String)this.heightS1)) {
                x.height = new Float(this.heightS1.replace(',', '.'));
            }
            if (StringUtils.isNotEmpty((String)this.weightS2)) {
                x.weight = new Float(this.weightS2.replace(',', '.'));
            }
            if (StringUtils.isNotEmpty((String)this.waistMeasurementS1)) {
                x.waistMeasurement = new Float(this.waistMeasurementS1.replace(',', '.'));
            }
            if (StringUtils.isNotEmpty((String)this.headCircS1)) {
                x.headCirc = new Float(this.headCircS1.replace(',', '.'));
            }
            if (StringUtils.isNotEmpty((String)this.timeVitalSignS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.timeVitalSignS.replaceAll("[// /:/-]", ""));
                x.setTimeVitalSign(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            if (StringUtils.isNotEmpty((String)this.entryDateS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.entryDateS.replaceAll("[// /:/-]", ""));
                x.setEntryDatetime(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            x.setIsDeleted(this.isStatusDeleted());
            x.entryDatetime = this.entryDate;
            x.note = this.note;
            x.nbJrsPremature = this.nbJrsPremature;
            x.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            x.setTag(this.tag);
            x.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return x;
        }

        public XMeasurement convertx() {
            return this.x();
        }
    }

    public static final class Freq
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "respiration", "timeVitalSign", "encLabelInt"};
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Boolean deleted;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Integer respiration;
        public Long timeVitalSign;
        public String timeVitalSignS;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = Messages.getString("FREQUENCES_RESPIRATOIRES", new String[0]);
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Freq", "Note"};

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Freq() {
        }

        public Freq(XFrequency c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[3];
            this.descr[0] = this.timeVitalSignS == null ? "" : this.timeVitalSignS;
            this.descr[1] = this.respiration == null ? "" : this.respiration.toString();
            this.descr[2] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Integer getRespiration() {
            return this.respiration;
        }

        public final void setRespiration(Integer respiration) {
            this.respiration = respiration;
        }

        public final Long getTimeVitalSign() {
            return this.timeVitalSign;
        }

        public final void setTimeVitalSign(Long timeVitalSign) {
            this.timeVitalSign = timeVitalSign;
        }

        public final String getTimeVitalSignS() {
            return this.timeVitalSignS;
        }

        public final void setTimeVitalSignS(String timeVitalSignS) {
            this.timeVitalSignS = timeVitalSignS;
        }

        public void init(XFrequency x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.deleted = x.getIsDeleted();
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setEntryDate(x.getEntryDatetime());
            this.setEntryDateS(CEncounter.getStringDateTimeFromLong(x.getEntryDatetime()));
            this.setTimeVitalSign(x.getTimeVitalSign());
            this.setTimeVitalSignS(CEncounter.getStringDateTimeFromLong(x.getTimeVitalSign()));
            this.setRespiration(x.getRespiration());
            this.setNote(x.getNote());
            this.setEncLabel((EnumSet<XEncounterLabel>)x.getEncLabel().clone());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XFrequency x = (XFrequency)XFrequency.class.cast(type);
            this.init(x);
            return this;
        }

        public XFrequency x() {
            Calendar dataStringToCalendar;
            XFrequency res = new XFrequency();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setRespiration(this.respiration);
            if (StringUtils.isNotEmpty((String)this.timeVitalSignS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.timeVitalSignS.replaceAll("[// /:/-]", ""));
                res.setTimeVitalSign(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            if (StringUtils.isNotEmpty((String)this.entryDateS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.entryDateS.replaceAll("[// /:/-]", ""));
                res.setEntryDatetime(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XFrequency convertx() {
            return this.x();
        }
    }

    public static final class BodyTemp
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "bodyTemperature", "bodyTemperatureType", "timeVitalSign", "encLabelInt"};
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Boolean deleted;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Double bodyTemperature;
        public Integer bodyTemperatureType;
        public Long timeVitalSign;
        public String timeVitalSignS;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = Messages.getString("TEMPERATURE", new String[0]);
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Temp", "Type", "Note"};

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public BodyTemp() {
        }

        public BodyTemp(XBodyTemperature c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[4];
            this.descr[0] = this.timeVitalSignS == null ? "" : this.timeVitalSignS;
            this.descr[1] = this.bodyTemperature == null ? "" : this.bodyTemperature.toString();
            this.descr[2] = XBodyTemperatureType.from(this.bodyTemperatureType).toString();
            this.descr[3] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Double getBodyTemperature() {
            return this.bodyTemperature;
        }

        public final void setBodyTemperature(Double bodyTemperature) {
            this.bodyTemperature = bodyTemperature;
        }

        public final Integer getBodyTemperatureType() {
            return this.bodyTemperatureType;
        }

        public final void setBodyTemperatureType(Integer bodyTemperatureType) {
            this.bodyTemperatureType = bodyTemperatureType;
        }

        public final Long getTimeVitalSign() {
            return this.timeVitalSign;
        }

        public final void setTimeVitalSign(Long timeVitalSign) {
            this.timeVitalSign = timeVitalSign;
        }

        public final String getTimeVitalSignS() {
            return this.timeVitalSignS;
        }

        public final void setTimeVitalSignS(String timeVitalSignS) {
            this.timeVitalSignS = timeVitalSignS;
        }

        public void init(XBodyTemperature x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.deleted = x.getIsDeleted();
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setEntryDate(x.getEntryDatetime());
            this.setEntryDateS(CEncounter.getStringDateTimeFromLong(x.getEntryDatetime()));
            this.setTimeVitalSign(x.getTimeVitalSign());
            this.setTimeVitalSignS(CEncounter.getStringDateTimeFromLong(x.getTimeVitalSign()));
            this.setBodyTemperature(x.getBodyTemperature());
            this.setBodyTemperatureType(x.getBodyTemperatureType().getValue());
            this.setNote(x.getNote());
            this.setEncLabel((EnumSet<XEncounterLabel>)x.getEncLabel().clone());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XBodyTemperature x = (XBodyTemperature)XBodyTemperature.class.cast(type);
            this.init(x);
            return this;
        }

        public XBodyTemperature x() {
            Calendar dataStringToCalendar;
            XBodyTemperature res = new XBodyTemperature();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setBodyTemperature(this.bodyTemperature);
            res.setBodyTemperatureType(XBodyTemperatureType.from(this.bodyTemperatureType));
            if (StringUtils.isNotEmpty((String)this.timeVitalSignS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.timeVitalSignS.replaceAll("[// /:/-]", ""));
                res.setTimeVitalSign(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            if (StringUtils.isNotEmpty((String)this.entryDateS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.entryDateS.replaceAll("[// /:/-]", ""));
                res.setEntryDatetime(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XBodyTemperature convertx() {
            return this.x();
        }
    }

    public static final class BloodPres
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "systolic", "diastolic", "pulse", "saturation", "timeVitalSign", "encLabelInt"};
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Integer systolic;
        public Integer diastolic;
        public Integer pulse;
        public Integer saturation;
        public Boolean deleted;
        public Long timeVitalSign;
        public String timeVitalSignS;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = Messages.getString("TENSION_ARTERIELLES", new String[0]);
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", Messages.getString("TAS", new String[0]) + "/" + Messages.getString("TAD", new String[0]), Messages.getString("POULS", new String[0]), "Saturation", "Note"};

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public BloodPres() {
        }

        public BloodPres(XBloodPressure c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[5];
            this.descr[0] = this.timeVitalSignS == null ? "" : this.timeVitalSignS;
            this.descr[1] = (this.systolic == null ? "-" : this.systolic) + "/" + (this.diastolic == null ? "-" : this.diastolic);
            this.descr[2] = this.pulse == null ? "-" : this.pulse.toString() + "/min";
            this.descr[3] = this.saturation == null ? "-" : this.saturation.toString() + "%";
            this.descr[4] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
            this.entryDateS = CEncounter.getStringDateTimeFromLong(entryDate);
        }

        public final String getEntryDateS() {
            if (this.entryDateS == null && this.entryDate != null) {
                this.entryDateS = CEncounter.getStringDateTimeFromLong(this.entryDate);
            }
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Integer getSystolic() {
            return this.systolic;
        }

        public final void setSystolic(Integer systolic) {
            this.systolic = systolic;
        }

        public final Integer getDiastolic() {
            return this.diastolic;
        }

        public final void setDiastolic(Integer diastolic) {
            this.diastolic = diastolic;
        }

        public final Integer getPulse() {
            return this.pulse;
        }

        public final void setPulse(Integer pulse) {
            this.pulse = pulse;
        }

        public Integer getSaturation() {
            return this.saturation;
        }

        public void setSaturation(Integer saturation) {
            this.saturation = saturation;
        }

        public final Long getTimeVitalSign() {
            return this.timeVitalSign;
        }

        public final void setTimeVitalSign(Long timeVitalSign) {
            this.timeVitalSign = timeVitalSign;
            this.timeVitalSignS = CEncounter.getStringDateTimeFromLong(timeVitalSign);
        }

        public final String getTimeVitalSignS() {
            if (this.timeVitalSignS == null && this.timeVitalSign != null) {
                this.timeVitalSignS = CEncounter.getStringDateTimeFromLong(this.timeVitalSign);
            }
            return this.timeVitalSignS;
        }

        public final void setTimeVitalSignS(String timeVitalSignS) {
            this.timeVitalSignS = timeVitalSignS;
        }

        public void init(XBloodPressure x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.deleted = x.getIsDeleted();
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setEntryDate(x.getEntryDatetime());
            this.setEntryDateS(CEncounter.getStringDateTimeFromLong(x.getEntryDatetime()));
            this.setTimeVitalSign(x.getTimeVitalSign());
            this.setTimeVitalSignS(CEncounter.getStringDateTimeFromLong(x.getTimeVitalSign()));
            this.setSystolic(x.getSystolic());
            this.setDiastolic(x.getDiastolic());
            this.setPulse(x.getPulse());
            this.setSaturation(x.getSaturation());
            this.setNote(x.getNote());
            this.setEncLabel((EnumSet<XEncounterLabel>)x.getEncLabel().clone());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XBloodPressure x = (XBloodPressure)XBloodPressure.class.cast(type);
            this.init(x);
            return this;
        }

        public XBloodPressure x() {
            Calendar dataStringToCalendar;
            XBloodPressure res = new XBloodPressure();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setPulse(this.pulse);
            res.setSaturation(this.saturation);
            res.setSystolic(this.systolic);
            res.setDiastolic(this.diastolic);
            if (StringUtils.isNotEmpty((String)this.timeVitalSignS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.timeVitalSignS.replaceAll("[// /:/-]", ""));
                res.setTimeVitalSign(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            if (StringUtils.isNotEmpty((String)this.entryDateS)) {
                dataStringToCalendar = DateUtil.dataStringToCalendar((String)this.entryDateS.replaceAll("[// /:/-]", ""));
                res.setEntryDatetime(dataStringToCalendar == null ? null : Long.valueOf(dataStringToCalendar.getTimeInMillis()));
            }
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XBloodPressure convertx() {
            return this.x();
        }
    }

    public static final class Immunizations
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "code", "vaccineName", "vaccinationDate", "refused", "codeId", "descrShort", "descrLong", "showInPatientSummary", "deleted", "encLabelInt"};
        public static Comparator<Immunizations> compare = new Comparator<Immunizations>(){

            @Override
            public int compare(Immunizations o1, Immunizations o2) {
                int c = ObjectUtils.compare((Comparable)((Object)o2.entryDateSD), (Comparable)((Object)o1.entryDateSD));
                return c == 0 ? ObjectUtils.compare((Comparable)((Object)o1.descr[1].toLowerCase()), (Comparable)((Object)o2.descr[1].toLowerCase())) : c;
            }
        };
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateSD;
        public String note;
        public String code;
        public String vaccineName;
        public Long vaccinationDate;
        public String vaccinationDateSP;
        public Boolean refused;
        public Integer codeId;
        public String descrShort;
        public String descrLong;
        public Boolean showInPatientSummary;
        public Boolean deleted;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = "Immunisations";
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", DETAILS, "\u00c9tat"};

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public Immunizations() {
        }

        public Immunizations(XImmunization c) {
            this.convertc(c);
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof Immunizations) {
                equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
            }
            return equals;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = this.getId() == null ? super.hashCode() : ("Immunizations" + this.getId().hashCode()).hashCode();
            return hashCode;
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[4];
            this.descr[0] = this.vaccinationDateSP == null ? "" : this.vaccinationDateSP;
            ArrayList<String> lst = new ArrayList<String>(4);
            if (StringUtils.isNotEmpty((String)this.getDescrShort())) {
                lst.add(this.getDescrShort());
            }
            if (StringUtils.isNotEmpty((String)this.getVaccineName())) {
                lst.add(this.getVaccineName());
            }
            if (StringUtils.isNotEmpty((String)this.getNote())) {
                lst.add(this.getNote());
            }
            this.descr[1] = new JoinList(", ", lst).toString();
            this.descr[2] = Boolean.TRUE.equals(this.refused) ? Messages.getString("preventactiontype.REFUSE", new String[0]) : Messages.getString("preventactiontype.DONE", new String[0]);
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateSD() {
            return this.entryDateSD;
        }

        public final void setEntryDateSD(String entryDateS) {
            this.entryDateSD = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public final String getVaccineName() {
            return this.vaccineName;
        }

        public final void setVaccineName(String vaccineName) {
            this.vaccineName = vaccineName;
        }

        public final Long getVaccinationDate() {
            return this.vaccinationDate;
        }

        public final void setVaccinationDate(Long vaccinationDate) {
            this.vaccinationDate = vaccinationDate;
        }

        public final String getVaccinationDateSP() {
            return this.vaccinationDateSP;
        }

        public final void setVaccinationDateSP(String vaccinationDateS) {
            this.vaccinationDateSP = vaccinationDateS;
        }

        public final Boolean getRefused() {
            return this.refused;
        }

        public final void setRefused(Boolean refused) {
            this.refused = refused;
        }

        public Boolean getShowInPatientSummary() {
            return this.showInPatientSummary;
        }

        public void setShowInPatientSummary(Boolean showInPatientSummary) {
            this.showInPatientSummary = showInPatientSummary;
        }

        public final Integer getCodeId() {
            return this.codeId;
        }

        public final void setCodeId(Integer codeId) {
            this.codeId = codeId;
        }

        public final String getDescrShort() {
            return this.descrShort;
        }

        public final void setDescrShort(String descrShortFr) {
            this.descrShort = descrShortFr;
        }

        public final String getDescrLong() {
            return this.descrLong;
        }

        public final void setDescrLong(String descrLongFr) {
            this.descrLong = descrLongFr;
        }

        public void init(XImmunization x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setShowInPatientSummary(x.getShowInPatientSummary());
            this.setEntryDate(x.getEntryDate().toTimeInMillisUTC());
            this.setEntryDateSD(x.getEntryDate().formatHyphen());
            if (x.getVaccinationDate() != null) {
                this.setVaccinationDate(x.getVaccinationDate().toAbsoluteDate().toTimeInMillisUTC());
                this.setVaccinationDateSP(x.getVaccinationDate().formatHyphen());
            }
            if (x.getCode() != null) {
                this.setCodeId(x.getCode().getId());
                this.setCode(x.getCode().getCode());
                this.setDescrShort(x.getCode().getDescriptionShort());
                this.setDescrLong(x.getCode().getDescriptionLong());
            }
            this.setVaccineName(x.getVaccineName());
            this.setNote(x.getNote());
            this.setRefused(x.getRefused());
            this.deleted = x.getIsDeleted();
            this.setEncLabel((EnumSet<XEncounterLabel>)x.getEncLabel().clone());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XImmunization x = (XImmunization)XImmunization.class.cast(type);
            this.init(x);
            return this;
        }

        public XImmunization x() {
            XImmunization res = new XImmunization();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setShowInPatientSummary(this.showInPatientSummary);
            res.setVaccineName(this.vaccineName);
            if (StringUtils.isNotEmpty((String)this.vaccinationDateSP)) {
                res.setVaccinationDate(MiscUtil.getPartialDate(this.vaccinationDateSP.trim()));
            } else if (this.vaccinationDate != null) {
                res.setVaccinationDate((IPartialDate)LocalDate.fromTimeInMillisLOCAL((Long)this.vaccinationDate));
            }
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            res.setEntryDate(LocalDate.fromTimeInMillisUTC((Long)this.entryDate));
            if (this.codeId != null) {
                XCode c = new XCode();
                c.setId(this.codeId);
                c.setCode(this.getCode());
                c.setClassification(XCodeClassification.IMMUNIZATION);
                c.setDescriptionShort(this.descrShort);
                c.setDescriptionLong(this.descrLong);
                res.setCode(c);
            } else {
                res.setCode(null);
            }
            res.setVaccineName(this.getVaccineName());
            res.setRefused(this.refused);
            res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XImmunization convertx() {
            return this.x();
        }
    }

    public static final class Docs
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idProfessionnalAnchor", "version", "entryDate", "atype", "idDocument", "description"};
        public Integer id;
        public Integer idProfessionnalAnchor;
        public Boolean deleted;
        public Long entryDate;
        public String entryDateS;
        public Integer atype;
        public Integer idDocument;
        public String description;
        public String title = "Documents li\u00e9s";
        public String[] descr;
        public String[] descrTitle = new String[]{"Type", "Nom"};

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Docs() {
        }

        public Docs(XDocuments c) {
            this.convertc(c);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[2];
            this.descr[0] = XDocumentType.from(this.atype).toString();
            this.descr[1] = this.description;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final Integer getAtype() {
            return this.atype;
        }

        public final void setAtype(Integer atype) {
            this.atype = atype;
        }

        public final Integer getIdDocument() {
            return this.idDocument;
        }

        public final void setIdDocument(Integer idDocument) {
            this.idDocument = idDocument;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public void init(XDocuments x) {
            super.init(x);
            this.setId(x.getId());
            this.deleted = x.getIsDeleted();
            this.setEntryDate(x.getEntryDate().toTimeInMillisUTC());
            this.setEntryDateS(x.getEntryDate().formatHyphen());
            this.setDescription(x.getDescription());
            this.setIdDocument(x.getIdDocument());
            this.setAtype(x.getType().getValue());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XDocuments x = (XDocuments)XDocuments.class.cast(type);
            this.init(x);
            return this;
        }

        public XDocuments x() {
            XDocuments res = new XDocuments();
            res.setId(this.id);
            res.setType(XDocumentType.from(this.atype));
            res.setDescription(this.description);
            res.setIdDocument(this.idDocument);
            res.setIsDeleted(this.isStatusDeleted());
            res.setEntryDate(LocalDate.fromTimeInMillisUTC((Long)this.entryDate));
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XDocuments convertx() {
            return this.x();
        }
    }

    public static final class Rappels
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "rappelDate", "isResolve", "deleted", "encLabelInt"};
        public static Comparator<Rappels> compare = new Comparator<Rappels>(){

            @Override
            public int compare(Rappels o1, Rappels o2) {
                int c = ObjectUtils.compare((Comparable)((Object)o2.entryDateSD), (Comparable)((Object)o1.entryDateSD));
                if (c == 0) {
                    String s1 = o1.descr[0] + o1.descr[1].toLowerCase();
                    String s2 = o2.descr[0] + o2.descr[1].toLowerCase();
                    if (Boolean.FALSE.equals(o1.getIsDone()) && Boolean.FALSE.equals(o2.getIsDone())) {
                        return ObjectUtils.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
                    }
                    c = ObjectUtils.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
                }
                return c;
            }
        };
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateSD;
        public String note;
        public Long rappelDate;
        public String rappelDateSP;
        public Integer isResolve;
        public Boolean isDone;
        public Boolean isHisto;
        public Boolean deleted;
        public String title = "Rappels cliniques";
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Note"};

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public Rappels() {
        }

        public Rappels(XRappel c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[2];
            this.descr[0] = this.rappelDateSP == null ? "" : this.rappelDateSP;
            this.descr[1] = this.note;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateSD() {
            return this.entryDateSD;
        }

        public final void setEntryDateSD(String entryDateS) {
            this.entryDateSD = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Long getRappelDate() {
            return this.rappelDate;
        }

        public final void setRappelDate(Long rappelDate) {
            this.rappelDate = rappelDate;
        }

        public final String getRappelDateSP() {
            return this.rappelDateSP;
        }

        public final void setRappelDateSP(String rappelDateS) {
            this.rappelDateSP = rappelDateS;
        }

        public final Integer getIsResolve() {
            return this.isResolve;
        }

        public final void setIsResolve(Integer isResolve) {
            if (isResolve != null) {
                this.isDone = (isResolve & XRappelResolvedStatus.REGLE.getValue()) == 1;
                this.isHisto = (isResolve & XRappelResolvedStatus.HISTORIQUE.getValue()) == 2;
            }
            this.isResolve = isResolve;
        }

        public Boolean getIsDone() {
            return this.isDone;
        }

        public void setIsDone(Boolean isResolveB) {
            this.isDone = isResolveB;
        }

        public Boolean getIsHisto() {
            return this.isHisto;
        }

        public void setIsHisto(Boolean isHisto) {
            this.isHisto = isHisto;
        }

        public boolean isIsHistorized() {
            return Boolean.TRUE.equals(this.isHisto);
        }

        public boolean isDone() {
            return Boolean.TRUE.equals(this.isDone);
        }

        public void init(XRappel x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setEntryDate(x.getEntryDate().toTimeInMillisUTC());
            this.setEntryDateSD(x.getEntryDate().formatHyphen());
            this.setNote(x.getNote());
            if (x.getDateRappel() != null) {
                this.setRappelDate(x.getDateRappel().toAbsoluteDate().toTimeInMillisUTC());
                this.setRappelDateSP(x.getDateRappel().formatHyphen());
            }
            this.deleted = x.getIsDeleted();
            this.setIsDone(x.getResolvedStatus().contains(XRappelResolvedStatus.REGLE));
            this.setIsHisto(x.getResolvedStatus().contains(XRappelResolvedStatus.HISTORIQUE));
            this.setEncLabel((EnumSet<XEncounterLabel>)x.encLabel.clone());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XRappel x = (XRappel)XRappel.class.cast(type);
            this.init(x);
            return this;
        }

        public XRappel x() {
            XRappel res = new XRappel();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            EnumSet<XRappelResolvedStatus> resolved = EnumSet.noneOf(XRappelResolvedStatus.class);
            if (Boolean.TRUE.equals(this.getIsDone())) {
                resolved.add(XRappelResolvedStatus.REGLE);
            }
            if (Boolean.TRUE.equals(this.getIsHisto())) {
                resolved.add(XRappelResolvedStatus.HISTORIQUE);
            }
            res.setResolvedStatus(resolved);
            if (StringUtils.isNotEmpty((String)this.rappelDateSP)) {
                res.setDateRappel(MiscUtil.getPartialDate(this.rappelDateSP.trim()));
            } else if (this.rappelDate != null) {
                res.setDateRappel((IPartialDate)LocalDate.fromTimeInMillisLOCAL((Long)this.rappelDate));
            }
            res.setEntryDate(LocalDate.fromTimeInMillisUTC((Long)this.entryDate));
            res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XRappel convertx() {
            return this.x();
        }
    }

    public static final class Prevents
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "preventDate", "atype", "isDone", "deleted", "encLabelInt"};
        public static Comparator<Prevents> compare = new Comparator<Prevents>(){

            @Override
            public int compare(Prevents o1, Prevents o2) {
                int c = ObjectUtils.compare((Comparable)((Object)o2.entryDateS), (Comparable)((Object)o1.entryDateS));
                return c == 0 ? ObjectUtils.compare((Comparable)((Object)o1.descr[1].toLowerCase()), (Comparable)((Object)o2.descr[1].toLowerCase())) : c;
            }
        };
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Long preventDate;
        public String preventDateSP;
        public Integer atype;
        public XPreventType type;
        public Integer isDone;
        public Boolean deleted;
        public XPreventActionType actionType;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = "Examens de pr\u00e9vention";
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Type", "Note", "Fait"};

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public Prevents() {
        }

        public Prevents(XPrevent c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[4];
            this.descr[0] = this.preventDateSP == null ? "" : this.preventDateSP;
            this.descr[1] = XPreventType.from(this.atype).toString();
            this.descr[2] = this.note;
            this.descr[3] = Integer.valueOf(1).equals(this.isDone) ? "Oui" : "Non";
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Long getPreventDate() {
            return this.preventDate;
        }

        public final void setPreventDate(Long preventDate) {
            this.preventDate = preventDate;
        }

        public final String getPreventDateSP() {
            return this.preventDateSP;
        }

        public final void setPreventDateSP(String preventDateS) {
            this.preventDateSP = preventDateS;
        }

        public final Integer getAtype() {
            return this.atype;
        }

        public final void setAtype(Integer atype) {
            this.atype = atype;
            this.type = XPreventType.from(atype);
        }

        public final Integer getIsDone() {
            return this.isDone;
        }

        public final void setIsDone(Integer isDone) {
            this.isDone = isDone;
            this.actionType = XPreventActionType.from(isDone);
        }

        public XPreventType getType() {
            return this.type;
        }

        public void setType(XPreventType type) {
            this.type = type;
        }

        public XPreventActionType getActionType() {
            return this.actionType;
        }

        public void setActionType(XPreventActionType actionType) {
            this.actionType = actionType;
        }

        public void init(XPrevent x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.deleted = x.getIsDeleted();
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XPrevent x = (XPrevent)XPrevent.class.cast(type);
            this.init(x);
            return this;
        }

        public XPrevent x() {
            XPrevent res = new XPrevent();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            res.setActionType(this.actionType);
            res.setType(this.type);
            res.setEntryDate(LocalDate.fromTimeInMillisUTC((Long)this.entryDate));
            res.setDatePrevent(LocalDate.fromTimeInMillisUTC((Long)this.preventDate));
            res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XPrevent convertx() {
            return this.x();
        }
    }

    public static final class LifeHabits
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "typeHabit", "frequency", "startDate", "endDate", "deleted", "encLabelInt"};
        public static Comparator<LifeHabits> compare = new Comparator<LifeHabits>(){

            @Override
            public int compare(LifeHabits o1, LifeHabits o2) {
                int c = ObjectUtils.compare((Comparable)((Object)o2.entryDateSD), (Comparable)((Object)o1.entryDateSD));
                return c == 0 ? ObjectUtils.compare((Comparable)((Object)o1.descr[1].toLowerCase()), (Comparable)((Object)o2.descr[1].toLowerCase())) : c;
            }
        };
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateSD;
        public String note;
        public Integer typeHabit;
        public Integer frequency;
        public Long startDate;
        public String startDateSP;
        public Long endDate;
        public String endDateSP;
        public Boolean deleted;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = "Habitus";
        public String[] descr;
        public String[] descrTitle = new String[]{"Type", "Fr\u00e9q", "Note", "D\u00e9but", "Fin"};

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public LifeHabits() {
        }

        public LifeHabits(XLifeHabit c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            XLifeHabitType xLifeHabitType = XLifeHabitType.from(this.typeHabit);
            this.descr = new String[5];
            this.descr[0] = xLifeHabitType == null ? "" : xLifeHabitType.toString();
            this.descr[1] = xLifeHabitType == null || this.frequency == null ? "" : XLifeHabitFrequency.from(this.frequency).toString(xLifeHabitType);
            this.descr[2] = this.note;
            this.descr[3] = this.startDateSP == null ? "" : this.startDateSP;
            this.descr[4] = this.endDateSP == null ? "" : this.endDateSP;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateSD() {
            return this.entryDateSD;
        }

        public final void setEntryDateSD(String entryDateS) {
            this.entryDateSD = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Integer getTypeHabit() {
            return this.typeHabit;
        }

        public final void setTypeHabit(Integer typeHabit) {
            this.typeHabit = typeHabit;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final Long getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Long startDate) {
            this.startDate = startDate;
        }

        public final String getStartDateSP() {
            return this.startDateSP;
        }

        public final void setStartDateSP(String startDateS) {
            this.startDateSP = startDateS;
        }

        public final Long getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Long endDate) {
            this.endDate = endDate;
        }

        public final String getEndDateSP() {
            return this.endDateSP;
        }

        public final void setEndDateSP(String endDateS) {
            this.endDateSP = endDateS;
        }

        public void init(XLifeHabit x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setTypeHabit(x.getType() == null ? null : Integer.valueOf(x.getType().getValue()));
            this.setFrequency(x.getFrequency() == null ? null : Integer.valueOf(x.getFrequency().getValue()));
            this.setNote(x.getNote());
            this.setEntryDateSD(x.getEntryDate().formatHyphen());
            if (x.getStartDate() != null) {
                this.setStartDate(x.getStartDate().toAbsoluteDate().toTimeInMillisUTC());
                this.setStartDateSP(x.getStartDate().formatHyphen());
            }
            if (x.getEndDate() != null) {
                this.setEndDate(x.getEndDate().toAbsoluteDate().toTimeInMillisUTC());
                this.setEndDateSP(x.getEndDate().formatHyphen());
            }
            this.deleted = x.getIsDeleted();
            this.setEncLabel((EnumSet<XEncounterLabel>)x.encLabel.clone());
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XLifeHabit x = (XLifeHabit)XLifeHabit.class.cast(type);
            this.init(x);
            return this;
        }

        public XLifeHabit x() {
            XLifeHabit res = new XLifeHabit();
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setType(XLifeHabitType.from(this.typeHabit));
            res.setFrequency(XLifeHabitFrequency.from(this.frequency));
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            res.setEntryDate(LocalDate.fromTimeInMillisUTC((Long)this.entryDate));
            if (StringUtils.isNotEmpty((String)this.startDateSP)) {
                res.setStartDate(MiscUtil.getPartialDate(this.startDateSP.trim()));
            } else if (this.startDate != null) {
                res.setStartDate((IPartialDate)LocalDate.fromTimeInMillisLOCAL((Long)this.startDate));
            }
            if (StringUtils.isNotEmpty((String)this.endDateSP)) {
                res.setEndDate(MiscUtil.getPartialDate(this.endDateSP.trim()));
            } else if (this.endDate != null) {
                res.setEndDate(GenericDataMapping.getPartialDateFromLong(this.endDate));
            }
            res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XLifeHabit convertx() {
            return this.x();
        }
    }

    public static final class Interventions
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "codeId", "code", "descrShort", "descrLong", "sinceDate", "deleted", "encLabelInt", "importance"};
        public static Comparator<Interventions> compare = new Comparator<Interventions>(){

            @Override
            public int compare(Interventions o1, Interventions o2) {
                int c = ObjectUtils.compare((Comparable)o2.importance, (Comparable)o1.importance);
                c = c == 0 ? ObjectUtils.compare((Comparable)((Object)o2.entryDateSD), (Comparable)((Object)o1.entryDateSD)) : c;
                return c == 0 ? ObjectUtils.compare((Comparable)((Object)o1.descr[1].toLowerCase()), (Comparable)((Object)o2.descr[1].toLowerCase())) : c;
            }
        };
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateSD;
        public Integer importance;
        public Integer importanceTemp;
        public String note;
        public Integer codeId;
        public String code;
        public String descrShort;
        public String descrLong;
        public Long sinceDate;
        public String sinceDateSP;
        public Boolean deleted;
        public Integer encLabelInt;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = "Interventions";
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Intervention"};

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public Interventions() {
        }

        public Interventions(XIntervention c) {
            this.convertc(c);
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public Integer getEncLabelInt() {
            return this.encLabel == null ? null : EnumWithValues.toSet(this.encLabel);
        }

        public void setEncLabelInt(Integer status) {
            this.encLabel = status != null ? EnumWithValues.fromSet(XEncounterLabel.class, status) : EnumSet.noneOf(XEncounterLabel.class);
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[3];
            String v1 = StringUtils.isNotEmpty((String)this.descrShort) ? this.descrShort + (StringUtils.isBlank((CharSequence)this.note) ? "" : " - ") : "";
            this.descr[0] = this.sinceDateSP == null ? "" : this.sinceDateSP;
            this.descr[1] = (StringUtils.isNotEmpty((String)v1) ? v1 : "") + (StringUtils.isBlank((CharSequence)this.note) ? "" : this.note);
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateSD() {
            return this.entryDateSD;
        }

        public final void setEntryDateSD(String entryDateS) {
            this.entryDateSD = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final Integer getCodeId() {
            return this.codeId;
        }

        public final void setCodeId(Integer codeId) {
            this.codeId = codeId;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDescrShort() {
            return this.descrShort;
        }

        public final void setDescrShort(String descrShortFr) {
            this.descrShort = descrShortFr;
        }

        public String getDescrLong() {
            return this.descrLong;
        }

        public void setDescrLong(String descrLong) {
            this.descrLong = descrLong;
        }

        public final Long getSinceDate() {
            return this.sinceDate;
        }

        public final void setSinceDate(Long adate) {
            this.sinceDate = adate;
        }

        public final String getSinceDateSP() {
            return this.sinceDateSP;
        }

        public final void setSinceDateSP(String adateS) {
            this.sinceDateSP = adateS;
        }

        public Integer getImportance() {
            return this.importance;
        }

        public void setImportance(Integer importance) {
            this.importance = importance;
            this.importanceTemp = importance;
        }

        public void init(XIntervention x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setNote(x.getNote());
            this.setEntryDate(x.getEntryDate());
            this.setEntryDateSD(DateUtil.calendarToFormatedStringDate((Calendar)DateUtil.getCalendarFromLong((long)this.getEntryDate())));
            this.setImportance(x.getImportance());
            if (x.getDate() != null) {
                this.setSinceDate(x.getDate().toAbsoluteDate().toTimeInMillisUTC());
                this.setSinceDateSP(x.getDate().formatHyphen());
            }
            if (x.getInterventionCode() != null) {
                this.setCodeId(x.getInterventionCode().getId());
                this.setCode(x.getInterventionCode().getCode());
                this.setDescrShort(x.getInterventionCode().getDescriptionShort());
                this.setDescrLong(x.getInterventionCode().getDescriptionLong());
            }
            this.deleted = x.getIsDeleted();
            this.setEncLabel((EnumSet<XEncounterLabel>)(x.getEncLabel() == null ? null : x.getEncLabel().clone()));
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XIntervention x = (XIntervention)XIntervention.class.cast(type);
            this.init(x);
            return this;
        }

        public XIntervention x() {
            XIntervention res = new XIntervention();
            super.x(res);
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            res.setNote(this.note);
            if (StringUtils.isNotEmpty((String)this.sinceDateSP)) {
                res.setDate(MiscUtil.getPartialDate(this.sinceDateSP.trim()));
            } else if (this.sinceDate != null) {
                res.setDate((IPartialDate)LocalDate.fromTimeInMillisLOCAL((Long)this.sinceDate));
            }
            res.setEntryDate(this.entryDate);
            res.setImportance(this.importance);
            if (this.codeId != null) {
                XCode interventionCode = new XCode();
                interventionCode.setId(this.codeId);
                interventionCode.setClassification(XCodeClassification.CCI);
                interventionCode.setCode(this.code);
                interventionCode.setDescriptionShort(this.descrShort);
                interventionCode.setDescriptionLong(this.descrLong);
                res.setInterventionCode(interventionCode);
            } else {
                res.setInterventionCode(null);
            }
            if (this.encLabel != null) {
                res.setEncLabel((EnumSet<XEncounterLabel>)this.encLabel.clone());
            }
            res.setIsDeleted(this.isStatusDeleted());
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XIntervention convertx() {
            return this.x();
        }
    }

    public static final class Intolerances
    extends Allergies {
        private static final long serialVersionUID = 1L;

        public Intolerances() {
            this.title = "Intol\u00e9rances";
        }

        public Intolerances(XAllergy c) {
            this.convertc(c);
        }
    }

    public static class Allergies
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idProfessionnalAnchor", "version", "idNextModificationEntry", "entryDate", "note", "reaction", "dataType", "severity", "drugrefDesc", "drugrefId", "declaredDate", "solvedDate", "noKnownAllergy", "drugrefDescType", "deleted", "din"};
        public static Comparator<Allergies> compare = new Comparator<Allergies>(){

            @Override
            public int compare(Allergies o1, Allergies o2) {
                int c = ObjectUtils.compare((Comparable)((Object)o2.entryDateSD), (Comparable)((Object)o1.entryDateSD));
                return c == 0 ? ObjectUtils.compare((Comparable)((Object)o1.descr[1].toLowerCase()), (Comparable)((Object)o2.descr[1].toLowerCase())) : c;
            }
        };
        public Integer id;
        public Integer idAnchor;
        public Integer idProfessionnalAnchor;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateSD;
        public String note;
        public String reaction;
        public Integer dataType;
        public Integer severity;
        public String drugrefDesc;
        public String drugrefId;
        public Long declaredDate;
        public String declaredDateSP;
        public Long solvedDate;
        public String solvedDateSP;
        public Boolean noKnownAllergy;
        public XRxAllergyTypeCode drugrefDescType;
        public Integer din;
        public String atc = null;
        public Boolean deleted;
        public String title = "Allergies";
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", DETAILS, "R\u00e9action", "S\u00e9v\u00e9rit\u00e9"};

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public void setIdProfessionnalAnchor(Integer i) {
            this.idProfessionnalAnchor = i;
        }

        public Boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public Allergies() {
        }

        public Allergies(XAllergy c) {
            this.convertc(c);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[4];
            ArrayList<String> lst = new ArrayList<String>(4);
            if (StringUtils.isNotEmpty((String)this.drugrefDesc)) {
                lst.add(this.drugrefDesc);
            }
            if (StringUtils.isNotEmpty((String)this.note)) {
                lst.add(this.note);
            }
            this.descr[0] = this.declaredDateSP == null ? "" : this.declaredDateSP;
            this.descr[1] = new JoinList(", ", lst).toString();
            this.descr[2] = this.reaction;
            this.descr[3] = XAllergySeverity.from((int)this.severity).toString();
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateSD() {
            return this.entryDateSD;
        }

        public final void setEntryDateSD(String entryDate) {
            this.entryDateSD = entryDate;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final String getReaction() {
            return this.reaction;
        }

        public final void setReaction(String reaction) {
            this.reaction = reaction;
        }

        public Integer getDataType() {
            return this.dataType;
        }

        public void setDataType(Integer d) {
            this.dataType = d;
        }

        public final Integer getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        public final String getDrugrefDesc() {
            return this.drugrefDesc;
        }

        public final void setDrugrefDesc(String drugrefDesc) {
            this.drugrefDesc = drugrefDesc;
        }

        public final String getDrugrefId() {
            return this.drugrefId;
        }

        public final void setDrugrefId(String drugrefId) {
            this.drugrefId = drugrefId;
        }

        public final Long getDeclaredDate() {
            return this.declaredDate;
        }

        public final void setDeclaredDate(Long declaredDate) {
            this.declaredDate = declaredDate;
        }

        public final String getDeclaredDateSP() {
            return this.declaredDateSP;
        }

        public final void setDeclaredDateSP(String declaredDateS) {
            this.declaredDateSP = declaredDateS;
        }

        public final Long getSolvedDate() {
            return this.solvedDate;
        }

        public final void setSolvedDate(Long solvedDate) {
            this.solvedDate = solvedDate;
        }

        public final String getSolvedDateSP() {
            return this.solvedDateSP;
        }

        public final void setSolvedDateSP(String solvedDateS) {
            this.solvedDateSP = solvedDateS;
        }

        public Integer getDin() {
            return this.din;
        }

        public void setDin(Integer din) {
            this.din = din;
        }

        public Boolean getNoKnownAllergy() {
            return this.noKnownAllergy;
        }

        public void setNoKnownAllergy(Boolean noKownAllergy) {
            this.noKnownAllergy = noKownAllergy;
        }

        public XRxAllergyTypeCode getDrugrefDescType() {
            return this.drugrefDescType;
        }

        public void setDrugrefDescType(String category) {
            if (category != null && NumberUtils.isNumber(category)) {
                this.drugrefDescType = XRxAllergyTypeCode.from(Integer.parseInt(category));
            }
        }

        public void setDrugrefDescType(XRxAllergyTypeCode category) {
            this.drugrefDescType = category;
        }

        public String getAtc() {
            return this.atc;
        }

        public void setAtc(String atc) {
            this.atc = atc;
        }

        public void init(XAllergy x) {
            super.init(x);
            this.setId(x.getId());
            this.setIdAnchor(x.getIdAnchor());
            this.setIdNextModificationEntry(x.getIdNextModificationEntry());
            this.setEntryDate(x.getEntryDate() == null ? null : Long.valueOf(x.getEntryDate().toTimeInMillisUTC()));
            this.setEntryDateSD(x.getEntryDate() == null ? "" : x.getEntryDate().formatHyphen());
            this.setNote(x.getNote());
            if (x.getSinceDate() != null) {
                this.setDeclaredDate(x.getSinceDate().toAbsoluteDate().toTimeInMillisUTC());
                this.setDeclaredDateSP(x.getSinceDate().formatHyphen());
            }
            if (x.getSolvedDate() != null) {
                this.setSolvedDate(x.getSolvedDate().toAbsoluteDate().toTimeInMillisUTC());
                this.setSolvedDateSP(x.getSolvedDate().formatHyphen());
            }
            this.setNote(x.getNote());
            this.deleted = x.getIsDeleted();
            this.reaction = x.getReaction();
            this.severity = x.getSeverity().getValue();
            this.note = x.getNote();
            this.noKnownAllergy = x.getNoKnownAllergy();
            this.drugrefId = x.getDrugrefId();
            this.drugrefDesc = x.getDrugrefDesc();
            this.drugrefDescType = x.getDrugrefDescType();
            this.din = x.getDin();
            this.dataType = x.getDataType().value;
            this.setDescriptionOfObject();
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            XAllergy x = (XAllergy)XAllergy.class.cast(type);
            this.init(x);
            return this;
        }

        public XAllergy x() {
            XAllergy res = new XAllergy();
            super.x(res);
            res.setId(this.id);
            res.setIdAnchor(this.idAnchor);
            res.setIdNextModificationEntry(this.idNextModificationEntry);
            if (StringUtils.isNotEmpty((String)this.declaredDateSP)) {
                res.setSinceDate(MiscUtil.getPartialDate(this.declaredDateSP.trim()));
            } else if (this.declaredDate != null) {
                res.setSinceDate((IPartialDate)LocalDate.fromTimeInMillisLOCAL((Long)this.declaredDate));
            }
            if (StringUtils.isNotEmpty((String)this.solvedDateSP)) {
                res.setSolvedDate(MiscUtil.getPartialDate(this.solvedDateSP.trim()));
            } else if (this.solvedDate != null) {
                res.setSolvedDate((IPartialDate)LocalDate.fromTimeInMillisLOCAL((Long)this.solvedDate));
            }
            res.setIsSolved(this.solvedDate != null && this.solvedDate > 0L);
            res.setReaction(this.reaction);
            res.setSeverity(XAllergySeverity.from(this.severity));
            res.setNote(this.note);
            res.setIsDeleted(this.isStatusDeleted());
            res.setNoKnownAllergy(this.noKnownAllergy);
            res.setDrugrefId(this.drugrefId);
            res.setDrugrefDesc(this.drugrefDesc);
            res.setDrugrefDescType(this.drugrefDescType);
            res.setDin(this.din);
            res.setDataType(XAllergyType.from(this.dataType));
            this.setTag();
            res.setTag(this.tag);
            res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
            return res;
        }

        public XAllergy convertx() {
            return this.x();
        }
    }

    public static final class Profs
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"idProfessionnalAnchor", "entryDate", "factType", "factUid"};
        public Integer idProfessionnalAnchor;
        public String profNom;
        public Long entryDate;
        public Integer factType;
        public UUID factUid;
        public String entryDateS;
        public String title = "Professionnels impliqu\u00e9s";
        public String[] descr;
        public String[] descrTitle = new String[]{"Date", "Professionnal"};

        public void setDescriptionOfObject() {
            this.descr = new String[2];
            this.descr[0] = this.entryDateS;
            this.descr[1] = this.profNom;
        }

        public final Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public final void setIdProfessionnalAnchor(Integer id) {
            this.idProfessionnalAnchor = id;
        }

        public String getProfNom() {
            return this.profNom;
        }

        public void setProfNom(String profNom) {
            this.profNom = profNom;
            this.setDescriptionOfObject();
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final Integer getFactType() {
            return this.factType;
        }

        public final void setFactType(Integer factType) {
            this.factType = factType;
        }

        public final UUID getFactUid() {
            return this.factUid;
        }

        public final void setFactUid(UUID factUid) {
            this.factUid = factUid;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        @Override
        public <T> CEditableDataObject convertc(T type) {
            return this;
        }

        @Override
        public <T> T convertx() {
            return null;
        }
    }
}

