/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.appointment;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentTypeStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.EnumWithValues;
import ca.infodata.ofys.util.MiscUtil;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.EnumSet;

public final class XAppointmentType
extends EditableDataObject
implements KryoSerializable {
    private static final long serialVersionUID = 1L;
    private static final String VALID_CODE = Messages.getString("ENTREZ_CODE_2_A_4_CARACTERES", new String[0]);
    public static final int[] DEFAULT_COLOR = new int[]{255, 255, 255};
    public Integer id = null;
    public String code = "";
    public String french = "";
    public String english = "";
    public String espanol = "";
    public int[] color;
    public Short duree = 0;
    public Boolean isDeleted = false;
    public Boolean isDefault = false;
    public Integer professionnal = null;
    public String message = null;
    public Integer survey1Q = null;
    public EnumSet<XAppointmentTypeStatus> status = EnumSet.noneOf(XAppointmentTypeStatus.class);

    public XAppointmentType() {
        this.color = DEFAULT_COLOR;
    }

    @Override
    public void write(Kryo k, Output output) {
        output.writeInt(MiscUtil.fromInt(this.getId()));
        output.writeInt(MiscUtil.transfertIntegerArrayToInteger(this.color).intValue(), true);
        output.writeString(MiscUtil.fromString(this.getCode()));
        output.writeString(MiscUtil.fromString(this.getFrench()));
        output.writeString(MiscUtil.fromString(this.getEnglish()));
        output.writeString(MiscUtil.fromString(this.getEspanol()));
        output.writeShort((int)MiscUtil.fromShort((short)this.getDuree()));
        output.writeBoolean(Boolean.TRUE.equals(this.getIsDeleted()));
        output.writeBoolean(Boolean.TRUE.equals(this.getIsDefault()));
        output.writeInt(MiscUtil.fromInt(this.getProfessionnal()));
        output.writeString(MiscUtil.fromString(this.getMessage()));
        output.writeInt(MiscUtil.fromInt(this.getSurvey1Q()));
        output.writeShort((int)EnumWithValues.toSet(this.status).shortValue());
        super.write(k, output);
    }

    @Override
    public void read(Kryo k, Input input) {
        this.id = MiscUtil.toInt(input.readInt());
        this.color = MiscUtil.transfertIntToIntegerArray(input.readInt(true));
        this.code = MiscUtil.toString(input.readString());
        this.french = MiscUtil.toString(input.readString());
        this.english = MiscUtil.toString(input.readString());
        this.espanol = MiscUtil.toString(input.readString());
        this.duree = MiscUtil.toShort(input.readShort());
        this.isDeleted = input.readBoolean();
        this.isDefault = input.readBoolean();
        this.professionnal = MiscUtil.toInt(input.readInt());
        this.message = MiscUtil.toString(input.readString());
        this.survey1Q = MiscUtil.toInt(input.readInt());
        this.status = EnumWithValues.fromSet(XAppointmentTypeStatus.class, Integer.valueOf(input.readShort()));
        super.read(k, input);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.setUpdated();
    }

    public String getFrench() {
        return this.french;
    }

    public void setFrench(String french) {
        this.french = french;
        this.setUpdated();
    }

    public String getEnglish() {
        return this.english;
    }

    public void setEnglish(String english) {
        this.english = english;
        this.setUpdated();
    }

    public String getEspanol() {
        return this.espanol;
    }

    public void setEspanol(String espanol) {
        this.espanol = espanol;
        this.setUpdated();
    }

    public int[] getColor() {
        return this.color;
    }

    public void setColor(int[] rgb) {
        this.color = rgb;
        this.setUpdated();
    }

    public Short getDuree() {
        return this.duree;
    }

    public void setDuree(Short duree) {
        this.duree = duree;
        this.setUpdated();
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
        if (isDeleted != null && isDeleted.booleanValue() && this.isNewOrNewUpdated()) {
            this.setDeleted();
        }
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        this.setUpdated();
    }

    public Integer getProfessionnal() {
        return this.professionnal;
    }

    public void setProfessionnal(Integer professionnal) {
        this.professionnal = professionnal;
        this.setUpdated();
    }

    @Override
    public XAppointmentType clone() {
        XAppointmentType c = (XAppointmentType)super.clone();
        c.id = this.id;
        c.code = this.code;
        c.color = this.color;
        c.french = this.french;
        c.english = this.english;
        c.espanol = this.espanol;
        c.duree = this.duree;
        c.professionnal = this.professionnal;
        c.isDeleted = this.isDeleted;
        c.isDefault = this.isDefault;
        c.message = this.message;
        c.survey1Q = this.survey1Q;
        c.status = this.status.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XAppointmentType" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XAppointmentType) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public IStatus valid() {
        MultiStatus status = new MultiStatus();
        status.add(super.valid());
        if (!(this.getIsDeleted().booleanValue() || this.isNonExisting() || this.getCode() != null && this.getCode().trim().length() >= 2 && this.getCode().trim().length() <= 4)) {
            status.add(new Status(IStatus.Severity.ERROR, VALID_CODE));
        }
        return status;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getCode()).append(" - ").append(this.getDuree()).append(" : ");
        buffer.append(this.getDescription());
        return buffer.toString();
    }

    public String getDescription() {
        boolean b = false;
        StringBuilder buffer = new StringBuilder();
        if (this.getFrench() != null) {
            buffer.append(this.getFrench());
            b = true;
        }
        if (this.getEnglish() != null && !this.getEnglish().equals(this.getFrench())) {
            if (b) {
                buffer.append(", ");
            }
            buffer.append(this.getEnglish());
            b = true;
        }
        if (this.getEspanol() != null && !this.getEspanol().equals(this.getEnglish()) && !this.getEspanol().equals(this.getFrench())) {
            if (b) {
                buffer.append(", ");
            }
            buffer.append(this.getEspanol());
        }
        return buffer.toString();
    }

    public String getDescription(String lang) {
        if ("fr".equals(lang)) {
            return this.getFrench();
        }
        if ("en".equals(lang)) {
            return this.getEnglish();
        }
        return this.getDescription();
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public void setMessage(String m) {
        this.message = m;
        this.setUpdated();
    }

    public Integer getSurvey1Q() {
        return this.survey1Q;
    }

    public void setSurvey1Q(Integer survey1q) {
        this.survey1Q = survey1q;
        this.setUpdated();
    }

    public EnumSet<XAppointmentTypeStatus> getStatus() {
        return this.status;
    }

    public void setStatus(EnumSet<XAppointmentTypeStatus> status) {
        this.status = status;
        this.setUpdated();
    }

    public void removeXAppointmentTypeStatus(XAppointmentTypeStatus x) {
        this.status.remove(x);
        this.setUpdated();
    }

    public void addXAppointmentTypeStatus(XAppointmentTypeStatus x) {
        this.status.add(x);
        this.setUpdated();
    }

    @Override
    @Deprecated
    public void initialize() {
    }
}

