/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.IImportance;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformationOrigin;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.MiscUtil;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class XContactInformation
extends EditableDataObject
implements KryoSerializable,
IImportance {
    public static String[] fields = new String[]{"id", "version", "importance", "origin", "typeContact", "contact", "note"};
    public transient boolean saveContextVar_saveFromIClsc = false;
    public Integer id;
    public Integer typeContact;
    public String contact;
    public String note;
    public Short importance;
    public XContactInformationOrigin origin;
    private static final long serialVersionUID = 1L;
    public static final String[] CONTACT_TYPE_TEXT = new String[]{Messages.getString("TELEPHONE", new String[0]), Messages.getString("COURRIEL_PRINC", new String[0]), Messages.getString("TELECOPIEUR", new String[0]), Messages.getString("TELEAVERTISSEUR", new String[0]), Messages.getString("COURRIEL_AUTRE", new String[0]), Messages.getString("CELLULAIRE", new String[0]), Messages.getString("CELLULAIRE_AUTRE", new String[0]), "iPhone ID", Messages.getString("PHONE_AUTRE", new String[0])};
    public static final Integer CONTACT_TYPE_PHONE = 0;
    public static final Integer CONTACT_TYPE_EMAIL = 1;
    public static final Integer CONTACT_TYPE_FAX = 2;
    public static final Integer CONTACT_TYPE_PAGET = 3;
    public static final Integer CONTACT_TYPE_EMAILS_AUTRES = 4;
    public static final Integer CONTACT_TYPE_CELL_TEXTO = 5;
    public static final Integer CONTACT_TYPE_CELL_AUTRE = 6;
    public static final Integer CONTACT_TYPE_IPHONE = 7;
    public static final Integer CONTACT_TYPE_PHONE_AUTRE = 8;
    public static final List<Integer> CONTACT_PHONE_TYPES = Collections.unmodifiableList(Arrays.asList(CONTACT_TYPE_PHONE, CONTACT_TYPE_CELL_TEXTO, CONTACT_TYPE_CELL_AUTRE, CONTACT_TYPE_PAGET, CONTACT_TYPE_FAX, CONTACT_TYPE_PHONE_AUTRE));
    public static final List<Integer> CONTACT_PHONE_TYPES_NO_FAX = Collections.unmodifiableList(Arrays.asList(CONTACT_TYPE_PHONE, CONTACT_TYPE_CELL_TEXTO, CONTACT_TYPE_CELL_AUTRE, CONTACT_TYPE_PAGET, CONTACT_TYPE_PHONE_AUTRE));
    public static final List<Integer> CONTACT_EMAILS_TYPES = Collections.unmodifiableList(Arrays.asList(CONTACT_TYPE_EMAIL, CONTACT_TYPE_EMAILS_AUTRES));
    public static final Map<Integer, String> TYPES_FORMAT;

    @Override
    public void write(Kryo k, Output out) {
        out.writeInt(MiscUtil.fromInt(this.id));
        out.writeShort((int)this.typeContact.shortValue());
        out.writeString(MiscUtil.fromString(this.contact));
        out.writeString(MiscUtil.fromString(this.note));
        out.writeShort((int)MiscUtil.fromShort(this.importance));
        super.write(k, out);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.id = MiscUtil.toInt(in.readInt());
        this.typeContact = in.readShort();
        this.contact = MiscUtil.toString(in.readString());
        this.note = MiscUtil.toString(in.readString());
        this.importance = MiscUtil.toShort(in.readShort());
        super.read(k, in);
    }

    @Override
    public void initialize() {
        this.setImportance((short)256);
        this.setTypeContact(0);
        this.setContact("");
        this.setNote("");
        this.setNeutral();
        this.setNew();
        assert (this.isNew());
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public Integer getTypeContact() {
        return this.typeContact;
    }

    public void setTypeContact(Integer typeContact) {
        this.typeContact = typeContact;
        this.setUpdated();
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
        this.setUpdated();
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.setUpdated();
    }

    @Override
    public Short getImportance() {
        return this.importance;
    }

    @Override
    public void setImportance(Short importance) {
        this.importance = importance;
        this.setUpdatedOrder();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XContactInformation) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XContactInformation" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Deprecated
    public String getFormatedTelephone() {
        if (this.getTypeContact() == null) {
            return "";
        }
        String strReturn = "";
        Integer type = this.getTypeContact();
        if (CONTACT_PHONE_TYPES.contains(type) && this.getContact().trim().length() == 10) {
            strReturn = "(" + this.getContact().substring(0, 3) + ")" + this.getContact().substring(3, 6) + "-" + this.getContact().substring(6, 10);
        }
        return strReturn;
    }

    @Override
    public String toString() {
        String contact = this.getFormatedTelephone();
        if ("".equals(contact)) {
            contact = this.getContact();
        }
        return "First: " + this.getImportance() + ", " + (this.getTypeContact() == null ? "" : CONTACT_TYPE_TEXT[this.getTypeContact()]) + ", " + contact + ", " + this.getNote() + ", id = " + this.getId();
    }

    @Override
    public XContactInformation clone() {
        XContactInformation c = (XContactInformation)super.clone();
        c.id = this.id;
        c.typeContact = this.typeContact;
        c.contact = this.contact;
        c.note = this.note;
        c.importance = this.importance;
        return c;
    }

    public XContactInformationOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(XContactInformationOrigin origin) {
        this.origin = origin;
        this.setUpdated();
    }

    @Override
    public IStatus valid() {
        MultiStatus status = new MultiStatus();
        status.add(super.valid());
        Integer type = this.getTypeContact();
        if (type == null) {
            status.add(new Status(IStatus.Severity.ERROR, Messages.getString("TYPE_CONTACT_INVALID", new String[0])));
        } else {
            String contact = this.getContact();
            if (type != CONTACT_TYPE_EMAIL) {
                if (contact == null || contact.length() == 0 || contact.length() < 10) {
                    status.add(new Status(IStatus.Severity.ERROR, Messages.getString("ENTREZ_NUMERO_TELEPHONE_VALIDE", new String[0])));
                }
            } else if (contact == null || contact.length() == 0 || !this.validEmail(contact)) {
                status.add(new Status(IStatus.Severity.ERROR, Messages.getString("ENTREZ_COURRIEL_VALIDE", new String[0])));
            }
        }
        return status;
    }

    private boolean validEmail(String contact) {
        int indexPt;
        int indexA;
        boolean valid = false;
        if (contact != null && contact.length() != 0 && (indexA = contact.indexOf("@")) >= 1 && (indexPt = contact.indexOf(".", indexA)) >= indexA + 2 && indexPt < contact.length() - 1) {
            valid = true;
        }
        return valid;
    }

    public String getFormatedContact() {
        String s = this.getContact();
        Integer type = this.getTypeContact();
        if (s != null && CONTACT_PHONE_TYPES.contains(type) && s.trim().length() == 10) {
            s = "(" + s.substring(0, 3) + ")" + s.substring(3, 6) + "-" + s.substring(6, 10);
        }
        s = s == null ? null : s.trim();
        return s;
    }

    public boolean isEmailType() {
        Integer type = this.getTypeContact();
        if (type == null) {
            return false;
        }
        return type.intValue() == CONTACT_TYPE_EMAIL.intValue() || type.intValue() == CONTACT_TYPE_EMAILS_AUTRES.intValue();
    }

    static {
        HashMap<Integer, String> temp = new HashMap<Integer, String>();
        temp.put(CONTACT_TYPE_PHONE, Messages.getString("TELEPHONE", new String[0]));
        temp.put(CONTACT_TYPE_EMAIL, Messages.getString("COURRIEL_PRINC", new String[0]));
        temp.put(CONTACT_TYPE_FAX, Messages.getString("TELECOPIEUR", new String[0]));
        temp.put(CONTACT_TYPE_PAGET, Messages.getString("TELEAVERTISSEUR", new String[0]));
        temp.put(CONTACT_TYPE_EMAILS_AUTRES, Messages.getString("COURRIEL_AUTRE", new String[0]));
        temp.put(CONTACT_TYPE_CELL_TEXTO, Messages.getString("CELLULAIRE", new String[0]));
        temp.put(CONTACT_TYPE_CELL_AUTRE, Messages.getString("CELLULAIRE_AUTRE", new String[0]));
        temp.put(CONTACT_TYPE_IPHONE, "iPhone ID");
        temp.put(CONTACT_TYPE_PHONE_AUTRE, Messages.getString("PHONE_AUTRE", new String[0]));
        TYPES_FORMAT = Collections.unmodifiableMap(temp);
    }
}

