/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.EmptyReportProperties;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICloneable;
import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.ObjectProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.NumberOfCopiesProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.Orientation;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.OrientationProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.OutputProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrinterProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReportProperties
implements Serializable,
Iterable<IReportProperty>,
ICloneable {
    private static final long serialVersionUID = 1L;
    public static final ReportProperties EMPTY_REPORT_PROPERTIES = new EmptyReportProperties();
    private Map<String, IReportProperty> properties = new LinkedHashMap<String, IReportProperty>();

    public IReportProperty get(String name) {
        return this.properties.get(name);
    }

    public Boolean getBooleanValue(String name, Boolean defaultValue) {
        return (Boolean)this.getValue(name, defaultValue);
    }

    public Object getValue(String name, Object defaultValue) {
        IReportProperty p = this.properties.get(name);
        return p != null && p.value() != null ? p.value() : defaultValue;
    }

    public IReportProperty put(IReportProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("property cant be null");
        }
        return this.properties.put(property.name(), property);
    }

    public IReportProperty remove(String name) {
        return this.properties.remove(name);
    }

    public IReportProperty put(String name, Serializable value) {
        if (value == null) {
            throw new IllegalArgumentException("value cant be null");
        }
        return this.put(new ObjectProperty(name, name, value, false));
    }

    public int size() {
        return this.properties.size();
    }

    @Override
    public Iterator<IReportProperty> iterator() {
        return this.properties.values().iterator();
    }

    public Collection<IReportProperty> values() {
        return this.properties.values();
    }

    public void setNumberCopies(Integer nbCopies) {
        NumberOfCopiesProperty property = (NumberOfCopiesProperty)this.get("numberofcopies");
        if (property == null) {
            property = new NumberOfCopiesProperty(nbCopies);
            this.put(property);
        } else {
            property.setValue(nbCopies);
        }
    }

    public void setOrientation(Orientation orientation) {
        OrientationProperty property = (OrientationProperty)this.get("orientation");
        if (property == null) {
            property = new OrientationProperty(orientation);
            this.put(property);
        } else {
            property.setValue(orientation);
        }
    }

    public void setOutput(String output) {
        OutputProperty property = (OutputProperty)this.get("output");
        if (property == null) {
            property = new OutputProperty(output);
            this.put(property);
        } else {
            property.setValue(output);
        }
    }

    public void setPrinter(String printer) {
        PrinterProperty property = (PrinterProperty)this.get("printer");
        if (property == null) {
            property = new PrinterProperty(printer);
            this.put(property);
        } else {
            property.setValue(printer);
        }
    }

    public Integer getNumberOfCopies(Integer defaultNumber) {
        return (Integer)this.getValue("numberofcopies", defaultNumber);
    }

    public String getOutput(String defaultOutput) {
        return (String)this.getValue("output", defaultOutput);
    }

    public Orientation getOrientation(Orientation defaultOrientation) {
        return (Orientation)this.getValue("orientation", defaultOrientation);
    }

    public String getPrinter(String defaultPrinter) {
        return (String)this.getValue("printer", defaultPrinter);
    }

    public String toString() {
        return this.properties.values().toString();
    }

    @Override
    public ReportProperties clone() {
        try {
            ReportProperties c = (ReportProperties)super.clone();
            c.properties = new HashMap<String, IReportProperty>();
            for (Map.Entry<String, IReportProperty> e : this.properties.entrySet()) {
                Object value2 = e.getValue() == null ? null : e.getValue().clone();
                c.properties.put(e.getKey(), (IReportProperty)value2);
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

