/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocaleProvider;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Messages {
    private static final Logger logger = Logger.getLogger(Messages.class.getName());
    private static final String BUNDLE_NAME = "ca.infodata.ofys.data.middle.dataobjects.messages";
    public static final ResourceBundle EN = ResourceBundle.getBundle("ca.infodata.ofys.data.middle.dataobjects.messages", Locale.ENGLISH);
    public static final ResourceBundle FR = ResourceBundle.getBundle("ca.infodata.ofys.data.middle.dataobjects.messages", Locale.FRENCH);
    public static final ResourceBundle ES = ResourceBundle.getBundle("ca.infodata.ofys.data.middle.dataobjects.messages", new Locale("es"));

    private Messages() {
        throw new UnsupportedOperationException();
    }

    public static String getString2(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key, int l) {
        try {
            if (l == 1) {
                return EN.getString(key);
            }
            if (l == 2) {
                return ES.getString(key);
            }
            return FR.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getStringCap(String key, String ... vars) {
        try {
            String text = Messages.getResourceBundle().getString(key);
            if (vars != null && vars.length > 0) {
                text = MessageFormat.format(text, vars);
            }
            return StringUtils.capitalize((String)text);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key, String ... vars) {
        try {
            String text = Messages.getResourceBundle().getString(key);
            if (vars != null && vars.length > 0) {
                MessageFormat temp = new MessageFormat(text);
                text = temp.format(vars);
            }
            return text;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static ResourceBundle getResourceBundle() {
        if (LocaleProvider.isFrench()) {
            return FR;
        }
        if (LocaleProvider.isEnglish()) {
            return EN;
        }
        if (LocaleProvider.isSpanish()) {
            return ES;
        }
        logger.log(Level.WARNING, "No ressource bundle for locale " + LocaleProvider.getLocale() + ". Use default FR");
        return FR;
    }
}

