/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification;

import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.XPreferencesContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XUserPreferences;
import ca.infodata.ofys.mb.listener.object.WeakEqualReference;
import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.ui.library.log.Log;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mb.listeners.GenListenerManager;
import org.mb.listeners.IListenerManager;

public final class DataObjectNotificationProcessor {
    private static final Logger logger = Logger.getLogger(ThreadExtension.class.getName());
    private static final Object PRESENT = new Object();
    private final IListenerManager<DataObjectNotificationProcessorListener> manager = new GenListenerManager(DataObjectNotificationProcessorListener.class);
    private final DataObjectNotificationProcessorListener proxy = (DataObjectNotificationProcessorListener)this.manager.getProxy();
    private final ConcurrentHashMap<WeakReference<Object>, Object> pool = new ConcurrentHashMap();
    private ThreadExtension cleanupThread;
    public final DataObjectNotificationHandler handler = new DataObjectNotificationHandlerImpl();

    public DataObjectNotificationProcessor() {
        this.createAndStartCleanupThread();
    }

    private void createAndStartCleanupThread() {
        this.cleanupThread = new ThreadExtension("DONOPCleanupThread" + this.hashCode());
        this.cleanupThread.setPriority(5);
        this.cleanupThread.setDaemon(true);
        this.cleanupThread.start();
    }

    public void addListener(DataObjectNotificationProcessorListener listener) {
        this.manager.addListener((Object)listener);
    }

    public void removeListener(DataObjectNotificationProcessorListener listener) {
        this.manager.removeListener((Object)listener);
    }

    public void put(Object object) {
        if (object != null) {
            this.pool.put((WeakReference<Object>)new WeakEqualReference(object), PRESENT);
        }
    }

    public void remove(Object object) {
        if (object != null) {
            this.pool.remove(object);
        }
    }

    public synchronized void reset() {
        Object[] listeners;
        this.pool.clear();
        Object[] objectArray = listeners = this.manager.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null) {
                this.manager.removeListener((Object)((DataObjectNotificationProcessorListener)object));
            }
            ++n2;
        }
    }

    public synchronized void addToGroup(Object object) {
        Log.log((Logger)logger, (Level)Level.FINE, (String)"DataObjectNotificationProcessor.addToGroup", (String[])new String[]{"group", "object"}, (Object[])new Object[]{this.hashCode(), object});
        if (object == null) {
            throw new IllegalArgumentException("oldObject cant be null");
        }
        if (object instanceof IEditableDataObject) {
            ((IEditableDataObject)object).setListenerEnabled(true);
        }
        boolean replaced = false;
        try {
            try {
                Iterator iterator = ((ConcurrentHashMap.KeySetView)this.pool.keySet()).iterator();
                while (iterator.hasNext()) {
                    Object item = ((WeakReference)iterator.next()).get();
                    if (item == null) {
                        iterator.remove();
                        continue;
                    }
                    if (!this.doProcess(item, null, object)) continue;
                    logger.fine(String.format("replaced for group %s in item=%s, object=%s", this.hashCode(), item.getClass(), object.getClass()));
                    replaced = true;
                }
                this.put(object);
                if (!replaced) {
                    this.afterReplace(null, object);
                    logger.fine(String.format("oject wasnt replaced for group %s object=%s", this.hashCode(), object.getClass()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.processed(object, replaced);
        }
    }

    public synchronized <A> void replaceInGroup(A oldObject, A newObject) {
        if (oldObject == null) {
            throw new IllegalArgumentException("oldObject cant be null");
        }
        if (oldObject == newObject) {
            this.processed(oldObject, false);
            return;
        }
        this.beforeReplace(oldObject, newObject);
        if (newObject instanceof IEditableDataObject) {
            ((IEditableDataObject)newObject).setListenerEnabled(true);
        }
        if (oldObject instanceof IEditableDataObject) {
            ((IEditableDataObject)oldObject).setListenerEnabled(true);
        }
        boolean updated = false;
        try {
            try {
                Iterator iterator = ((ConcurrentHashMap.KeySetView)this.pool.keySet()).iterator();
                while (iterator.hasNext()) {
                    Object item = ((WeakReference)iterator.next()).get();
                    if (item == null) {
                        iterator.remove();
                        continue;
                    }
                    boolean bl = updated = this.doProcess(item, oldObject, newObject) || updated;
                }
                if (!updated) {
                    this.put(newObject);
                    this.afterReplace(null, newObject);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.processed(oldObject, updated);
            this.processed(newObject, updated);
        }
    }

    private <A> boolean doProcess(Object target, A oldObject, A newObject) {
        Boolean updated = false;
        Class<?> targetClass = target.getClass();
        Class<?> objectClass = oldObject == null ? newObject.getClass() : oldObject.getClass();
        try {
            Method method = DataObjectNotificationProcessor.class.getDeclaredMethod("process", targetClass, objectClass, objectClass, Boolean.TYPE);
            updated = (Boolean)method.invoke((Object)this, target, oldObject, newObject, true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            updated = this.process(target, oldObject, newObject, true);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return updated;
    }

    private <A> boolean process(Object target, A oldObject, A newObject, boolean doit) {
        A object;
        A a = object = oldObject == null ? newObject : oldObject;
        if (target instanceof IMinimalEditableDataObject && object instanceof IMinimalEditableDataObject) {
            if (DataObjectNotificationProcessor.objectsAreEquals2((IMinimalEditableDataObject)target, (IMinimalEditableDataObject)object)) {
                if (doit) {
                    this.beforeReplace(target, newObject);
                    this.remove(target);
                    if (newObject != null) {
                        this.put(newObject);
                    }
                    this.afterReplace(target, newObject);
                }
                return true;
            }
        } else if (DataObjectNotificationProcessor.objectsAreEquals(target, object)) {
            if (doit) {
                this.beforeReplace(target, newObject);
                this.remove(target);
                if (newObject != null) {
                    this.put(newObject);
                }
                this.afterReplace(target, newObject);
            }
            return true;
        }
        return false;
    }

    private static boolean objectsAreEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private static boolean objectsAreEquals2(IMinimalEditableDataObject o1, IMinimalEditableDataObject o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2) || o1.equalsByTag(o2);
    }

    private boolean process(XPreferencesContainer container, XClientPreferences oldClient, XClientPreferences newClient, boolean doit) {
        XClientPreferences pref;
        XClientPreferences xClientPreferences = pref = oldClient == null ? newClient : oldClient;
        if (DataObjectNotificationProcessor.objectsAreEquals2((IMinimalEditableDataObject)container.getClientPreferences(), (IMinimalEditableDataObject)pref)) {
            if (doit) {
                this.beforeUpdate(container, true);
                container.clientPreferences = newClient;
                this.afterUpdate(container, true);
            }
            return true;
        }
        return false;
    }

    private boolean process(XPreferencesContainer container, XUserPreferences oldUser, XUserPreferences newUser, boolean doit) {
        XUserPreferences pref;
        XUserPreferences xUserPreferences = pref = oldUser == null ? newUser : oldUser;
        if (DataObjectNotificationProcessor.objectsAreEquals2((IMinimalEditableDataObject)container.getUserPreferences(), (IMinimalEditableDataObject)pref)) {
            if (doit) {
                this.beforeUpdate(container, true);
                container.userPreferences = newUser;
                this.afterUpdate(container, true);
            }
            return true;
        }
        return false;
    }

    public void afterReplace(Object oldObj, Object newObj) {
        try {
            this.proxy.afterReplace(oldObj, newObj);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to process afterReplace event. [old=" + oldObj + " , new=" + newObj + "]", e);
        }
    }

    public void processed(Object obj, boolean replacedOrUpdated) {
        try {
            this.proxy.processed(obj, replacedOrUpdated);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to process processed event. [obj=" + obj + " , replaced=" + replacedOrUpdated + "]", e);
        }
    }

    public void afterUpdate(Object object, boolean majorUpdate) {
        try {
            this.proxy.afterUpdate(object, majorUpdate);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to process afterUpdate event. [object=" + object + " , majorUpdate=" + majorUpdate + "]", e);
        }
    }

    public void beforeReplace(Object oldObj, Object newObj) {
        try {
            this.proxy.beforeReplace(oldObj, newObj);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to process beforeReplace event. [old=" + oldObj + " , new=" + newObj + "]", e);
        }
    }

    public void beforeUpdate(Object object, boolean majorUpdate) {
        try {
            this.proxy.beforeUpdate(object, majorUpdate);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to process beforeUpdate event. [object=" + object + " , majorUpdate=" + majorUpdate + "]", e);
        }
    }

    private class DataObjectNotificationHandlerImpl
    implements DataObjectNotificationHandler {
        private DataObjectNotificationHandlerImpl() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            Object clone;
            IDataObject object = notification.getObject();
            if (object == null) {
                return;
            }
            if (object instanceof IMinimalEditableDataObject) {
                Integer tag = ((IMinimalEditableDataObject)object).getTag();
                clone = object.clone();
                ((IMinimalEditableDataObject)clone).setTag(tag);
            } else {
                clone = object.clone();
            }
            DataObjectNotificationProcessor.this.addToGroup(clone);
        }
    }

    public static interface DataObjectNotificationProcessorListener {
        public void afterUpdate(Object var1, boolean var2);

        public void beforeUpdate(Object var1, boolean var2);

        public void beforeReplace(Object var1, Object var2);

        public void afterReplace(Object var1, Object var2);

        public void processed(Object var1, boolean var2);
    }

    private final class ThreadExtension
    extends DaemonThread {
        private ThreadExtension(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            super.run();
            while (true) {
                try {
                    block6: while (true) {
                        TimeUnit.SECONDS.sleep(10L);
                        ConcurrentHashMap concurrentHashMap = DataObjectNotificationProcessor.this.pool;
                        // MONITORENTER : concurrentHashMap
                        Iterator iterator = ((ConcurrentHashMap.KeySetView)DataObjectNotificationProcessor.this.pool.keySet()).iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                // MONITOREXIT : concurrentHashMap
                                continue block6;
                            }
                            WeakReference item = (WeakReference)iterator.next();
                            if (item.get() != null) continue;
                            iterator.remove();
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : concurrentHashMap
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in Thread " + this.getName(), e);
                    continue;
                }
                break;
            }
        }
    }
}

