/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IGenericReportAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.library.log.Log;

public class GenericReportAccessorClient
extends BaseAccessorClient {
    private static GenericReportAccessorClient instance;
    private final IGenericReportAccessor accessor;

    public static GenericReportAccessorClient getInstance() throws CannotConnectToServerException {
        return GenericReportAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static GenericReportAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new GenericReportAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private GenericReportAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getGenericReportAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void findAllBase(final ICallback callback, XSession session) {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (this.isOkToCallFunction("GenericReportAccessorClient.findAllBase", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findAllBase());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            GenericReportAccessorClient.this.functionCallEnded("GenericReportAccessorClient.findAllBase", callback);
                        }
                    }
                    finally {
                        GenericReportAccessorClient.this.functionCallEnded("GenericReportAccessorClient.findAllBase", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getGenericReport(final int uniqueKey, XSession session, final ICallback callback, final int genericReportId) {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (this.isOkToCallFunction("GenericReportAccessorClient.getGenericReport" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getGenericReport(genericReportId));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            GenericReportAccessorClient.this.functionCallEnded("GenericReportAccessorClient.getGenericReport" + uniqueKey, callback);
                        }
                    }
                    finally {
                        GenericReportAccessorClient.this.functionCallEnded("GenericReportAccessorClient.getGenericReport" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    protected IGenericReportAccessor getAccessor() {
        return this.accessor;
    }
}

