/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import java.io.Serializable;
import java.text.NumberFormat;

public class ValueWithUnit
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Number value;
    public final String unit;

    public ValueWithUnit(Number value, String unit) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (unit.isEmpty() || unit.trim().isEmpty()) {
            throw new IllegalArgumentException("unit is blank");
        }
        this.value = value;
        this.unit = unit;
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(5);
        if ("1".equals(this.unit)) {
            return nf.format(this.value) + " (u)";
        }
        return nf.format(this.value) + " (" + this.unit + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueWithUnit other = (ValueWithUnit)obj;
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.toString().equals(other.value.toString()));
    }
}

