/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import java.io.Serializable;

public class Code
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String code;
    public final String codeSystem;
    public final String text;

    public Code(String code) {
        this(code, null);
    }

    public Code(String code, String text) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        if (code.isEmpty() || code.trim().isEmpty()) {
            throw new IllegalArgumentException("code is blank");
        }
        this.code = code;
        this.codeSystem = null;
        this.text = text;
    }

    public Code(String code, String codeSystem, String text) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        if (code.isEmpty() || code.trim().isEmpty()) {
            throw new IllegalArgumentException("code is blank");
        }
        this.code = code;
        this.codeSystem = codeSystem;
        this.text = text;
    }

    public String toString() {
        if (this.codeSystem == null) {
            return String.format("Code [value=%s, text=%s]", this.code, this.text);
        }
        return String.format("Code [value=%s, oid=%s, text=%s]", this.code, this.codeSystem, this.text);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Code) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }
}

