/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.util.List;
import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ddogleg.clustering.gmm.InitializeGmm_F64;
import org.ddogleg.clustering.kmeans.StandardKMeans_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class SeedFromKMeans_F64
implements InitializeGmm_F64 {
    StandardKMeans_F64 kmeans;
    GrowQueue_I32 totals = new GrowQueue_I32();
    double[] dx = new double[1];
    int N;

    public SeedFromKMeans_F64(StandardKMeans_F64 kmeans) {
        this.kmeans = kmeans;
    }

    @Override
    public void init(int pointDimension, long randomSeed) {
        this.N = pointDimension;
        this.kmeans.init(this.N, randomSeed);
        if (this.dx.length < this.N) {
            this.dx = new double[this.N];
        }
    }

    @Override
    public void selectSeeds(List<double[]> points, List<GaussianGmm_F64> seeds) {
        DMatrixRMaj cov;
        int i;
        this.totals.resize(seeds.size());
        this.totals.fill(0);
        this.kmeans.process(points, seeds.size());
        GrowQueue_I32 labels = this.kmeans.getPointLabels();
        FastQueue<double[]> means = this.kmeans.getClusterMeans();
        for (i = 0; i < seeds.size(); ++i) {
            GaussianGmm_F64 g = seeds.get(i);
            g.setMean(means.get(i));
            CommonOps_DDRM.fill(g.covariance, 0.0);
        }
        for (i = 0; i < points.size(); ++i) {
            int label;
            double[] p = points.get(i);
            int n = label = labels.get(i);
            this.totals.data[n] = this.totals.data[n] + 1;
            double[] m = means.get(label);
            for (int j = 0; j < this.N; ++j) {
                this.dx[j] = m[j] - p[j];
            }
            DMatrixRMaj cov2 = seeds.get((int)label).covariance;
            for (int j = 0; j < this.N; ++j) {
                for (int k = j; k < this.N; ++k) {
                    int n2 = k * this.N + j;
                    cov2.data[n2] = cov2.data[n2] + this.dx[j] * this.dx[k];
                }
            }
        }
        for (i = 0; i < seeds.size(); ++i) {
            cov = seeds.get((int)i).covariance;
            for (int j = 0; j < this.N; ++j) {
                for (int k = 0; k < j; ++k) {
                    cov.data[k * this.N + j] = cov.data[j * this.N + k];
                }
            }
        }
        for (i = 0; i < seeds.size(); ++i) {
            cov = seeds.get((int)i).covariance;
            int M = this.totals.get(i) - 1;
            if (M <= 0) continue;
            CommonOps_DDRM.divide(cov, M);
            seeds.get((int)i).weight = (double)this.totals.get(i) / (double)points.size();
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.kmeans.setVerbose(verbose);
    }
}

